/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class Win32Renderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    static {
        Win32Renderer.initIDs();
    }

    private static native void initIDs();

    public Win32Renderer traceWrap() {
        return new Tracer();
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        int n6 = sunGraphics2D.transX;
        int n7 = sunGraphics2D.transY;
        this.doDrawLine(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + n6, n3 + n7, n4 + n6, n5 + n7);
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.doDrawOval(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.doDrawRect(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.doFillOval(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.doFillRect(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doDrawArc(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doDrawRoundRect(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doFillArc(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doFillRoundRect(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.doDrawPoly(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2, true);
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.doDrawPoly(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2, false);
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.doFillPoly(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2);
    }

    native void devCopyArea(SurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7);

    native void doDrawLine(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7);

    native void doDrawOval(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7);

    native void doDrawRect(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7);

    native void doFillOval(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7);

    native void doFillRect(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7);

    native void doDrawArc(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    native void doDrawRoundRect(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    native void doFillArc(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    native void doFillRoundRect(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    native void doFillPoly(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int[] var6, int[] var7, int var8);

    native void doDrawPoly(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, int[] var6, int[] var7, int var8, boolean var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            this.doShape(sunGraphics2D, shape, false);
        } else if (sunGraphics2D.strokeState < 2) {
            ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
            try {
                this.doFillSpans(sunGraphics2D, shapeSpanIterator);
                Object var5_4 = null;
                shapeSpanIterator.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                shapeSpanIterator.dispose();
                throw throwable;
            }
        } else {
            this.doShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape), true);
        }
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.doShape(sunGraphics2D, shape, true);
    }

    void doShape(SunGraphics2D sunGraphics2D, Shape shape, boolean bl2) {
        GeneralPath generalPath;
        int n2;
        int n3;
        if (shape instanceof GeneralPath) {
            if (sunGraphics2D.transformState > 1) {
                shape = ((GeneralPath)shape).createTransformedShape(sunGraphics2D.transform);
                n3 = 0;
                n2 = 0;
            } else {
                n3 = sunGraphics2D.transX;
                n2 = sunGraphics2D.transY;
            }
            generalPath = (GeneralPath)shape;
        } else {
            PathIterator pathIterator = shape.getPathIterator(sunGraphics2D.transform);
            generalPath = new GeneralPath(pathIterator.getWindingRule());
            generalPath.append(pathIterator, false);
            n3 = 0;
            n2 = 0;
        }
        this.doShape(sunGraphics2D.surfaceData, sunGraphics2D.compBounds, sunGraphics2D.rgb, n3, n2, generalPath, bl2);
    }

    public void doFillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        int[] nArray = new int[4];
        SurfaceData surfaceData = sunGraphics2D.surfaceData;
        Rectangle rectangle = sunGraphics2D.getCompBounds();
        int n2 = sunGraphics2D.rgb;
        while (spanIterator.nextSpan(nArray)) {
            this.doFillRect(surfaceData, rectangle, n2, nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    native void doShape(SurfaceData var1, Rectangle var2, int var3, int var4, int var5, GeneralPath var6, boolean var7);

    public static class Tracer
    extends Win32Renderer {
        void devCopyArea(SurfaceData surfaceData, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDICopyArea");
            super.devCopyArea(surfaceData, n2, n3, n4, n5, n6, n7);
        }

        void doDrawLine(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIDrawLine");
            super.doDrawLine(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doDrawOval(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIDrawOval");
            super.doDrawOval(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doDrawRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRect");
            super.doDrawRect(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doFillOval(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIFillOval");
            super.doFillOval(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doFillRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIFillRect");
            super.doFillRect(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doDrawArc(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIDrawArc");
            super.doDrawArc(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doDrawRoundRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRoundRect");
            super.doDrawRoundRect(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doFillArc(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIFillArc");
            super.doFillArc(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doFillRoundRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIFillRoundRect");
            super.doFillRoundRect(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doFillPoly(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillPoly");
            super.doFillPoly(surfaceData, rectangle, n2, n3, n4, nArray, nArray2, n5);
        }

        void doDrawPoly(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("GDIDrawPoly");
            super.doDrawPoly(surfaceData, rectangle, n2, n3, n4, nArray, nArray2, n5, bl2);
        }

        void doShape(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, GeneralPath generalPath, boolean bl2) {
            GraphicsPrimitive.tracePrimitive(bl2 ? "GDIFillShape" : "GDIDrawShape");
            super.doShape(surfaceData, rectangle, n2, n3, n4, generalPath, bl2);
        }
    }
}

