/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.awt.windows.Win32OffScreenImage;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.java2d.loops.CompositeType;
import sun.security.action.GetPropertyAction;

public class Win32PeerlessImage
extends Win32OffScreenImage {
    private static final int MAX_SIZE = 65536;
    private static final int ICM_HISTOGRAM_SIZE = 256;
    private static final int ICM_HISTOGRAM_MASK = 255;
    private static final int DCM_HISTOGRAM_SIZE = 1024;
    private static final int DCM_HISTOGRAM_MASK = 1023;
    private ColorModel cmHw;
    private int transparency;
    private Color transColor;
    protected static boolean isTranslucentImagesAccEnabled = false;
    int timesTried = 0;

    protected int getTransparency() {
        return this.transparency;
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.translaccel"));
        if (string != null && string.equals("true")) {
            isTranslucentImagesAccEnabled = true;
            System.out.println("Acceleration for translucent images is enabled.");
        }
    }

    public void displayChanged() {
        super.displayChanged();
    }

    protected Color getBackgroundColor() {
        if (!AcceleratedOffScreenImage.accelerationEnabled || !this.localAccelerationEnabled || this.transparency != 2) {
            return null;
        }
        this.transColor = this.setupTransparentPixel();
        if (this.transColor == null) {
            this.localAccelerationEnabled = false;
        }
        return this.transColor;
    }

    protected Color setupTransparentPixel() {
        Color color = null;
        Integer n2 = null;
        ColorModel colorModel = this.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            n2 = this.findUnusedPixelICM();
        } else if (colorModel instanceof DirectColorModel) {
            n2 = this.findUnusedPixelDCM();
        }
        if (n2 != null) {
            int n3 = n2;
            ((Win32OffScreenSurfaceData)this.surfaceDataHw).setTransparentPixel(n3);
            int n4 = this.surfaceDataHw.rgbFor(n3);
            color = new Color(n4);
        }
        return color;
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceleratedBackground(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        Win32PeerlessImage win32PeerlessImage = this;
        synchronized (win32PeerlessImage) {
            super.initAcceleratedBackground(graphicsConfiguration, n2, n3);
            if (this.surfaceDataHw == null) {
                if (this.timesTried++ > 3) {
                    this.localAccelerationEnabled = false;
                }
            } else {
                this.timesTried = 0;
            }
            if (this.surfaceDataHw != null && this.transparency == 2 && this.getBackgroundColor() == null) {
                this.flush();
                this.surfaceDataHw = null;
            }
        }
    }

    protected ColorModel getDeviceColorModel() {
        return this.cmHw;
    }

    private Integer findUnusedPixelDCM() {
        int n2;
        DataBufferInt dataBufferInt = (DataBufferInt)this.getRaster().getDataBuffer();
        this.localAccelerationEnabled = true;
        int[] nArray = dataBufferInt.getData();
        int[] nArray2 = new int[1024];
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 = this.surfaceDataHw.pixelFor(nArray[n3]);
            int n4 = n2 & 0x3FF;
            nArray2[n4] = nArray2[n4] + 1;
            ++n3;
        }
        n2 = 0;
        while (n2 < nArray2.length) {
            int n5 = nArray2[n2];
            if (n5 == 0) {
                return new Integer(n2);
            }
            ++n2;
        }
        return null;
    }

    private Integer findUnusedPixelICM() {
        int n2;
        IndexColorModel indexColorModel = (IndexColorModel)this.getColorModel();
        int n3 = indexColorModel.getMapSize();
        int[] nArray = new int[256];
        int[] nArray2 = new int[n3];
        indexColorModel.getRGBs(nArray2);
        int n4 = 0;
        while (n4 < n3) {
            n2 = this.surfaceDataHw.pixelFor(nArray2[n4]);
            int n5 = n2 & 0xFF;
            nArray[n5] = nArray[n5] + 1;
            ++n4;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            int n6 = nArray[n2];
            if (n6 == 0) {
                return new Integer(n2);
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return new String("Win32PeerlessImage@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }

    protected boolean operationSupported(CompositeType compositeType, Color color, boolean bl2) {
        if (this.transparency == 1) {
            if (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType)) {
                return !bl2 || Win32OffScreenSurfaceData.isDDScaleEnabled();
            }
        } else if (this.transparency == 3 ? (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcOver.equals(compositeType)) && color == null : CompositeType.SrcOverNoEa.equals(compositeType) && color == null) {
            return !bl2;
        }
        return false;
    }

    public static boolean isValidBitmaskConfig(ColorModel colorModel, ColorModel colorModel2, int n2) {
        if (colorModel.getTransparency() == 2 && colorModel2.getPixelSize() != 8) {
            if (colorModel instanceof IndexColorModel) {
                return true;
            }
            if (colorModel instanceof DirectColorModel && colorModel.getPixelSize() == 25 && colorModel.getTransferType() == 3 && n2 <= 65536) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidOpaqueConfig(ColorModel colorModel, ColorModel colorModel2, int n2) {
        return colorModel.getTransparency() == 1;
    }

    public static boolean isValidTranslucentConfig(ColorModel colorModel, ColorModel colorModel2, int n2) {
        return isTranslucentImagesAccEnabled && colorModel.getTransparency() == 3;
    }

    public Win32PeerlessImage(ColorModel colorModel, ColorModel colorModel2, WritableRaster writableRaster, boolean bl2, int n2) {
        super(null, colorModel, writableRaster, bl2);
        this.cmHw = colorModel2;
        this.transparency = n2;
        if (AcceleratedOffScreenImage.getAccelerationThreshold() == 0) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedBackground(graphicsConfiguration, this.getWidth(), this.getHeight());
        }
    }
}

