/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import sun.awt.windows.Win32DDRenderer;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;

public class Win32D3DRenderer
extends Win32DDRenderer {
    public Win32D3DRenderer traceWrapD3D() {
        return new Tracer();
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        if (n2 == n4 || n3 == n5) {
            super.drawLine(sunGraphics2D, n2, n3, n4, n5);
            return;
        }
        int n6 = n2 + sunGraphics2D.transX;
        int n7 = n3 + sunGraphics2D.transY;
        int n8 = n4 + sunGraphics2D.transX;
        int n9 = n5 + sunGraphics2D.transY;
        if (!this.lineClipNeeded(sunGraphics2D, n6, n7, n8, n9)) {
            if (!this.doDrawLineD3D(sunGraphics2D.surfaceData, sunGraphics2D.rgb, n6, n7, n8, n9)) {
                ((Win32OffScreenSurfaceData)sunGraphics2D.surfaceData).disableD3D();
                sunGraphics2D.validatePipe();
                super.drawLine(sunGraphics2D, n2, n3, n4, n5);
            }
        } else {
            super.drawLine(sunGraphics2D, n2, n3, n4, n5);
        }
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            return;
        }
        if (n4 == 0 || n5 == 0) {
            this.drawLine(sunGraphics2D, n2, n3, n2 + n4, n3 + n5);
            return;
        }
        int n6 = n2 + sunGraphics2D.transX;
        int n7 = n3 + sunGraphics2D.transY;
        if (!this.rectClipNeeded(sunGraphics2D, n6, n7, n4, n5)) {
            if (!this.doDrawRectD3D(sunGraphics2D.surfaceData, sunGraphics2D.rgb, n6, n7, n4, n5)) {
                ((Win32OffScreenSurfaceData)sunGraphics2D.surfaceData).disableD3D();
                sunGraphics2D.validatePipe();
                super.drawRect(sunGraphics2D, n2, n3, n4, n5);
            }
        } else {
            super.drawRect(sunGraphics2D, n2, n3, n4, n5);
        }
    }

    private boolean lineClipNeeded(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        return n2 < sunGraphics2D.clipX1 || n4 < sunGraphics2D.clipX1 || n2 > sunGraphics2D.clipX2 || n4 > sunGraphics2D.clipX2 || n3 < sunGraphics2D.clipY1 || n5 < sunGraphics2D.clipY1 || n3 > sunGraphics2D.clipY2 || n5 > sunGraphics2D.clipY2;
    }

    private boolean rectClipNeeded(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        return n2 < sunGraphics2D.clipX1 || n2 + n4 < sunGraphics2D.clipX1 || n2 > sunGraphics2D.clipX2 || n2 + n4 > sunGraphics2D.clipX2 || n3 < sunGraphics2D.clipY1 || n3 + n5 < sunGraphics2D.clipY1 || n3 > sunGraphics2D.clipY2 || n3 + n5 > sunGraphics2D.clipY2;
    }

    native boolean doDrawLineD3D(SurfaceData var1, int var2, int var3, int var4, int var5, int var6);

    native boolean doDrawRectD3D(SurfaceData var1, int var2, int var3, int var4, int var5, int var6);

    public static class Tracer
    extends Win32D3DRenderer {
        void doFillRectDD(SurfaceData surfaceData, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("DDFillRect");
            super.doFillRectDD(surfaceData, n2, n3, n4, n5, n6);
        }

        boolean doDrawLineD3D(SurfaceData surfaceData, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("D3DDrawLine");
            return super.doDrawLineD3D(surfaceData, n2, n3, n4, n5, n6);
        }

        boolean doDrawRectD3D(SurfaceData surfaceData, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("D3DDrawRect");
            return super.doDrawRectD3D(surfaceData, n2, n3, n4, n5, n6);
        }

        void devCopyArea(SurfaceData surfaceData, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDICopyArea");
            super.devCopyArea(surfaceData, n2, n3, n4, n5, n6, n7);
        }

        void doDrawLine(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIDrawLine");
            super.doDrawLine(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doDrawOval(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIDrawOval");
            super.doDrawOval(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doDrawRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRect");
            super.doDrawRect(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doFillOval(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDIFillOval");
            super.doFillOval(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doFillRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("DDFillRect");
            super.doFillRect(surfaceData, rectangle, n2, n3, n4, n5, n6);
        }

        void doDrawArc(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIDrawArc");
            super.doDrawArc(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doDrawRoundRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRoundRect");
            super.doDrawRoundRect(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doFillArc(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIFillArc");
            super.doFillArc(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doFillRoundRect(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("GDIFillRoundRect");
            super.doFillRoundRect(surfaceData, rectangle, n2, n3, n4, n5, n6, n7, n8);
        }

        void doFillPoly(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillPoly");
            super.doFillPoly(surfaceData, rectangle, n2, n3, n4, nArray, nArray2, n5);
        }

        void doDrawPoly(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("GDIDrawPoly");
            super.doDrawPoly(surfaceData, rectangle, n2, n3, n4, nArray, nArray2, n5, bl2);
        }

        void doShape(SurfaceData surfaceData, Rectangle rectangle, int n2, int n3, int n4, GeneralPath generalPath, boolean bl2) {
            GraphicsPrimitive.tracePrimitive(bl2 ? "GDIFillShape" : "GDIDrawShape");
            super.doShape(surfaceData, rectangle, n2, n3, n4, generalPath, bl2);
        }
    }
}

