/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.ImageRepresentation;
import sun.awt.windows.ModalityEvent;
import sun.awt.windows.ModalityListener;
import sun.awt.windows.WButtonPeer;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WCheckboxMenuItemPeer;
import sun.awt.windows.WCheckboxPeer;
import sun.awt.windows.WChoicePeer;
import sun.awt.windows.WClipboard;
import sun.awt.windows.WCustomCursor;
import sun.awt.windows.WDesktopProperties;
import sun.awt.windows.WDialogPeer;
import sun.awt.windows.WDragSourceContextPeer;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WFontPeer;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WInputMethod;
import sun.awt.windows.WInputMethodDescriptor;
import sun.awt.windows.WLabelPeer;
import sun.awt.windows.WListPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuItemPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WMouseDragGestureRecognizer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WPrintDialog;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.WRobotPeer;
import sun.awt.windows.WScrollPanePeer;
import sun.awt.windows.WScrollbarPeer;
import sun.awt.windows.WTextAreaPeer;
import sun.awt.windows.WTextFieldPeer;
import sun.awt.windows.WWindowPeer;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.LoadLibraryAction;

public class WToolkit
extends SunToolkit
implements Runnable {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$windows$WToolkit == null ? (class$sun$awt$windows$WToolkit = WToolkit.class$("sun.awt.windows.WToolkit")) : class$sun$awt$windows$WToolkit);
    static GraphicsConfiguration config;
    WClipboard clipboard;
    private Hashtable cacheFontPeer;
    private WDesktopProperties wprops;
    protected boolean dynamicLayoutSetting = false;
    public static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.windows.WDataTransferer";
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String awtPrefix = "awt.";
    private ModalityListenerList modalityListeners = new ModalityListenerList(this);
    static Class class$sun$awt$windows$WToolkit;
    static Class class$java$awt$dnd$MouseDragGestureRecognizer;
    static Class class$sun$awt$shell$Win32ShellFolderManager;

    public native int getMaximumCursorColors();

    protected native int getScreenHeight();

    public native int getScreenResolution();

    protected native int getScreenWidth();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        Win32GraphicsEnvironment.initDisplayWrapper();
        WToolkit.initIDs();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("browser");
                if (string != null && string.equals("sun.plugin")) {
                    WToolkit.access$000();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("WToolkit construction");
        }
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            Thread thread = new Thread(this, "AWT-Windows");
            thread.setDaemon(true);
            thread.setPriority(6);
            thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
    }

    static void access$000() {
        WToolkit.disableCustomPalette();
    }

    public native void beep();

    private static native void disableCustomPalette();

    public static void displayChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).displayChanged();
            }
        });
    }

    public native void embeddedEventLoopIdleProcessing();

    private native void eventLoop();

    protected native void finalize();

    private static native void initIDs();

    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.wprops = new WDesktopProperties(this);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", this.wprops.getProperty("win.drag.x"));
        this.desktopProperties.put("Shell.shellFolderManager", class$sun$awt$shell$Win32ShellFolderManager == null ? (class$sun$awt$shell$Win32ShellFolderManager = WToolkit.class$("sun.awt.shell.Win32ShellFolderManager")) : class$sun$awt$shell$Win32ShellFolderManager);
    }

    static void paletteChanged() {
        ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).paletteChanged();
    }

    public native void popModality();

    private static native void printWindowsVersion();

    public native void pushModality();

    public static native void quitSecondaryEventLoop();

    public static void resetGC() {
        config = GraphicsEnvironment.isHeadless() ? null : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        boolean bl2 = this.init();
        if (bl2) {
            object = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(this){
                private final WToolkit this$0;

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
                {
                    this.this$0 = wToolkit;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread((ThreadGroup)object, new Runnable(this){
                private final WToolkit this$0;

                public void run() {
                    WToolkit.access$100(this.this$0);
                }
                {
                    this.this$0 = wToolkit;
                }
            }));
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        if (bl2) {
            this.eventLoop();
        }
    }

    private native void shutdown();

    public static native void startSecondaryEventLoop();

    public native void sync();

    private void windowsSettingChange() {
        if (this.wprops != null) {
            this.wprops.firePropertyChanges();
        }
    }

    public static native boolean embeddedDispose();

    public static native boolean embeddedInit();

    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    private native boolean init();

    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSet() && this.isDynamicLayoutSupported();
    }

    protected boolean isDynamicLayoutSet() {
        return this.dynamicLayoutSetting;
    }

    protected boolean isDynamicLayoutSupported() {
        Boolean bl2 = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported");
        this.clearDesktopProperty("awt.dynamicLayoutSupported");
        return bl2 != null && !bl2.equals(Boolean.FALSE);
    }

    protected native boolean isDynamicLayoutSupportedNative();

    final void notifyModalityChange(int n2) {
        ModalityEvent modalityEvent = new ModalityEvent(this, this.modalityListeners, n2);
        modalityEvent.dispatch();
    }

    public boolean getLockingKeyState(int n2) {
        if (n2 != 20 && n2 != 144 && n2 != 145 && n2 != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n2);
    }

    public native boolean getLockingKeyStateNative(int var1);

    public boolean isFrameStateSupported(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void setLockingKeyState(int n2, boolean bl2) {
        if (n2 != 20 && n2 != 144 && n2 != 145 && n2 != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.setLockingKeyState");
        }
        this.setLockingKeyStateNative(n2, bl2);
    }

    public native void setLockingKeyStateNative(int var1, boolean var2);

    public void setDynamicLayout(boolean bl2) {
        if (bl2 == this.dynamicLayoutSetting) {
            return;
        }
        this.dynamicLayoutSetting = bl2;
        this.setDynamicLayoutNative(bl2);
    }

    protected native void setDynamicLayoutNative(boolean var1);

    protected native void loadSystemColors(int[] var1);

    public Dimension getBestCursorSize(int n2, int n3) {
        return new Dimension(WCustomCursor.getCursorWidth(), WCustomCursor.getCursorHeight());
    }

    protected native Insets getScreenInsets(int var1);

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.clipboard == null) {
            this.clipboard = new WClipboard();
        }
        return this.clipboard;
    }

    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        return new WInputMethodDescriptor();
    }

    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    static ColorModel getStaticColorModel() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        if (config == null) {
            WToolkit.resetGC();
        }
        return config.getColorModel();
    }

    static native ColorModel makeColorModel();

    synchronized void clearDesktopProperty(String string) {
        this.desktopProperties.remove(string);
    }

    public Locale getDefaultKeyboardLocale() {
        Locale locale = WInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    public void addModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.add(modalityListener);
    }

    public void removeModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.remove(modalityListener);
    }

    public static WToolkit getWToolkit() {
        WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
        return wToolkit;
    }

    static void access$100(WToolkit wToolkit) {
        wToolkit.shutdown();
    }

    public FontMetrics getFontMetrics(Font font) {
        if (NativeFontWrapper.usePlatformFontMetrics()) {
            return WFontMetrics.getFontMetrics(font);
        }
        return super.getFontMetrics(font);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return this.getScreenInsets(((Win32GraphicsDevice)graphicsConfiguration.getDevice()).getScreen());
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return WDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n2, n3, imageObserver);
    }

    static int checkScrImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (!(image instanceof WImage)) {
            return 32;
        }
        WImage wImage = (WImage)image;
        int n4 = n2 == 0 || n3 == 0 ? 32 : wImage.getImageRep().check(imageObserver);
        return wImage.check(imageObserver) | n4;
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n2, n3, imageObserver);
    }

    static boolean prepareScrImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (n2 == 0 || n3 == 0) {
            return true;
        }
        if (!(image instanceof WImage)) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    public ButtonPeer createButton(Button button) {
        WButtonPeer wButtonPeer = new WButtonPeer(button);
        SunToolkit.targetCreatedPeer(button, wButtonPeer);
        return wButtonPeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        WCanvasPeer wCanvasPeer = new WCanvasPeer(canvas);
        SunToolkit.targetCreatedPeer(canvas, wCanvasPeer);
        return wCanvasPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        WCheckboxMenuItemPeer wCheckboxMenuItemPeer = new WCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.targetCreatedPeer(checkboxMenuItem, wCheckboxMenuItemPeer);
        return wCheckboxMenuItemPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        WCheckboxPeer wCheckboxPeer = new WCheckboxPeer(checkbox);
        SunToolkit.targetCreatedPeer(checkbox, wCheckboxPeer);
        return wCheckboxPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        WChoicePeer wChoicePeer = new WChoicePeer(choice);
        SunToolkit.targetCreatedPeer(choice, wChoicePeer);
        return wChoicePeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        WDialogPeer wDialogPeer = new WDialogPeer(dialog);
        SunToolkit.targetCreatedPeer(dialog, wDialogPeer);
        return wDialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        WFileDialogPeer wFileDialogPeer = new WFileDialogPeer(fileDialog);
        SunToolkit.targetCreatedPeer(fileDialog, wFileDialogPeer);
        return wFileDialogPeer;
    }

    public FontPeer getFontPeer(String string, int n2) {
        FontPeer fontPeer = null;
        String string2 = string.toLowerCase();
        if (null != this.cacheFontPeer && null != (fontPeer = (FontPeer)this.cacheFontPeer.get(string2 + n2))) {
            return fontPeer;
        }
        fontPeer = new WFontPeer(string, n2);
        if (fontPeer != null) {
            if (null == this.cacheFontPeer) {
                this.cacheFontPeer = new Hashtable(5, 0.9f);
            }
            if (null != this.cacheFontPeer) {
                this.cacheFontPeer.put(string2 + n2, fontPeer);
            }
        }
        return fontPeer;
    }

    public FramePeer createFrame(Frame frame) {
        WFramePeer wFramePeer = new WFramePeer(frame);
        SunToolkit.targetCreatedPeer(frame, wFramePeer);
        return wFramePeer;
    }

    public LabelPeer createLabel(Label label) {
        WLabelPeer wLabelPeer = new WLabelPeer(label);
        SunToolkit.targetCreatedPeer(label, wLabelPeer);
        return wLabelPeer;
    }

    public ListPeer createList(List list) {
        WListPeer wListPeer = new WListPeer(list);
        SunToolkit.targetCreatedPeer(list, wListPeer);
        return wListPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = new WMenuBarPeer(menuBar);
        SunToolkit.targetCreatedPeer(menuBar, wMenuBarPeer);
        return wMenuBarPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        WMenuItemPeer wMenuItemPeer = new WMenuItemPeer(menuItem);
        SunToolkit.targetCreatedPeer(menuItem, wMenuItemPeer);
        return wMenuItemPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        WMenuPeer wMenuPeer = new WMenuPeer(menu);
        SunToolkit.targetCreatedPeer(menu, wMenuPeer);
        return wMenuPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        WPanelPeer wPanelPeer = new WPanelPeer(panel);
        SunToolkit.targetCreatedPeer(panel, wPanelPeer);
        return wPanelPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        WPopupMenuPeer wPopupMenuPeer = new WPopupMenuPeer(popupMenu);
        SunToolkit.targetCreatedPeer(popupMenu, wPopupMenuPeer);
        return wPopupMenuPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        WScrollPanePeer wScrollPanePeer = new WScrollPanePeer(scrollPane);
        SunToolkit.targetCreatedPeer(scrollPane, wScrollPanePeer);
        return wScrollPanePeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        WScrollbarPeer wScrollbarPeer = new WScrollbarPeer(scrollbar);
        SunToolkit.targetCreatedPeer(scrollbar, wScrollbarPeer);
        return wScrollbarPeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        WTextAreaPeer wTextAreaPeer = new WTextAreaPeer(textArea);
        SunToolkit.targetCreatedPeer(textArea, wTextAreaPeer);
        return wTextAreaPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        WTextFieldPeer wTextFieldPeer = new WTextFieldPeer(textField);
        SunToolkit.targetCreatedPeer(textField, wTextFieldPeer);
        return wTextFieldPeer;
    }

    public WindowPeer createWindow(Window window) {
        WWindowPeer wWindowPeer = new WWindowPeer(window);
        SunToolkit.targetCreatedPeer(window, wWindowPeer);
        return wWindowPeer;
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (WDesktopProperties.isWindowsProperty(string)) {
            if (this.wprops == null) {
                this.wprops = new WDesktopProperties(this);
            }
            this.wprops.addPropertyChangeListener(string, propertyChangeListener);
        } else {
            super.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (WDesktopProperties.isWindowsProperty(string)) {
            if (this.wprops != null) {
                this.wprops.removePropertyChangeListener(string, propertyChangeListener);
            }
        } else {
            super.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String string) {
        boolean bl2 = this.isDynamicLayoutSupportedNative();
        Boolean bl3 = (Boolean)this.wprops.getProperty(string);
        if (bl3 == null || bl2 != bl3) {
            this.windowsSettingChange();
            return new Boolean(bl2);
        }
        return bl3;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                throw new RuntimeException("cannot load system cursor: " + string2);
            }
        }
        if (WDesktopProperties.isWindowsProperty(string) || string.startsWith(awtPrefix)) {
            WToolkit wToolkit = this;
            synchronized (wToolkit) {
                if (this.wprops == null) {
                    this.wprops = new WDesktopProperties(this);
                } else if (string.equals("awt.dynamicLayoutSupported")) {
                    return this.lazilyLoadDynamicLayoutSupportedProperty(string);
                }
                Object object = this.wprops.getProperty(string);
                return object;
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return WInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    public WEmbeddedFramePeer createEmbeddedFrame(WEmbeddedFrame wEmbeddedFrame) {
        WEmbeddedFramePeer wEmbeddedFramePeer = new WEmbeddedFramePeer(wEmbeddedFrame);
        SunToolkit.targetCreatedPeer(wEmbeddedFrame, wEmbeddedFramePeer);
        return wEmbeddedFramePeer;
    }

    WPrintDialogPeer createWPrintDialog(WPrintDialog wPrintDialog) {
        WPrintDialogPeer wPrintDialogPeer = new WPrintDialogPeer(wPrintDialog);
        SunToolkit.targetCreatedPeer(wPrintDialog, wPrintDialogPeer);
        return wPrintDialogPeer;
    }

    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new WRobotPeer(graphicsDevice);
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new WCustomCursor(image, point, string);
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        if ((class$java$awt$dnd$MouseDragGestureRecognizer == null ? (class$java$awt$dnd$MouseDragGestureRecognizer = WToolkit.class$("java.awt.dnd.MouseDragGestureRecognizer")) : class$java$awt$dnd$MouseDragGestureRecognizer).equals(clazz)) {
            return new WMouseDragGestureRecognizer(dragSource, component, n2, dragGestureListener);
        }
        return null;
    }

    class ModalityListenerList
    implements ModalityListener {
        Vector listeners;
        private final WToolkit this$0;

        public void modalityPopped(ModalityEvent modalityEvent) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ModalityListener)enumeration.nextElement()).modalityPopped(modalityEvent);
            }
        }

        public void modalityPushed(ModalityEvent modalityEvent) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ModalityListener)enumeration.nextElement()).modalityPushed(modalityEvent);
            }
        }

        void add(ModalityListener modalityListener) {
            this.listeners.addElement(modalityListener);
        }

        void remove(ModalityListener modalityListener) {
            this.listeners.removeElement(modalityListener);
        }

        ModalityListenerList(WToolkit wToolkit) {
            this.this$0 = wToolkit;
            this.listeners = new Vector();
        }
    }
}

