/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.windows.HTMLDecodingInputStream;
import sun.awt.windows.HTMLSupport;
import sun.awt.windows.WImage;
import sun.awt.windows.WToolkitThreadBlockedHandler;

public class WDataTransferer
extends DataTransferer {
    private static final String[] predefinedClipboardNames = new String[]{"", "TEXT", "BITMAP", "METAFILEPICT", "SYLK", "DIF", "TIFF", "OEM TEXT", "DIB", "PALETTE", "PENDATA", "RIFF", "WAVE", "UNICODE TEXT", "ENHMETAFILE", "HDROP", "LOCALE"};
    private static final Map predefinedClipboardNameMap;
    public static final int CF_TEXT = 1;
    public static final int CF_DIB = 8;
    public static final int CF_ENHMETAFILE = 14;
    public static final int CF_HDROP = 15;
    public static final int CF_LOCALE = 16;
    public static final long CF_HTML;
    public static final long CFSTR_INETURL;
    public static final Long L_CF_DIB;
    public static final Long L_CF_ENHMETAFILE;
    private static final Long L_CF_LOCALE;
    private static final Long[] imageFormats;
    private static final DirectColorModel directColorModel;
    private static final int[] bandmasks;
    private static WDataTransferer transferer;
    private final ToolkitThreadBlockedHandler handler = new WToolkitThreadBlockedHandler();
    static Class class$sun$awt$windows$WDataTransferer;
    static Class class$java$net$URL;

    static {
        HashMap hashMap = new HashMap(16, 1.0f);
        int n2 = 1;
        while (n2 < predefinedClipboardNames.length) {
            hashMap.put(predefinedClipboardNames[n2], new Long(n2));
            ++n2;
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        CF_HTML = WDataTransferer.registerClipboardFormat("HTML Format");
        CFSTR_INETURL = WDataTransferer.registerClipboardFormat("UniformResourceLocator");
        L_CF_DIB = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[8]);
        L_CF_ENHMETAFILE = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[14]);
        L_CF_LOCALE = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[16]);
        imageFormats = new Long[]{L_CF_DIB, L_CF_ENHMETAFILE};
        directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        bandmasks = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
    }

    private WDataTransferer() {
    }

    public boolean isFileFormat(long l2) {
        return l2 == 15L;
    }

    public boolean isImageFormat(long l2) {
        return l2 == 8L || l2 == 14L;
    }

    public boolean isLocaleDependentTextFormat(long l2) {
        return l2 == 1L || l2 == CFSTR_INETURL;
    }

    private native int[] platformImageBytesToImageData(byte[] var1, long var2);

    private native byte[] imageDataToPlatformImageBytes(int[] var1, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToPlatformBytes(Image image, long l2) {
        DataBufferInt dataBufferInt;
        Object object;
        int n2 = 0;
        int n3 = 0;
        if (image instanceof WImage) {
            object = ((WImage)image).getImageRep();
            ((ImageRepresentation)object).reconstruct(32);
            n2 = ((ImageRepresentation)object).getWidth();
            n3 = ((ImageRepresentation)object).getHeight();
        } else {
            n2 = image.getWidth(null);
            n3 = image.getHeight(null);
        }
        object = new BufferedImage(n2, n3, 1);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n3);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        try {
            graphics2D.drawImage(image, affineTransform, null);
            dataBufferInt = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            graphics2D.dispose();
            throw throwable;
        }
        graphics2D.dispose();
        WritableRaster writableRaster = ((BufferedImage)object).getRaster();
        dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        return this.imageDataToPlatformImageBytes(nArray, n2, n3, l2);
    }

    protected Long[] getImageFormatsAsLongArray() {
        return imageFormats;
    }

    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    private static native String getClipboardFormatName(long var0);

    protected String getNativeForFormat(long l2) {
        return l2 < (long)predefinedClipboardNames.length ? predefinedClipboardNames[(int)l2] : WDataTransferer.getClipboardFormatName(l2);
    }

    private static native long registerClipboardFormat(String var0);

    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDataTransferer getInstanceImpl() {
        if (transferer == null) {
            Class clazz = class$sun$awt$windows$WDataTransferer == null ? (class$sun$awt$windows$WDataTransferer = WDataTransferer.class$("sun.awt.windows.WDataTransferer")) : class$sun$awt$windows$WDataTransferer;
            synchronized (clazz) {
                if (transferer == null) {
                    transferer = new WDataTransferer();
                }
            }
        }
        return transferer;
    }

    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l2) throws IOException {
        int[] nArray;
        if (byArray == null) {
            byArray = DataTransferer.inputStreamToByteArray(inputStream);
        }
        if ((nArray = this.platformImageBytesToImageData(byArray, l2)) == null) {
            throw new IOException("data translation failed");
        }
        int n2 = nArray.length - 2;
        int n3 = nArray[n2];
        int n4 = nArray[n2 + 1];
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n2);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n3, n4, n3, bandmasks, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l2) throws IOException {
        byte[] byArray = super.translateTransferable(transferable, dataFlavor, l2);
        if (l2 == CF_HTML) {
            byArray = HTMLSupport.convertToHTMLFormat(byArray);
        }
        return byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Long getFormatForNativeAsLong(String string) {
        Long l2 = (Long)predefinedClipboardNameMap.get(string);
        if (l2 == null) {
            l2 = new Long(WDataTransferer.registerClipboardFormat(string));
        }
        return l2;
    }

    public Map getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        Map map = super.getFormatsForFlavors(dataFlavorArray, flavorTable);
        map.remove(L_CF_LOCALE);
        return map;
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        if (l2 == CF_HTML && dataFlavor.isFlavorTextType()) {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(byArray);
                byArray = null;
            }
            inputStream = new HTMLDecodingInputStream(inputStream);
        }
        if (l2 == CFSTR_INETURL && (class$java$net$URL == null ? (class$java$net$URL = WDataTransferer.class$("java.net.URL")) : class$java$net$URL).equals(dataFlavor.getRepresentationClass())) {
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
                inputStream = null;
            }
            String string = DataTransferer.getDefaultTextCharset();
            if (transferable != null && transferable.isDataFlavorSupported(DataTransferer.javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(DataTransferer.javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(byArray, string));
        }
        return super.translateBytesOrStream(inputStream, byArray, dataFlavor, l2, transferable);
    }
}

