/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class IntegerComponentRaster
extends SunWritableRaster {
    static final int TYPE_CUSTOM = 0;
    static final int TYPE_BYTE_SAMPLES = 1;
    static final int TYPE_USHORT_SAMPLES = 2;
    static final int TYPE_INT_SAMPLES = 3;
    static final int TYPE_BYTE_BANDED_SAMPLES = 4;
    static final int TYPE_USHORT_BANDED_SAMPLES = 5;
    static final int TYPE_INT_BANDED_SAMPLES = 6;
    static final int TYPE_BYTE_PACKED_SAMPLES = 7;
    static final int TYPE_USHORT_PACKED_SAMPLES = 8;
    static final int TYPE_INT_PACKED_SAMPLES = 9;
    static final int TYPE_INT_8BIT_SAMPLES = 10;
    static final int TYPE_BYTE_BINARY_SAMPLES = 11;
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected int[] data;
    protected int numDataElems;
    int type;
    private int maxX;
    private int maxY;

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    static {
        NativeLibLoader.loadLibraries();
        IntegerComponentRaster.initIDs();
    }

    private static native void initIDs();

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int[] getDataStorage() {
        this.notifyChanged();
        return this.data;
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    private void verify(boolean bl2) {
        if (this.dataOffsets[0] < 0) {
            throw new RasterFormatException("Data offset (" + this.dataOffsets[0] + ") must be >= 0");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numDataElements) {
            int n4 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[n3];
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (this.data.length < n2) {
            throw new RasterFormatException("Data array too small (should be " + n2 + " but is " + this.data.length + " )");
        }
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        return this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
    }

    private void setDataElements(int n2, int n3, int n4, int n5, Raster raster) {
        int n6;
        Object object;
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        int[] nArray = null;
        if (raster instanceof IntegerComponentRaster && this.pixelStride == 1 && this.numDataElements == 1) {
            int n9;
            object = (IntegerComponentRaster)raster;
            if (((Raster)object).getNumDataElements() != 1) {
                throw new ArrayIndexOutOfBoundsException("Number of bands does not match");
            }
            nArray = ((IntegerComponentRaster)object).getDataStorage();
            n6 = ((IntegerComponentRaster)object).getScanlineStride();
            int n10 = n9 = ((IntegerComponentRaster)object).getDataOffset(0);
            int n11 = this.dataOffsets[0] + (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
            if (((IntegerComponentRaster)object).getPixelStride() == this.pixelStride) {
                n4 *= this.pixelStride;
                int n12 = 0;
                while (n12 < n5) {
                    System.arraycopy(nArray, n10, this.data, n11, n4);
                    n10 += n6;
                    n11 += this.scanlineStride;
                    ++n12;
                }
                this.notifyChanged();
                return;
            }
        }
        object = null;
        n6 = 0;
        while (n6 < n5) {
            object = raster.getDataElements(n7, n8 + n6, n4, 1, object);
            this.setDataElements(n2, n3 + n6, n4, 1, object);
            ++n6;
        }
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = n2 + raster.getMinX();
        int n5 = n3 + raster.getMinY();
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.maxX || n5 + n7 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n4, n5, n6, n7, raster);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new IntegerComponentRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new IntegerComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < this.numDataElements) {
                    this.data[this.dataOffsets[n11] + n9] = nArray[n7++];
                    ++n11;
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numDataElements) {
            this.data[this.dataOffsets[n5] + n4] = nArray[n5];
            ++n5;
        }
        this.notifyChanged();
    }

    public String toString() {
        return new String("IntegerComponentRaster: width = " + this.width + " height = " + this.height + " #Bands = " + this.numBands + " #DataElements " + this.numDataElements + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY + " dataOffset[0] " + this.dataOffsets[0]);
    }

    public IntegerComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object instanceof int[] ? (int[])object : new int[this.numDataElements * n4 * n5];
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < this.numDataElements) {
                    nArray[n7++] = this.data[this.dataOffsets[n11] + n9];
                    ++n11;
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return nArray;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object == null ? new int[this.numDataElements] : (int[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numDataElements) {
            nArray[n5] = this.data[this.dataOffsets[n5] + n4];
            ++n5;
        }
        return nArray;
    }

    public IntegerComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public IntegerComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, IntegerComponentRaster integerComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, integerComponentRaster);
        boolean bl2;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel;
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new RasterFormatException("IntegerComponentRasters must haveinteger DataBuffers");
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        this.data = dataBufferInt.getData();
        if (dataBufferInt.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for IntegerComponentRasters must only have 1 bank.");
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitOffsets();
            bl2 = false;
            int n2 = 1;
            while (n2 < nArray.length) {
                if (nArray[n2] % 8 != 0) {
                    bl2 = true;
                }
                ++n2;
            }
        } else {
            throw new RasterFormatException("IntegerComponentRasters must have SinglePixelPackedSampleModel");
        }
        this.type = bl2 ? 9 : 10;
        this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
        this.pixelStride = 1;
        this.dataOffsets = new int[1];
        this.dataOffsets[0] = dataBufferInt.getOffset();
        this.bandOffset = this.dataOffsets[0];
        int n3 = rectangle.x - point.x;
        int n4 = rectangle.y - point.y;
        this.dataOffsets[0] = this.dataOffsets[0] + (n3 + n4 * this.scanlineStride);
        this.numDataElems = singlePixelPackedSampleModel.getNumDataElements();
        this.verify(false);
    }
}

