/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import sun.awt.geom.Curve;

final class Order2
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;

    public double getCX0() {
        return this.cx0;
    }

    public double getCY0() {
        return this.cy0;
    }

    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public double getXBot() {
        return this.x1;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXTop() {
        return this.x0;
    }

    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public double getYBot() {
        return this.y1;
    }

    public double getYTop() {
        return this.y0;
    }

    public int getOrder() {
        return 2;
    }

    public double TforY(double d2) {
        double[] dArray = new double[3];
        Order2.getEqn(dArray, this.y0, this.cy0, this.y1);
        dArray[0] = dArray[0] - d2;
        int n2 = QuadCurve2D.solveQuadratic(dArray, dArray);
        return Curve.firstValidRoot(dArray, n2);
    }

    public double XforT(double d2) {
        return (this.xcoeff2 * d2 + this.xcoeff1) * d2 + this.xcoeff0;
    }

    public double XforY(double d2) {
        if (d2 == this.y0) {
            return this.x0;
        }
        if (d2 == this.y1) {
            return this.x1;
        }
        return this.XforT(this.TforY(d2));
    }

    public double YforT(double d2) {
        return (this.ycoeff2 * d2 + this.ycoeff1) * d2 + this.ycoeff0;
    }

    public double nextVertical(double d2, double d3) {
        double d4 = -this.ycoeff1 / (2.0 * this.ycoeff2);
        if (d4 > d2 && d4 < d3) {
            return d4;
        }
        return d3;
    }

    public Order2(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        super(n2);
        if (d5 < d3) {
            d5 = d3;
        } else if (d5 > d7) {
            d5 = d7;
        }
        this.x0 = d2;
        this.y0 = d3;
        this.cx0 = d4;
        this.cy0 = d5;
        this.x1 = d6;
        this.y1 = d7;
        this.xmin = Math.min(Math.min(d2, d6), d4);
        this.xmax = Math.max(Math.max(d2, d6), d4);
        this.xcoeff0 = d2;
        this.xcoeff1 = d4 + d4 - d2 - d2;
        this.xcoeff2 = d2 - d4 - d4 + d6;
        this.ycoeff0 = d3;
        this.ycoeff1 = d5 + d5 - d3 - d3;
        this.ycoeff2 = d3 - d5 - d5 + d7;
    }

    public static int getHorizontalParams(double d2, double d3, double d4, double[] dArray) {
        if (d2 <= d3 && d3 <= d4) {
            return 0;
        }
        double d5 = (d2 -= d3) + (d4 -= d3);
        if (d5 == 0.0) {
            return 0;
        }
        double d6 = d2 / d5;
        if (d6 <= 0.0 || d6 >= 1.0) {
            return 0;
        }
        dArray[0] = d6;
        return 1;
    }

    public double dXforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return (this.xcoeff2 * d2 + this.xcoeff1) * d2 + this.xcoeff0;
            }
            case 1: {
                return 2.0 * this.xcoeff2 * d2 + this.xcoeff1;
            }
            case 2: {
                return 2.0 * this.xcoeff2;
            }
        }
        return 0.0;
    }

    public double dYforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return (this.ycoeff2 * d2 + this.ycoeff1) * d2 + this.ycoeff0;
            }
            case 1: {
                return 2.0 * this.ycoeff2 * d2 + this.ycoeff1;
            }
            case 2: {
                return 2.0 * this.ycoeff2;
            }
        }
        return 0.0;
    }

    public int getSegment(double[] dArray) {
        dArray[0] = this.cx0;
        dArray[1] = this.cy0;
        if (this.direction == 1) {
            dArray[2] = this.x1;
            dArray[3] = this.y1;
        } else {
            dArray[2] = this.x0;
            dArray[3] = this.y0;
        }
        return 2;
    }

    public static void getEqn(double[] dArray, double d2, double d3, double d4) {
        dArray[0] = d2;
        dArray[1] = d3 + d3 - d2 - d2;
        dArray[2] = d2 - d3 - d3 + d4;
    }

    public static void split(double[] dArray, int n2, double d2) {
        double d3;
        double d4;
        dArray[n2 + 8] = d4 = dArray[n2 + 4];
        dArray[n2 + 9] = d3 = dArray[n2 + 5];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        d4 = d5 + (d4 - d5) * d2;
        d3 = d6 + (d3 - d6) * d2;
        double d7 = dArray[n2 + 0];
        double d8 = dArray[n2 + 1];
        d7 += (d5 - d7) * d2;
        d8 += (d6 - d8) * d2;
        d5 = d7 + (d4 - d7) * d2;
        d6 = d8 + (d3 - d8) * d2;
        dArray[n2 + 2] = d7;
        dArray[n2 + 3] = d8;
        dArray[n2 + 4] = d5;
        dArray[n2 + 5] = d6;
        dArray[n2 + 6] = d4;
        dArray[n2 + 7] = d3;
    }

    public void enlarge(Rectangle2D rectangle2D) {
        rectangle2D.add(this.x0, this.y0);
        double d2 = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (d2 > 0.0 && d2 < 1.0) {
            rectangle2D.add(this.XforT(d2), this.YforT(d2));
        }
        rectangle2D.add(this.x1, this.y1);
    }

    public String controlPointString() {
        return "(" + Curve.round(this.cx0) + ", " + Curve.round(this.cy0) + "), ";
    }

    public static void insert(Vector vector, double[] dArray, double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        int n3 = Order2.getHorizontalParams(d3, d5, d7, dArray);
        if (n3 == 0) {
            vector.add(new Order2(d2, d3, d4, d5, d6, d7, n2));
            return;
        }
        double d8 = dArray[0];
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray[4] = d6;
        dArray[5] = d7;
        Order2.split(dArray, 0, d8);
        Order2 order2 = Order2.getInstance(d2, d3, dArray[2], dArray[3], dArray[4], dArray[5], n2);
        Order2 order22 = Order2.getInstance(dArray[4], dArray[5], dArray[6], dArray[7], d6, d7, n2);
        if (n2 == 1) {
            vector.add(order2);
            vector.add(order22);
        } else {
            vector.add(order22);
            vector.add(order2);
        }
    }

    public Curve getReversedCurve() {
        return new Order2(this.x0, this.y0, this.cx0, this.cy0, this.x1, this.y1, -this.direction);
    }

    public Curve getSubCurve(double d2, double d3, int n2) {
        double d4;
        int n3;
        double d5;
        if (d2 == this.y0 && d3 == this.y1) {
            return this.getWithDirection(n2);
        }
        double[] dArray = new double[10];
        if (d2 == this.y0) {
            d5 = 0.0;
        } else {
            Order2.getEqn(dArray, this.y0, this.cy0, this.y1);
            dArray[0] = dArray[0] - d2;
            n3 = QuadCurve2D.solveQuadratic(dArray, dArray);
            d5 = Curve.firstValidRoot(dArray, n3);
        }
        if (d3 == this.y1) {
            d4 = 1.0;
        } else {
            Order2.getEqn(dArray, this.y0, this.cy0, this.y1);
            dArray[0] = dArray[0] - d3;
            n3 = QuadCurve2D.solveQuadratic(dArray, dArray);
            d4 = Curve.firstValidRoot(dArray, n3);
        }
        dArray[0] = this.x0;
        dArray[1] = this.y0;
        dArray[2] = this.cx0;
        dArray[3] = this.cy0;
        dArray[4] = this.x1;
        dArray[5] = this.y1;
        if (d4 < 1.0) {
            Order2.split(dArray, 0, d4);
        }
        if (d5 <= 0.0) {
            return new Order2(dArray[0], d2, dArray[2], dArray[3], dArray[4], d3, n2);
        }
        Order2.split(dArray, 0, d5 / d4);
        return new Order2(dArray[4], d2, dArray[6], dArray[7], dArray[8], d3, n2);
    }

    public static Order2 getInstance(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        if (d3 > d7) {
            return new Order2(d6, d7, d4, d5, d2, d3, -n2);
        }
        return new Order2(d2, d3, d4, d5, d6, d7, n2);
    }
}

