/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import sun.awt.font.TextSource;

public class StandardTextSource
extends TextSource {
    char[] chars;
    int start;
    int len;
    int cstart;
    int clen;
    int level;
    int flags;
    Font font;
    FontRenderContext frc;
    LineMetrics lm;

    public int getBidiLevel() {
        return this.level;
    }

    public int getContextLength() {
        return this.clen;
    }

    public int getContextStart() {
        return this.cstart;
    }

    public int getLayoutFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.len;
    }

    public int getStart() {
        return this.start;
    }

    public char[] getChars() {
        return this.chars;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFRC() {
        return this.frc;
    }

    public LineMetrics getLineMetrics() {
        return this.lm;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl2) {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[start:");
        stringBuffer.append(this.start);
        stringBuffer.append(", len:");
        stringBuffer.append(this.len);
        stringBuffer.append(", cstart:");
        stringBuffer.append(this.cstart);
        stringBuffer.append(", clen:");
        stringBuffer.append(this.clen);
        stringBuffer.append(", chars:\"");
        if (bl2) {
            n3 = this.cstart;
            n2 = this.cstart + this.clen;
        } else {
            n3 = this.start;
            n2 = this.start + this.len;
        }
        int n4 = n3;
        while (n4 < n2) {
            if (n4 > n3) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Integer.toHexString(this.chars[n4]));
            ++n4;
        }
        stringBuffer.append("\"");
        stringBuffer.append(", level:");
        stringBuffer.append(this.level);
        stringBuffer.append(", flags:");
        stringBuffer.append(this.flags);
        stringBuffer.append(", font:");
        stringBuffer.append(this.font);
        stringBuffer.append(", frc:");
        stringBuffer.append(this.frc);
        stringBuffer.append(", lm:");
        stringBuffer.append(this.lm);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public TextSource getSubSource(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > this.len) {
            throw new IllegalArgumentException("bad start (" + n2 + ") or length (" + n3 + ")");
        }
        int n5 = this.level;
        if (n4 != 2) {
            boolean bl2;
            boolean bl3 = bl2 = (this.flags & 8) == 0;
            if (!(n4 == 0 && bl2 || n4 == 1 && !bl2)) {
                throw new IllegalArgumentException("direction flag is invalid");
            }
            n5 = bl2 ? 0 : 1;
        }
        return new StandardTextSource(this.chars, this.start + n2, n3, this.cstart, this.clen, n5, this.flags, this.font, this.frc, this.lm);
    }

    public StandardTextSource(char[] cArray, int n2, int n3, Font font, FontRenderContext fontRenderContext) {
        this(cArray, 0, cArray.length, 0, cArray.length, n2, n3, font, fontRenderContext, null);
    }

    public StandardTextSource(String string, int n2, int n3, Font font, FontRenderContext fontRenderContext) {
        this(string.toCharArray(), 0, string.length(), 0, string.length(), n2, n3, font, fontRenderContext, null);
    }

    public StandardTextSource(char[] cArray, int n2, int n3, int n4, int n5, int n6, int n7, Font font, FontRenderContext fontRenderContext, LineMetrics lineMetrics) {
        if (cArray == null) {
            throw new IllegalArgumentException("bad chars: null");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("bad cstart: " + n4);
        }
        if (n2 < n4) {
            throw new IllegalArgumentException("bad start: " + n2 + " for cstart: " + n4);
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("bad clen: " + n5);
        }
        if (n4 + n5 > cArray.length) {
            throw new IllegalArgumentException("bad clen: " + n5 + " cstart: " + n4 + " for array len: " + cArray.length);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bad len: " + n3);
        }
        if (n2 + n3 > n4 + n5) {
            throw new IllegalArgumentException("bad len: " + n3 + " start: " + n2 + " for cstart: " + n4 + " clen: " + n5);
        }
        if (font == null) {
            throw new IllegalArgumentException("bad font: null");
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException("bad frc: null");
        }
        this.chars = cArray;
        this.start = n2;
        this.len = n3;
        this.cstart = n4;
        this.clen = n5;
        this.level = n6;
        this.flags = n7;
        this.font = font;
        this.frc = fontRenderContext;
        this.lm = lineMetrics != null ? lineMetrics : font.getLineMetrics(cArray, n4, n5, fontRenderContext);
    }

    public StandardTextSource(char[] cArray, int n2, int n3, int n4, int n5, Font font, FontRenderContext fontRenderContext, LineMetrics lineMetrics) {
        this(cArray, n2, n3, n2, n3, n4, n5, font, fontRenderContext, lineMetrics);
    }
}

