/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.File;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.FontProperties;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.windows.WFontProperties;
import sun.awt.windows.WPrinterJob;
import sun.awt.windows.WToolkit;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.LoadLibraryAction;

public class Win32GraphicsEnvironment
extends SunGraphicsEnvironment
implements DisplayChangedListener {
    SunDisplayChanger displayChanger = new SunDisplayChanger();
    private static boolean displayInitialized;

    protected native int getDefaultScreen();

    protected native int getNumScreens();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        Win32GraphicsEnvironment.initDisplayWrapper();
    }

    public void displayChanged() {
        GraphicsDevice[] graphicsDeviceArray = this.resetDisplays();
        WToolkit.resetGC();
        int n2 = 0;
        while (n2 < graphicsDeviceArray.length) {
            if (graphicsDeviceArray[n2] instanceof Win32GraphicsDevice) {
                ((Win32GraphicsDevice)graphicsDeviceArray[n2]).displayChanged();
            }
            ++n2;
        }
        this.displayChanger.notifyListeners();
    }

    private static native void initDisplay();

    public static void initDisplayWrapper() {
        if (!displayInitialized) {
            displayInitialized = true;
            Win32GraphicsEnvironment.initDisplay();
        }
    }

    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreen()];
    }

    public synchronized GraphicsDevice[] resetDisplays() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        return graphicsDeviceArray;
    }

    protected GraphicsDevice makeScreenDevice(int n2) {
        return new Win32GraphicsDevice(n2);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new WPrinterJob();
    }

    protected native void deRegisterFontWithPlatform(String var1);

    protected native void registerFontWithPlatform(String var1);

    protected void registerFontsWithPlatform(String string) {
        File file = new File(string);
        String[] stringArray = file.list(new SunGraphicsEnvironment.TTFilter(this));
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = new File(file, stringArray[n2]);
            this.registerFontWithPlatform(file2.getAbsolutePath());
            ++n2;
        }
    }

    protected String getPlatformFontPath(boolean bl2) {
        return NativeFontWrapper.getFontPath(bl2);
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    protected FontProperties createFontProperties() {
        return new WFontProperties();
    }
}

