/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.awt.ClassDebugHelperImpl;
import sun.awt.DebugHelper;
import sun.awt.DebugSettings;
import sun.awt.GlobalDebugHelperImpl;
import sun.awt.NativeLibLoader;

abstract class DebugHelperImpl
extends DebugHelper {
    protected static DebugSettings settings;
    protected static DebugHelperImpl globalDebugHelperImpl;
    private static boolean initialized;
    private static final String PROP_ON = "on";
    private static final String PROP_TRACE = "trace";
    private static final String PROP_ASSERT = "assert";
    private DebugHelperImpl parent = null;
    private boolean tracingOn = false;
    private boolean assertionsOn = false;
    static Class class$sun$awt$DebugHelper;

    static {
        initialized = false;
    }

    static final void initGlobals() {
        if (!initialized) {
            NativeLibLoader.loadLibraries();
            initialized = true;
            settings = DebugSettings.getInstance();
            globalDebugHelperImpl = GlobalDebugHelperImpl.getInstance();
        }
    }

    protected void loadSettings() {
        boolean bl2 = this.getBoolean(PROP_ON, this.parent == null);
        boolean bl3 = this.getBoolean(PROP_ASSERT, this.parent != null ? this.parent.assertionsOn : true);
        boolean bl4 = this.getBoolean(PROP_TRACE, this.parent != null ? this.parent.tracingOn : false);
        this.setDebugOn(bl2);
        this.setAssertOn(bl3);
        this.setTraceOn(bl4);
    }

    public final synchronized void printStackTrace() {
        if (this.tracingOn) {
            Thread.dumpStack();
        }
    }

    public final synchronized void assertion(boolean bl2) {
        this.assertion(bl2, "");
    }

    public final synchronized void setAssertOn(boolean bl2) {
        this.assertionsOn = bl2;
    }

    protected synchronized native void setCTracingOn(boolean var1);

    public final synchronized void setDebugOn(boolean bl2) {
        try {
            Class clazz = class$sun$awt$DebugHelper == null ? (class$sun$awt$DebugHelper = DebugHelperImpl.class$("sun.awt.DebugHelper")) : class$sun$awt$DebugHelper;
            Field field = clazz.getDeclaredField(PROP_ON);
            if (!Modifier.isFinal(field.getModifiers())) {
                field.setBoolean(this, bl2);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public final synchronized void setTraceOn(boolean bl2) {
        this.tracingOn = bl2;
    }

    public final synchronized void print(Object object) {
        if (this.tracingOn) {
            DebugHelperImpl.printImpl(object.toString());
        }
    }

    public final synchronized void println(Object object) {
        if (this.tracingOn) {
            DebugHelperImpl.printlnImpl(object.toString());
        }
    }

    public final synchronized String toString() {
        String string = "Debug {\ton=false, \ttrace=" + this.tracingOn + ", " + "\tassert=" + this.assertionsOn + "}";
        return string;
    }

    static synchronized native void printImpl(String var0);

    static synchronized native void printlnImpl(String var0);

    protected synchronized int getInt(String string, int n2) {
        String string2 = this.getString(string, String.valueOf(n2));
        return Integer.parseInt(string2);
    }

    protected synchronized boolean getBoolean(String string, boolean bl2) {
        String string2 = this.getString(string, String.valueOf(bl2));
        return string2.equalsIgnoreCase("true");
    }

    public final synchronized void assertion(boolean bl2, String string) {
        if (this.assertionsOn && !bl2) {
            throw new AssertionFailure(this, string);
        }
    }

    protected synchronized native void setCTracingOn(boolean var1, String var2);

    protected synchronized native void setCTracingOn(boolean var1, String var2, int var3);

    protected DebugHelperImpl getParent() {
        return this.parent;
    }

    protected DebugHelperImpl(DebugHelperImpl debugHelperImpl) {
        this.parent = debugHelperImpl;
    }

    protected void setParent(DebugHelperImpl debugHelperImpl) {
        this.parent = debugHelperImpl;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final DebugHelper factoryCreate(Class clazz) {
        DebugHelperImpl.initGlobals();
        return new ClassDebugHelperImpl(clazz);
    }

    protected synchronized String getString(String string, String string2) {
        String string3 = settings.getString(string, string2);
        return string3;
    }

    class AssertionFailure
    extends Error {
        private final DebugHelperImpl this$0;

        AssertionFailure(DebugHelperImpl debugHelperImpl, String string) {
            this.this$0 = debugHelperImpl;
            super(string);
        }
    }
}

