/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.applet.AppletClassLoader;
import sun.awt.AWTSecurityManager;
import sun.awt.AppContext;

public class AppletSecurity
extends AWTSecurityManager {
    private AppContext mainAppContext;
    private HashSet restrictedPackages = new HashSet();
    private static RuntimePermission threadPermission;
    private static RuntimePermission threadGroupPermission;
    private boolean inThreadGroupCheck = false;

    public AppletSecurity() {
        this.reset();
        this.mainAppContext = AppContext.getAppContext();
    }

    public void checkAwtEventQueueAccess() {
        AppContext appContext = AppContext.getAppContext();
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appContext == this.mainAppContext && appletClassLoader != null) {
            super.checkAwtEventQueueAccess();
        }
    }

    public void reset() {
        this.restrictedPackages.clear();
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final AppletSecurity this$0;

            public Object run() {
                Enumeration enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    AppletSecurity.access$000(this.this$0).add(string3);
                }
                return null;
            }
            {
                this.this$0 = appletSecurity;
            }
        });
    }

    public void checkPackageAccess(String string) {
        super.checkPackageAccess(string);
        Iterator iterator = this.restrictedPackages.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    public synchronized void checkAccess(Thread thread) {
        if (!this.inThreadGroup(thread)) {
            if (threadPermission == null) {
                threadPermission = new RuntimePermission("modifyThread");
            }
            this.checkPermission(threadPermission);
        }
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup;
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        ThreadGroup threadGroup2 = threadGroup = appletClassLoader == null ? null : appletClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return super.getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.inThreadGroupCheck) {
            if (threadGroupPermission == null) {
                threadGroupPermission = new RuntimePermission("modifyThreadGroup");
            }
            this.checkPermission(threadGroupPermission);
        } else {
            try {
                this.inThreadGroupCheck = true;
                if (!this.inThreadGroup(threadGroup)) {
                    if (threadGroupPermission == null) {
                        threadGroupPermission = new RuntimePermission("modifyThreadGroup");
                    }
                    this.checkPermission(threadGroupPermission);
                }
                Object var3_2 = null;
                this.inThreadGroupCheck = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.inThreadGroupCheck = false;
                throw throwable;
            }
        }
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        if (this.currentAppletClassLoader() == null) {
            return false;
        }
        return this.getThreadGroup().parentOf(threadGroup);
    }

    private AppletClassLoader currentAppletClassLoader() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null || classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        Class[] classArray = this.getClassContext();
        int n2 = 0;
        while (n2 < classArray.length) {
            classLoader = classArray[n2].getClassLoader();
            if (classLoader instanceof AppletClassLoader) {
                return (AppletClassLoader)classLoader;
            }
            ++n2;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        return null;
    }

    public AppContext getAppContext() {
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        return appletClassLoader == null ? null : appletClassLoader.getAppContext();
    }

    static HashSet access$000(AppletSecurity appletSecurity) {
        return appletSecurity.restrictedPackages;
    }
}

