/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Locale;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XString
extends XObject
implements XMLString {
    public static XString EMPTYSTRING = new XString("");

    public double num() {
        return this.toDouble();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double toDouble() {
        int n2 = this.length();
        if (0 == n2) {
            return Double.NaN;
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = n3;
        while (n5 < n2) {
            char c2 = this.charAt(n5);
            if (!XMLCharacterRecognizer.isWhiteSpace(c2)) break;
            ++n3;
            ++n5;
        }
        double d3 = 1.0;
        if (n3 < n2 && this.charAt(n3) == '-') {
            d3 = -1.0;
            ++n3;
        }
        int n6 = 0;
        int n7 = n3;
        while (n7 < n2) {
            char c3 = this.charAt(n7);
            if (c3 != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c3)) break;
                if (!Character.isDigit(c3)) return Double.NaN;
                d2 = d2 * 10.0 + (double)(c3 - 48);
                ++n6;
            } else {
                n4 = n7;
                break;
            }
            ++n7;
        }
        if (this.charAt(n4) == '.') {
            double d4 = 0.0;
            int n8 = n2 - 1;
            while (n8 > n4) {
                char c4 = this.charAt(n8);
                if (XMLCharacterRecognizer.isWhiteSpace(c4)) break;
                if (!Character.isDigit(c4)) return Double.NaN;
                d4 = d4 / 10.0 + (double)(c4 - 48);
                ++n6;
                --n8;
            }
            d2 += d4 / 10.0;
        }
        if (false != n6) return d2 * d3;
        return Double.NaN;
    }

    public int getType() {
        return 3;
    }

    public int hashCode() {
        return this.str().hashCode();
    }

    public int length() {
        return this.str().length();
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public boolean hasString() {
        return true;
    }

    private static boolean isSpace(char c2) {
        return XMLCharacterRecognizer.isWhiteSpace(c2);
    }

    public char charAt(int n2) {
        return this.str().charAt(n2);
    }

    public int indexOf(int n2) {
        return this.str().indexOf(n2);
    }

    public int lastIndexOf(int n2) {
        return this.str().lastIndexOf(n2);
    }

    public int indexOf(int n2, int n3) {
        return this.str().indexOf(n2, n3);
    }

    public int lastIndexOf(int n2, int n3) {
        return this.str().lastIndexOf(n2, n3);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        this.str().getChars(n2, n3, cArray, n4);
    }

    protected XString(Object object) {
        super(object);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        return this.str().equals(object.toString());
    }

    public String getTypeString() {
        return "#STRING";
    }

    public String str() {
        return null != this.m_obj ? (String)this.m_obj : "";
    }

    public int indexOf(String string) {
        return this.str().indexOf(string);
    }

    public int lastIndexOf(String string) {
        return this.str().lastIndexOf(string);
    }

    public XString(String string) {
        super(string);
    }

    public boolean endsWith(String string) {
        return this.str().endsWith(string);
    }

    public boolean equalsIgnoreCase(String string) {
        return this.str().equalsIgnoreCase(string);
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public int indexOf(String string, int n2) {
        return this.str().indexOf(string, n2);
    }

    public int lastIndexOf(String string, int n2) {
        return this.str().lastIndexOf(string, n2);
    }

    public boolean startsWith(String string, int n2) {
        return this.str().startsWith(string, n2);
    }

    public XMLString toLowerCase() {
        return new XString(this.str().toLowerCase());
    }

    public XMLString toUpperCase() {
        return new XString(this.str().toUpperCase());
    }

    public XMLString trim() {
        return new XString(this.str().trim());
    }

    public XMLString xstr() {
        return this;
    }

    public XMLString substring(int n2) {
        return new XString(this.str().substring(n2));
    }

    public XMLString substring(int n2, int n3) {
        return new XString(this.str().substring(n2, n3));
    }

    public int compareTo(XMLString xMLString) {
        int n2 = this.length();
        int n3 = xMLString.length();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = 0;
        while (n4-- != 0) {
            char c2;
            char c3 = this.charAt(n5);
            if (c3 != (c2 = xMLString.charAt(n6))) {
                return c3 - c2;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public int compareToIgnoreCase(XMLString xMLString) {
        throw new WrappedRuntimeException(new NoSuchMethodException("Java 1.2 method, not yet implemented"));
    }

    public int indexOf(XMLString xMLString) {
        return this.str().indexOf(xMLString.toString());
    }

    public boolean equals(XMLString xMLString) {
        if (!xMLString.hasString()) {
            return xMLString.equals(this);
        }
        return this.str().equals(xMLString.toString());
    }

    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString var1_1, int var2_2) {
        var3_3 = var2_2;
        var4_4 = this.length();
        var5_5 = 0;
        var6_6 = var1_1.length();
        if (var2_2 >= 0 && var2_2 <= var4_4 - var6_6) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.charAt(var3_3) != var1_1.charAt(var5_5)) {
                return false;
            }
            ++var3_3;
            ++var5_5;
lbl11:
            // 2 sources

            ** while (--var6_6 >= 0)
        }
lbl12:
        // 1 sources

        return true;
    }

    public XMLString fixWhiteSpace(boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3 = this.length();
        char[] cArray = new char[n3];
        this.getChars(0, n3, cArray, 0);
        boolean bl5 = false;
        int n4 = 0;
        while (n4 < n3) {
            if (XString.isSpace(cArray[n4])) break;
            ++n4;
        }
        int n5 = n4;
        boolean bl6 = false;
        while (n4 < n3) {
            n2 = cArray[n4];
            if (XString.isSpace((char)n2)) {
                if (!bl6) {
                    if (32 != n2) {
                        bl5 = true;
                    }
                    cArray[n5++] = 32;
                    if (bl4 && n4 != 0) {
                        char c2 = cArray[n4 - 1];
                        if (c2 != '.' && c2 != '!' && c2 != '?') {
                            bl6 = true;
                        }
                    } else {
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else {
                cArray[n5++] = n2;
                bl6 = false;
            }
            ++n4;
        }
        if (bl3 && 1 <= n5 && ' ' == cArray[n5 - 1]) {
            bl5 = true;
            --n5;
        }
        n2 = 0;
        if (bl2 && 0 < n5 && ' ' == cArray[0]) {
            bl5 = true;
            ++n2;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl5 ? xMLStringFactory.newstr(new String(cArray, n2, n5 - n2)) : this;
    }

    public int rtf(XPathContext xPathContext) {
        DTM dTM = xPathContext.createDocumentFragment();
        dTM.appendTextChild(this.str());
        return dTM.getDocument();
    }

    public boolean equals(XObject xObject) {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.str().equals(xObject.str());
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.str();
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public void dispatchAsComment(LexicalHandler lexicalHandler) throws SAXException {
        String string = this.str();
        lexicalHandler.comment(string.toCharArray(), 0, string.length());
    }

    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    public XMLString toLowerCase(Locale locale) {
        return new XString(this.str().toLowerCase(locale));
    }

    public XMLString toUpperCase(Locale locale) {
        return new XString(this.str().toUpperCase(locale));
    }
}

