/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class AxesWalker
extends PredicatedNodeTest
implements Cloneable {
    private DTM m_dtm;
    transient int m_root = -1;
    private transient int m_currentNode = -1;
    transient boolean m_isFresh;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;
    protected int m_axis = -1;
    protected DTMAxisTraverser m_traverser;

    public int getAxis() {
        return this.m_axis;
    }

    public final int getCurrentNode() {
        return this.m_currentNode;
    }

    protected int getNextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (this.m_isFresh) {
            this.m_currentNode = this.m_traverser.first(this.m_root);
            this.m_isFresh = false;
        } else if (-1 != this.m_currentNode) {
            this.m_currentNode = this.m_traverser.next(this.m_root, this.m_currentNode);
        }
        if (-1 == this.m_currentNode) {
            this.m_foundLast = true;
        }
        return this.m_currentNode;
    }

    public int getRoot() {
        return this.m_root;
    }

    public int nextNode() {
        int n2 = -1;
        AxesWalker axesWalker = this.wi().getLastUsedWalker();
        while (null != axesWalker) {
            n2 = axesWalker.getNextNode();
            if (-1 == n2) {
                axesWalker = axesWalker.m_prevWalker;
                continue;
            }
            if (axesWalker.acceptNode(n2) != 1) continue;
            if (null == axesWalker.m_nextWalker) {
                this.wi().setLastUsedWalker(axesWalker);
                break;
            }
            AxesWalker axesWalker2 = axesWalker;
            axesWalker = axesWalker.m_nextWalker;
            axesWalker.setRoot(n2);
            axesWalker.m_prevWalker = axesWalker2;
        }
        return n2;
    }

    public boolean isDocOrdered() {
        return true;
    }

    private int returnNextNode(int n2) {
        return n2;
    }

    public void setRoot(int n2) {
        this.m_dtm = this.wi().getXPathContext().getDTM(n2);
        this.m_traverser = this.m_dtm.getAxisTraverser(this.m_axis);
        this.m_isFresh = true;
        this.m_foundLast = false;
        this.m_root = n2;
        this.m_currentNode = n2;
        if (-1 == n2) {
            throw new RuntimeException("\n !!!! Error! Setting the root of a walker to null!!!");
        }
        this.resetProximityPositions();
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker axesWalker = (AxesWalker)super.clone();
        return axesWalker;
    }

    public DTM getDTM(int n2) {
        return this.wi().getXPathContext().getDTM(n2);
    }

    public void setDefaultDTM(DTM dTM) {
        this.m_dtm = dTM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPos(XPathContext xPathContext) {
        AxesWalker axesWalker;
        int n2 = this.getProximityPosition();
        try {
            axesWalker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        axesWalker.setPredicateCount(axesWalker.getPredicateCount() - 1);
        axesWalker.setNextWalker(null);
        axesWalker.setPrevWalker(null);
        WalkingIterator walkingIterator = this.wi();
        AxesWalker axesWalker2 = walkingIterator.getLastUsedWalker();
        try {
            int n3;
            walkingIterator.setLastUsedWalker(axesWalker);
            while (-1 != (n3 = axesWalker.nextNode())) {
                ++n2;
            }
            Object var8_8 = null;
            walkingIterator.setLastUsedWalker(axesWalker2);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            walkingIterator.setLastUsedWalker(axesWalker2);
            throw throwable;
        }
        return n2;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public void setNextWalker(AxesWalker axesWalker) {
        this.m_nextWalker = axesWalker;
    }

    public void setPrevWalker(AxesWalker axesWalker) {
        this.m_prevWalker = axesWalker;
    }

    public AxesWalker(LocPathIterator locPathIterator, int n2) {
        super(locPathIterator);
        this.m_axis = n2;
    }

    public final WalkingIterator wi() {
        return (WalkingIterator)this.m_lpi;
    }

    public void init(Compiler compiler, int n2, int n3) throws TransformerException {
        this.initPredicateInfo(compiler, n2);
    }

    static AxesWalker findClone(AxesWalker axesWalker, Vector vector) {
        if (null != vector) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (axesWalker == vector.elementAt(n3)) {
                    return (AxesWalker)vector.elementAt(n3 + 1);
                }
                n3 += 2;
            }
        }
        return null;
    }

    AxesWalker cloneDeep(WalkingIterator walkingIterator, Vector vector) throws CloneNotSupportedException {
        AxesWalker axesWalker = AxesWalker.findClone(this, vector);
        if (null != axesWalker) {
            return axesWalker;
        }
        axesWalker = (AxesWalker)this.clone();
        axesWalker.setLocPathIterator(walkingIterator);
        if (null != vector) {
            vector.addElement(this);
            vector.addElement(axesWalker);
        }
        if (this.wi().m_lastUsedWalker == this) {
            walkingIterator.m_lastUsedWalker = axesWalker;
        }
        if (null != this.m_nextWalker) {
            axesWalker.m_nextWalker = this.m_nextWalker.cloneDeep(walkingIterator, vector);
        }
        if (null != vector) {
            if (null != this.m_prevWalker) {
                axesWalker.m_prevWalker = this.m_prevWalker.cloneDeep(walkingIterator, vector);
            }
        } else if (null != this.m_nextWalker) {
            axesWalker.m_nextWalker.m_prevWalker = axesWalker;
        }
        return axesWalker;
    }
}

