/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Writer;
import java.util.Stack;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    public Document m_doc;
    protected Node m_currentNode = null;
    public DocumentFragment m_docFrag = null;
    protected Stack m_elemStack = new Stack();
    protected boolean m_inCData = false;

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDocument() throws SAXException {
    }

    private boolean isOutsideDocElem() {
        return null == this.m_docFrag && this.m_elemStack.size() == 0 && (null == this.m_currentNode || this.m_currentNode.getNodeType() == 9);
    }

    public void cdata(char[] cArray, int n2, int n3) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n2, n3)) {
            return;
        }
        String string = new String(cArray, n2, n3);
        this.append(this.m_doc.createCDATASection(string));
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n2, n3)) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(cArray, n2, n3);
            return;
        }
        String string = new String(cArray, n2, n3);
        Text text = this.m_doc.createTextNode(string);
        this.append(text);
    }

    public void charactersRaw(char[] cArray, int n2, int n3) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n2, n3)) {
            return;
        }
        String string = new String(cArray, n2, n3);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(string));
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        this.append(this.m_doc.createComment(new String(cArray, n2, n3)));
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.isOutsideDocElem()) {
            return;
        }
        String string = new String(cArray, n2, n3);
        this.append(this.m_doc.createTextNode(string));
    }

    public Writer getWriter() {
        return null;
    }

    public void endEntity(String string) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void entityReference(String string) throws SAXException {
        this.append(this.m_doc.createEntityReference(string));
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public DOMBuilder(Document document) {
        this.m_doc = document;
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public Node getRootNode() {
        return null != this.m_docFrag ? this.m_docFrag : this.m_doc;
    }

    protected void append(Node node) throws SAXException {
        Node node2 = this.m_currentNode;
        if (null != node2) {
            node2.appendChild(node);
        } else if (null != this.m_docFrag) {
            this.m_docFrag.appendChild(node);
        } else {
            boolean bl2 = true;
            short s2 = node.getNodeType();
            if (s2 == 3) {
                String string = node.getNodeValue();
                if (null != string && string.trim().length() > 0) {
                    throw new SAXException(XSLMessages.createXPATHMessage(63, null));
                }
                bl2 = false;
            } else if (s2 == 1 && this.m_doc.getDocumentElement() != null) {
                throw new SAXException(XSLMessages.createXPATHMessage(64, null));
            }
            if (bl2) {
                this.m_doc.appendChild(node);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(string, string2));
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public DOMBuilder(Document document, DocumentFragment documentFragment) {
        this.m_doc = document;
        this.m_docFrag = documentFragment;
    }

    public void setIDAttribute(String string, Element element) {
    }

    public DOMBuilder(Document document, Node node) {
        this.m_doc = document;
        this.m_currentNode = node;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = this.m_elemStack.isEmpty() ? null : (Node)this.m_elemStack.peek();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element = null == string || string.length() == 0 ? this.m_doc.createElement(string3) : this.m_doc.createElementNS(string, string3);
        this.append(element);
        try {
            int n2 = attributes.getLength();
            if (0 != n2) {
                int n3 = 0;
                while (n3 < n2) {
                    String string4;
                    if (attributes.getType(n3).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(attributes.getValue(n3), element);
                    }
                    if ((string4 = attributes.getURI(n3)) == null) {
                        string4 = "";
                    }
                    String string5 = attributes.getQName(n3);
                    if (string4.length() == 0) {
                        element.setAttribute(string5, attributes.getValue(n3));
                    } else {
                        element.setAttributeNS(string4, string5, attributes.getValue(n3));
                    }
                    ++n3;
                }
            }
            this.m_elemStack.push(element);
            this.m_currentNode = element;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }
}

