/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterToUTF8
extends Writer {
    private final OutputStream m_os;

    public void close() throws IOException {
        this.m_os.close();
    }

    public void flush() throws IOException {
        this.m_os.flush();
    }

    public void write(int n2) throws IOException {
        if (n2 < 128) {
            this.m_os.write(n2);
        } else if (n2 < 2048) {
            this.m_os.write(192 + (n2 >> 6));
            this.m_os.write(128 + (n2 & 0x3F));
        } else {
            this.m_os.write(224 + (n2 >> 12));
            this.m_os.write(128 + (n2 >> 6 & 0x3F));
            this.m_os.write(128 + (n2 & 0x3F));
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        OutputStream outputStream = this.m_os;
        int n4 = n3 + n2;
        int n5 = n2;
        while (n5 < n4) {
            char c2 = cArray[n5];
            if (c2 < '\u0080') {
                outputStream.write(c2);
            } else if (c2 < '\u0800') {
                outputStream.write(192 + (c2 >> 6));
                outputStream.write(128 + (c2 & 0x3F));
            } else {
                outputStream.write(224 + (c2 >> 12));
                outputStream.write(128 + (c2 >> 6 & 0x3F));
                outputStream.write(128 + (c2 & 0x3F));
            }
            ++n5;
        }
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public WriterToUTF8(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
    }

    public void write(String string) throws IOException {
        int n2 = string.length();
        OutputStream outputStream = this.m_os;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 < '\u0080') {
                outputStream.write(c2);
            } else if (c2 < '\u0800') {
                outputStream.write(192 + (c2 >> 6));
                outputStream.write(128 + (c2 & 0x3F));
            } else {
                outputStream.write(224 + (c2 >> 12));
                outputStream.write(128 + (c2 >> 6 & 0x3F));
                outputStream.write(128 + (c2 & 0x3F));
            }
            ++n3;
        }
    }
}

