/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

final class Doctype
extends NodeBase
implements DocumentType {
    private String name;
    private Nodemap entities;
    private Nodemap notations;
    private String publicId;
    private String systemId;
    private String internalSubset;

    public short getNodeType() {
        return 10;
    }

    void setReadonly() {
        this.entities.readonly = true;
        this.notations.readonly = true;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    protected void setOwnerDocument(XmlDocument xmlDocument) {
        super.setOwnerDocument(xmlDocument);
        if (this.entities != null) {
            int n2 = 0;
            while (this.entities.item(n2) != null) {
                ((NodeBase)this.entities.item(n2)).setOwnerDocument(xmlDocument);
                ++n2;
            }
        }
        if (this.notations != null) {
            int n3 = 0;
            while (this.notations.item(n3) != null) {
                ((NodeBase)this.notations.item(n3)).setOwnerDocument(xmlDocument);
                ++n3;
            }
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        Element element = this.getOwnerDocument().getDocumentElement();
        writer.write("<!DOCTYPE ");
        writer.write(element == null ? "UNKNOWN-ROOT" : element.getNodeName());
        if (this.systemId != null) {
            if (this.publicId != null) {
                writer.write(" PUBLIC '");
                writer.write(this.publicId);
                writer.write("' '");
            } else {
                writer.write(" SYSTEM '");
            }
            writer.write(this.systemId);
            writer.write("'");
        }
        if (this.internalSubset != null) {
            writer.write(XmlDocument.eol);
            writer.write("[");
            writer.write(this.internalSubset);
            writer.write("]");
        }
        writer.write(">");
        writer.write(XmlDocument.eol);
    }

    public NamedNodeMap getEntities() {
        return this.entities;
    }

    public NamedNodeMap getNotations() {
        return this.notations;
    }

    public Node cloneNode(boolean bl2) {
        Doctype doctype = new Doctype(this.name, this.publicId, this.systemId, this.internalSubset);
        doctype.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        return doctype;
    }

    void addEntityNode(String string, String string2) {
        if ("lt".equals(string) || "gt".equals(string) || "apos".equals(string) || "quot".equals(string) || "amp".equals(string)) {
            return;
        }
        EntityNode entityNode = new EntityNode(string, string2);
        entityNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(entityNode);
    }

    Doctype(String string, String string2, String string3) {
        this.publicId = string;
        this.systemId = string2;
        this.internalSubset = string3;
    }

    void addNotation(String string, String string2, String string3) {
        NotationNode notationNode = new NotationNode(string, string2, string3);
        notationNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.notations.setNamedItem(notationNode);
    }

    void setPrintInfo(String string, String string2, String string3) {
        this.publicId = string;
        this.systemId = string2;
        this.internalSubset = string3;
    }

    Doctype(String string, String string2, String string3, String string4) {
        this.name = string;
        this.publicId = string2;
        this.systemId = string3;
        this.internalSubset = string4;
        this.entities = new Nodemap();
        this.notations = new Nodemap();
    }

    void addEntityNode(String string, String string2, String string3, String string4) {
        EntityNode entityNode = new EntityNode(string, string2, string3, string4);
        entityNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(entityNode);
    }

    static class EntityNode
    extends NodeBase
    implements Entity {
        private String entityName;
        private String publicId;
        private String systemId;
        private String notation;
        private String value;

        public short getNodeType() {
            return 6;
        }

        public String getNodeName() {
            return this.entityName;
        }

        public String getNotationName() {
            return this.notation;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            Writer writer = xmlWriteContext.getWriter();
            writer.write("<!ENTITY ");
            writer.write(this.entityName);
            if (this.value == null) {
                if (this.publicId != null) {
                    writer.write(" PUBLIC '");
                    writer.write(this.publicId);
                    writer.write("' '");
                } else {
                    writer.write(" SYSTEM '");
                }
                writer.write(this.systemId);
                writer.write("'");
                if (this.notation != null) {
                    writer.write(" NDATA ");
                    writer.write(this.notation);
                }
            } else {
                writer.write(" \"");
                int n2 = this.value.length();
                int n3 = 0;
                while (n3 < n2) {
                    char c2 = this.value.charAt(n3);
                    if (c2 == '\"') {
                        writer.write("&quot;");
                    } else {
                        writer.write(c2);
                    }
                    ++n3;
                }
                writer.write(34);
            }
            writer.write(">");
        }

        public Node cloneNode(boolean bl2) {
            EntityNode entityNode = new EntityNode(this.entityName, this.publicId, this.systemId, this.notation);
            entityNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return entityNode;
        }

        EntityNode(String string, String string2) {
            this.entityName = string;
            this.value = string2;
        }

        EntityNode(String string, String string2, String string3, String string4) {
            this.entityName = string;
            this.publicId = string2;
            this.systemId = string3;
            this.notation = string4;
        }
    }

    static class Nodemap
    implements NamedNodeMap {
        boolean readonly;
        Vector list = new Vector();

        public int getLength() {
            return this.list.size();
        }

        Nodemap() {
        }

        public Node item(int n2) {
            if (n2 < 0 || n2 >= this.list.size()) {
                return null;
            }
            return (Node)this.list.elementAt(n2);
        }

        public Node getNamedItem(String string) {
            int n2 = this.list.size();
            int n3 = 0;
            while (n3 < n2) {
                Node node = this.item(n3);
                if (node.getNodeName().equals(string)) {
                    return node;
                }
                ++n3;
            }
            return null;
        }

        public Node removeNamedItem(String string) throws DOMException {
            throw new DomEx(7);
        }

        public Node setNamedItem(Node node) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(node);
            return null;
        }

        public Node setNamedItemNS(Node node) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(node);
            return null;
        }

        public Node getNamedItemNS(String string, String string2) {
            return null;
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            throw new DomEx(7);
        }
    }

    static class NotationNode
    extends NodeBase
    implements Notation {
        private String notation;
        private String publicId;
        private String systemId;

        public short getNodeType() {
            return 12;
        }

        public String getNodeName() {
            return this.notation;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            Writer writer = xmlWriteContext.getWriter();
            writer.write("<!NOTATION ");
            writer.write(this.notation);
            if (this.publicId != null) {
                writer.write(" PUBLIC '");
                writer.write(this.publicId);
                if (this.systemId != null) {
                    writer.write("' '");
                    writer.write(this.systemId);
                }
            } else {
                writer.write(" SYSTEM '");
                writer.write(this.systemId);
            }
            writer.write("'>");
        }

        public Node cloneNode(boolean bl2) {
            NotationNode notationNode = new NotationNode(this.notation, this.publicId, this.systemId);
            notationNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return notationNode;
        }

        NotationNode(String string, String string2, String string3) {
            this.notation = string;
            this.publicId = string2;
            this.systemId = string3;
        }
    }
}

