/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private Element ownerElement;

    public int getLength() {
        return this.list.size();
    }

    private AttributeSet() {
    }

    public void setReadonly() {
        this.readonly = true;
        int n2 = 0;
        while (n2 < this.list.size()) {
            ((AttributeNode)this.list.elementAt(n2)).setReadonly(true);
            ++n2;
        }
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(n2)).isReadonly()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    AttributeSet(AttributeSet attributeSet) {
        int n2 = attributeSet.getLength();
        this.list = new Vector(n2);
        int n3 = 0;
        while (n3 < n2) {
            Node node = attributeSet.item(n3);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            if (attributeNode.getSpecified()) {
                node = attributeNode.cloneAttributeNode(true);
                this.list.addElement(node);
            }
            ++n3;
        }
        this.list.trimToSize();
    }

    AttributeSet(AttributeSet attributeSet, boolean bl2) {
        int n2 = attributeSet.getLength();
        this.list = new Vector(n2);
        int n3 = 0;
        while (n3 < n2) {
            Node node = attributeSet.item(n3);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            node = attributeNode.cloneAttributeNode(bl2);
            this.list.addElement(node);
            ++n3;
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n3);
            if (attributeNode.getSpecified()) {
                writer.write(32);
                attributeNode.writeXml(xmlWriteContext);
            }
            ++n3;
        }
    }

    AttributeSet(Element element) {
        this.list = new Vector(5);
        this.ownerElement = element;
    }

    void setOwnerElement(Element element) {
        if (element != null && this.ownerElement != null) {
            throw new IllegalStateException(((NodeBase)((Object)element)).getMessage("A-004"));
        }
        this.ownerElement = element;
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n3);
            attributeNode.setOwnerElement(null);
            attributeNode.setOwnerElement(element);
            ++n3;
        }
    }

    public Node item(int n2) {
        if (n2 < 0 || n2 >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(n2);
    }

    String getValue(String string) {
        Attr attr = (Attr)this.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    static AttributeSet createAttributeSet1(Attributes attributes) throws DOMException {
        AttributeSet attributeSet = new AttributeSet();
        int n2 = attributes.getLength();
        AttributesEx attributesEx = null;
        attributeSet.list = new Vector(n2);
        if (attributes instanceof AttributesEx) {
            attributesEx = (AttributesEx)attributes;
        }
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode1 attributeNode1 = new AttributeNode1(attributes.getQName(n3), attributes.getValue(n3), attributesEx == null ? true : attributesEx.isSpecified(n3), attributesEx == null ? null : attributesEx.getDefault(n3));
            attributeSet.list.addElement(attributeNode1);
            ++n3;
        }
        return attributeSet;
    }

    static AttributeSet createAttributeSet2(Attributes attributes) throws DOMException {
        AttributeSet attributeSet = new AttributeSet();
        int n2 = attributes.getLength();
        AttributesEx attributesEx = null;
        attributeSet.list = new Vector(n2);
        if (attributes instanceof AttributesEx) {
            attributesEx = (AttributesEx)attributes;
        }
        int n3 = 0;
        while (n3 < n2) {
            String string;
            String string2 = attributes.getQName(n3);
            if ("xmlns".equals(string2) || "xmlns".equals(XmlNames.getPrefix(string2))) {
                string = "http://www.w3.org/2000/xmlns/";
            } else {
                string = attributes.getURI(n3);
                if ("".equals(string)) {
                    string = null;
                }
            }
            AttributeNode attributeNode = new AttributeNode(string, string2, attributes.getValue(n3), attributesEx == null ? true : attributesEx.isSpecified(n3), attributesEx == null ? null : attributesEx.getDefault(n3));
            attributeSet.list.addElement(attributeNode);
            ++n3;
        }
        return attributeSet;
    }

    public Node getNamedItem(String string) {
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            Node node = this.item(n3);
            if (node.getNodeName().equals(string)) {
                return node;
            }
            ++n3;
        }
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n2 = 0;
        while (n2 < this.list.size()) {
            Node node = (Node)this.list.elementAt(n2);
            if (node.getNodeName().equals(string)) {
                this.list.removeElementAt(n2);
                AttributeNode attributeNode = (AttributeNode)node;
                String string2 = attributeNode.getDefaultValue();
                if (string2 != null) {
                    AttributeNode attributeNode2 = attributeNode.cloneAttributeNode(true);
                    attributeNode2.setOwnerElement(attributeNode.getOwnerElement());
                    attributeNode2.setValue(string2);
                    attributeNode2.setSpecified(false);
                    this.list.addElement(attributeNode2);
                }
                attributeNode.setOwnerElement(null);
                return attributeNode;
            }
            ++n2;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n3);
            if (attributeNode2.getNodeName().equals(node.getNodeName())) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attributeNode, n3);
                attributeNode2.setOwnerElement(null);
                return attributeNode2;
            }
            ++n3;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(node);
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        String string = attributeNode.getLocalName();
        String string2 = attributeNode.getNamespaceURI();
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n3);
            String string3 = attributeNode2.getLocalName();
            String string4 = attributeNode2.getNamespaceURI();
            if ((string == string3 || string != null && string.equals(string3)) && (string2 == string4 || string2 != null && string2.equals(string4))) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attributeNode, n3);
                attributeNode2.setOwnerElement(null);
                return attributeNode2;
            }
            ++n3;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(attributeNode);
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.list.size()) {
            String string3;
            Node node = this.item(n2);
            String string4 = node.getLocalName();
            if (string2.equals(string4) && (string == (string3 = node.getNamespaceURI()) || string != null && string.equals(string3))) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (string2 == null) {
            throw new DomEx(8);
        }
        int n2 = 0;
        while (n2 < this.list.size()) {
            String string3;
            Node node = (Node)this.list.elementAt(n2);
            String string4 = node.getLocalName();
            if (string2.equals(string4) && (string == (string3 = node.getNamespaceURI()) || string != null && string.equals(string3))) {
                this.list.removeElementAt(n2);
                AttributeNode attributeNode = (AttributeNode)node;
                String string5 = attributeNode.getDefaultValue();
                if (string5 != null) {
                    AttributeNode attributeNode2 = attributeNode.cloneAttributeNode(true);
                    attributeNode2.setOwnerElement(attributeNode.getOwnerElement());
                    attributeNode2.setValue(string5);
                    attributeNode2.setSpecified(false);
                    this.list.addElement(attributeNode2);
                }
                attributeNode.setOwnerElement(null);
                return attributeNode;
            }
            ++n2;
        }
        throw new DomEx(8);
    }
}

