/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    SourceLocator locator;
    Throwable containedException;

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        Object object;
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        try {
            object = this.getLocationAsString();
            if (null != object) {
                printWriter.println((String)object);
            }
            super.printStackTrace(printWriter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = this.getException();
        int n2 = 0;
        while (n2 < 10 && null != object) {
            Object object2;
            printWriter.println("---------");
            try {
                if (object instanceof TransformerException && null != (object2 = ((TransformerException)object).getLocationAsString())) {
                    printWriter.println((String)object2);
                }
                ((Throwable)object).printStackTrace(printWriter);
            }
            catch (Throwable throwable) {
                printWriter.println("Could not print stack trace...");
            }
            try {
                object2 = object.getClass().getMethod("getException", null);
                if (null != object2) {
                    Object object3 = object;
                    if (object3 == (object = (Throwable)((Method)object2).invoke(object, null))) {
                        break;
                    }
                } else {
                    object = null;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                object = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                object = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = null;
            }
            ++n2;
        }
        printWriter.flush();
    }

    public String getLocationAsString() {
        if (null != this.locator) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.locator.getSystemId();
            int n2 = this.locator.getLineNumber();
            int n3 = this.locator.getColumnNumber();
            if (null != string) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string);
            }
            if (0 != n2) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n2);
            }
            if (0 != n3) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n3);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String getMessageAndLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.getMessage();
        if (null != string) {
            stringBuffer.append(string);
        }
        if (null != this.locator) {
            String string2 = this.locator.getSystemId();
            int n2 = this.locator.getLineNumber();
            int n3 = this.locator.getColumnNumber();
            if (null != string2) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string2);
            }
            if (0 != n2) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n2);
            }
            if (0 != n3) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n3);
            }
        }
        return stringBuffer.toString();
    }

    public TransformerException(String string) {
        super(string);
        this.containedException = null;
        this.locator = null;
    }

    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public TransformerException(Throwable throwable) {
        super(throwable.toString());
        this.containedException = throwable;
        this.locator = null;
    }

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    public TransformerException(String string, Throwable throwable) {
        super(string == null || string.length() == 0 ? throwable.toString() : string);
        this.containedException = throwable;
        this.locator = null;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.containedException != null) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.containedException = throwable;
        return this;
    }

    public TransformerException(String string, SourceLocator sourceLocator) {
        super(string);
        this.containedException = null;
        this.locator = sourceLocator;
    }

    public TransformerException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.containedException = throwable;
        this.locator = sourceLocator;
    }
}

