/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    boolean inProgress = true;
    protected Vector edits = new Vector();

    public void die() {
        int n2 = this.edits.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n3);
            undoableEdit.die();
            --n3;
        }
        super.die();
    }

    public void end() {
        this.inProgress = false;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            ((UndoableEdit)enumeration.nextElement()).redo();
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        int n2 = this.edits.size();
        while (n2-- > 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n2);
            undoableEdit.undo();
        }
    }

    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            if (!((UndoableEdit)enumeration.nextElement()).isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return super.getPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }

    protected UndoableEdit lastEdit() {
        int n2 = this.edits.size();
        if (n2 > 0) {
            return (UndoableEdit)this.edits.elementAt(n2 - 1);
        }
        return null;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.addElement(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(undoableEdit);
        }
        return true;
    }
}

