/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public abstract class AbstractLayoutCache
implements RowMapper {
    protected NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected boolean rootVisible;
    protected int rowHeight;

    public int getPreferredHeight() {
        Rectangle rectangle;
        int n2 = this.getRowCount();
        if (n2 > 0 && (rectangle = this.getBounds(this.getPathForRow(n2 - 1), null)) != null) {
            return rectangle.y + rectangle.height;
        }
        return 0;
    }

    public abstract int getRowCount();

    public int getRowHeight() {
        return this.rowHeight;
    }

    public abstract void invalidateSizes();

    protected boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRowHeight(int n2) {
        this.rowHeight = n2;
    }

    public void setRootVisible(boolean bl2) {
        this.rootVisible = bl2;
    }

    public int getPreferredWidth(Rectangle rectangle) {
        int n2 = this.getRowCount();
        if (n2 > 0) {
            int n3;
            TreePath treePath;
            if (rectangle == null) {
                treePath = this.getPathForRow(0);
                n3 = Integer.MAX_VALUE;
            } else {
                treePath = this.getPathClosestTo(rectangle.x, rectangle.y);
                n3 = rectangle.height + rectangle.y;
            }
            Enumeration enumeration = this.getVisiblePathsFrom(treePath);
            if (enumeration != null && enumeration.hasMoreElements()) {
                int n4;
                Rectangle rectangle2 = this.getBounds((TreePath)enumeration.nextElement(), null);
                if (rectangle2 != null) {
                    n4 = rectangle2.x + rectangle2.width;
                    if (rectangle2.y >= n3) {
                        return n4;
                    }
                } else {
                    n4 = 0;
                }
                while (rectangle2 != null && enumeration.hasMoreElements()) {
                    rectangle2 = this.getBounds((TreePath)enumeration.nextElement(), rectangle2);
                    if (rectangle2 != null && rectangle2.y < n3) {
                        n4 = Math.max(n4, rectangle2.x + rectangle2.width);
                        continue;
                    }
                    rectangle2 = null;
                }
                return n4;
            }
        }
        return 0;
    }

    public abstract void treeNodesChanged(TreeModelEvent var1);

    public abstract void treeNodesInserted(TreeModelEvent var1);

    public abstract void treeNodesRemoved(TreeModelEvent var1);

    public abstract void treeStructureChanged(TreeModelEvent var1);

    public NodeDimensions getNodeDimensions() {
        return this.nodeDimensions;
    }

    public void setNodeDimensions(NodeDimensions nodeDimensions) {
        this.nodeDimensions = nodeDimensions;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public abstract TreePath getPathForRow(int var1);

    public abstract TreePath getPathClosestTo(int var1, int var2);

    public abstract int getRowForPath(TreePath var1);

    public abstract int getVisibleChildCount(TreePath var1);

    public abstract void invalidatePathBounds(TreePath var1);

    public abstract boolean getExpandedState(TreePath var1);

    public abstract boolean isExpanded(TreePath var1);

    public abstract void setExpandedState(TreePath var1, boolean var2);

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return null;
        }
        int n2 = treePathArray.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.getRowForPath(treePathArray[n3]);
            ++n3;
        }
        return nArray;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(null);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(this);
        }
    }

    public abstract Enumeration getVisiblePathsFrom(TreePath var1);

    protected Rectangle getNodeDimensions(Object object, int n2, int n3, boolean bl2, Rectangle rectangle) {
        NodeDimensions nodeDimensions = this.getNodeDimensions();
        if (nodeDimensions != null) {
            return nodeDimensions.getNodeDimensions(object, n2, n3, bl2, rectangle);
        }
        return null;
    }

    public abstract Rectangle getBounds(TreePath var1, Rectangle var2);

    public static abstract class NodeDimensions {
        public abstract Rectangle getNodeDimensions(Object var1, int var2, int var3, boolean var4, Rectangle var5);
    }
}

