/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Map;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.StyleSheet;

public class HTMLWriter
extends AbstractWriter {
    private Stack blockElementStack = new Stack();
    private boolean inContent = false;
    private boolean inPre = false;
    private int preEndOffset;
    private boolean inTextArea = false;
    private boolean newlineOutputed = false;
    private boolean completeDoc;
    private Vector tags = new Vector(10);
    private Vector tagValues = new Vector(10);
    private Segment segment;
    private Vector tagsToRemove = new Vector(10);
    private boolean wroteHead;
    private boolean replaceEntities;
    private char[] tempChars;
    private boolean indentNext = false;
    private boolean writeCSS = false;
    private MutableAttributeSet convAttr = new SimpleAttributeSet();
    private MutableAttributeSet oConvAttr = new SimpleAttributeSet();

    public void write() throws IOException, BadLocationException {
        Object object;
        ElementIterator elementIterator = this.getElementIterator();
        Element element = null;
        Element element2 = null;
        this.wroteHead = false;
        this.setCurrentLineLength(0);
        this.replaceEntities = false;
        this.setCanWrapLines(false);
        if (this.segment == null) {
            this.segment = new Segment();
        }
        this.inPre = false;
        boolean bl2 = false;
        while ((element2 = elementIterator.next()) != null) {
            if (!this.inRange(element2)) {
                if (!this.completeDoc || element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
                bl2 = true;
            }
            if (element != null) {
                if (this.indentNeedsIncrementing(element, element2)) {
                    this.incrIndent();
                } else if (element.getParentElement() != element2.getParentElement()) {
                    object = (Element)this.blockElementStack.peek();
                    while (object != element2.getParentElement()) {
                        this.blockElementStack.pop();
                        if (!this.synthesizedElement((Element)object)) {
                            AttributeSet attributeSet = object.getAttributes();
                            if (!this.matchNameAttribute(attributeSet, HTML.Tag.PRE) && !this.isFormElementWithContent(attributeSet)) {
                                this.decrIndent();
                            }
                            this.endTag((Element)object);
                        }
                        object = (Element)this.blockElementStack.peek();
                    }
                } else if (element.getParentElement() == element2.getParentElement() && (object = (Element)this.blockElementStack.peek()) == element) {
                    this.blockElementStack.pop();
                    this.endTag((Element)object);
                }
            }
            if (!element2.isLeaf() || this.isFormElementWithContent(element2.getAttributes())) {
                this.blockElementStack.push(element2);
                this.startTag(element2);
            } else {
                this.emptyTag(element2);
            }
            element = element2;
        }
        this.closeOutUnwantedEmbeddedTags(null);
        if (bl2) {
            this.blockElementStack.pop();
            this.endTag(element);
        }
        while (!this.blockElementStack.empty()) {
            element = (Element)this.blockElementStack.pop();
            if (this.synthesizedElement(element)) continue;
            object = element.getAttributes();
            if (!this.matchNameAttribute((AttributeSet)object, HTML.Tag.PRE) && !this.isFormElementWithContent((AttributeSet)object)) {
                this.decrIndent();
            }
            this.endTag(element);
        }
        if (this.completeDoc) {
            this.writeAdditionalComments();
        }
        this.segment.array = null;
    }

    void writeAdditionalComments() throws IOException {
        Object object = this.getDocument().getProperty("AdditionalComments");
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                this.writeComment(vector.elementAt(n2).toString());
                ++n2;
            }
        }
    }

    protected void writeLineSeparator() throws IOException {
        boolean bl2 = this.replaceEntities;
        this.replaceEntities = false;
        super.writeLineSeparator();
        this.replaceEntities = bl2;
    }

    void writeStyleEndTag() throws IOException {
        this.decrIndent();
        this.indent();
        this.write("-->");
        this.writeLineSeparator();
        this.decrIndent();
        this.indent();
        this.write("</style>");
        this.writeLineSeparator();
        this.indent();
    }

    void writeStyleStartTag() throws IOException {
        this.indent();
        this.write("<style type=\"text/css\">");
        this.incrIndent();
        this.writeLineSeparator();
        this.indent();
        this.write("<!--");
        this.incrIndent();
        this.writeLineSeparator();
    }

    protected void output(char[] cArray, int n2, int n3) throws IOException {
        if (!this.replaceEntities) {
            super.output(cArray, n2, n3);
            return;
        }
        int n4 = n2;
        n3 += n2;
        int n5 = n2;
        while (n5 < n3) {
            switch (cArray[n5]) {
                case '<': {
                    if (n5 > n4) {
                        super.output(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    this.output("&lt;");
                    break;
                }
                case '>': {
                    if (n5 > n4) {
                        super.output(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    this.output("&gt;");
                    break;
                }
                case '&': {
                    if (n5 > n4) {
                        super.output(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    this.output("&amp;");
                    break;
                }
                case '\"': {
                    if (n5 > n4) {
                        super.output(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    this.output("&quot;");
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (cArray[n5] >= ' ' && cArray[n5] <= '\u007f') break;
                    if (n5 > n4) {
                        super.output(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    this.output("&#");
                    this.output(String.valueOf((int)cArray[n5]));
                    this.output(";");
                }
            }
            ++n5;
        }
        if (n4 < n3) {
            super.output(cArray, n4, n3 - n4);
        }
    }

    private void output(String string) throws IOException {
        int n2 = string.length();
        if (this.tempChars == null || this.tempChars.length < n2) {
            this.tempChars = new char[n2];
        }
        string.getChars(0, n2, this.tempChars, 0);
        super.output(this.tempChars, 0, n2);
    }

    void writeComment(String string) throws IOException {
        this.write("<!--");
        if (string != null) {
            this.write(string);
        }
        this.write("-->");
        this.writeLineSeparator();
    }

    void writeMaps(Enumeration enumeration) throws IOException {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Map map = (Map)enumeration.nextElement();
                String string = map.getName();
                this.incrIndent();
                this.indent();
                this.write("<map");
                if (string != null) {
                    this.write(" name=\"");
                    this.write(string);
                    this.write("\">");
                } else {
                    this.write('>');
                }
                this.writeLineSeparator();
                this.incrIndent();
                AttributeSet[] attributeSetArray = map.getAreas();
                if (attributeSetArray != null) {
                    int n2 = 0;
                    int n3 = attributeSetArray.length;
                    while (n2 < n3) {
                        this.indent();
                        this.write("<area");
                        this.writeAttributes(attributeSetArray[n2]);
                        this.write("></area>");
                        this.writeLineSeparator();
                        ++n2;
                    }
                }
                this.decrIndent();
                this.indent();
                this.write("</map>");
                this.writeLineSeparator();
                this.decrIndent();
            }
        }
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attributeSet) throws IOException {
        HTML.Tag tag;
        this.tagsToRemove.removeAllElements();
        attributeSet = this.convertToHTML(attributeSet, null);
        int n2 = -1;
        int n3 = this.tags.size();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            tag = (HTML.Tag)this.tags.elementAt(n4);
            Object object = this.tagValues.elementAt(n4);
            if (attributeSet == null || this.noMatchForTagInAttributes(attributeSet, tag, object)) {
                n2 = n4;
                this.tagsToRemove.addElement(tag);
            }
            --n4;
        }
        if (n2 != -1) {
            boolean bl2 = n3 - n2 == this.tagsToRemove.size();
            int n5 = n3 - 1;
            while (n5 >= n2) {
                tag = (HTML.Tag)this.tags.elementAt(n5);
                if (bl2 || this.tagsToRemove.contains(tag)) {
                    this.tags.removeElementAt(n5);
                    this.tagValues.removeElementAt(n5);
                }
                this.write('<');
                this.write('/');
                this.write(tag.toString());
                this.write('>');
                --n5;
            }
            n3 = this.tags.size();
            int n6 = n2;
            while (n6 < n3) {
                tag = (HTML.Tag)this.tags.elementAt(n6);
                this.write('<');
                this.write(tag.toString());
                Object object = this.tagValues.elementAt(n6);
                if (object != null && object instanceof AttributeSet) {
                    this.writeAttributes((AttributeSet)object);
                }
                this.write('>');
                ++n6;
            }
        }
    }

    protected void selectContent(AttributeSet attributeSet) throws IOException {
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        this.incrIndent();
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            int n2 = optionListModel.getSize();
            int n3 = 0;
            while (n3 < n2) {
                Option option = (Option)optionListModel.getElementAt(n3);
                this.writeOption(option);
                ++n3;
            }
        } else if (object instanceof OptionComboBoxModel) {
            OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object;
            int n4 = optionComboBoxModel.getSize();
            int n5 = 0;
            while (n5 < n4) {
                Option option = (Option)optionComboBoxModel.getElementAt(n5);
                this.writeOption(option);
                ++n5;
            }
        }
        this.decrIndent();
    }

    protected void textAreaContent(AttributeSet attributeSet) throws BadLocationException, IOException {
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (document != null && document.getLength() > 0) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            document.getText(0, document.getLength(), this.segment);
            if (this.segment.count > 0) {
                this.inTextArea = true;
                this.incrIndent();
                this.indent();
                this.setCanWrapLines(true);
                this.replaceEntities = true;
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.replaceEntities = false;
                this.setCanWrapLines(false);
                this.writeLineSeparator();
                this.inTextArea = false;
                this.decrIndent();
            }
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        this.convAttr.removeAttributes(this.convAttr);
        HTMLWriter.convertToHTML32(attributeSet, this.convAttr);
        Enumeration enumeration = this.convAttr.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Tag || object instanceof StyleConstants || object == HTML.Attribute.ENDTAG) continue;
            this.write(" " + object + "=\"" + this.convAttr.getAttribute(object) + "\"");
        }
    }

    protected void writeEmbeddedTags(AttributeSet attributeSet) throws IOException {
        attributeSet = this.convertToHTML(attributeSet, this.oConvAttr);
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            HTML.Tag tag;
            Object object = enumeration.nextElement();
            if (!(object instanceof HTML.Tag) || (tag = (HTML.Tag)object) == HTML.Tag.FORM || this.tags.contains(tag)) continue;
            this.write('<');
            this.write(tag.toString());
            Object object2 = attributeSet.getAttribute(tag);
            if (object2 != null && object2 instanceof AttributeSet) {
                this.writeAttributes((AttributeSet)object2);
            }
            this.write('>');
            this.tags.addElement(tag);
            this.tagValues.addElement(object2);
        }
    }

    protected boolean isBlockTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag.isBlock();
        }
        return false;
    }

    private boolean isFormElementWithContent(AttributeSet attributeSet) {
        return this.matchNameAttribute(attributeSet, HTML.Tag.TEXTAREA) || this.matchNameAttribute(attributeSet, HTML.Tag.SELECT);
    }

    protected void comment(Element element) throws BadLocationException, IOException {
        AttributeSet attributeSet = element.getAttributes();
        if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            Object object = attributeSet.getAttribute(HTML.Attribute.COMMENT);
            if (object instanceof String) {
                this.writeComment((String)object);
            } else {
                this.writeComment(null);
            }
        }
    }

    protected void emptyTag(Element element) throws BadLocationException, IOException {
        if (!this.inContent && !this.inPre) {
            this.indent();
        }
        AttributeSet attributeSet = element.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        this.writeEmbeddedTags(attributeSet);
        if (this.matchNameAttribute(attributeSet, HTML.Tag.CONTENT)) {
            this.inContent = true;
            this.text(element);
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            this.comment(element);
        } else {
            boolean bl2 = this.isBlockTag(element.getAttributes());
            if (this.inContent && bl2) {
                this.writeLineSeparator();
                this.indent();
            }
            Object object = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
            Object object2 = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
            boolean bl3 = false;
            if (object != null && object2 != null && object2 instanceof String && ((String)object2).equals("true")) {
                bl3 = true;
            }
            if (this.completeDoc && this.matchNameAttribute(attributeSet, HTML.Tag.HEAD)) {
                if (bl3) {
                    this.writeStyles(((HTMLDocument)this.getDocument()).getStyleSheet());
                }
                this.wroteHead = true;
            }
            this.write('<');
            if (bl3) {
                this.write('/');
            }
            this.write(element.getName());
            this.writeAttributes(attributeSet);
            this.write('>');
            if (this.matchNameAttribute(attributeSet, HTML.Tag.TITLE) && !bl3) {
                Document document = element.getDocument();
                String string = (String)document.getProperty("title");
                this.write(string);
            } else if (!this.inContent || bl2) {
                this.writeLineSeparator();
                if (bl2 && this.inContent) {
                    this.indent();
                }
            }
        }
    }

    protected void endTag(Element element) throws IOException {
        if (this.synthesizedElement(element)) {
            return;
        }
        if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
            this.inPre = false;
        }
        this.closeOutUnwantedEmbeddedTags(element.getAttributes());
        if (this.inContent) {
            if (!this.newlineOutputed) {
                this.writeLineSeparator();
            }
            this.newlineOutputed = false;
            this.inContent = false;
        }
        this.indent();
        this.write('<');
        this.write('/');
        this.write(element.getName());
        this.write('>');
        this.writeLineSeparator();
    }

    protected void startTag(Element element) throws IOException, BadLocationException {
        if (this.synthesizedElement(element)) {
            return;
        }
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        HTML.Tag tag = object instanceof HTML.Tag ? (HTML.Tag)object : null;
        if (tag == HTML.Tag.PRE) {
            this.inPre = true;
            this.preEndOffset = element.getEndOffset();
        }
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        if (this.inContent) {
            this.writeLineSeparator();
            this.inContent = false;
            this.newlineOutputed = false;
        }
        if (this.completeDoc && tag == HTML.Tag.BODY && !this.wroteHead) {
            this.wroteHead = true;
            this.indent();
            this.write("<head>");
            this.writeLineSeparator();
            this.incrIndent();
            this.writeStyles(((HTMLDocument)this.getDocument()).getStyleSheet());
            this.decrIndent();
            this.writeLineSeparator();
            this.indent();
            this.write("</head>");
            this.writeLineSeparator();
        }
        this.indent();
        this.write('<');
        this.write(element.getName());
        this.writeAttributes(attributeSet);
        this.write('>');
        if (tag != HTML.Tag.PRE) {
            this.writeLineSeparator();
        }
        if (tag == HTML.Tag.TEXTAREA) {
            this.textAreaContent(element.getAttributes());
        } else if (tag == HTML.Tag.SELECT) {
            this.selectContent(element.getAttributes());
        } else if (this.completeDoc && tag == HTML.Tag.BODY) {
            this.writeMaps(((HTMLDocument)this.getDocument()).getMaps());
        } else if (tag == HTML.Tag.HEAD) {
            this.wroteHead = true;
        }
    }

    protected void text(Element element) throws BadLocationException, IOException {
        int n2;
        int n3 = Math.max(this.getStartOffset(), element.getStartOffset());
        if (n3 < (n2 = Math.min(this.getEndOffset(), element.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(n3, n2 - n3, this.segment);
            this.newlineOutputed = false;
            if (this.segment.count > 0) {
                if (this.segment.array[this.segment.offset + this.segment.count - 1] == '\n') {
                    this.newlineOutputed = true;
                }
                if (this.inPre && n2 == this.preEndOffset) {
                    if (this.segment.count > 1) {
                        --this.segment.count;
                    } else {
                        return;
                    }
                }
                this.replaceEntities = true;
                this.setCanWrapLines(!this.inPre);
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.setCanWrapLines(false);
                this.replaceEntities = false;
            }
        }
    }

    protected boolean synthesizedElement(Element element) {
        return this.matchNameAttribute(element.getAttributes(), HTML.Tag.IMPLIED);
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.write('<');
        this.write("option");
        Object object = option.getAttributes().getAttribute(HTML.Attribute.VALUE);
        if (object != null) {
            this.write(" value=" + object);
        }
        if (option.isSelected()) {
            this.write(" selected");
        }
        this.write('>');
        if (option.getLabel() != null) {
            this.write(option.getLabel());
        }
        this.writeLineSeparator();
    }

    void writeStyles(StyleSheet styleSheet) throws IOException {
        Enumeration enumeration;
        if (styleSheet != null && (enumeration = styleSheet.getStyleNames()) != null) {
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if ("default".equals(string) || !this.writeStyle(string, styleSheet.getStyle(string), bl2)) continue;
                bl2 = true;
            }
            if (bl2) {
                this.writeStyleEndTag();
            }
        }
    }

    private boolean indentNeedsIncrementing(Element element, Element element2) {
        if (element2.getParentElement() == element && !this.inPre) {
            if (this.indentNext) {
                this.indentNext = false;
                return true;
            }
            if (this.synthesizedElement(element2)) {
                this.indentNext = true;
            } else if (!this.synthesizedElement(element)) {
                return true;
            }
        }
        return false;
    }

    private static void convertToHTML32(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (attributeSet == null) {
            return;
        }
        Enumeration enumeration = attributeSet.getAttributeNames();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof CSS.Attribute) {
                Object object2;
                if (object == CSS.Attribute.FONT_FAMILY || object == CSS.Attribute.FONT_SIZE || object == CSS.Attribute.COLOR) {
                    HTMLWriter.createFontAttribute((CSS.Attribute)object, attributeSet, mutableAttributeSet);
                    continue;
                }
                if (object == CSS.Attribute.FONT_WEIGHT) {
                    object2 = (CSS.FontWeight)attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT);
                    if (object2 == null || ((CSS.FontWeight)object2).getValue() <= 400) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.B, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.FONT_STYLE) {
                    object2 = attributeSet.getAttribute(object).toString();
                    if (((String)object2).indexOf("italic") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.I, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.TEXT_DECORATION) {
                    object2 = attributeSet.getAttribute(object).toString();
                    if (((String)object2).indexOf("underline") >= 0) {
                        mutableAttributeSet.addAttribute(HTML.Tag.U, SimpleAttributeSet.EMPTY);
                    }
                    if (((String)object2).indexOf("line-through") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.STRIKE, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.VERTICAL_ALIGN) {
                    object2 = attributeSet.getAttribute(object).toString();
                    if (((String)object2).indexOf("sup") >= 0) {
                        mutableAttributeSet.addAttribute(HTML.Tag.SUP, SimpleAttributeSet.EMPTY);
                    }
                    if (((String)object2).indexOf("sub") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.SUB, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.TEXT_ALIGN) {
                    mutableAttributeSet.addAttribute(HTML.Attribute.ALIGN, attributeSet.getAttribute(object).toString());
                    continue;
                }
                if (string.length() > 0) {
                    string = string + "; ";
                }
                string = string + object + ": " + attributeSet.getAttribute(object);
                continue;
            }
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
        if (string.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, string);
        }
    }

    private static void convertToHTML40(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof CSS.Attribute) {
                string = string + " " + object + "=" + attributeSet.getAttribute(object) + ";";
                continue;
            }
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
        if (string.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, string);
        }
    }

    boolean writeStyle(String string, Style style, boolean bl2) throws IOException {
        boolean bl3 = false;
        Enumeration enumeration = style.getAttributeNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string2;
                Object object = enumeration.nextElement();
                if (!(object instanceof CSS.Attribute) || (string2 = style.getAttribute(object).toString()) == null) continue;
                if (!bl2) {
                    this.writeStyleStartTag();
                    bl2 = true;
                }
                if (!bl3) {
                    bl3 = true;
                    this.indent();
                    this.write(string);
                    this.write(" {");
                } else {
                    this.write(";");
                }
                this.write(' ');
                this.write(object.toString());
                this.write(": ");
                this.write(string2);
            }
        }
        if (bl3) {
            this.write(" }");
            this.writeLineSeparator();
        }
        return bl3;
    }

    protected boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument) {
        this(writer, hTMLDocument, 0, hTMLDocument.getLength());
    }

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument, int n2, int n3) {
        super(writer, hTMLDocument, n2, n3);
        this.completeDoc = n2 == 0 && n3 == hTMLDocument.getLength();
        this.setLineLength(80);
    }

    private boolean noMatchForTagInAttributes(AttributeSet attributeSet, HTML.Tag tag, Object object) {
        if (attributeSet != null && attributeSet.isDefined(tag)) {
            Object object2 = attributeSet.getAttribute(tag);
            if (object == null ? object2 == null : object2 != null && object.equals(object2)) {
                return false;
            }
        }
        return true;
    }

    AttributeSet convertToHTML(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (mutableAttributeSet == null) {
            mutableAttributeSet = this.convAttr;
        }
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        if (this.writeCSS) {
            HTMLWriter.convertToHTML40(attributeSet, mutableAttributeSet);
        } else {
            HTMLWriter.convertToHTML32(attributeSet, mutableAttributeSet);
        }
        return mutableAttributeSet;
    }

    private static void createFontAttribute(CSS.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = (MutableAttributeSet)mutableAttributeSet.getAttribute(HTML.Tag.FONT);
        if (mutableAttributeSet2 == null) {
            mutableAttributeSet2 = new SimpleAttributeSet();
            mutableAttributeSet.addAttribute(HTML.Tag.FONT, mutableAttributeSet2);
        }
        String string = attributeSet.getAttribute(attribute).toString();
        if (attribute == CSS.Attribute.FONT_FAMILY) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.FACE, string);
        } else if (attribute == CSS.Attribute.FONT_SIZE) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.SIZE, string);
        } else if (attribute == CSS.Attribute.COLOR) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.COLOR, string);
        }
    }
}

