/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Map;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TextAreaDocument;
import javax.swing.undo.UndoableEdit;

public class HTMLDocument
extends DefaultStyledDocument {
    private boolean frameDocument = false;
    private boolean preservesUnknownTags = true;
    private HashMap radioButtonGroupsMap;
    static final String TokenThreshold = "token threshold";
    public static final String AdditionalComments = "AdditionalComments";
    static final String StyleType = "StyleType";
    URL base;
    private HTMLEditorKit.Parser parser;
    private static AttributeSet contentAttributeSet;
    static String MAP_PROPERTY;
    private static char[] NEWLINE;

    public int getTokenThreshold() {
        Integer n2 = (Integer)this.getProperty(TokenThreshold);
        if (n2 != null) {
            return n2;
        }
        return Integer.MAX_VALUE;
    }

    static {
        MAP_PROPERTY = "__MAP__";
        contentAttributeSet = new SimpleAttributeSet();
        ((MutableAttributeSet)contentAttributeSet).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        NEWLINE = new char[1];
        HTMLDocument.NEWLINE[0] = 10;
    }

    public HTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    private void installParserIfNecessary() {
        if (this.getParser() == null) {
            this.setParser(new HTMLEditorKit().getParser());
        }
    }

    void obtainLock() {
        this.writeLock();
    }

    void releaseLock() {
        this.writeUnlock();
    }

    private void verifyParser() {
        if (this.getParser() == null) {
            throw new IllegalStateException("No HTMLEditorKit.Parser");
        }
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    static char[] access$100() {
        return NEWLINE;
    }

    public void setTokenThreshold(int n2) {
        this.putProperty(TokenThreshold, new Integer(n2));
    }

    void setFrameDocumentState(boolean bl2) {
        this.frameDocument = bl2;
    }

    public void setPreservesUnknownTags(boolean bl2) {
        this.preservesUnknownTags = bl2;
    }

    String getDefaultStyleSheetType() {
        String string = (String)this.getProperty(StyleType);
        if (string == null) {
            return "text/css";
        }
        return string;
    }

    void setDefaultStyleSheetType(String string) {
        this.putProperty(StyleType, string);
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL uRL) {
        this.base = uRL;
        this.getStyleSheet().setBase(uRL);
    }

    Enumeration getMaps() {
        Object object = this.getProperty(MAP_PROPERTY);
        if (object instanceof Hashtable) {
            return ((Hashtable)object).elements();
        }
        return null;
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        super.fireChangedUpdate(documentEvent);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        super.fireUndoableEditUpdate(undoableEditEvent);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.HTML);
        BlockElement blockElement = new BlockElement(this, null, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.BODY);
        BlockElement blockElement2 = new BlockElement(this, (Element)blockElement, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        BlockElement blockElement3 = new BlockElement(this, (Element)blockElement2, simpleAttributeSet.copyAttributes());
        simpleAttributeSet.removeAttributes(simpleAttributeSet);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        RunElement runElement = new RunElement(this, (Element)blockElement3, (AttributeSet)simpleAttributeSet, 0, 1);
        Element[] elementArray = new Element[]{runElement};
        blockElement3.replace(0, 0, elementArray);
        elementArray[0] = blockElement3;
        blockElement2.replace(0, 0, elementArray);
        elementArray[0] = blockElement2;
        blockElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return blockElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParagraphAttributes(int n2, int n3, AttributeSet attributeSet, boolean bl2) {
        try {
            this.writeLock();
            int n4 = Math.min(n2 + n3, this.getLength());
            Element element = this.getParagraphElement(n2);
            n2 = element.getStartOffset();
            element = this.getParagraphElement(n4);
            n3 = Math.max(0, element.getEndOffset() - n2);
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n2, n3, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n5 = Integer.MAX_VALUE;
            int n6 = n2;
            while (n6 <= n4) {
                Element element2 = this.getParagraphElement(n6);
                n5 = n5 == element2.getEndOffset() ? ++n5 : element2.getEndOffset();
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element2, attributeSet2, bl2));
                if (bl2) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n6 = n5;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    protected void insert(int n2, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
        super.insert(n2, elementSpecArray);
    }

    protected void create(DefaultStyledDocument.ElementSpec[] elementSpecArray) {
        super.create(elementSpecArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeElements(Element element, int n2, int n3) throws BadLocationException {
        this.writeLock();
        try {
            int n4 = element.getElement(n2).getStartOffset();
            int n5 = element.getElement(n2 + n3 - 1).getEndOffset();
            if (n5 > this.getLength()) {
                this.removeElementsAtEnd(element, n2, n3, n4, n5);
            } else {
                this.removeElements(element, n2, n3, n4, n5);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    private void removeElements(Element element, int n2, int n3, int n4, int n5) throws BadLocationException {
        Element[] elementArray = new Element[n3];
        Element[] elementArray2 = new Element[]{};
        int n6 = 0;
        while (n6 < n3) {
            elementArray[n6] = element.getElement(n6 + n2);
            ++n6;
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n4, n5 - n4, DocumentEvent.EventType.REMOVE);
        ((AbstractDocument.BranchElement)element).replace(n2, elementArray.length, elementArray2);
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, n2, elementArray, elementArray2));
        UndoableEdit undoableEdit = this.getContent().remove(n4, n5 - n4);
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        if (undoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
    }

    private void removeElementsAtEnd(Element element, int n2, int n3, int n4, int n5) throws BadLocationException {
        boolean bl2 = element.getElement(n2 - 1).isLeaf();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n4 - 1, n5 - n4 + 1, DocumentEvent.EventType.REMOVE);
        if (bl2) {
            Element element2 = this.getCharacterElement(this.getLength());
            --n2;
            if (element2.getParentElement() != element) {
                this.replace(defaultDocumentEvent, element, n2, ++n3, n4, n5, true, true);
            } else {
                this.replace(defaultDocumentEvent, element, n2, n3, n4, n5, true, false);
            }
        } else {
            Element element3 = element.getElement(n2 - 1);
            while (!element3.isLeaf()) {
                element3 = element3.getElement(element3.getElementCount() - 1);
            }
            element3 = element3.getParentElement();
            this.replace(defaultDocumentEvent, element, n2, n3, n4, n5, false, false);
            this.replace(defaultDocumentEvent, element3, element3.getElementCount() - 1, 1, n4, n5, true, true);
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
    }

    public HTMLEditorKit.Parser getParser() {
        Object object = this.getProperty("__PARSER__");
        if (object instanceof HTMLEditorKit.Parser) {
            return (HTMLEditorKit.Parser)object;
        }
        return this.parser;
    }

    public void setParser(HTMLEditorKit.Parser parser) {
        this.parser = parser;
        this.putProperty("__PARSER__", null);
    }

    public HTMLEditorKit.ParserCallback getReader(int n2) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.setBase((URL)object);
        }
        HTMLReader hTMLReader = new HTMLReader(this, n2);
        return hTMLReader;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
        String string = hTMLFrameHyperlinkEvent.getTarget();
        Element element = hTMLFrameHyperlinkEvent.getSourceElement();
        String string2 = hTMLFrameHyperlinkEvent.getURL().toString();
        if (string.equals("_self")) {
            this.updateFrame(element, string2);
        } else if (string.equals("_parent")) {
            this.updateFrameSet(element.getParentElement(), string2);
        } else {
            Element element2 = this.findFrame(string);
            if (element2 != null) {
                this.updateFrame(element2, string2);
            }
        }
    }

    void addMap(Map map) {
        String string = map.getName();
        if (string != null) {
            Object object = this.getProperty(MAP_PROPERTY);
            if (object == null) {
                object = new Hashtable(11);
                this.putProperty(MAP_PROPERTY, object);
            }
            if (object instanceof Hashtable) {
                ((Hashtable)object).put("#" + string, map);
            }
        }
    }

    void removeMap(Map map) {
        Object object;
        String string = map.getName();
        if (string != null && (object = this.getProperty(MAP_PROPERTY)) instanceof Hashtable) {
            ((Hashtable)object).remove("#" + string);
        }
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getAttributeContext();
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    /*
     * Unable to fully structure code
     */
    private void insertHTML(Element var1_1, int var2_2, String var3_3, boolean var4_4) throws BadLocationException, IOException {
        block3: {
            if (var1_1 == null || var3_3 == null || (var5_5 = this.getParser()) == null) break block3;
            var6_6 = Math.max(0, var2_2 - 1);
            var7_7 = this.getCharacterElement(var6_6);
            var8_8 = var1_1;
            var9_9 = 0;
            var10_10 = 0;
            if (var1_1.getStartOffset() <= var6_6) ** GOTO lbl16
            while (var8_8 != null && var8_8.getStartOffset() > var6_6) {
                var8_8 = var8_8.getParentElement();
                ++var10_10;
            }
            if (var8_8 != null) ** GOTO lbl16
            throw new BadLocationException("No common parent", var2_2);
lbl-1000:
            // 1 sources

            {
                ++var9_9;
                var7_7 = var7_7.getParentElement();
lbl16:
                // 3 sources

                ** while (var7_7 != null && var7_7 != var8_8)
            }
lbl17:
            // 1 sources

            if (var7_7 != null) {
                var11_11 = new HTMLReader(this, var2_2, var9_9 - 1, var10_10, null, false, true, var4_4);
                var5_5.parse(new StringReader(var3_3), var11_11, true);
                var11_11.flush();
            }
        }
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        Element element2;
        this.verifyParser();
        if (element != null && (element2 = element.getParentElement()) != null) {
            int n2 = element.getEndOffset();
            if (n2 > this.getLength()) {
                --n2;
            } else if (element.isLeaf() && this.getText(n2 - 1, 1).charAt(0) == NEWLINE[0]) {
                --n2;
            }
            this.insertHTML(element2, n2, string, false);
        }
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not insert HTML after start of a leaf");
        }
        this.insertHTML(element, element.getStartOffset(), string, false);
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML before end of leaf");
        }
        int n2 = element.getEndOffset();
        if (element.getElement(element.getElementIndex(n2 - 1)).isLeaf() && this.getText(n2 - 1, 1).charAt(0) == NEWLINE[0]) {
            --n2;
        }
        this.insertHTML(element, n2, string, false);
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        Element element2;
        this.verifyParser();
        if (element != null && (element2 = element.getParentElement()) != null) {
            this.insertHTML(element2, element.getStartOffset(), string, false);
        }
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML of a leaf");
        }
        if (element != null && string != null) {
            int n2 = element.getElementCount();
            int n3 = element.getStartOffset();
            this.insertHTML(element, element.getStartOffset(), string, true);
            if (element.getElementCount() > n2) {
                this.removeElements(element, element.getElementCount() - n2, n2);
            }
        }
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
        this.verifyParser();
        if (element != null && element.getParentElement() != null && string != null) {
            boolean bl2;
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            int n4 = this.getLength();
            boolean bl3 = bl2 = !element.isLeaf();
            if (!(bl2 || n3 <= n4 && this.getText(n3 - 1, 1).charAt(0) != NEWLINE[0])) {
                bl2 = true;
            }
            Element element2 = element.getParentElement();
            int n5 = element2.getElementCount();
            this.insertHTML(element2, n2, string, bl2);
            int n6 = this.getLength();
            if (n5 != element2.getElementCount()) {
                int n7 = element2.getElementIndex(n2 + n6 - n4);
                this.removeElements(element2, n7, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrame(Element element, String string) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet = element.getAttributes().copyAttributes();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet, false));
            mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
            mutableAttributeSet.addAttribute(HTML.Attribute.SRC, string);
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    private void updateFrameSet(Element element, String string) {
        try {
            int n2 = element.getStartOffset();
            int n3 = Math.min(this.getLength(), element.getEndOffset());
            String string2 = "<frame";
            if (string != null) {
                string2 = string2 + " src=\"" + string + "\"";
            }
            string2 = string2 + ">";
            this.installParserIfNecessary();
            this.setOuterHTML(element, string2);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {}
    }

    static HashMap access$700(HTMLDocument hTMLDocument) {
        return hTMLDocument.radioButtonGroupsMap;
    }

    static void access$500(HTMLDocument hTMLDocument, DocumentEvent documentEvent) {
        hTMLDocument.fireRemoveUpdate(documentEvent);
    }

    static AbstractDocument.Content access$300(HTMLDocument hTMLDocument) {
        return hTMLDocument.getContent();
    }

    static void access$200(HTMLDocument hTMLDocument, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        hTMLDocument.removeUpdate(defaultDocumentEvent);
    }

    static void access$400(HTMLDocument hTMLDocument, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        hTMLDocument.postRemoveUpdate(defaultDocumentEvent);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (attributeSet == null) {
            attributeSet = contentAttributeSet;
        } else if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
            ((MutableAttributeSet)attributeSet).addAttributes(contentAttributeSet);
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    private Element findFrame(String string) {
        ElementIterator elementIterator = new ElementIterator(this);
        Element element = null;
        while ((element = elementIterator.next()) != null) {
            String string2;
            AttributeSet attributeSet = element.getAttributes();
            if (HTMLDocument.matchNameAttribute(attributeSet, HTML.Tag.FRAME) && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME)) != null && string2.equals(string)) break;
        }
        return element;
    }

    public Element getElement(String string) {
        if (string == null) {
            return null;
        }
        return this.getElement(this.getDefaultRootElement(), HTML.Attribute.ID, string, true);
    }

    private void replace(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, Element element, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) throws BadLocationException {
        UndoableEdit undoableEdit;
        AttributeSet attributeSet = element.getElement(n2).getAttributes();
        Element[] elementArray = new Element[n3];
        int n6 = 0;
        while (n6 < n3) {
            elementArray[n6] = element.getElement(n6 + n2);
            ++n6;
        }
        if (bl2 && (undoableEdit = this.getContent().remove(n4 - 1, n5 - n4)) != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        Element[] elementArray2 = bl3 ? new Element[]{this.createLeafElement(element, attributeSet, n4 - 1, n4)} : new Element[]{};
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, n2, elementArray, elementArray2));
        ((AbstractDocument.BranchElement)element).replace(n2, elementArray.length, elementArray2);
    }

    static boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    public Iterator getIterator(HTML.Tag tag) {
        if (tag.isBlock()) {
            return null;
        }
        return new LeafIterator(tag, this);
    }

    public HTMLEditorKit.ParserCallback getReader(int n2, int n3, int n4, HTML.Tag tag) {
        return this.getReader(n2, n3, n4, tag, true);
    }

    HTMLEditorKit.ParserCallback getReader(int n2, int n3, int n4, HTML.Tag tag, boolean bl2) {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            this.setBase((URL)object);
        }
        HTMLReader hTMLReader = new HTMLReader(this, n2, n3, n4, tag, bl2, false, true);
        return hTMLReader;
    }

    Map getMap(String string) {
        Object object;
        if (string != null && (object = this.getProperty(MAP_PROPERTY)) != null && object instanceof Hashtable) {
            return (Map)((Hashtable)object).get(string);
        }
        return null;
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        super(content, styleSheet);
    }

    static HashMap access$702(HTMLDocument hTMLDocument, HashMap hashMap) {
        hTMLDocument.radioButtonGroupsMap = hashMap;
        return hTMLDocument.radioButtonGroupsMap;
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(this, element, attributeSet);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n2, int n3) {
        return new RunElement(this, element, attributeSet, n2, n3);
    }

    public Element getElement(Element element, Object object, Object object2) {
        return this.getElement(element, object, object2, false);
    }

    private Element getElement(Element element, Object object, Object object2, boolean bl2) {
        block5: {
            Enumeration enumeration;
            AttributeSet attributeSet;
            block4: {
                attributeSet = element.getAttributes();
                if (attributeSet != null && attributeSet.isDefined(object) && object2.equals(attributeSet.getAttribute(object))) {
                    return element;
                }
                if (element.isLeaf()) break block4;
                int n2 = 0;
                int n3 = element.getElementCount();
                while (n2 < n3) {
                    Element element2 = this.getElement(element.getElement(n2), object, object2, bl2);
                    if (element2 != null) {
                        return element2;
                    }
                    ++n2;
                }
                break block5;
            }
            if (!bl2 || attributeSet == null || (enumeration = attributeSet.getAttributeNames()) == null) break block5;
            while (enumeration.hasMoreElements()) {
                AttributeSet attributeSet2;
                Object object3 = enumeration.nextElement();
                if (!(object3 instanceof HTML.Tag) || !(attributeSet.getAttribute(object3) instanceof AttributeSet) || !(attributeSet2 = (AttributeSet)attributeSet.getAttribute(object3)).isDefined(object) || !object2.equals(attributeSet2.getAttribute(object))) continue;
                return element;
            }
        }
        return null;
    }

    class 1 {
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        private final HTMLDocument this$0;

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public BlockElement(HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet) {
            this.this$0 = hTMLDocument;
            super(hTMLDocument, element, attributeSet);
        }
    }

    private static class FixedLengthDocument
    extends PlainDocument {
        private int maxLength;

        public FixedLengthDocument(int n2) {
            this.maxLength = n2;
        }

        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && string.length() + this.getLength() <= this.maxLength) {
                super.insertString(n2, string, attributeSet);
            }
        }
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        private boolean receivedEndHTML;
        private int flushCount;
        private boolean insertAfterImplied;
        private boolean wantsTrailingNewline;
        int threshold;
        int offset;
        boolean inParagraph;
        boolean impliedP;
        boolean inPre;
        boolean inTextArea;
        TextAreaDocument textAreaDocument;
        boolean inTitle;
        boolean lastWasNewline;
        boolean emptyAnchor;
        boolean midInsert;
        boolean inBody;
        HTML.Tag insertTag;
        boolean insertInsertTag;
        boolean foundInsertTag;
        int insertTagDepthDelta;
        int popDepth;
        int pushDepth;
        Map lastMap;
        boolean inStyle;
        String defaultStyle;
        Vector styles;
        boolean inHead;
        boolean isStyleCSS;
        boolean emptyDocument;
        AttributeSet styleAttributes;
        Option option;
        protected Vector parseBuffer;
        protected MutableAttributeSet charAttr;
        Stack charAttrStack;
        Hashtable tagMap;
        int inBlock;
        private final HTMLDocument this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustEndElement() {
            int n2 = this.this$0.getLength();
            if (n2 == 0) {
                return;
            }
            this.this$0.obtainLock();
            try {
                block6: {
                    try {
                        Element[] elementArray = this.getPathTo(n2 - 1);
                        int n3 = elementArray.length;
                        if (n3 <= 1 || elementArray[1].getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY || elementArray[1].getEndOffset() != n2) break block6;
                        String string = this.this$0.getText(n2 - 1, 1);
                        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = null;
                        Element[] elementArray2 = new Element[]{};
                        Element[] elementArray3 = new Element[1];
                        int n4 = elementArray[0].getElementIndex(n2);
                        elementArray3[0] = elementArray[0].getElement(n4);
                        ((AbstractDocument.BranchElement)elementArray[0]).replace(n4, 1, elementArray2);
                        AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(elementArray[0], n4, elementArray3, elementArray2);
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        elementArray2 = new Element[]{this.this$0.createLeafElement(elementArray[n3 - 1], simpleAttributeSet, n2, n2 + 1)};
                        n4 = elementArray[n3 - 1].getElementCount();
                        ((AbstractDocument.BranchElement)elementArray[n3 - 1]).replace(n4, 0, elementArray2);
                        defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this.this$0, n2, 1, DocumentEvent.EventType.CHANGE);
                        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(elementArray[n3 - 1], n4, new Element[0], elementArray2));
                        defaultDocumentEvent.addEdit(elementEdit);
                        defaultDocumentEvent.end();
                        this.this$0.fireChangedUpdate(defaultDocumentEvent);
                        this.this$0.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                        if (!string.equals("\n")) break block6;
                        defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this.this$0, n2 - 1, 1, DocumentEvent.EventType.REMOVE);
                        HTMLDocument.access$200(this.this$0, defaultDocumentEvent);
                        UndoableEdit undoableEdit = HTMLDocument.access$300(this.this$0).remove(n2 - 1, 1);
                        if (undoableEdit != null) {
                            defaultDocumentEvent.addEdit(undoableEdit);
                        }
                        HTMLDocument.access$400(this.this$0, defaultDocumentEvent);
                        defaultDocumentEvent.end();
                        HTMLDocument.access$500(this.this$0, defaultDocumentEvent);
                        this.this$0.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    }
                    catch (BadLocationException badLocationException) {
                        Object var13_14 = null;
                        this.this$0.releaseLock();
                    }
                }
                Object var13_13 = null;
                this.this$0.releaseLock();
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                this.this$0.releaseLock();
                throw throwable;
            }
        }

        private void adjustEndSpecsForPartialInsert() {
            int n2;
            int n3 = this.parseBuffer.size();
            if (this.insertTagDepthDelta < 0) {
                n2 = this.insertTagDepthDelta;
                while (n2 < 0 && n3 >= 0 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n3 - 1)).getType() == 2) {
                    this.parseBuffer.removeElementAt(--n3);
                    ++n2;
                }
            }
            if (!(this.flushCount != 0 || this.insertAfterImplied && this.wantsTrailingNewline)) {
                n2 = 0;
                if (this.pushDepth > 0 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(0)).getType() == 3) {
                    ++n2;
                }
                int n4 = 0;
                int n5 = n2 += this.popDepth + this.pushDepth;
                while (n2 < n3 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n2)).getType() == 3) {
                    ++n2;
                    ++n4;
                }
                if (n4 > 1) {
                    char[] cArray;
                    while (n2 < n3 && ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n2)).getType() == 2) {
                        ++n2;
                    }
                    if (n2 == n3 && (cArray = ((DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n5 + n4 - 1)).getArray()).length == 1 && cArray[0] == HTMLDocument.access$100()[0]) {
                        n2 = n5 + n4 - 1;
                        while (n3 > n2) {
                            this.parseBuffer.removeElementAt(--n3);
                        }
                    }
                }
            }
            if (this.wantsTrailingNewline) {
                n2 = this.parseBuffer.size() - 1;
                while (n2 >= 0) {
                    DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)this.parseBuffer.elementAt(n2);
                    if (elementSpec.getType() == 3) {
                        if (elementSpec.getArray()[elementSpec.getLength() - 1] == '\n') break;
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        this.parseBuffer.insertElementAt(new DefaultStyledDocument.ElementSpec(simpleAttributeSet, 3, HTMLDocument.access$100(), 0, 1), n2 + 1);
                        break;
                    }
                    --n2;
                }
            }
        }

        public void flush() throws BadLocationException {
            if (this.emptyDocument && !this.insertAfterImplied) {
                if (this.this$0.getLength() > 0 || this.parseBuffer.size() > 0) {
                    this.flushBuffer(true);
                    this.adjustEndElement();
                }
            } else {
                this.flushBuffer(true);
            }
        }

        private void generateEndsSpecsForMidInsert() {
            int n2 = this.heightToElementWithName(HTML.Tag.BODY, Math.max(0, this.offset - 1));
            boolean bl2 = false;
            if (n2 == -1 && this.offset > 0 && (n2 = this.heightToElementWithName(HTML.Tag.BODY, this.offset)) != -1) {
                n2 = this.depthTo(this.offset - 1) - 1;
                bl2 = true;
            }
            if (n2 == -1) {
                throw new RuntimeException("Must insert new content into body element-");
            }
            if (n2 != -1) {
                Object object;
                try {
                    if (!bl2 && this.offset > 0 && !this.this$0.getText(this.offset - 1, 1).equals("\n")) {
                        object = new SimpleAttributeSet();
                        ((SimpleAttributeSet)object).addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec((AttributeSet)object, 3, HTMLDocument.access$100(), 0, 1);
                        this.parseBuffer.addElement(elementSpec);
                    }
                }
                catch (BadLocationException badLocationException) {}
                while (n2-- > 0) {
                    this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                }
                if (bl2) {
                    object = new DefaultStyledDocument.ElementSpec(null, 1);
                    ((DefaultStyledDocument.ElementSpec)object).setDirection((short)5);
                    this.parseBuffer.addElement(object);
                }
            }
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.empty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.peek();
                this.charAttrStack.pop();
            }
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        private int depthTo(int n2) {
            Element element = this.this$0.getDefaultRootElement();
            int n3 = 0;
            while (!element.isLeaf()) {
                ++n3;
                element = element.getElement(element.getElementIndex(n2));
            }
            return n3;
        }

        void flushBuffer(boolean bl2) throws BadLocationException {
            int n2 = this.this$0.getLength();
            int n3 = this.parseBuffer.size();
            if (bl2 && (this.insertTag != null || this.insertAfterImplied) && n3 > 0) {
                this.adjustEndSpecsForPartialInsert();
                n3 = this.parseBuffer.size();
            }
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[n3];
            this.parseBuffer.copyInto(objectArray);
            if (n2 == 0 && this.insertTag == null && !this.insertAfterImplied) {
                this.this$0.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                this.this$0.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.parseBuffer.removeAllElements();
            this.offset += this.this$0.getLength() - n2;
            ++this.flushCount;
        }

        private void foundInsertTag(boolean bl2) {
            Object object;
            int n2;
            this.foundInsertTag = true;
            if (!(this.insertAfterImplied || this.popDepth <= 0 && this.pushDepth <= 0)) {
                try {
                    if (this.offset == 0 || !this.this$0.getText(this.offset - 1, 1).equals("\n")) {
                        SimpleAttributeSet simpleAttributeSet = null;
                        n2 = 1;
                        if (this.offset != 0) {
                            object = this.this$0.getCharacterElement(this.offset - 1);
                            AttributeSet attributeSet = object.getAttributes();
                            if (attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                                n2 = 0;
                            } else {
                                HTML.Tag tag;
                                Object object2 = attributeSet.getAttribute(StyleConstants.NameAttribute);
                                if (object2 instanceof HTML.Tag && ((tag = (HTML.Tag)object2) == HTML.Tag.IMG || tag == HTML.Tag.HR || tag == HTML.Tag.COMMENT || tag instanceof HTML.UnknownTag)) {
                                    n2 = 0;
                                }
                            }
                        }
                        if (n2 == 0) {
                            simpleAttributeSet = new SimpleAttributeSet();
                            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                        }
                        object = new DefaultStyledDocument.ElementSpec(simpleAttributeSet, 3, HTMLDocument.access$100(), 0, HTMLDocument.access$100().length);
                        if (n2 != 0) {
                            ((DefaultStyledDocument.ElementSpec)object).setDirection((short)4);
                        }
                        this.parseBuffer.addElement(object);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            int n3 = 0;
            while (n3 < this.popDepth) {
                this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                ++n3;
            }
            n2 = 0;
            while (n2 < this.pushDepth) {
                object = new DefaultStyledDocument.ElementSpec(null, 1);
                ((DefaultStyledDocument.ElementSpec)object).setDirection((short)5);
                this.parseBuffer.addElement(object);
                ++n2;
            }
            this.insertTagDepthDelta = this.depthTo(Math.max(0, this.offset - 1)) - this.popDepth + this.pushDepth - this.inBlock;
            if (bl2) {
                ++this.insertTagDepthDelta;
            } else {
                --this.insertTagDepthDelta;
                this.inParagraph = true;
                this.lastWasNewline = false;
            }
        }

        protected void preContent(char[] cArray) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] == '\n') {
                    this.addContent(cArray, n2, n3 - n2 + 1);
                    this.blockClose(HTML.Tag.IMPLIED);
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                    this.blockOpen(HTML.Tag.IMPLIED, simpleAttributeSet);
                    n2 = n3 + 1;
                }
                ++n3;
            }
            if (n2 < cArray.length) {
                this.addContent(cArray, n2, cArray.length - n2);
            }
        }

        protected void textAreaContent(char[] cArray) {
            try {
                this.textAreaDocument.insertString(this.textAreaDocument.getLength(), new String(cArray), null);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void handleComment(char[] cArray, int n2) {
            if (this.receivedEndHTML) {
                this.addExternalComment(new String(cArray));
                return;
            }
            if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(cArray));
                }
            } else if (this.this$0.getPreservesUnknownTags()) {
                if (this.inBlock == 0 && (this.foundInsertTag || this.insertTag != HTML.Tag.COMMENT)) {
                    this.addExternalComment(new String(cArray));
                    return;
                }
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(HTML.Attribute.COMMENT, new String(cArray));
                this.addSpecialElement(HTML.Tag.COMMENT, simpleAttributeSet);
            }
        }

        public void handleText(char[] cArray, int n2) {
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (this.inTextArea) {
                this.textAreaContent(cArray);
            } else if (this.inPre) {
                this.preContent(cArray);
            } else if (this.inTitle) {
                this.this$0.putProperty("title", new String(cArray));
            } else if (this.option != null) {
                this.option.setLabel(new String(cArray));
            } else if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(cArray));
                }
            } else if (this.inBlock > 0) {
                if (!this.foundInsertTag && this.insertAfterImplied) {
                    this.foundInsertTag(false);
                    this.foundInsertTag = true;
                    this.impliedP = true;
                    this.inParagraph = true;
                }
                if (cArray.length >= 1) {
                    this.addContent(cArray, 0, cArray.length);
                }
            }
        }

        protected void addContent(char[] cArray, int n2, int n3) {
            this.addContent(cArray, n2, n3, true);
        }

        protected void addContent(char[] cArray, int n2, int n3, boolean bl2) {
            if (!this.foundInsertTag) {
                return;
            }
            if (bl2 && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            this.charAttr.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            AttributeSet attributeSet = this.charAttr.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n2, n3);
            this.parseBuffer.addElement(elementSpec);
            if (this.parseBuffer.size() > this.threshold) {
                try {
                    this.flushBuffer(false);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (n3 > 0) {
                this.lastWasNewline = cArray[n2 + n3 - 1] == '\n';
            }
        }

        private int heightToElementWithName(Object object, int n2) {
            Element element = this.this$0.getCharacterElement(n2).getParentElement();
            int n3 = 0;
            while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != object) {
                ++n3;
                element = element.getParentElement();
            }
            return element == null ? -1 : n3;
        }

        void addCSSRules(String string) {
            StyleSheet styleSheet = this.this$0.getStyleSheet();
            styleSheet.addRule(string);
        }

        private void addExternalComment(String string) {
            Object object = this.this$0.getProperty(HTMLDocument.AdditionalComments);
            if (object != null && !(object instanceof Vector)) {
                return;
            }
            if (object == null) {
                object = new Vector();
                this.this$0.putProperty(HTMLDocument.AdditionalComments, object);
            }
            ((Vector)object).addElement(string);
        }

        public void handleEndOfLineString(String string) {
            if (this.emptyDocument && string != null) {
                this.this$0.putProperty("__EndOfLine__", string);
            }
        }

        void linkCSSStyleSheet(String string) {
            URL uRL = null;
            try {
                uRL = new URL(this.this$0.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException2) {
                    uRL = null;
                }
            }
            if (uRL != null) {
                this.this$0.getStyleSheet().importStyleSheet(uRL);
            }
        }

        private Element[] getPathTo(int n2) {
            Stack stack = new Stack();
            Element element = this.this$0.getDefaultRootElement();
            while (!element.isLeaf()) {
                stack.push(element);
                element = element.getElement(element.getElementIndex(n2));
            }
            Object[] objectArray = new Element[stack.size()];
            stack.copyInto(objectArray);
            return objectArray;
        }

        protected void blockClose(HTML.Tag tag) {
            Object object;
            DefaultStyledDocument.ElementSpec elementSpec;
            --this.inBlock;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                this.addContent(HTMLDocument.access$100(), 0, 1, true);
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                if (tag != HTML.Tag.IMPLIED) {
                    this.blockClose(HTML.Tag.IMPLIED);
                }
            }
            DefaultStyledDocument.ElementSpec elementSpec2 = elementSpec = this.parseBuffer.size() > 0 ? (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement() : null;
            if (elementSpec != null && elementSpec.getType() == 1) {
                object = new char[1];
                object[0] = 32;
                this.addContent((char[])object, 0, 1);
            }
            object = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(object);
        }

        private boolean isInsertTag(HTML.Tag tag) {
            return this.insertTag == tag;
        }

        public void handleEndTag(HTML.Tag tag, int n2) {
            TagAction tagAction;
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (tag == HTML.Tag.HTML) {
                this.receivedEndHTML = true;
            }
            if (tag == HTML.Tag.BODY) {
                this.inBody = false;
                if (this.midInsert) {
                    --this.inBlock;
                }
            }
            if ((tagAction = (TagAction)this.tagMap.get(tag)) != null) {
                tagAction.end(tag);
            }
        }

        public HTMLReader(HTMLDocument hTMLDocument, int n2) {
            this(hTMLDocument, n2, 0, 0, null);
        }

        static boolean access$800(HTMLReader hTMLReader) {
            return hTMLReader.insertAfterImplied;
        }

        private boolean canInsertTag(HTML.Tag tag, AttributeSet attributeSet, boolean bl2) {
            if (!this.foundInsertTag) {
                if (this.insertTag != null && !this.isInsertTag(tag) || this.insertAfterImplied && (tag == HTML.Tag.IMPLIED || attributeSet == null || attributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED))) {
                    return false;
                }
                this.foundInsertTag(bl2);
                if (!this.insertInsertTag) {
                    return false;
                }
            }
            return true;
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (tag != HTML.Tag.FRAME && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            if (!this.canInsertTag(tag, mutableAttributeSet, tag.isBlock())) {
                return;
            }
            if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
            }
            this.emptyAnchor = false;
            mutableAttributeSet.addAttributes(this.charAttr);
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            char[] cArray = new char[]{' '};
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 3, cArray, 0, 1);
            this.parseBuffer.addElement(elementSpec);
            if (tag == HTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (this.impliedP) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.canInsertTag(tag, mutableAttributeSet, true)) {
                return;
            }
            if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
            }
            this.lastWasNewline = false;
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 1);
            this.parseBuffer.addElement(elementSpec);
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n2) {
            Object object;
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (this.isStyleCSS && mutableAttributeSet.isDefined(HTML.Attribute.STYLE)) {
                object = (String)mutableAttributeSet.getAttribute(HTML.Attribute.STYLE);
                mutableAttributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = this.this$0.getStyleSheet().getDeclaration((String)object);
                mutableAttributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            object = (TagAction)this.tagMap.get(tag);
            if (object != null) {
                ((TagAction)object).start(tag, mutableAttributeSet);
                ((TagAction)object).end(tag);
            } else if (this.this$0.getPreservesUnknownTags()) {
                this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n2) {
            Object object;
            if (this.receivedEndHTML) {
                return;
            }
            if (this.midInsert && !this.inBody) {
                if (tag == HTML.Tag.BODY) {
                    this.inBody = true;
                    ++this.inBlock;
                }
                return;
            }
            if (!this.inBody && tag == HTML.Tag.BODY) {
                this.inBody = true;
            }
            if (this.isStyleCSS && mutableAttributeSet.isDefined(HTML.Attribute.STYLE)) {
                object = (String)mutableAttributeSet.getAttribute(HTML.Attribute.STYLE);
                mutableAttributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = this.this$0.getStyleSheet().getDeclaration((String)object);
                mutableAttributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            object = (TagAction)this.tagMap.get(tag);
            if (object != null) {
                ((TagAction)object).start(tag, mutableAttributeSet);
            }
        }

        public HTMLReader(HTMLDocument hTMLDocument, int n2, int n3, int n4, HTML.Tag tag) {
            this(hTMLDocument, n2, n3, n4, tag, true, false, true);
        }

        HTMLReader(HTMLDocument hTMLDocument, int n2, int n3, int n4, HTML.Tag tag, boolean bl2, boolean bl3, boolean bl4) {
            this.this$0 = hTMLDocument;
            this.inParagraph = false;
            this.impliedP = false;
            this.inPre = false;
            this.inTextArea = false;
            this.textAreaDocument = null;
            this.inTitle = false;
            this.lastWasNewline = true;
            this.inStyle = false;
            this.inHead = false;
            this.parseBuffer = new Vector();
            this.charAttr = new TaggedAttributeSet();
            this.charAttrStack = new Stack();
            this.inBlock = 0;
            this.emptyDocument = hTMLDocument.getLength() == 0;
            this.isStyleCSS = "text/css".equals(hTMLDocument.getDefaultStyleSheetType());
            this.offset = n2;
            this.threshold = hTMLDocument.getTokenThreshold();
            this.tagMap = new Hashtable(57);
            TagAction tagAction = new TagAction(this);
            BlockAction blockAction = new BlockAction(this);
            ParagraphAction paragraphAction = new ParagraphAction(this);
            CharacterAction characterAction = new CharacterAction(this);
            SpecialAction specialAction = new SpecialAction(this);
            FormAction formAction = new FormAction(this);
            HiddenAction hiddenAction = new HiddenAction(this);
            ConvertAction convertAction = new ConvertAction(this);
            this.tagMap.put(HTML.Tag.A, new AnchorAction(this));
            this.tagMap.put(HTML.Tag.ADDRESS, characterAction);
            this.tagMap.put(HTML.Tag.APPLET, hiddenAction);
            this.tagMap.put(HTML.Tag.AREA, new AreaAction(this));
            this.tagMap.put(HTML.Tag.B, convertAction);
            this.tagMap.put(HTML.Tag.BASE, new BaseAction(this));
            this.tagMap.put(HTML.Tag.BASEFONT, characterAction);
            this.tagMap.put(HTML.Tag.BIG, characterAction);
            this.tagMap.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagMap.put(HTML.Tag.BODY, blockAction);
            this.tagMap.put(HTML.Tag.BR, specialAction);
            this.tagMap.put(HTML.Tag.CAPTION, blockAction);
            this.tagMap.put(HTML.Tag.CENTER, blockAction);
            this.tagMap.put(HTML.Tag.CITE, characterAction);
            this.tagMap.put(HTML.Tag.CODE, characterAction);
            this.tagMap.put(HTML.Tag.DD, blockAction);
            this.tagMap.put(HTML.Tag.DFN, characterAction);
            this.tagMap.put(HTML.Tag.DIR, blockAction);
            this.tagMap.put(HTML.Tag.DIV, blockAction);
            this.tagMap.put(HTML.Tag.DL, blockAction);
            this.tagMap.put(HTML.Tag.DT, paragraphAction);
            this.tagMap.put(HTML.Tag.EM, characterAction);
            this.tagMap.put(HTML.Tag.FONT, convertAction);
            this.tagMap.put(HTML.Tag.FORM, new FormTagAction(this, null));
            this.tagMap.put(HTML.Tag.FRAME, specialAction);
            this.tagMap.put(HTML.Tag.FRAMESET, blockAction);
            this.tagMap.put(HTML.Tag.H1, paragraphAction);
            this.tagMap.put(HTML.Tag.H2, paragraphAction);
            this.tagMap.put(HTML.Tag.H3, paragraphAction);
            this.tagMap.put(HTML.Tag.H4, paragraphAction);
            this.tagMap.put(HTML.Tag.H5, paragraphAction);
            this.tagMap.put(HTML.Tag.H6, paragraphAction);
            this.tagMap.put(HTML.Tag.HEAD, new HeadAction(this));
            this.tagMap.put(HTML.Tag.HR, specialAction);
            this.tagMap.put(HTML.Tag.HTML, blockAction);
            this.tagMap.put(HTML.Tag.I, convertAction);
            this.tagMap.put(HTML.Tag.IMG, specialAction);
            this.tagMap.put(HTML.Tag.INPUT, formAction);
            this.tagMap.put(HTML.Tag.ISINDEX, new IsindexAction(this));
            this.tagMap.put(HTML.Tag.KBD, characterAction);
            this.tagMap.put(HTML.Tag.LI, blockAction);
            this.tagMap.put(HTML.Tag.LINK, new LinkAction(this));
            this.tagMap.put(HTML.Tag.MAP, new MapAction(this));
            this.tagMap.put(HTML.Tag.MENU, blockAction);
            this.tagMap.put(HTML.Tag.META, new MetaAction(this));
            this.tagMap.put(HTML.Tag.NOBR, characterAction);
            this.tagMap.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagMap.put(HTML.Tag.OBJECT, specialAction);
            this.tagMap.put(HTML.Tag.OL, blockAction);
            this.tagMap.put(HTML.Tag.OPTION, formAction);
            this.tagMap.put(HTML.Tag.P, paragraphAction);
            this.tagMap.put(HTML.Tag.PARAM, new ObjectAction(this));
            this.tagMap.put(HTML.Tag.PRE, new PreAction(this));
            this.tagMap.put(HTML.Tag.SAMP, characterAction);
            this.tagMap.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagMap.put(HTML.Tag.SELECT, formAction);
            this.tagMap.put(HTML.Tag.SMALL, characterAction);
            this.tagMap.put(HTML.Tag.STRIKE, convertAction);
            this.tagMap.put(HTML.Tag.S, characterAction);
            this.tagMap.put(HTML.Tag.STRONG, characterAction);
            this.tagMap.put(HTML.Tag.STYLE, new StyleAction(this));
            this.tagMap.put(HTML.Tag.SUB, convertAction);
            this.tagMap.put(HTML.Tag.SUP, convertAction);
            this.tagMap.put(HTML.Tag.TABLE, blockAction);
            this.tagMap.put(HTML.Tag.TD, blockAction);
            this.tagMap.put(HTML.Tag.TEXTAREA, formAction);
            this.tagMap.put(HTML.Tag.TH, blockAction);
            this.tagMap.put(HTML.Tag.TITLE, new TitleAction(this));
            this.tagMap.put(HTML.Tag.TR, blockAction);
            this.tagMap.put(HTML.Tag.TT, characterAction);
            this.tagMap.put(HTML.Tag.U, convertAction);
            this.tagMap.put(HTML.Tag.UL, blockAction);
            this.tagMap.put(HTML.Tag.VAR, characterAction);
            if (tag != null) {
                this.insertTag = tag;
                this.popDepth = n3;
                this.pushDepth = n4;
                this.insertInsertTag = bl2;
                this.foundInsertTag = false;
            } else {
                this.foundInsertTag = true;
            }
            if (bl3) {
                this.popDepth = n3;
                this.pushDepth = n4;
                this.insertAfterImplied = true;
                this.foundInsertTag = false;
                this.midInsert = false;
                this.insertInsertTag = true;
                this.wantsTrailingNewline = bl4;
            } else {
                boolean bl5 = this.midInsert = !this.emptyDocument && tag == null;
                if (this.midInsert) {
                    this.generateEndsSpecsForMidInsert();
                }
            }
        }

        static HTMLDocument access$600(HTMLReader hTMLReader) {
            return hTMLReader.this$0;
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagMap.put(tag, tagAction);
        }

        static boolean access$900(HTMLReader hTMLReader, HTML.Tag tag, AttributeSet attributeSet, boolean bl2) {
            return hTMLReader.canInsertTag(tag, attributeSet, bl2);
        }

        class AnchorAction
        extends CharacterAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                if (this.this$1.emptyAnchor) {
                    char[] cArray = new char[]{' '};
                    this.this$1.addContent(cArray, 0, 1);
                }
                super.end(tag);
            }

            AnchorAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.emptyAnchor = true;
                super.start(tag, mutableAttributeSet);
            }
        }

        class AreaAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
            }

            AreaAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (this.this$1.lastMap != null) {
                    this.this$1.lastMap.addArea(mutableAttributeSet.copyAttributes());
                }
            }
        }

        class BaseAction
        extends TagAction {
            private final HTMLReader this$1;

            BaseAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                block2: {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                    if (string == null) break block2;
                    try {
                        URL uRL = new URL(HTMLReader.access$600((HTMLReader)this.this$1).base, string);
                        HTMLReader.access$600(this.this$1).setBase(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        }

        public class BlockAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                this.this$1.blockClose(tag);
            }

            public BlockAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.blockOpen(tag, mutableAttributeSet);
            }
        }

        public class CharacterAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                this.this$1.popCharacterStyle();
            }

            public CharacterAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.pushCharacterStyle();
                if (!this.this$1.foundInsertTag) {
                    boolean bl2 = HTMLReader.access$900(this.this$1, tag, mutableAttributeSet, false);
                    if (this.this$1.foundInsertTag && !this.this$1.inParagraph) {
                        this.this$1.impliedP = true;
                        this.this$1.inParagraph = true;
                    }
                    if (!bl2) {
                        return;
                    }
                }
                if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                this.this$1.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                if (this.this$1.styleAttributes != null) {
                    this.this$1.charAttr.addAttributes(this.this$1.styleAttributes);
                }
            }
        }

        class ConvertAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                this.this$1.popCharacterStyle();
            }

            ConvertAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.pushCharacterStyle();
                if (!this.this$1.foundInsertTag) {
                    boolean bl2 = HTMLReader.access$900(this.this$1, tag, mutableAttributeSet, false);
                    if (this.this$1.foundInsertTag && !this.this$1.inParagraph) {
                        this.this$1.impliedP = true;
                        this.this$1.inParagraph = true;
                    }
                    if (!bl2) {
                        return;
                    }
                }
                if (mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    mutableAttributeSet.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (this.this$1.styleAttributes != null) {
                    this.this$1.charAttr.addAttributes(this.this$1.styleAttributes);
                }
                this.this$1.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                StyleSheet styleSheet = HTMLReader.access$600(this.this$1).getStyleSheet();
                if (tag == HTML.Tag.B) {
                    styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.FONT_WEIGHT, "bold");
                } else if (tag == HTML.Tag.I) {
                    styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.FONT_STYLE, "italic");
                } else if (tag == HTML.Tag.U) {
                    Object object = this.this$1.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String string = "underline";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.TEXT_DECORATION, string);
                } else if (tag == HTML.Tag.STRIKE) {
                    Object object = this.this$1.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String string = "line-through";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.TEXT_DECORATION, string);
                } else if (tag == HTML.Tag.SUP) {
                    Object object = this.this$1.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String string = "sup";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.VERTICAL_ALIGN, string);
                } else if (tag == HTML.Tag.SUB) {
                    Object object = this.this$1.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String string = "sub";
                    string = object != null ? string + "," + object.toString() : string;
                    styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.VERTICAL_ALIGN, string);
                } else if (tag == HTML.Tag.FONT) {
                    String string;
                    String string2;
                    String string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.COLOR);
                    if (string3 != null) {
                        styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.COLOR, string3);
                    }
                    if ((string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.FACE)) != null) {
                        styleSheet.addCSSAttribute(this.this$1.charAttr, CSS.Attribute.FONT_FAMILY, string2);
                    }
                    if ((string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.SIZE)) != null) {
                        styleSheet.addCSSAttributeFromHTML(this.this$1.charAttr, CSS.Attribute.FONT_SIZE, string);
                    }
                }
            }
        }

        public class FormAction
        extends SpecialAction {
            Object selectModel;
            int optionCount;
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                if (tag == HTML.Tag.OPTION) {
                    this.this$1.option = null;
                } else {
                    if (tag == HTML.Tag.SELECT) {
                        this.selectModel = null;
                        this.optionCount = 0;
                    } else if (tag == HTML.Tag.TEXTAREA) {
                        this.this$1.inTextArea = false;
                        this.this$1.textAreaDocument.storeInitialText();
                    }
                    super.end(tag);
                }
            }

            public FormAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            void setModel(String string, MutableAttributeSet mutableAttributeSet) {
                if (string.equals("submit") || string.equals("reset") || string.equals("image")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (string.equals("text") || string.equals("password")) {
                    int n2 = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.MAXLENGTH, -1);
                    PlainDocument plainDocument = n2 > 0 ? new FixedLengthDocument(n2) : new PlainDocument();
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, plainDocument);
                } else if (string.equals("file")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (string.equals("checkbox") || string.equals("radio")) {
                    JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
                    if (string.equals("radio")) {
                        String string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME);
                        ButtonGroup buttonGroup = (ButtonGroup)HTMLDocument.access$700(HTMLReader.access$600(this.this$1)).get(string2);
                        if (buttonGroup == null) {
                            buttonGroup = new ButtonGroup();
                            HTMLDocument.access$700(HTMLReader.access$600(this.this$1)).put(string2, buttonGroup);
                        }
                        toggleButtonModel.setGroup(buttonGroup);
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, toggleButtonModel);
                }
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.INPUT) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TYPE);
                    if (string == null) {
                        string = "text";
                        mutableAttributeSet.addAttribute(HTML.Attribute.TYPE, "text");
                    }
                    this.setModel(string, mutableAttributeSet);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    this.this$1.inTextArea = true;
                    this.this$1.textAreaDocument = new TextAreaDocument();
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, this.this$1.textAreaDocument);
                } else if (tag == HTML.Tag.SELECT) {
                    boolean bl2;
                    int n2 = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.SIZE, 1);
                    boolean bl3 = bl2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.MULTIPLE) != null;
                    if (n2 > 1 || bl2) {
                        OptionListModel optionListModel = new OptionListModel();
                        if (bl2) {
                            optionListModel.setSelectionMode(2);
                        }
                        this.selectModel = optionListModel;
                    } else {
                        this.selectModel = new OptionComboBoxModel();
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, this.selectModel);
                }
                if (tag == HTML.Tag.OPTION) {
                    this.this$1.option = new Option(mutableAttributeSet);
                    if (this.selectModel instanceof OptionListModel) {
                        OptionListModel optionListModel = (OptionListModel)this.selectModel;
                        optionListModel.addElement(this.this$1.option);
                        if (this.this$1.option.isSelected()) {
                            optionListModel.addSelectionInterval(this.optionCount, this.optionCount);
                            optionListModel.setInitialSelection(this.optionCount);
                        }
                    } else if (this.selectModel instanceof OptionComboBoxModel) {
                        OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)this.selectModel;
                        optionComboBoxModel.addElement(this.this$1.option);
                        if (this.this$1.option.isSelected()) {
                            optionComboBoxModel.setSelectedItem(this.this$1.option);
                            optionComboBoxModel.setInitialSelection(this.this$1.option);
                        }
                    }
                    ++this.optionCount;
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }
        }

        private class FormTagAction
        extends BlockAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                super.end(tag);
                HTMLDocument.access$702(HTMLReader.access$600(this.this$1), null);
            }

            private FormTagAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                HTMLDocument.access$702(HTMLReader.access$600(this.this$1), new HashMap());
            }

            FormTagAction(HTMLReader hTMLReader, 1 var2_2) {
                this(hTMLReader);
            }
        }

        class HeadAction
        extends BlockAction {
            private final HTMLReader this$1;

            private void handleLink(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
                if (string == null) {
                    string = HTMLReader.access$600(this.this$1).getDefaultStyleSheetType();
                }
                if (string.equals("text/css")) {
                    String string2 = (String)attributeSet.getAttribute(HTML.Attribute.REL);
                    String string3 = (String)attributeSet.getAttribute(HTML.Attribute.TITLE);
                    String string4 = (String)attributeSet.getAttribute(HTML.Attribute.MEDIA);
                    string4 = string4 == null ? "all" : string4.toLowerCase();
                    if (string2 != null) {
                        string2 = string2.toLowerCase();
                        if ((string4.indexOf("all") != -1 || string4.indexOf("screen") != -1) && (string2.equals("stylesheet") || string2.equals("alternate stylesheet") && string3.equals(this.this$1.defaultStyle))) {
                            this.this$1.linkCSSStyleSheet((String)attributeSet.getAttribute(HTML.Attribute.HREF));
                        }
                    }
                }
            }

            public void end(HTML.Tag tag) {
                this.this$1.inStyle = false;
                this.this$1.inHead = false;
                if (this.this$1.styles != null) {
                    boolean bl2 = this.this$1.isStyleCSS;
                    int n2 = 0;
                    int n3 = this.this$1.styles.size();
                    while (n2 < n3) {
                        String string;
                        Object object = this.this$1.styles.elementAt(n2);
                        if (object == HTML.Tag.LINK) {
                            this.handleLink((AttributeSet)this.this$1.styles.elementAt(++n2));
                            ++n2;
                            continue;
                        }
                        boolean bl3 = (string = (String)this.this$1.styles.elementAt(++n2)) == null ? bl2 : string.equals("text/css");
                        while (++n2 < n3 && this.this$1.styles.elementAt(n2) instanceof String) {
                            if (!bl3) continue;
                            this.this$1.addCSSRules((String)this.this$1.styles.elementAt(n2));
                        }
                    }
                }
                if (this.this$1.insertTag == null && !HTMLReader.access$800(this.this$1) || this.this$1.insertTag == HTML.Tag.HEAD || HTMLReader.access$800(this.this$1) && this.this$1.foundInsertTag) {
                    super.end(tag);
                }
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }

            HeadAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.inHead = true;
                if (this.this$1.insertTag == null && !HTMLReader.access$800(this.this$1) || this.this$1.insertTag == HTML.Tag.HEAD || HTMLReader.access$800(this.this$1) && (this.this$1.foundInsertTag || !mutableAttributeSet.isDefined(HTMLEditorKit.ParserCallback.IMPLIED))) {
                    super.start(tag, mutableAttributeSet);
                }
            }
        }

        public class HiddenAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                if (!this.isEmpty(tag)) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(HTML.Attribute.ENDTAG, "true");
                    this.this$1.addSpecialElement(tag, simpleAttributeSet);
                }
            }

            boolean isEmpty(HTML.Tag tag) {
                return tag != HTML.Tag.APPLET && tag != HTML.Tag.SCRIPT;
            }

            public HiddenAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public class IsindexAction
        extends TagAction {
            private final HTMLReader this$1;

            public IsindexAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.this$1.addSpecialElement(tag, mutableAttributeSet);
                this.this$1.blockClose(HTML.Tag.IMPLIED);
            }
        }

        class LinkAction
        extends HiddenAction {
            private final HTMLReader this$1;

            LinkAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.REL);
                if (string != null && ((string = string.toLowerCase()).equals("stylesheet") || string.equals("alternate stylesheet"))) {
                    if (this.this$1.styles == null) {
                        this.this$1.styles = new Vector(3);
                    }
                    this.this$1.styles.addElement(tag);
                    this.this$1.styles.addElement(mutableAttributeSet.copyAttributes());
                }
                super.start(tag, mutableAttributeSet);
            }
        }

        class MapAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
            }

            MapAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.lastMap = new Map((String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME));
                HTMLReader.access$600(this.this$1).addMap(this.this$1.lastMap);
            }
        }

        class MetaAction
        extends HiddenAction {
            private final HTMLReader this$1;

            boolean isEmpty(HTML.Tag tag) {
                return true;
            }

            MetaAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                Object object = mutableAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV);
                if (object != null) {
                    if ((object = ((String)object).toLowerCase()).equals("content-style-type")) {
                        String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                        HTMLReader.access$600(this.this$1).setDefaultStyleSheetType(string);
                        this.this$1.isStyleCSS = "text/css".equals(HTMLReader.access$600(this.this$1).getDefaultStyleSheetType());
                    } else if (object.equals("default-style")) {
                        this.this$1.defaultStyle = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                    }
                }
                super.start(tag, mutableAttributeSet);
            }
        }

        class ObjectAction
        extends SpecialAction {
            private final HTMLReader this$1;

            void addParameter(AttributeSet attributeSet) {
                String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                if (string != null && string2 != null) {
                    DefaultStyledDocument.ElementSpec elementSpec = (DefaultStyledDocument.ElementSpec)this.this$1.parseBuffer.lastElement();
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)elementSpec.getAttributes();
                    mutableAttributeSet.addAttribute(string, string2);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag != HTML.Tag.PARAM) {
                    super.end(tag);
                }
            }

            ObjectAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.PARAM) {
                    this.addParameter(mutableAttributeSet);
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }
        }

        public class ParagraphAction
        extends BlockAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                super.end(tag);
                this.this$1.inParagraph = false;
            }

            public ParagraphAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                this.this$1.inParagraph = true;
            }
        }

        public class PreAction
        extends BlockAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                this.this$1.blockClose(HTML.Tag.IMPLIED);
                this.this$1.inPre = false;
                this.this$1.blockClose(tag);
            }

            public PreAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.inPre = true;
                this.this$1.blockOpen(tag, mutableAttributeSet);
                mutableAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                this.this$1.blockOpen(HTML.Tag.IMPLIED, mutableAttributeSet);
            }
        }

        public class SpecialAction
        extends TagAction {
            private final HTMLReader this$1;

            public SpecialAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        class StyleAction
        extends TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                this.this$1.inStyle = false;
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }

            StyleAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (this.this$1.inHead) {
                    if (this.this$1.styles == null) {
                        this.this$1.styles = new Vector(3);
                    }
                    this.this$1.styles.addElement(tag);
                    this.this$1.styles.addElement(mutableAttributeSet.getAttribute(HTML.Attribute.TYPE));
                    this.this$1.inStyle = true;
                }
            }
        }

        public class TagAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
            }

            public TagAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }
        }

        class TitleAction
        extends HiddenAction {
            private final HTMLReader this$1;

            public void end(HTML.Tag tag) {
                this.this$1.inTitle = false;
                super.end(tag);
            }

            boolean isEmpty(HTML.Tag tag) {
                return false;
            }

            TitleAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super(hTMLReader);
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.inTitle = true;
                super.start(tag, mutableAttributeSet);
            }
        }
    }

    public static abstract class Iterator {
        public abstract int getEndOffset();

        public abstract int getStartOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract AttributeSet getAttributes();

        public abstract HTML.Tag getTag();
    }

    static class LeafIterator
    extends Iterator {
        private int endOffset;
        private HTML.Tag tag;
        private ElementIterator pos;

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getStartOffset() {
            Element element = this.pos.current();
            if (element != null) {
                return element.getStartOffset();
            }
            return -1;
        }

        public void next() {
            this.nextLeaf(this.pos);
            while (this.isValid()) {
                AttributeSet attributeSet;
                Element element = this.pos.current();
                if (element.getStartOffset() >= this.endOffset && (attributeSet = this.pos.current().getAttributes()).isDefined(this.tag)) {
                    this.setEndOffset();
                    break;
                }
                this.nextLeaf(this.pos);
            }
        }

        void setEndOffset() {
            AttributeSet attributeSet = this.getAttributes();
            this.endOffset = this.pos.current().getEndOffset();
            ElementIterator elementIterator = (ElementIterator)this.pos.clone();
            this.nextLeaf(elementIterator);
            while (elementIterator.current() != null) {
                Element element = elementIterator.current();
                AttributeSet attributeSet2 = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                if (attributeSet2 == null || !attributeSet2.equals(attributeSet)) break;
                this.endOffset = element.getEndOffset();
                this.nextLeaf(elementIterator);
            }
        }

        public boolean isValid() {
            return this.pos.current() != null;
        }

        public AttributeSet getAttributes() {
            Element element = this.pos.current();
            if (element != null) {
                AttributeSet attributeSet = (AttributeSet)element.getAttributes().getAttribute(this.tag);
                return attributeSet;
            }
            return null;
        }

        void nextLeaf(ElementIterator elementIterator) {
            elementIterator.next();
            while (elementIterator.current() != null) {
                Element element = elementIterator.current();
                if (element.isLeaf()) break;
                elementIterator.next();
            }
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        LeafIterator(HTML.Tag tag, Document document) {
            this.tag = tag;
            this.pos = new ElementIterator(document);
            this.endOffset = 0;
            this.next();
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        private final HTMLDocument this$0;

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public RunElement(HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet, int n2, int n3) {
            this.this$0 = hTMLDocument;
            super(hTMLDocument, element, attributeSet, n2, n3);
        }
    }

    static class TaggedAttributeSet
    extends SimpleAttributeSet {
        TaggedAttributeSet() {
        }
    }
}

