/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private CSS.LengthValue cssWidth;
    private CSS.LengthValue cssHeight;

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
        this.cssWidth = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.WIDTH);
        this.cssHeight = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.HEIGHT);
    }

    public float getAlignment(int n2) {
        switch (n2) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                if (this.getViewCount() == 0) {
                    return 0.0f;
                }
                float f2 = this.getPreferredSpan(1);
                View view = this.getView(0);
                float f3 = view.getPreferredSpan(1);
                float f4 = (int)f2 != 0 ? f3 * view.getAlignment(1) / f2 : 0.0f;
                return f4;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    public float getMaximumSpan(int n2) {
        return super.getMaximumSpan(n2);
    }

    public float getMinimumSpan(int n2) {
        return super.getMinimumSpan(n2);
    }

    public float getPreferredSpan(int n2) {
        return super.getPreferredSpan(n2);
    }

    public int getResizeWeight(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = this.getViewCount();
        CSS.Attribute attribute = n3 == 0 ? CSS.Attribute.WIDTH : CSS.Attribute.HEIGHT;
        int n5 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            int n6 = (int)view.getMinimumSpan(n3);
            int n7 = (int)view.getMaximumSpan(n3);
            AttributeSet attributeSet = view.getAttributes();
            CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(attribute);
            if (lengthValue != null && lengthValue.isPercentage()) {
                n7 = n6 = (int)lengthValue.getValue(n2);
            }
            if (n7 < n2) {
                float f2 = view.getAlignment(n3);
                nArray[n5] = (int)((float)(n2 - n7) * f2);
                nArray2[n5] = n7;
            } else {
                nArray[n5] = 0;
                nArray2[n5] = Math.max(n6, n2);
            }
            ++n5;
        }
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    boolean isPercentage(int n2, AttributeSet attributeSet) {
        if (n2 == 0) {
            if (this.cssWidth != null) {
                return this.cssWidth.isPercentage();
            }
        } else if (this.cssHeight != null) {
            return this.cssHeight.isPercentage();
        }
        return false;
    }

    public BlockView(Element element, int n2) {
        super(element, n2);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, rectangle);
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (!BlockView.spanSetFromAttributes(n2, sizeRequirements, this.cssWidth, this.cssHeight)) {
            sizeRequirements = super.calculateMajorAxisRequirements(n2, sizeRequirements);
        } else {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n2, null);
            int n3 = n2 == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n3;
            sizeRequirements.preferred -= n3;
            sizeRequirements.maximum -= n3;
            this.constrainSize(n2, sizeRequirements, sizeRequirements2);
        }
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        Object object;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (!BlockView.spanSetFromAttributes(n2, sizeRequirements, this.cssWidth, this.cssHeight)) {
            sizeRequirements = super.calculateMinorAxisRequirements(n2, sizeRequirements);
        } else {
            object = super.calculateMinorAxisRequirements(n2, null);
            int n3 = n2 == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n3;
            sizeRequirements.preferred -= n3;
            sizeRequirements.maximum -= n3;
            this.constrainSize(n2, sizeRequirements, (SizeRequirements)object);
        }
        if (n2 == 0 && (object = this.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            String string = object.toString();
            sizeRequirements.alignment = string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f);
        }
        return sizeRequirements;
    }

    private void constrainSize(int n2, SizeRequirements sizeRequirements, SizeRequirements sizeRequirements2) {
        if (sizeRequirements2.minimum > sizeRequirements.minimum) {
            sizeRequirements.minimum = sizeRequirements.preferred = sizeRequirements2.minimum;
            sizeRequirements.maximum = Math.max(sizeRequirements.maximum, sizeRequirements2.maximum);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n2 = documentEvent.getOffset();
        if (n2 <= this.getStartOffset() && n2 + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    static boolean spanSetFromAttributes(int n2, SizeRequirements sizeRequirements, CSS.LengthValue lengthValue, CSS.LengthValue lengthValue2) {
        if (n2 == 0) {
            if (lengthValue != null && !lengthValue.isPercentage()) {
                sizeRequirements.preferred = sizeRequirements.maximum = (int)lengthValue.getValue();
                sizeRequirements.minimum = sizeRequirements.maximum;
                return true;
            }
        } else if (lengthValue2 != null && !lengthValue2.isPercentage()) {
            sizeRequirements.preferred = sizeRequirements.maximum = (int)lengthValue2.getValue();
            sizeRequirements.minimum = sizeRequirements.maximum;
            return true;
        }
        return false;
    }
}

