/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private TabStop[] tabs;

    public int getTabCount() {
        return this.tabs == null ? 0 : this.tabs.length;
    }

    public int getTabIndexAfter(float f2) {
        int n2 = 0;
        int n3 = this.getTabCount();
        while (n2 != n3) {
            int n4 = (n3 - n2) / 2 + n2;
            if (f2 > this.tabs[n4].getPosition()) {
                if (n2 == n4) {
                    n2 = n3;
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 == 0 || f2 > this.tabs[n4 - 1].getPosition()) {
                return n4;
            }
            n3 = n4;
        }
        return -1;
    }

    public String toString() {
        int n2 = this.getTabCount();
        StringBuffer stringBuffer = new StringBuffer("[ ");
        int n3 = 0;
        while (n3 < n2) {
            if (n3 > 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(this.getTab(n3).toString());
            ++n3;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public TabStop getTabAfter(float f2) {
        int n2 = this.getTabIndexAfter(f2);
        return n2 == -1 ? null : this.tabs[n2];
    }

    public TabStop getTab(int n2) {
        int n3 = this.getTabCount();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException(n2 + " is outside the range of tabs");
        }
        return this.tabs[n2];
    }

    public int getTabIndex(TabStop tabStop) {
        int n2 = this.getTabCount() - 1;
        while (n2 >= 0) {
            if (this.getTab(n2) == tabStop) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public TabSet(TabStop[] tabStopArray) {
        if (tabStopArray != null) {
            int n2 = tabStopArray.length;
            this.tabs = new TabStop[n2];
            System.arraycopy(tabStopArray, 0, this.tabs, 0, n2);
        } else {
            this.tabs = null;
        }
    }
}

