/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.Utilities;

public class PlainDocument
extends AbstractDocument {
    public static final String tabSizeAttribute = "tabSize";
    public static final String lineLimitAttribute = "lineLimit";
    private AbstractDocument.AbstractElement defaultRoot;
    private Vector added = new Vector();
    private Vector removed = new Vector();

    public PlainDocument() {
        this(new GapContent());
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element element = this.createLeafElement(branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{element};
        branchElement.replace(0, 0, elementArray);
        return branchElement;
    }

    public PlainDocument(AbstractDocument.Content content) {
        super(content);
        this.putProperty(tabSizeAttribute, new Integer(8));
        this.defaultRoot = this.createDefaultRoot();
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.removed.removeAllElements();
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n2 = defaultDocumentEvent.getOffset();
        int n3 = defaultDocumentEvent.getLength();
        int n4 = branchElement.getElementIndex(n2);
        int n5 = branchElement.getElementIndex(n2 + n3);
        if (n4 != n5) {
            int n6 = n4;
            while (n6 <= n5) {
                this.removed.addElement(branchElement.getElement(n6));
                ++n6;
            }
            int n7 = branchElement.getElement(n4).getStartOffset();
            int n8 = branchElement.getElement(n5).getEndOffset();
            Element[] elementArray = new Element[]{this.createLeafElement(branchElement, null, n7, n8)};
            Object[] objectArray = new Element[this.removed.size()];
            this.removed.copyInto(objectArray);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n4, (Element[])objectArray, elementArray);
            defaultDocumentEvent.addEdit(elementEdit);
            branchElement.replace(n4, objectArray.length, elementArray);
        } else {
            Element element;
            Element element2 = branchElement.getElement(n4);
            if (!element2.isLeaf() && Utilities.isComposedTextElement(element = element2.getElement(element2.getElementIndex(n2)))) {
                Element[] elementArray = new Element[]{this.createLeafElement(branchElement, null, element2.getStartOffset(), element2.getEndOffset())};
                Element[] elementArray2 = new Element[]{element2};
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n4, elementArray2, elementArray);
                defaultDocumentEvent.addEdit(elementEdit);
                branchElement.replace(n4, 1, elementArray);
            }
        }
        super.removeUpdate(defaultDocumentEvent);
    }

    public Element getDefaultRootElement() {
        return this.defaultRoot;
    }

    public Element getParagraphElement(int n2) {
        Element element = this.getDefaultRootElement();
        return element.getElement(element.getElementIndex(n2));
    }

    public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        Object object = this.getProperty("filterNewlines");
        if (object instanceof Boolean && object.equals(Boolean.TRUE) && string != null && string.indexOf(10) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = stringBuffer.length();
            int n4 = 0;
            while (n4 < n3) {
                if (stringBuffer.charAt(n4) == '\n') {
                    stringBuffer.setCharAt(n4, ' ');
                }
                ++n4;
            }
            string = stringBuffer.toString();
        }
        super.insertString(n2, string, attributeSet);
    }

    private void insertComposedTextUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        this.added.removeAllElements();
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n2 = defaultDocumentEvent.getOffset();
        int n3 = defaultDocumentEvent.getLength();
        int n4 = branchElement.getElementIndex(n2);
        Element element = branchElement.getElement(n4);
        int n5 = element.getStartOffset();
        int n6 = element.getEndOffset();
        Element[] elementArray = new AbstractDocument.BranchElement[]{(AbstractDocument.BranchElement)this.createBranchElement(branchElement, null)};
        Element[] elementArray2 = new Element[]{element};
        if (n5 != n2) {
            this.added.addElement(this.createLeafElement(elementArray[0], null, n5, n2));
        }
        this.added.addElement(this.createLeafElement(elementArray[0], attributeSet, n2, n2 + n3));
        if (n6 != n2 + n3) {
            this.added.addElement(this.createLeafElement(elementArray[0], null, n2 + n3, n6));
        }
        Object[] objectArray = new Element[this.added.size()];
        this.added.copyInto(objectArray);
        AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n4, elementArray2, elementArray);
        defaultDocumentEvent.addEdit(elementEdit);
        ((AbstractDocument.BranchElement)elementArray[0]).replace(0, 0, (Element[])objectArray);
        branchElement.replace(n4, 1, elementArray);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        this.removed.removeAllElements();
        this.added.removeAllElements();
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n2 = defaultDocumentEvent.getOffset();
        int n3 = defaultDocumentEvent.getLength();
        if (n2 > 0) {
            --n2;
            ++n3;
        }
        int n4 = branchElement.getElementIndex(n2);
        Element element = branchElement.getElement(n4);
        int n5 = element.getStartOffset();
        int n6 = element.getEndOffset();
        int n7 = n5;
        try {
            int n8;
            String string = this.getText(n2, n3);
            boolean bl2 = false;
            int n9 = 0;
            while (n9 < n3) {
                n8 = string.charAt(n9);
                if (n8 == 10) {
                    int n10 = n2 + n9 + 1;
                    this.added.addElement(this.createLeafElement(branchElement, null, n7, n10));
                    n7 = n10;
                    bl2 = true;
                }
                ++n9;
            }
            if (bl2) {
                n8 = 1;
                this.removed.addElement(element);
                if (n2 + n3 == n6 && n7 != n6 && n4 + 1 < branchElement.getElementCount()) {
                    ++n8;
                    Element element2 = branchElement.getElement(n4 + 1);
                    this.removed.addElement(element2);
                    n6 = element2.getEndOffset();
                }
                if (n7 < n6) {
                    this.added.addElement(this.createLeafElement(branchElement, null, n7, n6));
                }
                Object[] objectArray = new Element[this.added.size()];
                this.added.copyInto(objectArray);
                Object[] objectArray2 = new Element[this.removed.size()];
                this.removed.copyInto(objectArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n4, (Element[])objectArray2, (Element[])objectArray);
                defaultDocumentEvent.addEdit(elementEdit);
                branchElement.replace(n4, objectArray2.length, (Element[])objectArray);
            }
            if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
                this.insertComposedTextUpdate(defaultDocumentEvent, attributeSet);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new Error("Internal error: " + badLocationException.toString());
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }
}

