/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private Document model;
    private transient Caret caret;
    private NavigationFilter navigationFilter;
    private transient Highlighter highlighter;
    private transient Keymap keymap;
    private transient MutableCaretEvent caretEvent;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private Color disabledTextColor;
    private boolean editable;
    private Insets margin;
    private char focusAccelerator;
    private boolean dragEnabled;
    private static DefaultTransferHandler defaultTransferHandler;
    private static Map overrideMap;
    private static JTextComponent focusedComponent;
    private static Hashtable keymapTable;
    private JTextComponent editor;
    private transient InputMethodRequests inputMethodRequestsHandler;
    private AttributedString composedText;
    private String composedTextContent;
    private Position composedTextStart;
    private Position composedTextEnd;
    private Position latestCommittedTextStart;
    private Position latestCommittedTextEnd;
    private ComposedTextCaret composedTextCaret;
    private transient Caret originalCaret;
    private boolean checkedInputOverride;
    private boolean needToSendKeyTypedEvent;
    public static final String DEFAULT_KEYMAP = "default";
    static Class class$javax$swing$event$CaretListener;
    static Class class$javax$swing$text$JTextComponent;
    static Class class$java$awt$event$InputMethodEvent;

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    private int getCurrentEventModifiers() {
        int n2 = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n2 = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n2 = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n2;
    }

    public int getSelectionEnd() {
        int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
        return n2;
    }

    public int getSelectionStart() {
        int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
        return n2;
    }

    static {
        keymapTable = null;
        try {
            keymapTable = new Hashtable(17);
            Keymap keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public JTextComponent() {
        this.enableEvents(2056L);
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.setEditable(true);
        this.setDragEnabled(false);
        this.setLayout(null);
        this.updateUI();
    }

    public void copy() {
        this.invokeAction("copy", TransferHandler.getCopyAction());
    }

    public void cut() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("cut", TransferHandler.getCutAction());
        }
    }

    private void installDefaultTransferHandlerIfNecessary() {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
    }

    public void paste() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("paste", TransferHandler.getPasteAction());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(document.getLength());
        }
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        this.invalidate();
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private boolean isProcessInputMethodEventOverridden() {
        Boolean bl2;
        if (overrideMap == null) {
            overrideMap = Collections.synchronizedMap(new HashMap());
        }
        if ((bl2 = (Boolean)overrideMap.get(this.getClass().getName())) != null) {
            return bl2;
        }
        Boolean bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this){
            private final JTextComponent this$0;

            public Object run() {
                return JTextComponent.access$1000(this.this$0.getClass());
            }
            {
                this.this$0 = jTextComponent;
            }
        });
        return bl3;
    }

    private boolean shouldSynthensizeKeyEvents() {
        if (!this.checkedInputOverride) {
            this.checkedInputOverride = true;
            this.needToSendKeyTypedEvent = !this.isProcessInputMethodEventOverridden();
        }
        return this.needToSendKeyTypedEvent;
    }

    public void setFocusAccelerator(char c2) {
        c2 = Character.toUpperCase(c2);
        char c3 = this.focusAccelerator;
        this.focusAccelerator = c2;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c3, this.focusAccelerator);
    }

    public void moveCaretPosition(int n2) {
        Document document = this.getDocument();
        if (document != null) {
            if (n2 > document.getLength() || n2 < 0) {
                throw new IllegalArgumentException("bad position: " + n2);
            }
            this.caret.moveDot(n2);
        }
    }

    public void setCaretPosition(int n2) {
        Document document = this.getDocument();
        if (document != null) {
            if (n2 > document.getLength() || n2 < 0) {
                throw new IllegalArgumentException("bad position: " + n2);
            }
            this.caret.setDot(n2);
        }
    }

    public void setSelectionEnd(int n2) {
        this.select(this.getSelectionStart(), n2);
    }

    public void setSelectionStart(int n2) {
        this.select(n2, this.getSelectionEnd());
    }

    public void select(int n2, int n3) {
        int n4 = this.getDocument().getLength();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n3 < n2) {
            n3 = n2;
        }
        this.setCaretPosition(n2);
        this.moveCaretPosition(n3);
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public void setEditable(boolean bl2) {
        if (bl2 != this.editable) {
            boolean bl3 = this.editable;
            this.editable = bl2;
            if (this.editable) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.firePropertyChange("editable", (Object)bl3, (Object)this.editable);
            this.repaint();
        }
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, this.disabledTextColor);
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        Document document = this.getDocument();
        if (document != null) {
            Boolean bl2 = componentOrientation.isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            document.putProperty(TextAttribute.RUN_DIRECTION, bl2);
        }
        super.setComponentOrientation(componentOrientation);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public Rectangle modelToView(int n2) throws BadLocationException {
        return this.getUI().modelToView(this, n2);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n2);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n2);
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        super.processInputMethodEvent(inputMethodEvent);
        if (!inputMethodEvent.isConsumed()) {
            if (!this.isEditable()) {
                return;
            }
            switch (inputMethodEvent.getID()) {
                case 1100: {
                    this.replaceInputMethodText(inputMethodEvent);
                }
                case 1101: {
                    this.setInputMethodCaretPosition(inputMethodEvent);
                }
            }
            inputMethodEvent.consume();
        }
    }

    private void replaceInputMethodText(InputMethodEvent inputMethodEvent) {
        int n2;
        int n3 = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        Document document = this.getDocument();
        if (this.composedTextStart != null) {
            try {
                n2 = this.composedTextStart.getOffset();
                document.remove(n2, this.composedTextEnd.getOffset() - n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.composedTextEnd = null;
            this.composedTextStart = null;
            this.composedText = null;
            this.composedTextContent = null;
        }
        if (attributedCharacterIterator != null) {
            int n4;
            attributedCharacterIterator.first();
            n2 = 0;
            int n5 = 0;
            if (n3 > 0) {
                n2 = this.caret.getDot();
                if (this.shouldSynthensizeKeyEvents()) {
                    char c2 = attributedCharacterIterator.current();
                    while (n3 > 0) {
                        KeyEvent keyEvent = new KeyEvent(this, 400, EventQueue.getMostRecentEventTime(), 0, 0, c2);
                        this.processKeyEvent(keyEvent);
                        c2 = attributedCharacterIterator.next();
                        --n3;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    char c3 = attributedCharacterIterator.current();
                    while (n3 > 0) {
                        stringBuffer.append(c3);
                        c3 = attributedCharacterIterator.next();
                        --n3;
                    }
                    this.mapCommittedTextToAction(new String(stringBuffer));
                }
                n5 = this.caret.getDot();
            }
            if ((n4 = attributedCharacterIterator.getIndex()) < attributedCharacterIterator.getEndIndex()) {
                this.createComposedString(n4, attributedCharacterIterator);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.ComposedTextAttribute, this.composedText);
                try {
                    this.replaceSelection(null);
                    document.insertString(this.caret.getDot(), this.composedTextContent, simpleAttributeSet);
                    this.composedTextStart = document.createPosition(this.caret.getDot() - this.composedTextContent.length());
                    this.composedTextEnd = document.createPosition(this.caret.getDot());
                }
                catch (BadLocationException badLocationException) {
                    this.composedTextEnd = null;
                    this.composedTextStart = null;
                    this.composedText = null;
                    this.composedTextContent = null;
                }
            }
            if (n2 != n5) {
                try {
                    this.latestCommittedTextStart = document.createPosition(n2);
                    this.latestCommittedTextEnd = document.createPosition(n5);
                }
                catch (BadLocationException badLocationException) {
                    this.latestCommittedTextStart = null;
                    this.latestCommittedTextEnd = null;
                }
            } else {
                this.latestCommittedTextStart = null;
                this.latestCommittedTextEnd = null;
            }
        }
    }

    private void setInputMethodCaretPosition(InputMethodEvent inputMethodEvent) {
        if (this.composedTextStart != null) {
            TextHitInfo textHitInfo;
            int n2 = this.composedTextStart.getOffset();
            if (!(this.caret instanceof ComposedTextCaret)) {
                if (this.composedTextCaret == null) {
                    this.composedTextCaret = new ComposedTextCaret(this);
                }
                this.originalCaret = this.caret;
                this.exchangeCaret(this.originalCaret, this.composedTextCaret);
            }
            if ((textHitInfo = inputMethodEvent.getCaret()) != null) {
                int n3 = textHitInfo.getInsertionIndex();
                n2 += n3;
                if (n3 == 0) {
                    try {
                        Rectangle rectangle = this.modelToView(n2);
                        Rectangle rectangle2 = this.modelToView(this.composedTextEnd.getOffset());
                        Rectangle rectangle3 = this.getBounds();
                        rectangle.x += Math.min(rectangle2.x - rectangle.x, rectangle3.width);
                        this.scrollRectToVisible(rectangle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            this.caret.setDot(n2);
        } else if (this.caret instanceof ComposedTextCaret) {
            int n4 = this.caret.getDot();
            this.exchangeCaret(this.caret, this.originalCaret);
            this.caret.setDot(n4);
        }
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        super.addInputMethodListener(inputMethodListener);
        if (inputMethodListener != null) {
            this.needToSendKeyTypedEvent = false;
            this.checkedInputOverride = true;
        }
    }

    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodRequestsHandler == null) {
            this.inputMethodRequestsHandler = new InputMethodRequestsHandler(this);
            Document document = this.getDocument();
            if (document != null) {
                document.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
        }
        return this.inputMethodRequestsHandler;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
    }

    public void write(Writer writer) throws IOException {
        Document document = this.getDocument();
        try {
            this.getUI().getEditorKit(this).write(writer, document, 0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public String getSelectedText() {
        int n2;
        String string = null;
        int n3 = Math.min(this.caret.getDot(), this.caret.getMark());
        if (n3 != (n2 = Math.max(this.caret.getDot(), this.caret.getMark()))) {
            try {
                Document document = this.getDocument();
                string = document.getText(n3, n2 - n3);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
        return string;
    }

    public String getText() {
        String string;
        Document document = this.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.caretColor != null ? this.caretColor.toString() : "";
        String string3 = this.selectionColor != null ? this.selectionColor.toString() : "";
        String string4 = this.selectedTextColor != null ? this.selectedTextColor.toString() : "";
        String string5 = this.disabledTextColor != null ? this.disabledTextColor.toString() : "";
        String string6 = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",caretColor=" + string2 + ",disabledTextColor=" + string5 + ",editable=" + string + ",margin=" + string6 + ",selectedTextColor=" + string4 + ",selectionColor=" + string3;
    }

    public String getText(int n2, int n3) throws BadLocationException {
        return this.getDocument().getText(n2, n3);
    }

    private void mapCommittedTextToAction(String string) {
        Keymap keymap = this.getKeymap();
        if (keymap != null) {
            Serializable serializable;
            Action action = null;
            if (string.length() == 1) {
                serializable = KeyStroke.getKeyStroke(string.charAt(0));
                action = keymap.getAction((KeyStroke)serializable);
            }
            if (action == null) {
                action = keymap.getDefaultAction();
            }
            if (action != null) {
                serializable = new ActionEvent(this, 1001, string, EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers());
                action.actionPerformed((ActionEvent)serializable);
            }
        }
    }

    public void replaceSelection(String string) {
        block6: {
            Document document = this.getDocument();
            if (document == null) break block6;
            try {
                int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
                int n3 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n2, n3 - n2, string, null);
                } else {
                    if (n2 != n3) {
                        document.remove(n2, n3 - n2);
                    }
                    if (string != null && string.length() > 0) {
                        document.insertString(n2, string, null);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    private void createComposedString(int n2, AttributedCharacterIterator attributedCharacterIterator) {
        Document document = this.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = attributedCharacterIterator.setIndex(n2);
        while (c2 != '\uffff') {
            stringBuffer.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        this.composedTextContent = new String(stringBuffer);
        this.composedText = new AttributedString(attributedCharacterIterator, n2, attributedCharacterIterator.getEndIndex());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextComponent(this);
        }
        return this.accessibleContext;
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CaretListener == null ? JTextComponent.class$("javax.swing.event.CaretListener") : class$javax$swing$event$CaretListener)) {
                ((CaretListener)objectArray[n2 + 1]).caretUpdate(caretEvent);
            }
            n2 -= 2;
        }
    }

    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.listenerList.getListeners(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener);
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.removeChangeListener(this.caretEvent);
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
            this.caret.addChangeListener(this.caretEvent);
        }
        this.firePropertyChange("caret", caret2, this.caret);
    }

    public Document getDocument() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(Document document) {
        Document document2 = this.model;
        try {
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readLock();
            }
            if (this.accessibleContext != null) {
                this.model.removeDocumentListener((AccessibleJTextComponent)this.accessibleContext);
            }
            if (this.inputMethodRequestsHandler != null) {
                this.model.removeDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
            this.model = document;
            Boolean bl2 = this.getComponentOrientation().isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            document.putProperty(TextAttribute.RUN_DIRECTION, bl2);
            this.firePropertyChange("document", document2, document);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readUnlock();
            }
            throw throwable;
        }
        if (document2 instanceof AbstractDocument) {
            ((AbstractDocument)document2).readUnlock();
        }
        this.revalidate();
        this.repaint();
        if (this.accessibleContext != null) {
            this.model.addDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
        if (this.inputMethodRequestsHandler != null) {
            this.model.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
        }
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    static final JTextComponent getFocusedComponent() {
        return focusedComponent;
    }

    static int access$200(JTextComponent jTextComponent) {
        return jTextComponent.getCurrentEventModifiers();
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
        this.updateInputMap(keymap2, keymap);
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
        this.navigationFilter = navigationFilter;
    }

    static Boolean access$1000(Class clazz) {
        return JTextComponent.isProcessInputMethodEventOverridden(clazz);
    }

    private static Boolean isProcessInputMethodEventOverridden(Class clazz) {
        if (clazz == (class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = JTextComponent.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent)) {
            return Boolean.FALSE;
        }
        Boolean bl2 = (Boolean)overrideMap.get(clazz.getName());
        if (bl2 != null) {
            return bl2;
        }
        Boolean bl3 = JTextComponent.isProcessInputMethodEventOverridden(clazz.getSuperclass());
        if (bl3.booleanValue()) {
            overrideMap.put(clazz.getName(), bl3);
            return bl3;
        }
        try {
            Class[] classArray = new Class[]{class$java$awt$event$InputMethodEvent == null ? (class$java$awt$event$InputMethodEvent = JTextComponent.class$("java.awt.event.InputMethodEvent")) : class$java$awt$event$InputMethodEvent};
            Method method = clazz.getDeclaredMethod("processInputMethodEvent", classArray);
            bl2 = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl2 = Boolean.FALSE;
        }
        overrideMap.put(clazz.getName(), bl2);
        return bl2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void read(Reader reader, Object object) throws IOException {
        EditorKit editorKit = this.getUI().getEditorKit(this);
        Document document = editorKit.createDefaultDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            editorKit.read(reader, document, 0);
            this.setDocument(document);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TextUI textUI;
        String string = super.getToolTipText(mouseEvent);
        if (string == null && (textUI = this.getUI()) != null) {
            string = textUI.getToolTipText(this, new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        return string;
    }

    static String access$800(JTextComponent jTextComponent) {
        return jTextComponent.composedTextContent;
    }

    static AttributedString access$900(JTextComponent jTextComponent) {
        return jTextComponent.composedText;
    }

    private void invokeAction(String string, Action action) {
        ActionMap actionMap = this.getActionMap();
        Action action2 = null;
        if (actionMap != null) {
            action2 = actionMap.get(string);
        }
        if (action2 == null) {
            this.installDefaultTransferHandlerIfNecessary();
            action2 = action;
        }
        action2.actionPerformed(new ActionEvent(this, 1001, (String)action2.getValue("Name"), EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers()));
    }

    private void exchangeCaret(Caret caret, Caret caret2) {
        int n2 = caret.getBlinkRate();
        this.setCaret(caret2);
        this.caret.setBlinkRate(n2);
        this.caret.setVisible(this.hasFocus());
    }

    static Document access$000(JTextComponent jTextComponent) {
        return jTextComponent.model;
    }

    static JTextComponent access$302(JTextComponent jTextComponent) {
        focusedComponent = jTextComponent;
        return focusedComponent;
    }

    public static Keymap getKeymap(String string) {
        return (Keymap)keymapTable.get(string);
    }

    public static Keymap removeKeymap(String string) {
        return (Keymap)keymapTable.remove(string);
    }

    void updateInputMap(Keymap keymap, Keymap keymap2) {
        Serializable serializable;
        InputMap inputMap;
        InputMap inputMap2 = inputMap = this.getInputMap(0);
        while (inputMap != null && !(inputMap instanceof KeymapWrapper)) {
            inputMap2 = inputMap;
            inputMap = inputMap.getParent();
        }
        if (inputMap != null) {
            if (keymap2 == null) {
                if (inputMap2 != inputMap) {
                    inputMap2.setParent(inputMap.getParent());
                } else {
                    inputMap2.setParent(null);
                }
            } else {
                serializable = new KeymapWrapper(keymap2);
                inputMap2.setParent((InputMap)serializable);
                if (inputMap2 != inputMap) {
                    ((InputMap)serializable).setParent(inputMap.getParent());
                }
            }
        } else if (keymap2 != null && (inputMap = this.getInputMap(0)) != null) {
            serializable = new KeymapWrapper(keymap2);
            ((InputMap)serializable).setParent(inputMap.getParent());
            inputMap.setParent((InputMap)serializable);
        }
        serializable = this.getActionMap();
        ActionMap actionMap = serializable;
        while (serializable != null && !(serializable instanceof KeymapActionMap)) {
            actionMap = serializable;
            serializable = ((ActionMap)serializable).getParent();
        }
        if (serializable != null) {
            if (keymap2 == null) {
                if (actionMap != serializable) {
                    actionMap.setParent(((ActionMap)serializable).getParent());
                } else {
                    actionMap.setParent(null);
                }
            } else {
                KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
                actionMap.setParent(keymapActionMap);
                if (actionMap != serializable) {
                    keymapActionMap.setParent(((ActionMap)serializable).getParent());
                }
            }
        } else if (keymap2 != null && (serializable = this.getActionMap()) != null) {
            KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
            keymapActionMap.setParent(((ActionMap)serializable).getParent());
            ((ActionMap)serializable).setParent(keymapActionMap);
        }
    }

    static Position access$400(JTextComponent jTextComponent) {
        return jTextComponent.latestCommittedTextStart;
    }

    static Position access$500(JTextComponent jTextComponent) {
        return jTextComponent.latestCommittedTextEnd;
    }

    static Position access$600(JTextComponent jTextComponent) {
        return jTextComponent.composedTextStart;
    }

    static Position access$700(JTextComponent jTextComponent) {
        return jTextComponent.composedTextEnd;
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Object object;
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < actionArray.length) {
            Action action = actionArray[n2];
            object = (String)action.getValue("Name");
            hashtable.put(object != null ? object : "", action);
            ++n2;
        }
        int n3 = 0;
        while (n3 < keyBindingArray.length) {
            object = (Action)hashtable.get(keyBindingArray[n3].actionName);
            if (object != null) {
                keymap.addActionForKeyStroke(keyBindingArray[n3].key, (Action)object);
            }
            ++n3;
        }
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            keymapTable.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    static Position access$402(JTextComponent jTextComponent, Position position) {
        jTextComponent.latestCommittedTextStart = position;
        return jTextComponent.latestCommittedTextStart;
    }

    static Position access$502(JTextComponent jTextComponent, Position position) {
        jTextComponent.latestCommittedTextEnd = position;
        return jTextComponent.latestCommittedTextEnd;
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText {
        int caretPos;
        Point oldLocationOnScreen;
        private final JTextComponent this$0;

        public int getAccessibleActionCount() {
            Action[] actionArray = this.this$0.getActions();
            return actionArray.length;
        }

        public int getCaretPosition() {
            return this.this$0.getCaretPosition();
        }

        public int getCharCount() {
            return JTextComponent.access$000(this.this$0).getLength();
        }

        public int getSelectionEnd() {
            return this.this$0.getSelectionEnd();
        }

        public int getSelectionStart() {
            return this.this$0.getSelectionStart();
        }

        public void paste(int n2) {
            this.this$0.setCaretPosition(n2);
            this.this$0.paste();
        }

        public boolean doAccessibleAction(int n2) {
            Action[] actionArray = this.this$0.getActions();
            if (n2 < 0 || n2 >= actionArray.length) {
                return false;
            }
            ActionEvent actionEvent = new ActionEvent(this.this$0, 1001, null, EventQueue.getMostRecentEventTime(), JTextComponent.access$200(this.this$0));
            actionArray[n2].actionPerformed(actionEvent);
            return true;
        }

        public void cut(int n2, int n3) {
            this.selectText(n2, n3);
            this.this$0.cut();
        }

        public void delete(int n2, int n3) {
            if (this.this$0.isEditable() && this.isEnabled()) {
                try {
                    int n4 = Math.min(n2, n3);
                    int n5 = Math.max(n2, n3);
                    if (n4 != n5) {
                        Document document = this.this$0.getDocument();
                        document.remove(n4, n5 - n4);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.this$0);
            }
        }

        public void selectText(int n2, int n3) {
            this.this$0.select(n2, n3);
        }

        public int getIndexAtPoint(Point point) {
            if (point == null) {
                return -1;
            }
            return this.this$0.viewToModel(point);
        }

        Rectangle getRootEditorRect() {
            Rectangle rectangle = this.this$0.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                rectangle.y = 0;
                rectangle.x = 0;
                Insets insets = this.this$0.getInsets();
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                return rectangle;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Rectangle getCharacterBounds(int n2) {
            if (n2 < 0) return null;
            if (n2 > JTextComponent.access$000(this.this$0).getLength() - 1) {
                return null;
            }
            TextUI textUI = this.this$0.getUI();
            if (textUI == null) {
                return null;
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.getRootEditorRect();
            if (rectangle2 == null) {
                return null;
            }
            if (JTextComponent.access$000(this.this$0) instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.access$000(this.this$0)).readLock();
            }
            try {
                block8: {
                    try {
                        View view = textUI.getRootView(this.this$0);
                        if (view == null) break block8;
                        view.setSize(rectangle2.width, rectangle2.height);
                        Shape shape = view.modelToView(n2, Position.Bias.Forward, n2 + 1, Position.Bias.Backward, rectangle2);
                        rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    }
                    catch (BadLocationException badLocationException) {
                        Object var8_9 = null;
                        if (!(JTextComponent.access$000(this.this$0) instanceof AbstractDocument)) return rectangle;
                        ((AbstractDocument)JTextComponent.access$000(this.this$0)).readUnlock();
                        return rectangle;
                    }
                }
                Object var8_8 = null;
                if (!(JTextComponent.access$000(this.this$0) instanceof AbstractDocument)) return rectangle;
                ((AbstractDocument)JTextComponent.access$000(this.this$0)).readUnlock();
                return rectangle;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!(JTextComponent.access$000(this.this$0) instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.access$000(this.this$0)).readUnlock();
                throw throwable;
            }
        }

        public String getSelectedText() {
            return this.this$0.getSelectedText();
        }

        public String getAccessibleActionDescription(int n2) {
            Action[] actionArray = this.this$0.getActions();
            if (n2 < 0 || n2 >= actionArray.length) {
                return null;
            }
            return (String)actionArray[n2].getValue("Name");
        }

        public String getAfterIndex(int n2, int n3) {
            return this.getAtIndex(n2, n3, 1);
        }

        public String getAtIndex(int n2, int n3) {
            return this.getAtIndex(n2, n3, 0);
        }

        public String getBeforeIndex(int n2, int n3) {
            return this.getAtIndex(n2, n3, -1);
        }

        public String getTextRange(int n2, int n3) {
            int n4;
            String string = null;
            int n5 = Math.min(n2, n3);
            if (n5 != (n4 = Math.max(n2, n3))) {
                try {
                    Document document = this.this$0.getDocument();
                    string = document.getText(n5, n4 - n5);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException(badLocationException.getMessage());
                }
            }
            return string;
        }

        /*
         * Exception decompiling
         */
        private String getAtIndex(int var1_1, int var2_2, int var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void replaceText(int n2, int n3, String string) {
            this.selectText(n2, n3);
            this.this$0.replaceSelection(string);
        }

        public void insertTextAtIndex(int n2, String string) {
            block3: {
                Document document = this.this$0.getDocument();
                if (document == null) break block3;
                try {
                    if (string != null && string.length() > 0) {
                        document.insertString(n2, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.this$0);
                }
            }
        }

        public void setTextContents(String string) {
            this.this$0.setText(string);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n2 = caretEvent.getDot();
            int n3 = caretEvent.getMark();
            if (this.caretPos != n2) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretPos), new Integer(n2));
                this.caretPos = n2;
                try {
                    this.oldLocationOnScreen = this.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
            if (n3 != n2) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Integer n2 = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n2);
            } else {
                Runnable runnable = new Runnable(this, n2){
                    private final Integer val$pos;
                    private final AccessibleJTextComponent this$1;

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n2;
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Integer n2 = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n2);
            } else {
                Runnable runnable = new Runnable(this, n2){
                    private final Integer val$pos;
                    private final AccessibleJTextComponent this$1;

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n2;
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Integer n2 = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n2);
            } else {
                Runnable runnable = new Runnable(this, n2){
                    private final Integer val$pos;
                    private final AccessibleJTextComponent this$1;

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n2;
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getCharacterAttribute(int n2) {
            Element element = null;
            if (JTextComponent.access$000(this.this$0) instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.access$000(this.this$0)).readLock();
            }
            try {
                element = JTextComponent.access$000(this.this$0).getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n3 = element.getElementIndex(n2);
                    element = element.getElement(n3);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (JTextComponent.access$000(this.this$0) instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.access$000(this.this$0)).readUnlock();
                }
                throw throwable;
            }
            if (JTextComponent.access$000(this.this$0) instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.access$000(this.this$0)).readUnlock();
            }
            return element.getAttributes();
        }

        public void setAttributes(int n2, int n3, AttributeSet attributeSet) {
            Document document = this.this$0.getDocument();
            if (document != null && document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                int n4 = n2;
                int n5 = n3 - n2;
                styledDocument.setCharacterAttributes(n4, n5, attributeSet, true);
            }
        }

        private Element getParagraphElement(int n2) {
            if (JTextComponent.access$000(this.this$0) instanceof PlainDocument) {
                PlainDocument plainDocument = (PlainDocument)JTextComponent.access$000(this.this$0);
                return plainDocument.getParagraphElement(n2);
            }
            if (JTextComponent.access$000(this.this$0) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)JTextComponent.access$000(this.this$0);
                return styledDocument.getParagraphElement(n2);
            }
            Element element = null;
            element = JTextComponent.access$000(this.this$0).getDefaultRootElement();
            while (!element.isLeaf()) {
                int n3 = element.getElementIndex(n2);
                element = element.getElement(n3);
            }
            if (element == null) {
                return null;
            }
            return element.getParentElement();
        }

        public AccessibleJTextComponent(JTextComponent jTextComponent) {
            this.this$0 = jTextComponent;
            super(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
            }
            jTextComponent.addCaretListener(this);
            this.caretPos = this.getCaretPosition();
            try {
                this.oldLocationOnScreen = this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
            jTextComponent.addComponentListener(new ComponentAdapter(this){
                private final AccessibleJTextComponent this$1;

                public void componentMoved(ComponentEvent componentEvent) {
                    try {
                        Point point = this.this$1.getLocationOnScreen();
                        this.this$1.firePropertyChange("AccessibleVisibleData", this.this$1.oldLocationOnScreen, point);
                        this.this$1.oldLocationOnScreen = point;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {}
                }
                {
                    this.this$1 = accessibleJTextComponent;
                }
            });
        }

        private IndexedSegment getParagraphElementText(int n2) throws BadLocationException {
            Element element = this.getParagraphElement(n2);
            if (element != null) {
                IndexedSegment indexedSegment = new IndexedSegment(this, null);
                try {
                    int n3 = element.getEndOffset() - element.getStartOffset();
                    JTextComponent.access$000(this.this$0).getText(element.getStartOffset(), n3, indexedSegment);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                indexedSegment.modelOffset = element.getStartOffset();
                return indexedSegment;
            }
            return null;
        }

        private IndexedSegment getSegmentAt(int n2, int n3) throws BadLocationException {
            BreakIterator breakIterator;
            IndexedSegment indexedSegment = this.getParagraphElementText(n3);
            if (indexedSegment == null) {
                return null;
            }
            switch (n2) {
                case 2: {
                    breakIterator = BreakIterator.getWordInstance(this.getLocale());
                    break;
                }
                case 3: {
                    breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                    break;
                }
                default: {
                    return null;
                }
            }
            indexedSegment.first();
            breakIterator.setText(indexedSegment);
            int n4 = breakIterator.following(n3 - indexedSegment.modelOffset + indexedSegment.offset);
            if (n4 == -1) {
                return null;
            }
            if (n4 > indexedSegment.offset + indexedSegment.count) {
                return null;
            }
            int n5 = breakIterator.previous();
            if (n5 == -1 || n5 >= indexedSegment.offset + indexedSegment.count) {
                return null;
            }
            indexedSegment.modelOffset = indexedSegment.modelOffset + n5 - indexedSegment.offset;
            indexedSegment.offset = n5;
            indexedSegment.count = n4 - n5;
            return indexedSegment;
        }

        private class IndexedSegment
        extends Segment {
            public int modelOffset;
            private final AccessibleJTextComponent this$1;

            private IndexedSegment(AccessibleJTextComponent accessibleJTextComponent) {
                this.this$1 = accessibleJTextComponent;
            }

            IndexedSegment(AccessibleJTextComponent accessibleJTextComponent, 1 var2_2) {
                this(accessibleJTextComponent);
            }
        }
    }

    class ComposedTextCaret
    extends DefaultCaret
    implements Serializable {
        Color bg;
        private final JTextComponent this$0;

        public void paint(Graphics graphics) {
            block2: {
                if (!this.isVisible()) break block2;
                try {
                    Rectangle rectangle = this.component.modelToView(this.getDot());
                    graphics.setXORMode(this.bg);
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                    graphics.setPaintMode();
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        protected void positionCaret(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = this.component;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n2 = jTextComponent.viewToModel(point);
            if (n2 < JTextComponent.access$600(jTextComponent).getOffset() || n2 > JTextComponent.access$700(jTextComponent).getOffset()) {
                try {
                    Position position = jTextComponent.getDocument().createPosition(n2);
                    jTextComponent.getInputContext().endComposition();
                    EventQueue.invokeLater(new DoSetCaretPosition(this.this$0, jTextComponent, position));
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            } else {
                super.positionCaret(mouseEvent);
            }
        }

        ComposedTextCaret(JTextComponent jTextComponent) {
            this.this$0 = jTextComponent;
        }

        public void install(JTextComponent jTextComponent) {
            super.install(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                Element element = styledDocument.getCharacterElement(JTextComponent.access$600(jTextComponent).getOffset());
                AttributeSet attributeSet = element.getAttributes();
                this.bg = styledDocument.getBackground(attributeSet);
            }
            if (this.bg == null) {
                this.bg = jTextComponent.getBackground();
            }
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        public void removeBindings() {
            this.bindings.clear();
        }

        public String getName() {
            return this.nm;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n2 = 0;
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n2++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n2 = 0;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n2++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            KeyStroke[] keyStrokeArray;
            if (action == null) {
                return null;
            }
            Object[] objectArray = null;
            Vector vector = null;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray = enumeration.nextElement();
                if (this.bindings.get(keyStrokeArray) != action) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(keyStrokeArray);
            }
            if (this.parent != null && (keyStrokeArray = this.parent.getKeyStrokesForAction(action)) != null) {
                int n2 = 0;
                int n3 = keyStrokeArray.length - 1;
                while (n3 >= 0) {
                    if (this.isLocallyDefined(keyStrokeArray[n3])) {
                        keyStrokeArray[n3] = null;
                        ++n2;
                    }
                    --n3;
                }
                if (n2 > 0 && n2 < keyStrokeArray.length) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    int n4 = keyStrokeArray.length - 1;
                    while (n4 >= 0) {
                        if (keyStrokeArray[n4] != null) {
                            vector.addElement(keyStrokeArray[n4]);
                        }
                        --n4;
                    }
                } else if (n2 == 0) {
                    if (vector == null) {
                        objectArray = keyStrokeArray;
                    } else {
                        objectArray = new KeyStroke[vector.size() + keyStrokeArray.length];
                        vector.copyInto(objectArray);
                        System.arraycopy(keyStrokeArray, 0, objectArray, vector.size(), keyStrokeArray.length);
                        vector = null;
                    }
                }
            }
            if (vector != null) {
                objectArray = new KeyStroke[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }
    }

    static class DefaultTransferHandler
    extends TransferHandler
    implements UIResource {
        DefaultTransferHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n2) {
            block3: {
                int n3;
                JTextComponent jTextComponent;
                int n4;
                if (!(jComponent instanceof JTextComponent) || (n4 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) == (n3 = jTextComponent.getSelectionEnd())) break block3;
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n4, n3 - n4);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    if (n2 == 2) {
                        document.remove(n4, n3 - n4);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                int n2 = 0;
                while (n2 < dataFlavorArray.length) {
                    if (dataFlavorArray[n2].equals(DataFlavor.stringFlavor)) {
                        return dataFlavorArray[n2];
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getFlavor(dataFlavorArray) != null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor;
            if (jComponent instanceof JTextComponent && (dataFlavor = this.getFlavor(transferable.getTransferDataFlavors())) != null) {
                try {
                    String string = (String)transferable.getTransferData(dataFlavor);
                    ((JTextComponent)jComponent).replaceSelection(string);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                }
            }
            return false;
        }
    }

    private class DoSetCaretPosition
    implements Runnable {
        JTextComponent host;
        Position newPos;
        private final JTextComponent this$0;

        public void run() {
            this.host.setCaretPosition(this.newPos.getOffset());
        }

        DoSetCaretPosition(JTextComponent jTextComponent, JTextComponent jTextComponent2, Position position) {
            this.this$0 = jTextComponent;
            this.host = jTextComponent2;
            this.newPos = position;
        }
    }

    class InputMethodRequestsHandler
    implements InputMethodRequests,
    DocumentListener {
        private final JTextComponent this$0;

        public int getCommittedTextLength() {
            Document document = this.this$0.getDocument();
            int n2 = 0;
            if (document != null) {
                n2 = document.getLength();
                if (JTextComponent.access$800(this.this$0) != null) {
                    n2 -= JTextComponent.access$800(this.this$0).length();
                }
            }
            return n2;
        }

        public int getInsertPositionOffset() {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (JTextComponent.access$600(this.this$0) != null) {
                n3 = JTextComponent.access$600(this.this$0).getOffset();
                n4 = JTextComponent.access$700(this.this$0).getOffset();
            }
            if ((n2 = this.this$0.getCaretPosition()) < n3) {
                return n2;
            }
            if (n2 < n4) {
                return n3;
            }
            return n2 - (n4 - n3);
        }

        public TextHitInfo getLocationOffset(int n2, int n3) {
            if (JTextComponent.access$900(this.this$0) == null) {
                return null;
            }
            Point point = this.this$0.getLocationOnScreen();
            point.x = n2 - point.x;
            point.y = n3 - point.y;
            int n4 = this.this$0.viewToModel(point);
            if (n4 >= JTextComponent.access$600(this.this$0).getOffset() && n4 <= JTextComponent.access$700(this.this$0).getOffset()) {
                return TextHitInfo.leading(n4 - JTextComponent.access$600(this.this$0).getOffset());
            }
            return null;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            JTextComponent.access$402(this.this$0, null);
            JTextComponent.access$502(this.this$0, null);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JTextComponent.access$402(this.this$0, null);
            JTextComponent.access$502(this.this$0, null);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JTextComponent.access$402(this.this$0, null);
            JTextComponent.access$502(this.this$0, null);
        }

        InputMethodRequestsHandler(JTextComponent jTextComponent) {
            this.this$0 = jTextComponent;
        }

        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            Rectangle rectangle;
            try {
                rectangle = this.this$0.modelToView(this.this$0.getCaretPosition());
                if (rectangle != null) {
                    Point point = this.this$0.getLocationOnScreen();
                    rectangle.translate(point.x, point.y);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            return rectangle;
        }

        public AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
            String string;
            int n4 = 0;
            int n5 = 0;
            if (JTextComponent.access$600(this.this$0) != null) {
                n4 = JTextComponent.access$600(this.this$0).getOffset();
                n5 = JTextComponent.access$700(this.this$0).getOffset();
            }
            try {
                if (n2 < n4) {
                    if (n3 <= n4) {
                        string = this.this$0.getText(n2, n3 - n2);
                    } else {
                        int n6 = n4 - n2;
                        string = this.this$0.getText(n2, n6) + this.this$0.getText(n5, n3 - n2 - n6);
                    }
                } else {
                    string = this.this$0.getText(n2 + (n5 - n4), n3 - n2);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Invalid range");
            }
            return new AttributedString(string).getIterator();
        }

        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            Document document = this.this$0.getDocument();
            if (document != null && JTextComponent.access$400(this.this$0) != null && JTextComponent.access$500(this.this$0) != null) {
                try {
                    int n2 = JTextComponent.access$400(this.this$0).getOffset();
                    int n3 = JTextComponent.access$500(this.this$0).getOffset();
                    String string = document.getText(n2, n3 - n2);
                    document.remove(n2, n3 - n2);
                    return new AttributedString(string).getIterator();
                }
                catch (BadLocationException badLocationException) {
                }
            }
            return null;
        }

        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            String string = this.this$0.getSelectedText();
            if (string != null) {
                return new AttributedString(string).getIterator();
            }
            return null;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }

    static class KeymapActionMap
    extends ActionMap {
        private Keymap keymap;

        public int size() {
            int n2;
            Action[] actionArray = this.keymap.getBoundActions();
            int n3 = n2 = actionArray == null ? 0 : actionArray.length;
            if (this.keymap.getDefaultAction() != null) {
                ++n2;
            }
            return super.size() + n2;
        }

        public Object[] keys() {
            boolean bl2;
            Object[] objectArray = super.keys();
            Object[] objectArray2 = this.keymap.getBoundActions();
            int n2 = objectArray == null ? 0 : objectArray.length;
            int n3 = objectArray2 == null ? 0 : objectArray2.length;
            boolean bl3 = bl2 = this.keymap.getDefaultAction() != null;
            if (bl2) {
                ++n3;
            }
            if (n2 == 0) {
                if (bl2) {
                    Object[] objectArray3 = new Object[n3];
                    if (n3 > 1) {
                        System.arraycopy(objectArray2, 0, objectArray3, 0, n3 - 1);
                    }
                    objectArray3[n3 - 1] = KeymapWrapper.DefaultActionKey;
                    return objectArray3;
                }
                return objectArray2;
            }
            if (n3 == 0) {
                return objectArray;
            }
            Object[] objectArray4 = new Object[n2 + n3];
            System.arraycopy(objectArray, 0, objectArray4, 0, n2);
            if (bl2) {
                if (n3 > 1) {
                    System.arraycopy(objectArray2, 0, objectArray4, n2, n3 - 1);
                }
                objectArray4[n2 + n3 - 1] = KeymapWrapper.DefaultActionKey;
            } else {
                System.arraycopy(objectArray2, 0, objectArray4, n2, n3);
            }
            return objectArray4;
        }

        KeymapActionMap(Keymap keymap) {
            this.keymap = keymap;
        }

        public Action get(Object object) {
            Action action = super.get(object);
            if (action == null) {
                if (object == KeymapWrapper.DefaultActionKey) {
                    action = this.keymap.getDefaultAction();
                } else if (object instanceof Action) {
                    action = (Action)object;
                }
            }
            return action;
        }
    }

    static class KeymapWrapper
    extends InputMap {
        static final Object DefaultActionKey = new Object();
        private Keymap keymap;

        public int size() {
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            int n2 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            return super.size() + n2;
        }

        public KeyStroke[] keys() {
            int n2;
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.keymap.getBoundKeyStrokes();
            int n3 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            int n4 = n2 = keyStrokeArray2 == null ? 0 : keyStrokeArray2.length;
            if (n3 == 0) {
                return keyStrokeArray2;
            }
            if (n2 == 0) {
                return keyStrokeArray;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n3 + n2];
            System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, n3);
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray3, n3, n2);
            return keyStrokeArray3;
        }

        KeymapWrapper(Keymap keymap) {
            this.keymap = keymap;
        }

        public Object get(KeyStroke keyStroke) {
            Object object = this.keymap.getAction(keyStroke);
            if (object == null && (object = super.get(keyStroke)) == null && keyStroke.getKeyChar() != '\uffff' && this.keymap.getDefaultAction() != null) {
                object = DefaultActionKey;
            }
            return object;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    FocusListener,
    MouseListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        final void fire() {
            JTextComponent jTextComponent = (JTextComponent)this.getSource();
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                jTextComponent.fireCaretUpdate(this);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextComponent.access$302((JTextComponent)focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.dragActive = true;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.dragActive = false;
            this.fire();
        }

        public final String toString() {
            return "dot=" + this.dot + "," + "mark=" + this.mark;
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        MutableCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
        }
    }
}

