/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    protected int layoutSpan = Short.MAX_VALUE;
    protected View layoutPool;
    protected FlowStrategy strategy = new FlowStrategy();

    public int getFlowAxis() {
        if (this.getAxis() == 1) {
            return 0;
        }
        return 1;
    }

    public int getFlowSpan(int n2) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n2) {
        return 0;
    }

    protected int getViewIndexAtPosition(int n2) {
        if (n2 >= this.getStartOffset() && n2 < this.getEndOffset()) {
            int n3 = this.getViewCount() - 1;
            while (n3 >= 0) {
                View view = this.getView(n3);
                if (n2 >= view.getStartOffset() && n2 < view.getEndOffset()) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    protected void layout(int n2, int n3) {
        int n4 = this.getFlowAxis();
        int n5 = n4 == 0 ? n2 : n3;
        if (this.layoutSpan != n5) {
            this.layoutChanged(n4);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = n5;
        }
        if (!this.isLayoutValid(n4)) {
            int n6 = this.getAxis();
            int n7 = n6 == 0 ? this.getWidth() : this.getHeight();
            this.strategy.layout(this);
            int n8 = (int)this.getPreferredSpan(n6);
            if (n7 != n8) {
                Container container;
                View view = this.getParent();
                if (view != null) {
                    view.preferenceChanged(this, n6 == 0, n6 == 1);
                }
                if ((container = this.getContainer()) != null) {
                    container.repaint();
                }
            }
        }
        super.layout(n2, n3);
    }

    public FlowView(Element element, int n2) {
        super(element, n2);
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        float f2 = this.layoutPool.getPreferredSpan(n2);
        float f3 = this.layoutPool.getMinimumSpan(n2);
        sizeRequirements.minimum = (int)f3;
        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)f2);
        sizeRequirements.maximum = Short.MAX_VALUE;
        sizeRequirements.alignment = 0.5f;
        return sizeRequirements;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public static class FlowStrategy {
        public void layout(FlowView flowView) {
            int n2 = flowView.getStartOffset();
            int n3 = flowView.getEndOffset();
            View view = this.getLogicalView(flowView);
            int n4 = view.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view2 = view.getView(n5);
                view2.setParent(view);
                ++n5;
            }
            flowView.removeAll();
            int n6 = 0;
            while (n2 < n3) {
                View view3 = flowView.createRow();
                flowView.append(view3);
                int n7 = this.layoutRow(flowView, n6, n2);
                if (view3.getViewCount() == 0) {
                    view3.append(this.createView(flowView, n2, Integer.MAX_VALUE, n6));
                    n7 = view3.getEndOffset();
                }
                if (n7 <= n2) {
                    throw new StateInvariantError("infinite loop in formatting");
                }
                n2 = n7;
                ++n6;
            }
        }

        protected int layoutRow(FlowView flowView, int n2, int n3) {
            View view;
            View view2 = flowView.getView(n2);
            int n4 = flowView.getFlowStart(n2);
            int n5 = flowView.getFlowSpan(n2);
            int n6 = flowView.getEndOffset();
            TabExpander tabExpander = flowView instanceof TabExpander ? (TabExpander)((Object)flowView) : null;
            int n7 = n4;
            int n8 = n5;
            n7 = n4;
            int n9 = flowView.getFlowAxis();
            boolean bl2 = false;
            while (n3 < n6 && n5 > 0) {
                view = this.createView(flowView, n3, n5, n2);
                if (view == null) break;
                int n10 = n9 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n4, tabExpander) : (int)view.getPreferredSpan(n9);
                if (view.getBreakWeight(n9, n3, n5) >= 3000) {
                    int n11 = view2.getViewCount();
                    if (n11 > 0) {
                        n10 = (view = view.breakView(n9, n3, n4, n5)) != null ? (n9 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n4, tabExpander) : (int)view.getPreferredSpan(n9)) : 0;
                    }
                    bl2 = true;
                }
                n5 -= n10;
                n4 += n10;
                if (view != null) {
                    view2.append(view);
                    n3 = view.getEndOffset();
                }
                if (bl2) break;
            }
            if (n5 < 0) {
                this.adjustRow(flowView, n2, n8, n7);
            } else if (view2.getViewCount() == 0) {
                view = this.createView(flowView, n3, Integer.MAX_VALUE, n2);
                view2.append(view);
            }
            return view2.getEndOffset();
        }

        protected void adjustRow(FlowView flowView, int n2, int n3, int n4) {
            int n5;
            View view;
            int n6 = flowView.getFlowAxis();
            View view2 = flowView.getView(n2);
            int n7 = view2.getViewCount();
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = -1;
            boolean bl2 = false;
            int n12 = 0;
            while (n12 < n7) {
                view = view2.getView(n12);
                int n13 = view.getBreakWeight(n6, n4 + n8, n5 = n3 - n8);
                if (n13 >= n9 && n13 > 0) {
                    n9 = n13;
                    n11 = n12;
                    n10 = n8;
                    if (n13 >= 3000) break;
                }
                n8 = (int)((float)n8 + view.getPreferredSpan(n6));
                ++n12;
            }
            if (n11 < 0) {
                return;
            }
            n5 = n3 - n10;
            view = view2.getView(n11);
            view = view.breakView(n6, view.getStartOffset(), n4 + n10, n5);
            View[] viewArray = new View[]{view};
            view2.replace(n11, n7 - n11, viewArray);
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        protected View createView(FlowView flowView, int n2, int n3, int n4) {
            int n5;
            View view = this.getLogicalView(flowView);
            View view2 = view.getView(n5 = view.getViewIndex(n2, Position.Bias.Forward));
            if (n2 == view2.getStartOffset()) {
                return view2;
            }
            view2 = view2.createFragment(n2, view2.getEndOffset());
            return view2;
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            Container container;
            if (rectangle != null && (container = flowView.getContainer()) != null) {
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            Container container;
            if (rectangle != null && (container = flowView.getContainer()) != null) {
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            Container container;
            if (rectangle != null && (container = flowView.getContainer()) != null) {
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    static class LogicalView
    extends CompositeView {
        public float getMinimumSpan(int n2) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            boolean bl2 = false;
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                View view = this.getView(n4);
                if (view.getBreakWeight(n2, 0.0f, 32767.0f) == 0) {
                    f3 += view.getPreferredSpan(n2);
                    bl2 = true;
                } else if (bl2) {
                    f2 = Math.max(f3, f2);
                    bl2 = false;
                    f3 = 0.0f;
                }
                ++n4;
            }
            f2 = Math.max(f2, f3);
            return f2;
        }

        public float getPreferredSpan(int n2) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                View view = this.getView(n4);
                f3 += view.getPreferredSpan(n2);
                if (view.getBreakWeight(n2, 0.0f, 32767.0f) >= 3000) {
                    f2 = Math.max(f2, f3);
                    f3 = 0.0f;
                }
                ++n4;
            }
            f2 = Math.max(f2, f3);
            return f2;
        }

        protected int getViewIndexAtPosition(int n2) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                return 0;
            }
            return super.getViewIndexAtPosition(n2);
        }

        protected boolean isAfter(int n2, int n3, Rectangle rectangle) {
            return false;
        }

        protected boolean isBefore(int n2, int n3, Rectangle rectangle) {
            return false;
        }

        protected void childAllocation(int n2, Rectangle rectangle) {
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        LogicalView(Element element) {
            super(element);
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                LabelView labelView = new LabelView(element);
                this.append(labelView);
            } else {
                super.loadChildren(viewFactory);
            }
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        protected View getViewAtPoint(int n2, int n3, Rectangle rectangle) {
            return null;
        }

        protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            view.setParent(this);
            super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
        }
    }
}

