/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.plaf.UIResource;

class BasicTransferable
implements Transferable,
UIResource {
    protected String plainData;
    protected String htmlData;
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;
    static Class class$java$lang$String;
    static Class class$java$io$Reader;
    static Class class$java$io$InputStream;

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
        }
    }

    protected boolean isHTMLSupported() {
        return this.htmlData != null;
    }

    protected boolean isPlainSupported() {
        return this.plainData != null;
    }

    protected DataFlavor[] getRicherFlavors() {
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n2 = dataFlavorArray != null ? dataFlavorArray.length : 0;
        int n3 = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int n4 = this.isPlainSupported() ? plainFlavors.length : 0;
        int n5 = this.isPlainSupported() ? stringFlavors.length : 0;
        int n6 = n2 + n3 + n4 + n5;
        DataFlavor[] dataFlavorArray2 = new DataFlavor[n6];
        int n7 = 0;
        if (n2 > 0) {
            System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n7, n2);
            n7 += n2;
        }
        if (n3 > 0) {
            System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n7, n3);
            n7 += n3;
        }
        if (n4 > 0) {
            System.arraycopy(plainFlavors, 0, dataFlavorArray2, n7, n4);
            n7 += n4;
        }
        if (n5 > 0) {
            System.arraycopy(stringFlavors, 0, dataFlavorArray2, n7, n5);
            n7 += n5;
        }
        return dataFlavorArray2;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            if (dataFlavorArray[n2].equals(dataFlavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = htmlFlavors;
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            if (dataFlavorArray[n2].equals(dataFlavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isPlainFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = plainFlavors;
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            if (dataFlavorArray[n2].equals(dataFlavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isRicherFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n2 = dataFlavorArray != null ? dataFlavorArray.length : 0;
        int n3 = 0;
        while (n3 < n2) {
            if (dataFlavorArray[n3].equals(dataFlavor)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected boolean isStringFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = stringFlavors;
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            if (dataFlavorArray[n2].equals(dataFlavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getHTMLData() {
        return this.htmlData;
    }

    protected String getPlainData() {
        return this.plainData;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        return null;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        if (this.isRicherFlavor(dataFlavor)) {
            return this.getRicherData(dataFlavor);
        }
        if (this.isHTMLFlavor(dataFlavor)) {
            String string = this.getHTMLData();
            string = string == null ? "" : string;
            if ((class$java$lang$String == null ? (class$java$lang$String = BasicTransferable.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if ((class$java$io$Reader == null ? (class$java$io$Reader = BasicTransferable.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = BasicTransferable.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isPlainFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            if ((class$java$lang$String == null ? (class$java$lang$String = BasicTransferable.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if ((class$java$io$Reader == null ? (class$java$io$Reader = BasicTransferable.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = BasicTransferable.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(string);
            }
        } else if (this.isStringFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public BasicTransferable(String string, String string2) {
        this.plainData = string;
        this.htmlData = string2;
    }
}

