/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicSliderUI
extends SliderUI {
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected Timer scrollTimer;
    protected JSlider slider;
    protected Insets focusInsets = null;
    protected Insets insetCache = null;
    protected boolean leftToRightCache = true;
    protected Rectangle focusRect = null;
    protected Rectangle contentRect = null;
    protected Rectangle labelRect = null;
    protected Rectangle tickRect = null;
    protected Rectangle trackRect = null;
    protected Rectangle thumbRect = null;
    protected int trackBuffer = 0;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(200, 21);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(21, 200);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
    private transient boolean isDragging;
    protected TrackListener trackListener;
    protected ChangeListener changeListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color shadowColor;
    private Color highlightColor;
    private Color focusColor;
    private static Rectangle unionRect = new Rectangle();

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().height;
        }
        return n2;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().height;
        }
        return n2;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n2 = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n2 = Math.max(component.getPreferredSize().height, n2);
            }
        }
        return n2;
    }

    protected int getTickLength() {
        return 8;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().width;
        }
        return n2;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().width;
        }
        return n2;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n2 = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n2 = Math.max(component.getPreferredSize().width, n2);
            }
        }
        return n2;
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom);
    }

    protected void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - (this.insetCache.left + this.insetCache.right);
        this.focusRect.height = this.slider.getHeight() - (this.insetCache.top + this.insetCache.bottom);
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = BasicGraphicsUtils.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected void calculateThumbLocation() {
        int n2;
        if (this.slider.getSnapToTicks()) {
            int n3 = n2 = this.slider.getValue();
            int n4 = this.slider.getMajorTickSpacing();
            int n5 = this.slider.getMinorTickSpacing();
            int n6 = 0;
            if (n5 > 0) {
                n6 = n5;
            } else if (n4 > 0) {
                n6 = n4;
            }
            if (n6 != 0) {
                if ((n2 - this.slider.getMinimum()) % n6 != 0) {
                    float f2 = (float)(n2 - this.slider.getMinimum()) / (float)n6;
                    int n7 = Math.round(f2);
                    n3 = this.slider.getMinimum() + n7 * n6;
                }
                if (n3 != n2) {
                    this.slider.setValue(n3);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n2 = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n2 - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            n2 = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = n2 - this.thumbRect.height / 2;
        }
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void calculateTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component component = this.getHighestValueLabel();
            Component component2 = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                this.trackBuffer = Math.max(component.getBounds().width, component2.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.width / 2);
            } else {
                this.trackBuffer = Math.max(component.getBounds().height, component2.getBounds().height) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.height / 2);
            }
        } else {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackRect() {
        int n2 = 0;
        if (this.slider.getOrientation() == 0) {
            n2 = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                n2 += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n2 += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - n2 - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height;
        } else {
            n2 = this.thumbRect.width;
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                if (this.slider.getPaintTicks()) {
                    n2 += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n2 += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    n2 -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n2 -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n2 - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.slider.getInsets();
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        boolean bl2 = BasicGraphicsUtils.isLeftToRight(this.slider);
        if (bl2 != this.leftToRightCache) {
            this.leftToRightCache = bl2;
            this.calculateGeometry();
        }
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    public int valueForXPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.width;
        int n7 = this.trackRect.x;
        int n8 = this.trackRect.x + (this.trackRect.width - 1);
        if (n2 <= n7) {
            n3 = this.drawInverted() ? n5 : n4;
        } else if (n2 >= n8) {
            n3 = this.drawInverted() ? n4 : n5;
        } else {
            int n9 = n2 - n7;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n6;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n5 - n10 : n4 + n10;
        }
        return n3;
    }

    public int valueForYPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.height;
        int n7 = this.trackRect.y;
        int n8 = this.trackRect.y + (this.trackRect.height - 1);
        if (n2 <= n7) {
            n3 = this.drawInverted() ? n4 : n5;
        } else if (n2 >= n8) {
            n3 = this.drawInverted() ? n5 : n4;
        } else {
            int n9 = n2 - n7;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n6;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n4 + n10 : n5 - n10;
        }
        return n3;
    }

    protected int xPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.width;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n6 / d2;
        int n7 = this.trackRect.x;
        int n8 = this.trackRect.x + (this.trackRect.width - 1);
        if (!this.drawInverted()) {
            n3 = n7;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        } else {
            n3 = n8;
            n3 = (int)((long)n3 - Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n7, n3);
        n3 = Math.min(n8, n3);
        return n3;
    }

    protected int yPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.height;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n6 / d2;
        int n7 = this.trackRect.y;
        int n8 = this.trackRect.y + (this.trackRect.height - 1);
        if (!this.drawInverted()) {
            n3 = n7;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n5 - (double)n2)));
        } else {
            n3 = n7;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n7, n3);
        n3 = Math.min(n8, n3);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n2) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n3 = this.slider.getValue();
            int n4 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n4 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n4 = 1;
            }
            int n5 = n4 * (n2 > 0 ? 1 : -1);
            this.slider.setValue(n3 + n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n2) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n3 = this.slider.getValue();
            int n4 = 1 * (n2 > 0 ? 1 : -1);
            this.slider.setValue(n3 + n4);
        }
    }

    protected void scrollDueToClickInTrack(int n2) {
        this.scrollByBlock(n2);
    }

    public void setThumbLocation(int n2, int n3) {
        unionRect.setBounds(this.thumbRect);
        this.thumbRect.setLocation(n2, n3);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(BasicSliderUI.unionRect.x, BasicSliderUI.unionRect.y, BasicSliderUI.unionRect.width, BasicSliderUI.unionRect.height);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Component getHighestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n3 = (Integer)enumeration.nextElement();
                n2 = Math.max(n3, n2);
            }
            component = (Component)dictionary.get(new Integer(n2));
        }
        return component;
    }

    protected Component getLowestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n3 = (Integer)enumeration.nextElement();
                n2 = Math.min(n3, n2);
            }
            component = (Component)dictionary.get(new Integer(n2));
        }
        return component;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = 20;
            dimension.height = 11;
        } else {
            dimension.width = 11;
            dimension.height = 20;
        }
        return dimension;
    }

    public void paintFocus(Graphics graphics) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
    }

    public void paintLabels(Graphics graphics) {
        Rectangle rectangle = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n2 = this.slider.getMinimum();
            int n3 = this.slider.getMaximum();
            while (enumeration.hasMoreElements()) {
                Integer n4 = (Integer)enumeration.nextElement();
                int n5 = n4;
                if (n5 < n2 || n5 > n3) continue;
                Component component = (Component)dictionary.get(n4);
                if (this.slider.getOrientation() == 0) {
                    graphics.translate(0, rectangle.y);
                    this.paintHorizontalLabel(graphics, n5, component);
                    graphics.translate(0, -rectangle.y);
                    continue;
                }
                int n6 = 0;
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    n6 = rectangle.width - component.getPreferredSize().width;
                }
                graphics.translate(rectangle.x + n6, 0);
                this.paintVerticalLabel(graphics, n5, component);
                graphics.translate(-rectangle.x - n6, 0);
            }
        }
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getBackground());
        } else {
            graphics.setColor(this.slider.getBackground().darker());
        }
        if (!this.slider.getPaintTicks()) {
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(Color.black);
            graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
            graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, 0, 0, n3 - 2);
            graphics.drawLine(1, 0, n2 - 2, 0);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(1, n3 - 2, n2 - 2, n3 - 2);
            graphics.drawLine(n2 - 2, 1, n2 - 2, n3 - 3);
        } else if (this.slider.getOrientation() == 0) {
            int n4 = n2 / 2;
            graphics.fillRect(1, 1, n2 - 3, n3 - 1 - n4);
            Polygon polygon = new Polygon();
            polygon.addPoint(1, n3 - n4);
            polygon.addPoint(n4 - 1, n3 - 1);
            polygon.addPoint(n2 - 2, n3 - 1 - n4);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, 0, n2 - 2, 0);
            graphics.drawLine(0, 1, 0, n3 - 1 - n4);
            graphics.drawLine(0, n3 - n4, n4 - 1, n3 - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 2 - n4);
            graphics.drawLine(n2 - 1, n3 - 1 - n4, n2 - 1 - n4, n3 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n2 - 2, 1, n2 - 2, n3 - 2 - n4);
            graphics.drawLine(n2 - 2, n3 - 1 - n4, n2 - 1 - n4, n3 - 2);
        } else {
            int n5 = n3 / 2;
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                graphics.fillRect(1, 1, n2 - 1 - n5, n3 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n2 - n5 - 1, 0);
                polygon.addPoint(n2 - 1, n5);
                polygon.addPoint(n2 - 1 - n5, n3 - 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.highlightColor);
                graphics.drawLine(0, 0, 0, n3 - 2);
                graphics.drawLine(1, 0, n2 - 1 - n5, 0);
                graphics.drawLine(n2 - n5 - 1, 0, n2 - 1, n5);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n3 - 1, n2 - 2 - n5, n3 - 1);
                graphics.drawLine(n2 - 1 - n5, n3 - 1, n2 - 1, n3 - 1 - n5);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(1, n3 - 2, n2 - 2 - n5, n3 - 2);
                graphics.drawLine(n2 - 1 - n5, n3 - 2, n2 - 2, n3 - n5 - 1);
            } else {
                graphics.fillRect(5, 1, n2 - 1 - n5, n3 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n5, 0);
                polygon.addPoint(0, n5);
                polygon.addPoint(n5, n3 - 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.highlightColor);
                graphics.drawLine(n5 - 1, 0, n2 - 2, 0);
                graphics.drawLine(0, n5, n5, 0);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n3 - 1 - n5, n5, n3 - 1);
                graphics.drawLine(n5, n3 - 1, n2 - 1, n3 - 1);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(n5, n3 - 2, n2 - 2, n3 - 2);
                graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 2);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n4 = this.slider.getMajorTickSpacing();
        int n5 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            graphics.translate(0, rectangle.y);
            int n6 = this.slider.getMinimum();
            int n7 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                while (n6 <= this.slider.getMaximum()) {
                    n7 = this.xPositionForValue(n6);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n7);
                    n6 += this.slider.getMinorTickSpacing();
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n6 = this.slider.getMinimum();
                while (n6 <= this.slider.getMaximum()) {
                    n7 = this.xPositionForValue(n6);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n7);
                    n6 += this.slider.getMajorTickSpacing();
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n8 = this.slider.getMinimum();
            int n9 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n10 = 0;
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    n10 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n10, 0);
                }
                while (n8 <= this.slider.getMaximum()) {
                    n9 = this.yPositionForValue(n8);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n9);
                    n8 += this.slider.getMinorTickSpacing();
                }
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(-n10, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n8 = this.slider.getMinimum();
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n8 <= this.slider.getMaximum()) {
                    n9 = this.yPositionForValue(n8);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n9);
                    n8 += this.slider.getMajorTickSpacing();
                }
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n2;
            int n3 = n2 = this.trackBuffer;
            int n4 = rectangle.height / 2 - 2;
            int n5 = rectangle.width;
            graphics.translate(rectangle.x, rectangle.y + n4);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, n5 - 1, 0);
            graphics.drawLine(0, 1, 0, 2);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(0, 3, n5, 3);
            graphics.drawLine(n5, 0, n5, 3);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, n5 - 2, 1);
            graphics.translate(-rectangle.x, -(rectangle.y + n4));
        } else {
            int n6 = this.trackBuffer;
            int n7 = rectangle.width / 2 - 2;
            int n8 = n6;
            int n9 = rectangle.height;
            graphics.translate(rectangle.x + n7, rectangle.y);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, 0, n9 - 1);
            graphics.drawLine(1, 0, 2, 0);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(3, 0, 3, n9);
            graphics.drawLine(0, n9, 3, n9);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, 1, n9 - 2);
            graphics.translate(-(rectangle.x + n7), -rectangle.y);
        }
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        actionMapUIResource.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        actionMapUIResource.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        actionMapUIResource.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        actionMapUIResource.put("minScroll", new SharedActionScroller(-2, true));
        actionMapUIResource.put("maxScroll", new SharedActionScroller(2, true));
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Slider.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Slider.actionMap", actionMap);
        }
        return actionMap;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("Slider.focusInputMap");
            if (this.slider.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("Slider.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JSlider)jComponent;
        this.slider.setEnabled(this.slider.isEnabled());
        this.slider.setOpaque(true);
        this.isDragging = false;
        this.trackListener = this.createTrackListener(this.slider);
        this.changeListener = this.createChangeListener(this.slider);
        this.componentListener = this.createComponentListener(this.slider);
        this.focusListener = this.createFocusListener(this.slider);
        this.scrollListener = this.createScrollListener(this.slider);
        this.propertyChangeListener = this.createPropertyChangeListener(this.slider);
        this.installDefaults(this.slider);
        this.installListeners(this.slider);
        this.installKeyboardActions(this.slider);
        this.scrollTimer = new Timer(100, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        this.insetCache = this.slider.getInsets();
        this.leftToRightCache = BasicGraphicsUtils.isLeftToRight(this.slider);
        this.focusRect = new Rectangle();
        this.contentRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle();
        this.calculateGeometry();
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.slider) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this.slider + ".");
        }
        LookAndFeel.uninstallBorder(this.slider);
        this.scrollTimer.stop();
        this.scrollTimer = null;
        this.uninstallListeners(this.slider);
        this.uninstallKeyboardActions(this.slider);
        this.focusInsets = null;
        this.insetCache = null;
        this.leftToRightCache = true;
        this.focusRect = null;
        this.contentRect = null;
        this.labelRect = null;
        this.tickRect = null;
        this.trackRect = null;
        this.thumbRect = null;
        this.trackListener = null;
        this.changeListener = null;
        this.componentListener = null;
        this.focusListener = null;
        this.scrollListener = null;
        this.propertyChangeListener = null;
        this.slider = null;
    }

    public BasicSliderUI(JSlider jSlider) {
    }

    protected void installDefaults(JSlider jSlider) {
        LookAndFeel.installBorder(jSlider, "Slider.border");
        LookAndFeel.installColors(jSlider, "Slider.background", "Slider.foreground");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
    }

    protected void installKeyboardActions(JSlider jSlider) {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(jSlider, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jSlider, actionMap);
    }

    protected void installListeners(JSlider jSlider) {
        jSlider.addMouseListener(this.trackListener);
        jSlider.addMouseMotionListener(this.trackListener);
        jSlider.addFocusListener(this.focusListener);
        jSlider.addComponentListener(this.componentListener);
        jSlider.addPropertyChangeListener(this.propertyChangeListener);
        jSlider.getModel().addChangeListener(this.changeListener);
    }

    protected void uninstallKeyboardActions(JSlider jSlider) {
        SwingUtilities.replaceUIActionMap(jSlider, null);
        SwingUtilities.replaceUIInputMap(jSlider, 0, null);
    }

    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removeMouseListener(this.trackListener);
        jSlider.removeMouseMotionListener(this.trackListener);
        jSlider.removeFocusListener(this.focusListener);
        jSlider.removeComponentListener(this.componentListener);
        jSlider.removePropertyChangeListener(this.propertyChangeListener);
        jSlider.getModel().removeChangeListener(this.changeListener);
    }

    static boolean access$000(BasicSliderUI basicSliderUI) {
        return basicSliderUI.isDragging;
    }

    static boolean access$002(BasicSliderUI basicSliderUI, boolean bl2) {
        basicSliderUI.isDragging = bl2;
        return basicSliderUI.isDragging;
    }

    protected void paintHorizontalLabel(Graphics graphics, int n2, Component component) {
        int n3 = this.xPositionForValue(n2);
        int n4 = n3 - component.getPreferredSize().width / 2;
        graphics.translate(n4, 0);
        component.paint(graphics);
        graphics.translate(-n4, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n2, Component component) {
        int n3 = this.yPositionForValue(n2);
        int n4 = n3 - component.getPreferredSize().height / 2;
        graphics.translate(0, n4);
        component.paint(graphics);
        graphics.translate(0, -n4);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 1) {
            dimension.height = Short.MAX_VALUE;
        } else {
            dimension.width = Short.MAX_VALUE;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getMinimumVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            dimension = new Dimension(this.getMinimumHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getPreferredVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return dimension;
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(n2, 0, n2, rectangle.height - 2);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(0, n2, rectangle.width - 2, n2);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(n2, 0, n2, rectangle.height / 2 - 1);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(0, n2, rectangle.width / 2 - 1, n2);
    }

    protected ComponentListener createComponentListener(JSlider jSlider) {
        return new ComponentHandler(this);
    }

    protected FocusListener createFocusListener(JSlider jSlider) {
        return new FocusHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new PropertyChangeHandler(this);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (!rectangle.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.slider.hasFocus() && rectangle.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
    }

    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSliderUI((JSlider)jComponent);
    }

    protected ScrollListener createScrollListener(JSlider jSlider) {
        return new ScrollListener(this);
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener(this);
    }

    public class ActionScroller
    extends AbstractAction {
        int dir;
        boolean block;
        JSlider slider;
        private final BasicSliderUI this$0;

        public boolean isEnabled() {
            boolean bl2 = true;
            if (this.slider != null) {
                bl2 = this.slider.isEnabled();
            }
            return bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dir == -1 || this.dir == 1) {
                int n2 = this.dir;
                if (this.this$0.drawInverted()) {
                    int n3 = n2 = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    this.this$0.scrollByBlock(n2);
                } else {
                    this.this$0.scrollByUnit(n2);
                }
            } else if (this.this$0.drawInverted()) {
                if (this.dir == -2) {
                    this.slider.setValue(this.slider.getMaximum());
                } else if (this.dir == 2) {
                    this.slider.setValue(this.slider.getMinimum());
                }
            } else if (this.dir == -2) {
                this.slider.setValue(this.slider.getMinimum());
            } else if (this.dir == 2) {
                this.slider.setValue(this.slider.getMaximum());
            }
        }

        public ActionScroller(BasicSliderUI basicSliderUI, JSlider jSlider, int n2, boolean bl2) {
            this.this$0 = basicSliderUI;
            this.dir = n2;
            this.block = bl2;
            this.slider = jSlider;
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        private final BasicSliderUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            if (!BasicSliderUI.access$000(this.this$0)) {
                this.this$0.calculateThumbLocation();
                this.this$0.slider.repaint();
            }
        }

        public ChangeHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        private final BasicSliderUI this$0;

        public void componentResized(ComponentEvent componentEvent) {
            this.this$0.calculateGeometry();
            this.this$0.slider.repaint();
        }

        public ComponentHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class FocusHandler
    implements FocusListener {
        private final BasicSliderUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            this.this$0.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.this$0.slider.repaint();
        }

        public FocusHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private final BasicSliderUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation") || string.equals("inverted") || string.equals("labelTable") || string.equals("majorTickSpacing") || string.equals("minorTickSpacing") || string.equals("paintTicks") || string.equals("paintTrack") || string.equals("paintLabels")) {
                this.this$0.calculateGeometry();
                this.this$0.slider.repaint();
            } else if (string.equals("componentOrientation")) {
                this.this$0.calculateGeometry();
                this.this$0.slider.repaint();
                InputMap inputMap = this.this$0.getInputMap(0);
                SwingUtilities.replaceUIInputMap(this.this$0.slider, 0, inputMap);
            } else if (string.equals("model")) {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(this.this$0.changeListener);
                ((BoundedRangeModel)propertyChangeEvent.getNewValue()).addChangeListener(this.this$0.changeListener);
                this.this$0.calculateThumbLocation();
                this.this$0.slider.repaint();
            }
        }

        public PropertyChangeHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class ScrollListener
    implements ActionListener {
        int direction;
        boolean useBlockIncrement;
        private final BasicSliderUI this$0;

        public void setDirection(int n2) {
            this.direction = n2;
        }

        public void setScrollByBlock(boolean bl2) {
            this.useBlockIncrement = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                this.this$0.scrollByBlock(this.direction);
            } else {
                this.this$0.scrollByUnit(this.direction);
            }
            if (!this.this$0.trackListener.shouldScroll(this.direction)) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }

        public ScrollListener(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
            this.direction = 1;
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(BasicSliderUI basicSliderUI, int n2, boolean bl2) {
            this.this$0 = basicSliderUI;
            this.direction = 1;
            this.direction = n2;
            this.useBlockIncrement = bl2;
        }
    }

    static class SharedActionScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public SharedActionScroller(int n2, boolean bl2) {
            this.dir = n2;
            this.block = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSlider jSlider = (JSlider)actionEvent.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int n2 = this.dir;
                BasicSliderUI basicSliderUI = (BasicSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    int n3 = n2 = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    basicSliderUI.scrollByBlock(n2);
                } else {
                    basicSliderUI.scrollByUnit(n2);
                }
            } else if (jSlider.getInverted()) {
                if (this.dir == -2) {
                    jSlider.setValue(jSlider.getMaximum());
                } else if (this.dir == 2) {
                    jSlider.setValue(jSlider.getMinimum());
                }
            } else if (this.dir == -2) {
                jSlider.setValue(jSlider.getMinimum());
            } else if (this.dir == 2) {
                jSlider.setValue(jSlider.getMaximum());
            }
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private final BasicSliderUI this$0;

        public boolean shouldScroll(int n2) {
            Rectangle rectangle = this.this$0.thumbRect;
            if (this.this$0.slider.getOrientation() == 1 ? ((this.this$0.drawInverted() ? n2 < 0 : n2 > 0) ? rectangle.y + rectangle.height <= this.currentMouseY : rectangle.y >= this.currentMouseY) : ((this.this$0.drawInverted() ? n2 < 0 : n2 > 0) ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX)) {
                return false;
            }
            if (n2 > 0 && this.this$0.slider.getValue() + this.this$0.slider.getExtent() >= this.this$0.slider.getMaximum()) {
                return false;
            }
            return n2 >= 0 || this.this$0.slider.getValue() > this.this$0.slider.getMinimum();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n2 = 0;
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!BasicSliderUI.access$000(this.this$0)) {
                return;
            }
            this.this$0.slider.setValueIsAdjusting(true);
            switch (this.this$0.slider.getOrientation()) {
                case 1: {
                    int n3 = this.this$0.thumbRect.height / 2;
                    int n4 = mouseEvent.getY() - this.offset;
                    int n5 = this.this$0.trackRect.y;
                    int n6 = this.this$0.trackRect.y + (this.this$0.trackRect.height - 1);
                    int n7 = this.this$0.yPositionForValue(this.this$0.slider.getMaximum() - this.this$0.slider.getExtent());
                    if (this.this$0.drawInverted()) {
                        n6 = n7;
                    } else {
                        n5 = n7;
                    }
                    n4 = Math.max(n4, n5 - n3);
                    n4 = Math.min(n4, n6 - n3);
                    this.this$0.setThumbLocation(this.this$0.thumbRect.x, n4);
                    n2 = n4 + n3;
                    this.this$0.slider.setValue(this.this$0.valueForYPosition(n2));
                    break;
                }
                case 0: {
                    int n8 = this.this$0.thumbRect.width / 2;
                    int n9 = mouseEvent.getX() - this.offset;
                    int n10 = this.this$0.trackRect.x;
                    int n11 = this.this$0.trackRect.x + (this.this$0.trackRect.width - 1);
                    int n12 = this.this$0.xPositionForValue(this.this$0.slider.getMaximum() - this.this$0.slider.getExtent());
                    if (this.this$0.drawInverted()) {
                        n10 = n12;
                    } else {
                        n11 = n12;
                    }
                    n9 = Math.max(n9, n10 - n8);
                    n9 = Math.min(n9, n11 - n8);
                    this.this$0.setThumbLocation(n9, this.this$0.thumbRect.y);
                    n2 = n9 + n8;
                    this.this$0.slider.setValue(this.this$0.valueForXPosition(n2));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.this$0.slider.isRequestFocusEnabled()) {
                this.this$0.slider.requestFocus();
            }
            if (this.this$0.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (this.this$0.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - this.this$0.thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - this.this$0.thumbRect.x;
                    }
                }
                BasicSliderUI.access$002(this.this$0, true);
                return;
            }
            BasicSliderUI.access$002(this.this$0, false);
            this.this$0.slider.setValueIsAdjusting(true);
            Dimension dimension = this.this$0.slider.getSize();
            int n2 = 1;
            switch (this.this$0.slider.getOrientation()) {
                case 1: {
                    int n3;
                    if (this.this$0.thumbRect.isEmpty()) {
                        n3 = dimension.height / 2;
                        if (!this.this$0.drawInverted()) {
                            n2 = this.currentMouseY < n3 ? 1 : -1;
                            break;
                        }
                        n2 = this.currentMouseY < n3 ? -1 : 1;
                        break;
                    }
                    n3 = this.this$0.thumbRect.y;
                    if (!this.this$0.drawInverted()) {
                        n2 = this.currentMouseY < n3 ? 1 : -1;
                        break;
                    }
                    n2 = this.currentMouseY < n3 ? -1 : 1;
                    break;
                }
                case 0: {
                    int n3;
                    if (this.this$0.thumbRect.isEmpty()) {
                        n3 = dimension.width / 2;
                        if (!this.this$0.drawInverted()) {
                            n2 = this.currentMouseX < n3 ? -1 : 1;
                            break;
                        }
                        n2 = this.currentMouseX < n3 ? 1 : -1;
                        break;
                    }
                    n3 = this.this$0.thumbRect.x;
                    n2 = !this.this$0.drawInverted() ? (this.currentMouseX < n3 ? -1 : 1) : (this.currentMouseX < n3 ? 1 : -1);
                }
            }
            this.this$0.scrollDueToClickInTrack(n2);
            Rectangle rectangle = this.this$0.thumbRect;
            if (!rectangle.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(n2)) {
                this.this$0.scrollTimer.stop();
                this.this$0.scrollListener.setDirection(n2);
                this.this$0.scrollTimer.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            this.this$0.scrollTimer.stop();
            if (this.this$0.slider.getSnapToTicks()) {
                BasicSliderUI.access$002(this.this$0, false);
                this.this$0.slider.setValueIsAdjusting(false);
            } else {
                this.this$0.slider.setValueIsAdjusting(false);
                BasicSliderUI.access$002(this.this$0, false);
            }
            this.this$0.slider.repaint();
        }

        public TrackListener(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }
}

