/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicProgressBarUI
extends ProgressBarUI {
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean isIndeterminate = false;
    private Animator animator;
    private PropertyChangeListener propertyListener;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;
    private int animationIndex = 0;
    private int numFrames;
    private int repaintInterval;
    private int cycleTime;
    private static boolean ADJUSTTIMER = true;
    private static boolean DEBUGALL = false;
    private static boolean DEBUGTIMER = false;
    private static boolean BASICDEBUG = false;
    private static boolean LOGSTATS = false;
    private long startTime = 0L;
    private long lastLoopTime = 0L;
    private int numLoops = 0;
    private Rectangle boxRect;
    private Rectangle nextPaintRect;
    private Rectangle componentInnards;
    private Rectangle oldComponentInnards;
    private double delta = 0.0;
    private int maxPosition = 0;

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    private int getCachedPercent() {
        return this.cachedPercent;
    }

    protected int getCellLength() {
        if (this.progressBar.isStringPainted()) {
            return 1;
        }
        return this.cellLength;
    }

    protected int getCellSpacing() {
        if (this.progressBar.isStringPainted()) {
            return 0;
        }
        return this.cellSpacing;
    }

    private int getCycleTime() {
        return this.cycleTime;
    }

    private int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initCycleTime() {
        this.cycleTime = UIManager.getInt("ProgressBar.cycleTime");
        if (BASICDEBUG) {
            System.out.println("    value of ProgressBar.cycleTime is " + this.cycleTime);
        }
        return this.cycleTime;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIManager.getInt("ProgressBar.repaintInterval");
        if (BASICDEBUG) {
            System.out.println("    value of ProgressBar.repaintInterval is " + this.repaintInterval);
        }
        return this.repaintInterval;
    }

    private void cleanUpIndeterminateValues() {
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin cleanUpIndeterminateValues----");
        }
        this.repaintInterval = 0;
        this.cycleTime = 0;
        this.animationIndex = 0;
        this.numFrames = 0;
        this.maxPosition = 0;
        this.delta = 0.0;
        this.nextPaintRect = null;
        this.boxRect = null;
        this.oldComponentInnards = null;
        this.componentInnards = null;
        if (LOGSTATS) {
            this.numLoops = 0;
            this.startTime = this.lastLoopTime = (long)0;
        }
        if (DEBUGALL) {
            System.out.println("----end cleanUpIndeterminateValues----");
        }
    }

    protected void incrementAnimationIndex() {
        int n2 = this.getAnimationIndex() + 1;
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin incrementAnimationIndex----");
            System.out.println("    newValue = " + n2);
            System.out.println("    numFrames = " + this.numFrames);
        }
        if (n2 < this.numFrames) {
            this.setAnimationIndex(n2);
        } else {
            this.setAnimationIndex(0);
            if (LOGSTATS) {
                ++this.numLoops;
                long l2 = System.currentTimeMillis();
                System.out.println("Loop #" + this.numLoops + ": " + (l2 - this.lastLoopTime) + " (" + (l2 - this.startTime) + " total)");
                this.lastLoopTime = l2;
            }
        }
        if (DEBUGALL) {
            System.out.println("----end incrementAnimationIndex----");
        }
    }

    private void initAnimationIndex() {
        if (this.progressBar.getOrientation() == 0 && BasicGraphicsUtils.isLeftToRight(this.progressBar)) {
            this.setAnimationIndex(0);
        } else {
            this.setAnimationIndex(this.numFrames / 2);
        }
    }

    private void initIndeterminateDefaults() {
        if (DEBUGALL) {
            System.out.println("----begin initIndeterminateDefaults----");
        }
        this.initRepaintInterval();
        this.initCycleTime();
        if (this.repaintInterval <= 0) {
            this.repaintInterval = 100;
        }
        if (this.repaintInterval > this.cycleTime) {
            this.cycleTime = this.repaintInterval * 20;
            if (DEBUGALL) {
                System.out.println("cycleTime changed to " + this.cycleTime);
            }
        } else {
            int n2;
            int n3 = (int)Math.ceil((double)this.cycleTime / ((double)this.repaintInterval * 2.0));
            if (DEBUGALL && this.cycleTime != (n2 = this.repaintInterval * n3 * 2)) {
                System.out.println("cycleTime being changed to " + n2);
            }
            this.cycleTime = this.repaintInterval * n3 * 2;
        }
        if (BASICDEBUG) {
            System.out.println("    cycle length: " + this.cycleTime);
            System.out.println("    repaint interval: " + this.repaintInterval);
        }
        if (DEBUGALL) {
            System.out.println("----end initIndeterminateDefaults----");
        }
    }

    private void initIndeterminateValues() {
        if (DEBUGALL) {
            System.out.println();
            System.out.println("----begin initIndeterminateValues----");
        }
        if (LOGSTATS) {
            this.startTime = this.lastLoopTime = System.currentTimeMillis();
            this.numLoops = 0;
        }
        if (BASICDEBUG) {
            System.out.println("ADJUSTTIMER = " + ADJUSTTIMER);
        }
        this.initIndeterminateDefaults();
        this.numFrames = this.cycleTime / this.repaintInterval;
        this.initAnimationIndex();
        this.boxRect = new Rectangle();
        this.nextPaintRect = new Rectangle();
        this.componentInnards = new Rectangle();
        this.oldComponentInnards = new Rectangle();
        if (BASICDEBUG) {
            System.out.println("    numFrames: " + this.numFrames);
        }
        if (DEBUGALL) {
            System.out.println("----end initIndeterminateValues----");
        }
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(true);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler(this);
        this.progressBar.addChangeListener(this.changeListener);
        this.propertyListener = new PropertyChangeHandler(this, null);
        this.progressBar.addPropertyChangeListener(this.propertyListener);
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator(this, null);
        }
        Animator.access$200(this.animator, this.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            Animator.access$300(this.animator);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.propertyListener);
    }

    private void updateSizes() {
        if (DEBUGALL) {
            System.out.println("----begin updateSizes----");
        }
        int n2 = 0;
        if (this.progressBar.getOrientation() == 0) {
            n2 = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            this.maxPosition = this.componentInnards.x + this.componentInnards.width - n2;
        } else {
            n2 = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            this.maxPosition = this.componentInnards.y + this.componentInnards.height - n2;
        }
        if (DEBUGALL) {
            System.out.println("    Updating delta.");
        }
        this.delta = 2.0 * (double)this.maxPosition / (double)this.numFrames;
        if (BASICDEBUG) {
            System.out.println("    delta: " + this.delta);
            System.out.println("    maxPosition: " + this.maxPosition);
        }
        if (DEBUGALL) {
            System.out.println("----end updateSizes----");
        }
    }

    static boolean access$400() {
        return ADJUSTTIMER;
    }

    static boolean access$600() {
        return DEBUGTIMER;
    }

    private boolean sizeChanged() {
        if (this.oldComponentInnards == null || this.componentInnards == null) {
            return true;
        }
        this.oldComponentInnards.setRect(this.componentInnards);
        this.componentInnards = SwingUtilities.calculateInnerArea(this.progressBar, this.componentInnards);
        return !this.oldComponentInnards.equals(this.componentInnards);
    }

    protected void setAnimationIndex(int n2) {
        if (DEBUGALL) {
            System.out.println("----begin setAnimationIndex----");
            System.out.println("    argument = " + n2);
        }
        if (this.animationIndex != n2) {
            if (DEBUGALL) {
                System.out.println("    Changing animation index from " + this.animationIndex + " to " + n2);
            }
            if (this.sizeChanged()) {
                if (DEBUGALL) {
                    System.out.println("    size changed; resetting maxPosition, delta");
                }
                this.animationIndex = n2;
                this.maxPosition = 0;
                this.delta = 0.0;
                this.progressBar.repaint();
                return;
            }
            this.nextPaintRect = this.getBox(this.nextPaintRect);
            if (DEBUGALL) {
                System.out.println("    previous paint rect =  " + this.nextPaintRect);
                System.out.println("    before setting, boxRect =  " + this.boxRect);
            }
            this.animationIndex = n2;
            if (this.nextPaintRect != null) {
                this.boxRect = this.getBox(this.boxRect);
                if (this.boxRect != null) {
                    this.nextPaintRect.add(this.boxRect);
                }
            }
            if (DEBUGALL) {
                System.out.println("    after setting, boxRect =  " + this.boxRect);
                System.out.println("    after setting, nextPaintRect =  " + this.nextPaintRect);
            }
        } else {
            if (DEBUGALL) {
                System.out.println("    No change in value");
                System.out.println("----end setAnimationIndex----");
            }
            return;
        }
        if (this.nextPaintRect != null) {
            this.progressBar.repaint(this.nextPaintRect);
        } else {
            this.progressBar.repaint();
            if (DEBUGALL) {
                System.out.println("    repaint without args");
            }
        }
        if (DEBUGALL) {
            System.out.println("----end setAnimationIndex----");
        }
    }

    private void setCachedPercent(int n2) {
        this.cachedPercent = n2;
    }

    protected void setCellLength(int n2) {
        this.cellLength = n2;
    }

    protected void setCellSpacing(int n2) {
        this.cellSpacing = n2;
    }

    private int getBoxLength(int n2, int n3) {
        return (int)Math.round((double)n2 / 6.0);
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    protected int getAmountFull(Insets insets, int n2, int n3) {
        int n4 = 0;
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        if (boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() != 0) {
            n4 = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)n2 * this.progressBar.getPercentComplete()) : (int)Math.round((double)n3 * this.progressBar.getPercentComplete());
        }
        return n4;
    }

    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    static int access$1000(BasicProgressBarUI basicProgressBarUI) {
        return basicProgressBarUI.getCachedPercent();
    }

    static int access$500(BasicProgressBarUI basicProgressBarUI) {
        return basicProgressBarUI.getRepaintInterval();
    }

    static void access$800(BasicProgressBarUI basicProgressBarUI) {
        basicProgressBarUI.initIndeterminateValues();
    }

    static void access$900(BasicProgressBarUI basicProgressBarUI) {
        basicProgressBarUI.cleanUpIndeterminateValues();
    }

    static boolean access$700(BasicProgressBarUI basicProgressBarUI) {
        return basicProgressBarUI.isIndeterminate;
    }

    static void access$1100(BasicProgressBarUI basicProgressBarUI, int n2) {
        basicProgressBarUI.setCachedPercent(n2);
    }

    static boolean access$702(BasicProgressBarUI basicProgressBarUI, boolean bl2) {
        basicProgressBarUI.isIndeterminate = bl2;
        return basicProgressBarUI.isIndeterminate;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                int n2;
                String string = this.progressBar.getString();
                int n3 = fontMetrics.stringWidth(string);
                if (n3 > dimension.width) {
                    dimension.width = n3;
                }
                if ((n2 = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n2;
                }
            }
        } else {
            dimension = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                int n4;
                String string = this.progressBar.getString();
                int n5 = fontMetrics.getHeight() + fontMetrics.getDescent();
                if (n5 > dimension.width) {
                    dimension.width = n5;
                }
                if ((n4 = fontMetrics.stringWidth(string)) > dimension.height) {
                    dimension.height = n4;
                }
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(this.getSelectionBackground());
            graphics2D.drawString(string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n6, n3, n7, n5);
            graphics.drawString(string, point.x, point.y);
        } else {
            graphics2D.setColor(this.getSelectionBackground());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics2D.setFont(this.progressBar.getFont().deriveFont(affineTransform));
            point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
            graphics2D.drawString(string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n2, n6, n4, n7);
            graphics2D.drawString(string, point.x, point.y);
        }
        graphics2D.setClip(rectangle);
    }

    protected void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        if (this.progressBar.getOrientation() == 0) {
            if (BasicGraphicsUtils.isLeftToRight(this.progressBar)) {
                this.paintString(graphics, n2, n3, n4, n5, n2, n6, insets);
            } else {
                this.paintString(graphics, n2, n3, n4, n5, n2 + n4 - n6, n6, insets);
            }
        } else {
            this.paintString(graphics, n2, n3, n4, n5, n3 + n5 - n6, n6, insets);
        }
    }

    protected Rectangle getBox(Rectangle rectangle) {
        int n2 = this.getAnimationIndex();
        int n3 = this.numFrames / 2;
        if (DEBUGALL) {
            System.out.println("----begin getBox----");
            System.out.println("    getBox argument: " + rectangle);
            System.out.println("    currentFrame = " + n2);
            System.out.println("    middleFrame = " + n3);
        }
        if (this.sizeChanged() || this.delta == 0.0 || (double)this.maxPosition == 0.0) {
            this.updateSizes();
        }
        if ((rectangle = this.getGenericBox(rectangle)) == null) {
            if (DEBUGALL) {
                System.out.println("    Exiting because r is null");
            }
            return null;
        }
        if (n3 <= 0) {
            if (DEBUGALL) {
                System.out.println("    Exiting because middleFrame <= 0.");
            }
            return null;
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.x = n2 < n3 ? this.componentInnards.x + (int)Math.round(this.delta * (double)n2) : this.maxPosition - (int)Math.round(this.delta * (double)(n2 - n3));
        } else {
            rectangle.y = n2 < n3 ? this.componentInnards.y + (int)Math.round(this.delta * (double)n2) : this.maxPosition - (int)Math.round(this.delta * (double)(n2 - n3));
        }
        if (DEBUGALL) {
            System.out.println("    getBox return value: " + rectangle);
            System.out.println("----end getBox----");
        }
        return rectangle;
    }

    private Rectangle getGenericBox(Rectangle rectangle) {
        if (DEBUGALL) {
            System.out.println("----begin getGenericBox----");
            System.out.println("    argument: " + rectangle);
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.width = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            if (rectangle.width < 0) {
                rectangle = null;
            } else {
                rectangle.height = this.componentInnards.height;
                rectangle.y = this.componentInnards.y;
            }
        } else {
            rectangle.height = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            if (rectangle.height < 0) {
                rectangle = null;
            } else {
                rectangle.width = this.componentInnards.width;
                rectangle.x = this.componentInnards.x;
            }
        }
        if (DEBUGALL) {
            System.out.println("    getGenericBox returns: " + rectangle);
            System.out.println("----end getGenericBox----");
        }
        return rectangle;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.isIndeterminate) {
            this.paintIndeterminate(graphics, jComponent);
        } else {
            this.paintDeterminate(graphics, jComponent);
        }
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n4 = this.getCellLength();
        int n5 = this.getCellSpacing();
        int n6 = this.getAmountFull(insets, n2, n3);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            if (n5 == 0 && n6 > 0) {
                graphics2D.setStroke(new BasicStroke(n3, 0, 2));
            } else {
                graphics2D.setStroke(new BasicStroke(n3, 0, 2, 0.0f, new float[]{n4, n5}, 0.0f));
            }
            if (BasicGraphicsUtils.isLeftToRight(jComponent)) {
                graphics2D.drawLine(insets.left, n3 / 2 + insets.top, n6 + insets.left, n3 / 2 + insets.top);
            } else {
                graphics2D.drawLine(n2 + insets.left, n3 / 2 + insets.top, n2 + insets.left - n6, n3 / 2 + insets.top);
            }
        } else {
            if (n5 == 0 && n6 > 0) {
                graphics2D.setStroke(new BasicStroke(n2, 0, 2));
            } else {
                graphics2D.setStroke(new BasicStroke(n2, 0, 2, 0.0f, new float[]{n4, n5}, 0.0f));
            }
            graphics2D.drawLine(n2 / 2 + insets.left, insets.top + n3, n2 / 2 + insets.left, insets.top + n3 - n6);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, insets.left, insets.top, n2, n3, n6, insets);
        }
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (DEBUGALL) {
            System.out.println();
            System.out.println("basic: paintIndeterminate");
        }
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            graphics2D.setColor(this.progressBar.getForeground());
            graphics2D.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        } else if (DEBUGALL) {
            System.out.println("boxRect == null; returning");
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.x, this.boxRect.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.y, this.boxRect.height, insets);
            }
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int n6 = fontMetrics.stringWidth(string);
        if (this.progressBar.getOrientation() == 0) {
            return new Point(n2 + Math.round(n4 / 2 - n6 / 2), n3 + (n5 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2);
        }
        return new Point(n2 + (n4 - fontMetrics.getAscent() + fontMetrics.getLeading() + fontMetrics.getDescent()) / 2, n3 + Math.round(n5 / 2 - n6 / 2));
    }

    class 1 {
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private long previousDelay;
        private int interval;
        private long lastCall;
        private int MINIMUM_DELAY;
        private final BasicProgressBarUI this$0;

        private void stop() {
            this.timer.stop();
        }

        private void start(int n2) {
            this.previousDelay = n2;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(n2, this);
            } else {
                this.timer.setDelay(n2);
            }
            if (BasicProgressBarUI.access$400()) {
                this.timer.setRepeats(false);
                this.timer.setCoalesce(false);
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicProgressBarUI.access$400()) {
                long l2 = System.currentTimeMillis();
                if (this.lastCall > 0L) {
                    int n2 = (int)(this.previousDelay - l2 + this.lastCall + (long)BasicProgressBarUI.access$500(this.this$0));
                    if (n2 < this.MINIMUM_DELAY) {
                        n2 = this.MINIMUM_DELAY;
                    }
                    this.timer.setInitialDelay(n2);
                    this.previousDelay = n2;
                    if (BasicProgressBarUI.access$600()) {
                        System.out.println("---------------------");
                        System.out.println("actual delay = " + (l2 - this.lastCall));
                        System.out.println("next delay = " + n2);
                    }
                }
                this.timer.start();
                this.lastCall = l2;
            }
            this.this$0.incrementAnimationIndex();
        }

        private Animator(BasicProgressBarUI basicProgressBarUI) {
            this.this$0 = basicProgressBarUI;
            this.MINIMUM_DELAY = 5;
        }

        static void access$300(Animator animator) {
            animator.stop();
        }

        static void access$200(Animator animator, int n2) {
            animator.start(n2);
        }

        Animator(BasicProgressBarUI basicProgressBarUI, 1 var2_2) {
            this(basicProgressBarUI);
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        private final BasicProgressBarUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            BoundedRangeModel boundedRangeModel = this.this$0.progressBar.getModel();
            int n3 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n4 = n3 > 0 ? (int)(100L * (long)boundedRangeModel.getValue() / (long)n3) : 0;
            if (n4 != (n2 = BasicProgressBarUI.access$1000(this.this$0))) {
                BasicProgressBarUI.access$1100(this.this$0, n4);
                this.this$0.progressBar.repaint();
            }
        }

        public ChangeHandler(BasicProgressBarUI basicProgressBarUI) {
            this.this$0 = basicProgressBarUI;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final BasicProgressBarUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("indeterminate".equals(string)) {
                BasicProgressBarUI.access$702(this.this$0, this.this$0.progressBar.isIndeterminate());
                if (BasicProgressBarUI.access$700(this.this$0)) {
                    BasicProgressBarUI.access$800(this.this$0);
                    this.this$0.startAnimationTimer();
                } else {
                    this.this$0.stopAnimationTimer();
                    BasicProgressBarUI.access$900(this.this$0);
                }
                this.this$0.progressBar.repaint();
            }
        }

        private PropertyChangeHandler(BasicProgressBarUI basicProgressBarUI) {
            this.this$0 = basicProgressBarUI;
        }

        PropertyChangeHandler(BasicProgressBarUI basicProgressBarUI, 1 var2_2) {
            this(basicProgressBarUI);
        }
    }
}

