/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu = null;
    static MenuKeyboardHelper menuKeyboardHelper = null;
    private static transient MouseGrabber mouseGrabber = null;
    private transient PopupMenuListener basicPopupMenuListener = null;

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.popupMenu.setOpaque(true);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (this.basicPopupMenuListener == null) {
            this.basicPopupMenuListener = this.createPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.basicPopupMenuListener);
        if (menuKeyboardHelper == null) {
            menuKeyboardHelper = new MenuKeyboardHelper(null);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(menuKeyboardHelper);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    protected void uninstallListeners() {
        if (this.basicPopupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.basicPopupMenuListener);
        }
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    static ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        actionMapUIResource.put("cancel", new CancelAction(null));
        actionMapUIResource.put("selectNext", new SelectNextItemAction(SelectNextItemAction.FORWARD));
        actionMapUIResource.put("selectPrevious", new SelectNextItemAction(SelectNextItemAction.BACKWARD));
        actionMapUIResource.put("selectParent", new SelectParentChildAction(SelectParentChildAction.PARENT));
        actionMapUIResource.put("selectChild", new SelectParentChildAction(SelectParentChildAction.CHILD));
        actionMapUIResource.put("return", new ReturnAction(null));
        return actionMapUIResource;
    }

    static ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap");
        if (actionMap == null && (actionMap = BasicPopupMenuUI.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", actionMap);
        }
        return actionMap;
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new BasicPopupMenuListener(this, null);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    static Window access$300(Component component) {
        return BasicPopupMenuUI.getWindow(component);
    }

    private static Window getWindow(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    static boolean access$400(MenuElement menuElement, MenuElement menuElement2) {
        return BasicPopupMenuUI.checkInvokerEqual(menuElement, menuElement2);
    }

    private static boolean checkInvokerEqual(MenuElement menuElement, MenuElement menuElement2) {
        Component component = menuElement.getComponent();
        Component component2 = menuElement2.getComponent();
        if (component instanceof JPopupMenu) {
            component = ((JPopupMenu)component).getInvoker();
        }
        if (component2 instanceof JPopupMenu) {
            component2 = ((JPopupMenu)component2).getInvoker();
        }
        return component == component2;
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n2, int n3) {
        int n4 = n2;
        while (n4 <= n3) {
            Component component;
            if (menuElementArray[n4] != null && (component = menuElementArray[n4].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n4];
            }
            ++n4;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n2, int n3) {
        int n4 = n2;
        while (n4 >= n3) {
            Component component;
            if (menuElementArray[n4] != null && (component = menuElementArray[n4].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n4];
            }
            --n4;
        }
        return null;
    }

    static MenuElement access$600(MenuElement[] menuElementArray, int n2, boolean bl2) {
        return BasicPopupMenuUI.findEnabledChild(menuElementArray, n2, bl2);
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, int n2, boolean bl2) {
        MenuElement menuElement = null;
        if (bl2) {
            menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, n2 + 1, menuElementArray.length - 1);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, 0, n2 - 1);
            }
        } else {
            menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, n2 - 1, 0);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n2 + 1);
            }
        }
        return menuElement;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    static InputMap getInputMap(JPopupMenu jPopupMenu, JComponent jComponent) {
        ComponentInputMap componentInputMap = null;
        Object[] objectArray = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (objectArray != null) {
            Object[] objectArray2;
            componentInputMap = LookAndFeel.makeComponentInputMap(jComponent, objectArray);
            if (!jPopupMenu.getComponentOrientation().isLeftToRight() && (objectArray2 = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft")) != null) {
                ComponentInputMap componentInputMap2 = LookAndFeel.makeComponentInputMap(jComponent, objectArray2);
                ((InputMap)componentInputMap2).setParent(componentInputMap);
                componentInputMap = componentInputMap2;
            }
        }
        return componentInputMap;
    }

    static MenuElement access$700(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl2) {
        return BasicPopupMenuUI.findEnabledChild(menuElementArray, menuElement, bl2);
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl2) {
        int n2 = 0;
        while (n2 < menuElementArray.length) {
            if (menuElementArray[n2] == menuElement) {
                return BasicPopupMenuUI.findEnabledChild(menuElementArray, n2, bl2);
            }
            ++n2;
        }
        return null;
    }

    private class BasicPopupMenuListener
    implements PopupMenuListener {
        private final BasicPopupMenuUI this$0;

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Action action;
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            ActionMap actionMap = jPopupMenu.getActionMap();
            if (actionMap != null && (action = actionMap.get("PopupMenu.popupSound")) != null) {
                BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
                basicLookAndFeel.playSound(action);
            }
        }

        private BasicPopupMenuListener(BasicPopupMenuUI basicPopupMenuUI) {
            this.this$0 = basicPopupMenuUI;
        }

        BasicPopupMenuListener(BasicPopupMenuUI basicPopupMenuUI, 1 var2_2) {
            this(basicPopupMenuUI);
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }

        CancelAction(1 var1_1) {
            this();
        }
    }

    private static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = BasicPopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;
        private FocusListener rootPaneFocusListener = new FocusAdapter(this){
            private final MenuKeyboardHelper this$0;

            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    MenuKeyboardHelper.access$802(this.this$0, component);
                }
                focusEvent.getComponent().removeFocusListener(this);
            }
            {
                this.this$0 = menuKeyboardHelper;
            }
        };

        private MenuKeyboardHelper() {
        }

        void removeItems() {
            if (this.lastFocused != null) {
                this.lastFocused.requestFocus();
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(menuKeyboardHelper);
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
            }
            this.receivedKeyPressed = false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu != null && !jPopupMenu.isFocusable()) {
                return;
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !BasicPopupMenuUI.access$400(menuElementArray[0], this.lastPathSelected[0])) {
                this.removeItems();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length > 0) {
                JComponent jComponent;
                if (jPopupMenu == null) {
                    if (menuElementArray.length != 2 || !(menuElementArray[0] instanceof JMenuBar) || !(menuElementArray[1] instanceof JMenu)) return;
                    jComponent = (JComponent)((Object)menuElementArray[1]);
                    jPopupMenu = ((JMenu)jComponent).getPopupMenu();
                } else {
                    Component component = jPopupMenu.getInvoker();
                    while (!(component instanceof JComponent)) {
                        if (component == null) {
                            return;
                        }
                        component = component.getParent();
                    }
                    jComponent = (JComponent)component;
                }
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane(jComponent);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(menuKeyboardHelper);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = BasicPopupMenuUI.getInputMap(jPopupMenu, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.removeItems();
            } else if (jPopupMenu != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = menuElementArray;
            this.lastPopup = jPopupMenu;
        }

        MenuKeyboardHelper(1 var1_1) {
            this();
        }

        void addUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            ActionMap actionMap3 = jComponent.getActionMap();
            while (actionMap3 != null && !(actionMap3 instanceof UIResource)) {
                actionMap2 = actionMap3;
                actionMap3 = actionMap3.getParent();
            }
            if (actionMap2 == null) {
                jComponent.setActionMap(actionMap);
            } else {
                actionMap2.setParent(actionMap);
            }
            actionMap.setParent(actionMap3);
        }

        void removeUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            ActionMap actionMap3 = jComponent.getActionMap();
            while (actionMap3 != null) {
                if (actionMap3 == actionMap) {
                    if (actionMap2 == null) {
                        jComponent.setActionMap(actionMap.getParent());
                        break;
                    }
                    actionMap2.setParent(actionMap.getParent());
                    break;
                }
                actionMap2 = actionMap3;
                actionMap3 = actionMap3.getParent();
            }
        }

        void addUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            InputMap inputMap3 = jComponent.getInputMap(2);
            while (inputMap3 != null && !(inputMap3 instanceof UIResource)) {
                inputMap2 = inputMap3;
                inputMap3 = inputMap3.getParent();
            }
            if (inputMap2 == null) {
                jComponent.setInputMap(2, inputMap);
            } else {
                inputMap2.setParent(inputMap);
            }
            inputMap.setParent(inputMap3);
        }

        void removeUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            InputMap inputMap3 = jComponent.getInputMap(2);
            while (inputMap3 != null) {
                if (inputMap3 == inputMap) {
                    if (inputMap2 == null) {
                        jComponent.setInputMap(2, inputMap.getParent());
                        break;
                    }
                    inputMap2.setParent(inputMap.getParent());
                    break;
                }
                inputMap2 = inputMap3;
                inputMap3 = inputMap3.getParent();
            }
        }

        JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            int n2 = menuElementArray.length - 1;
            while (n2 >= 0) {
                MenuElement menuElement = menuElementArray[n2];
                if (menuElement instanceof JPopupMenu) {
                    return (JPopupMenu)menuElement;
                }
                --n2;
            }
            return null;
        }

        static Component access$802(MenuKeyboardHelper menuKeyboardHelper, Component component) {
            menuKeyboardHelper.lastFocused = component;
            return menuKeyboardHelper.lastFocused;
        }
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    WindowListener,
    ComponentListener,
    ChangeListener {
        Vector grabbed = new Vector();
        MenuElement lastGrabbed = null;
        boolean lastGrabbedMenuBarChild = false;
        MenuElement[] lastPathSelected = new MenuElement[0];

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
        }

        void cancelPopupMenu() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastGrabbed == this.getFirstPopup()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.ungrabContainers();
            } else {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
        }

        private void requestRemoveGrab() {
            this.ungrabContainers();
        }

        void ungrabContainers() {
            int n2 = 0;
            int n3 = this.grabbed.size();
            while (n2 < n3) {
                Component component = (Component)this.grabbed.elementAt(n2);
                if (component instanceof Window) {
                    ((Window)component).removeWindowListener(this);
                    ((Window)component).removeComponentListener(this);
                } else {
                    component.removeMouseListener(this);
                    component.removeMouseMotionListener(this);
                    component.removeMouseWheelListener(this);
                }
                ++n2;
            }
            this.grabbed = new Vector();
            this.lastGrabbed = null;
            this.lastGrabbedMenuBarChild = false;
        }

        private void requestAddGrab(Component component) {
            Window window = BasicPopupMenuUI.access$300(component);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            Component component2 = null;
            int n2 = 0;
            while (component2 == null && n2 < menuElementArray.length) {
                if (menuElementArray[n2] instanceof JPopupMenu) {
                    component2 = menuElementArray[n2].getComponent();
                }
                ++n2;
            }
            this.grabContainer(window, component2);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.cancelPopupMenu();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        private MenuElement getFirstPopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            MenuElement menuElement = null;
            int n2 = 0;
            while (menuElement == null && n2 < menuElementArray.length) {
                if (menuElementArray[n2] instanceof JPopupMenu) {
                    menuElement = menuElementArray[n2];
                }
                ++n2;
            }
            return menuElement;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !BasicPopupMenuUI.access$400(menuElementArray[0], this.lastPathSelected[0])) {
                this.requestRemoveGrab();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                Component component = menuElementArray[0].getComponent();
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.requestAddGrab(component);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.requestRemoveGrab();
            }
            if (menuElementArray != null && menuElementArray.length > 2 && menuElementArray[0] instanceof JMenuBar && this.lastGrabbedMenuBarChild && this.lastGrabbed != this.getFirstPopup()) {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
            this.lastPathSelected = menuElementArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            this.lastGrabbed = this.getFirstPopup();
            this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            Component component2 = null;
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            } else if (container instanceof JRootPane && ((component2 = ((JRootPane)container).getGlassPane()).getMouseListeners().length > 0 || component2.getMouseMotionListeners().length > 0 || component2.getMouseWheelListeners().length > 0)) {
                component2 = null;
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n2 = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n3 = 0;
                while (n3 < n2) {
                    Component component3 = componentArray[n3];
                    if (component3.isVisible()) {
                        if (component3 != component2) {
                            component3.addMouseListener(this);
                            component3.addMouseMotionListener(this);
                            component3.addMouseWheelListener(this);
                            this.grabbed.addElement(component3);
                        }
                        if (component3 instanceof Container) {
                            Container container2 = (Container)component3;
                            this.grabContainer(container2, component);
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    private static class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }

        ReturnAction(1 var1_1) {
            this();
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        static boolean FORWARD = true;
        static boolean BACKWARD = false;
        boolean direction;

        SelectNextItemAction(boolean bl2) {
            this.direction = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length < 2) {
                return;
            }
            int n2 = menuElementArray.length;
            if (menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu && n2 == 2) {
                MenuElement[] menuElementArray2;
                JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.access$600(jPopupMenu.getSubElements(), -1, FORWARD);
                if (menuElement != null) {
                    menuElementArray2 = new MenuElement[4];
                    menuElementArray2[3] = menuElement;
                } else {
                    menuElementArray2 = new MenuElement[3];
                }
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, 2);
                menuElementArray2[2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray2);
            } else if (menuElementArray[n2 - 1] instanceof JPopupMenu && menuElementArray[n2 - 2] instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray[n2 - 2];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.access$600(jPopupMenu.getSubElements(), -1, this.direction);
                if (menuElement != null) {
                    MenuElement[] menuElementArray3 = new MenuElement[n2 + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n2);
                    menuElementArray3[n2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                } else if (n2 > 2 && menuElementArray[n2 - 3] instanceof JPopupMenu && (menuElement = BasicPopupMenuUI.access$700((jPopupMenu = (JPopupMenu)menuElementArray[n2 - 3]).getSubElements(), jMenu, this.direction)) != null && menuElement != jMenu) {
                    MenuElement[] menuElementArray4 = new MenuElement[n2 - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n2 - 2);
                    menuElementArray4[n2 - 2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                }
            } else {
                MenuElement[] menuElementArray5 = menuElementArray[n2 - 2].getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.access$700(menuElementArray5, menuElementArray[n2 - 1], this.direction);
                if (menuElement == null) {
                    menuElement = BasicPopupMenuUI.access$600(menuElementArray5, -1, this.direction);
                }
                if (menuElement != null) {
                    menuElementArray[n2 - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
    }

    private static class SelectParentChildAction
    extends AbstractAction {
        static boolean PARENT = false;
        static boolean CHILD = true;
        boolean direction;

        SelectParentChildAction(boolean bl2) {
            this.direction = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n2 = menuElementArray.length;
            if (this.direction == PARENT) {
                int n3 = n2 - 1;
                if (n2 > 2 && (menuElementArray[n3] instanceof JPopupMenu || menuElementArray[--n3] instanceof JPopupMenu) && !((JMenu)menuElementArray[n3 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n3];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n3);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n2 > 0 && menuElementArray[n2 - 1] instanceof JMenu && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n2 - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.access$600(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n2 + 1];
                } else {
                    menuElementArray3 = new MenuElement[n2 + 2];
                    menuElementArray3[n2 + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n2);
                menuElementArray3[n2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n2 > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = BasicPopupMenuUI.access$700(menuElementArray[0].getSubElements(), menuElement, this.direction);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5 = n2 == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : new MenuElement[]{menuElementArray[0], menuElement2, ((JMenu)menuElement2).getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }
    }
}

