/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private static MenuListener sharedMenuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic;

    static {
        crossMenuMnemonic = true;
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    void updateMnemonicBinding() {
        int n2;
        int n3 = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIManager.get("Menu.shortcutKeys");
        if (n3 == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            n2 = 0;
            while (n2 < nArray.length) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, nArray[n2], false));
                ++n2;
            }
        }
        if (n3 != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            n2 = 0;
            while (n2 < nArray.length) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n3, nArray[n2], false), "selectMenu");
                ++n2;
            }
        }
        this.lastMnemonic = n3;
    }

    static boolean access$400() {
        return crossMenuMnemonic;
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        int n2 = menuElementArray.length - 1;
        while (n2 >= 0) {
            MenuElement menuElement = menuElementArray[n2];
            if (menuElement instanceof JPopupMenu) {
                return (JPopupMenu)menuElement;
            }
            --n2;
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler(this, null);
    }

    static void access$500(MenuElement[] menuElementArray, MenuElement menuElement) {
        BasicMenuUI.appendPath(menuElementArray, menuElement);
    }

    private static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler(this, null);
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler(this, null);
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        if (sharedMenuListener == null) {
            sharedMenuListener = new MenuHandler(null);
        }
        return sharedMenuListener;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    class 1 {
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public BasicMenuUI ui;
        public boolean isSelected;
        public Component wasFocused;
        private final BasicMenuUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
        }

        public ChangeHandler(BasicMenuUI basicMenuUI, JMenu jMenu, BasicMenuUI basicMenuUI2) {
            this.this$0 = basicMenuUI;
            this.isSelected = false;
            this.menu = jMenu;
            this.ui = basicMenuUI2;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private final BasicMenuUI this$0;

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!this.this$0.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < this.this$0.menuItem.getWidth() && point.y >= 0 && point.y < this.this$0.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)this.this$0.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        BasicMenuUI.access$500(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        this.this$0.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }

        private MenuDragMouseHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }

        MenuDragMouseHandler(BasicMenuUI basicMenuUI, 1 var2_2) {
            this(basicMenuUI);
        }
    }

    private static class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
        }

        MenuHandler(1 var1_1) {
            this();
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private int[] indexes;
        private char lastMnemonic;
        private int lastIndex;
        private int matches;
        private final BasicMenuUI this$0;

        private char lower(char c2) {
            return Character.toLowerCase(c2);
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c2 = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c2)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            int n2 = menuElementArray2.length - 1;
            while (n2 >= 0) {
                if (menuElementArray2[n2] == this.this$0.menuItem) {
                    JPopupMenu jPopupMenu = ((JMenu)this.this$0.menuItem).getPopupMenu();
                    MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                    if (this.indexes == null || this.lastMnemonic != c2) {
                        this.matches = 0;
                        this.lastIndex = 0;
                        this.indexes = new int[menuElementArray3.length];
                        int n3 = 0;
                        while (n3 < menuElementArray3.length) {
                            int n4 = ((JMenuItem)menuElementArray3[n3]).getMnemonic();
                            if (this.lower((char)n4) == this.lower(c2)) {
                                this.indexes[this.matches++] = n3;
                            }
                            ++n3;
                        }
                        this.lastMnemonic = c2;
                    }
                    if (this.matches != 0) {
                        if (this.matches == 1) {
                            JMenuItem jMenuItem = (JMenuItem)menuElementArray3[this.indexes[0]];
                            if (!(jMenuItem instanceof JMenu)) {
                                menuSelectionManager.clearSelectedPath();
                                jMenuItem.doClick();
                            }
                        } else {
                            if (this.lastIndex == this.matches) {
                                this.lastIndex = 0;
                            }
                            MenuElement menuElement = menuElementArray3[this.indexes[this.lastIndex++]];
                            MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 2];
                            System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                            menuElementArray4[menuElementArray.length] = jPopupMenu;
                            menuElementArray4[menuElementArray.length + 1] = menuElement;
                            menuSelectionManager.setSelectedPath(menuElementArray4);
                        }
                    }
                    menuKeyEvent.consume();
                    return;
                }
                --n2;
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!BasicMenuUI.access$400() && (jPopupMenu = BasicMenuUI.getActivePopupMenu()) != null && jPopupMenu != this.this$0.menuItem.getParent()) {
                return;
            }
            int n2 = this.this$0.menuItem.getMnemonic();
            if (n2 == 0) {
                return;
            }
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            if (this.lower((char)n2) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu2 = ((JMenu)this.this$0.menuItem).getPopupMenu();
                MenuElement[] menuElementArray2 = jPopupMenu2.getSubElements();
                if (menuElementArray2.length > 0) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = jPopupMenu2;
                    menuElementArray3[menuElementArray.length + 1] = menuElementArray2[0];
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                } else {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                    menuElementArray4[menuElementArray.length] = jPopupMenu2;
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                }
                menuKeyEvent.consume();
            }
        }

        private MenuKeyHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }

        MenuKeyHandler(BasicMenuUI basicMenuUI, 1 var2_2) {
            this(basicMenuUI);
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private final BasicMenuUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        BasicMenuUI.access$500(this.this$0.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(this.this$0.getPath());
                        this.this$0.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    BasicMenuUI.access$500(object, jMenu.getPopupMenu());
                } else {
                    this.this$0.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        protected MouseInputHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!BasicMenuUI.access$400() && (object = BasicMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    BasicMenuUI.access$500(menuElementArray, this.menu.getPopupMenu());
                }
            }
        }

        PostAction(JMenu jMenu, boolean bl2) {
            this.menu = jMenu;
            this.force = bl2;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final BasicMenuUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                this.this$0.updateMnemonicBinding();
            }
        }

        private PropertyChangeHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }

        PropertyChangeHandler(BasicMenuUI basicMenuUI, 1 var2_2) {
            this(basicMenuUI);
        }
    }
}

