/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public int getSize() {
        return this.fileCache.size();
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void invalidateFileCache() {
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.loadThread = new LoadFilesThread(this, file, this.fetchID);
        this.loadThread.start();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        }
    }

    public Object getElementAt(int n2) {
        return this.fileCache.get(n2);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            int n2 = 0;
            while (n2 < this.getSize()) {
                File file = (File)this.fileCache.get(n2);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                } else {
                    this.files.add(file);
                }
                ++n2;
            }
            return this.files;
        }
    }

    protected void sort(Vector vector) {
        ShellFolder.sortFiles(vector);
    }

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    static int access$200(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.fetchID;
    }

    protected boolean lt(File file, File file2) {
        int n2 = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n2 != 0) {
            return n2 < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    static void access$500(BasicDirectoryModel basicDirectoryModel, Object object, int n2, int n3) {
        basicDirectoryModel.fireIntervalRemoved(object, n2, n3);
    }

    static void access$600(BasicDirectoryModel basicDirectoryModel, Object object, int n2, int n3) {
        basicDirectoryModel.fireIntervalAdded(object, n2, n3);
    }

    static Vector access$100(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.fileCache;
    }

    static JFileChooser access$000(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.filechooser;
    }

    static Vector access$302(BasicDirectoryModel basicDirectoryModel, Vector vector) {
        basicDirectoryModel.files = vector;
        return basicDirectoryModel.files;
    }

    static Vector access$402(BasicDirectoryModel basicDirectoryModel, Vector vector) {
        basicDirectoryModel.directories = vector;
        return basicDirectoryModel.directories;
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire;
        private int fid;
        private int addStart;
        private int remStart;
        private int change;
        private final BasicDirectoryModel this$0;

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.access$200(this.this$0) == this.fid && this.doFire) {
                int n2 = this.remFiles == null ? 0 : this.remFiles.size();
                int n3 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.access$100(this.this$0);
                synchronized (vector) {
                    if (n2 > 0) {
                        BasicDirectoryModel.access$100(this.this$0).removeAll(this.remFiles);
                    }
                    if (n3 > 0) {
                        BasicDirectoryModel.access$100(this.this$0).addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.access$302(this.this$0, null);
                    BasicDirectoryModel.access$402(this.this$0, null);
                }
                if (n2 > 0 && n3 == 0) {
                    BasicDirectoryModel.access$500(this.this$0, this.this$0, this.remStart, this.remStart + n2 - 1);
                } else if (n3 > 0 && n2 == 0 && BasicDirectoryModel.access$100(this.this$0).size() > n3) {
                    BasicDirectoryModel.access$600(this.this$0, this.this$0, this.addStart, this.addStart + n3 - 1);
                } else {
                    this.this$0.fireContentsChanged();
                }
            }
        }

        public DoChangeContents(BasicDirectoryModel basicDirectoryModel, List list, int n2, List list2, int n3, int n4) {
            this.this$0 = basicDirectoryModel;
            this.doFire = true;
            this.addStart = 0;
            this.remStart = 0;
            this.addFiles = list;
            this.addStart = n2;
            this.remFiles = list2;
            this.remStart = n3;
            this.fid = n4;
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;
        private final BasicDirectoryModel this$0;

        public void run() {
            int n2;
            Serializable serializable;
            FileSystemView fileSystemView = BasicDirectoryModel.access$000(this.this$0).getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.access$000(this.this$0).isFileHidingEnabled());
            Vector vector = new Vector();
            if (this.isInterrupted()) {
                return;
            }
            int n3 = 0;
            while (n3 < fileArray.length) {
                if (BasicDirectoryModel.access$000(this.this$0).accept(fileArray[n3])) {
                    vector.addElement(fileArray[n3]);
                }
                ++n3;
            }
            if (this.isInterrupted()) {
                return;
            }
            this.this$0.sort(vector);
            Vector vector2 = new Vector(50);
            Vector vector3 = new Vector();
            int n4 = 0;
            while (n4 < vector.size()) {
                serializable = (File)vector.elementAt(n4);
                n2 = BasicDirectoryModel.access$000(this.this$0).isTraversable((File)serializable);
                if (n2 != 0) {
                    vector2.addElement(serializable);
                } else if (n2 == 0 && BasicDirectoryModel.access$000(this.this$0).isFileSelectionEnabled()) {
                    vector3.addElement(serializable);
                }
                if (this.isInterrupted()) {
                    return;
                }
                ++n4;
            }
            serializable = new Vector(vector2);
            ((Vector)serializable).addAll(vector3);
            n2 = ((Vector)serializable).size();
            int n5 = BasicDirectoryModel.access$100(this.this$0).size();
            if (n2 > n5) {
                int n6 = n5;
                int n7 = n2;
                int n8 = 0;
                block2: while (n8 < n5) {
                    if (!((Vector)serializable).get(n8).equals(BasicDirectoryModel.access$100(this.this$0).get(n8))) {
                        n6 = n8;
                        int n9 = n8;
                        while (n9 < n2) {
                            if (((Vector)serializable).get(n9).equals(BasicDirectoryModel.access$100(this.this$0).get(n8))) {
                                n7 = n9;
                                break block2;
                            }
                            ++n9;
                        }
                        break;
                    }
                    ++n8;
                }
                if (n6 >= 0 && n7 > n6 && ((Vector)serializable).subList(n7, n2).equals(BasicDirectoryModel.access$100(this.this$0).subList(n6, n5))) {
                    this.invokeLater(new DoChangeContents(this.this$0, ((Vector)serializable).subList(n6, n7), n6, null, 0, this.fid));
                    serializable = null;
                }
            } else if (n2 < n5) {
                int n10 = -1;
                int n11 = -1;
                int n12 = 0;
                while (n12 < n2) {
                    if (!((Vector)serializable).get(n12).equals(BasicDirectoryModel.access$100(this.this$0).get(n12))) {
                        n10 = n12;
                        n11 = n12 + n5 - n2;
                        break;
                    }
                    ++n12;
                }
                if (n10 >= 0 && n11 > n10 && BasicDirectoryModel.access$100(this.this$0).subList(n11, n5).equals(((Vector)serializable).subList(n10, n2))) {
                    this.invokeLater(new DoChangeContents(this.this$0, null, 0, new Vector(BasicDirectoryModel.access$100(this.this$0).subList(n10, n11)), n10, this.fid));
                    serializable = null;
                }
            }
            if (serializable != null && !BasicDirectoryModel.access$100(this.this$0).equals(serializable)) {
                this.invokeLater(new DoChangeContents(this.this$0, (List)((Object)serializable), 0, BasicDirectoryModel.access$100(this.this$0), 0, this.fid));
            }
            if (this.isInterrupted()) {
                this.cancelRunnables(this.runnables);
            }
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void cancelRunnables(Vector vector) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ((DoChangeContents)vector.elementAt(n2)).cancel();
                ++n2;
            }
        }

        public LoadFilesThread(BasicDirectoryModel basicDirectoryModel, File file, int n2) {
            this.this$0 = basicDirectoryModel;
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n2;
        }
    }
}

