/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;

public class BasicColorChooserUI
extends ColorChooserUI {
    JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    MouseListener previewMouseListener;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        TransferHandler transferHandler = this.chooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener(this);
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
            this.previewPanel.removeMouseListener(this.previewMouseListener);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected void uninstallDefaultChoosers() {
        int n2 = 0;
        while (n2 < this.defaultChoosers.length) {
            this.chooser.removeChooserPanel(this.defaultChoosers[n2]);
            ++n2;
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler(this);
    }

    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.singlePanel = new JPanel(new CenterLayout());
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(new CenterLayout());
        String string = UIManager.getString((Object)"ColorChooser.previewText", this.chooser.getLocale());
        this.previewPanelHolder.setBorder(new TitledBorder(string));
        this.chooser.add((Component)this.previewPanelHolder, "South");
        this.previewMouseListener = new MouseAdapter(this){
            private final BasicColorChooserUI this$0;

            public void mousePressed(MouseEvent mouseEvent) {
                if (this.this$0.chooser.getDragEnabled()) {
                    TransferHandler transferHandler = this.this$0.chooser.getTransferHandler();
                    transferHandler.exportAsDrag(this.this$0.chooser, mouseEvent, 1);
                }
            }
            {
                this.this$0 = basicColorChooserUI;
            }
        };
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(jComponent.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.previewPanelHolder.remove(this.previewPanel);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        return abstractColorChooserPanelArray;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    class PreviewListener
    implements ChangeListener {
        private final BasicColorChooserUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (this.this$0.previewPanel != null) {
                this.this$0.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                this.this$0.previewPanel.repaint();
            }
        }

        PreviewListener(BasicColorChooserUI basicColorChooserUI) {
            this.this$0 = basicColorChooserUI;
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        private final BasicColorChooserUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (propertyChangeEvent.getPropertyName().equals("chooserPanels")) {
                Container container;
                object2 = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                object = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                int n2 = 0;
                while (n2 < ((AbstractColorChooserPanel[])object2).length) {
                    Container container2 = object2[n2].getParent();
                    if (container2 != null) {
                        container = container2.getParent();
                        if (container != null) {
                            container.remove(container2);
                        }
                        object2[n2].uninstallChooserPanel(this.this$0.chooser);
                    }
                    ++n2;
                }
                int n3 = ((AbstractColorChooserPanel[])object).length;
                if (n3 == 0) {
                    this.this$0.chooser.remove(this.this$0.tabbedPane);
                    return;
                }
                if (n3 == 1) {
                    this.this$0.chooser.remove(this.this$0.tabbedPane);
                    container = new JPanel(new CenterLayout());
                    container.add((Component)object[0]);
                    this.this$0.singlePanel.add((Component)container, "Center");
                    this.this$0.chooser.add(this.this$0.singlePanel);
                } else {
                    if (((AbstractColorChooserPanel[])object2).length < 2) {
                        this.this$0.chooser.remove(this.this$0.singlePanel);
                        this.this$0.chooser.add((Component)this.this$0.tabbedPane, "Center");
                    }
                    int n4 = 0;
                    while (n4 < ((Object)object).length) {
                        JPanel jPanel = new JPanel(new CenterLayout());
                        String string = ((AbstractColorChooserPanel)object[n4]).getDisplayName();
                        int n5 = ((AbstractColorChooserPanel)object[n4]).getMnemonic();
                        jPanel.add((Component)object[n4]);
                        this.this$0.tabbedPane.addTab(string, jPanel);
                        if (n5 > 0) {
                            this.this$0.tabbedPane.setMnemonicAt(n4, n5);
                            this.this$0.tabbedPane.setDisplayedMnemonicIndexAt(n4, ((AbstractColorChooserPanel)object[n4]).getDisplayedMnemonicIndex());
                        }
                        ++n4;
                    }
                }
                this.this$0.chooser.applyComponentOrientation(this.this$0.chooser.getComponentOrientation());
                int n6 = 0;
                while (n6 < ((Object)object).length) {
                    ((AbstractColorChooserPanel)object[n6]).installChooserPanel(this.this$0.chooser);
                    ++n6;
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("previewPanel") && propertyChangeEvent.getNewValue() != this.this$0.previewPanel) {
                this.this$0.installPreviewPanel();
            }
            if (propertyChangeEvent.getPropertyName().equals("componentOrientation")) {
                object2 = (ComponentOrientation)propertyChangeEvent.getNewValue();
                object = (JColorChooser)propertyChangeEvent.getSource();
                if (object2 != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    ((Container)object).applyComponentOrientation((ComponentOrientation)object2);
                    ((JColorChooser)object).updateUI();
                }
            }
        }

        public PropertyHandler(BasicColorChooserUI basicColorChooserUI) {
            this.this$0 = basicColorChooserUI;
        }
    }
}

