/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class SmartGridLayout
implements LayoutManager,
Serializable {
    int rows = 2;
    int columns = 2;
    int xGap = 2;
    int yGap = 2;
    int componentCount = 0;
    Component[][] layoutGrid;

    private int computeColumnWidth(int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.rows) {
            int n5 = this.layoutGrid[n2][n4].getPreferredSize().width;
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    private int computeRowHeight(int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.columns) {
            int n5 = this.layoutGrid[n4][n2].getPreferredSize().height;
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    public SmartGridLayout(int n2, int n3) {
        this.rows = n3;
        this.columns = n2;
        this.layoutGrid = new Component[n2][n3];
    }

    public void removeLayoutComponent(Component component) {
    }

    private void buildLayoutGrid(Container container) {
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            int n3 = 0;
            int n4 = 0;
            if (n2 != 0) {
                n4 = n2 % this.columns;
                n3 = (n2 - n4) / this.columns;
            }
            this.layoutGrid[n4][n3] = componentArray[n2];
            ++n2;
        }
    }

    public void layoutContainer(Container container) {
        this.buildLayoutGrid(container);
        int[] nArray = new int[this.rows];
        int[] nArray2 = new int[this.columns];
        int n2 = 0;
        while (n2 < this.rows) {
            nArray[n2] = this.computeRowHeight(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.columns) {
            nArray2[n3] = this.computeColumnWidth(n3);
            ++n3;
        }
        Insets insets = container.getInsets();
        if (container.getComponentOrientation().isLeftToRight()) {
            int n4 = insets.left;
            int n5 = 0;
            while (n5 < this.columns) {
                int n6 = insets.top;
                int n7 = 0;
                while (n7 < this.rows) {
                    Component component = this.layoutGrid[n5][n7];
                    component.setBounds(n4, n6, nArray2[n5], nArray[n7]);
                    n6 += nArray[n7] + this.yGap;
                    ++n7;
                }
                n4 += nArray2[n5] + this.xGap;
                ++n5;
            }
        } else {
            int n8 = container.getWidth() - insets.right;
            int n9 = 0;
            while (n9 < this.columns) {
                int n10 = insets.top;
                n8 -= nArray2[n9];
                int n11 = 0;
                while (n11 < this.rows) {
                    Component component = this.layoutGrid[n9][n11];
                    component.setBounds(n8, n10, nArray2[n9], nArray[n11]);
                    n10 += nArray[n11] + this.yGap;
                    ++n11;
                }
                n8 -= this.xGap;
                ++n9;
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        this.buildLayoutGrid(container);
        Insets insets = container.getInsets();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.rows) {
            n2 += this.computeRowHeight(n4);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.columns) {
            n3 += this.computeColumnWidth(n5);
            ++n5;
        }
        return new Dimension(n3 += this.xGap * (this.columns - 1) + insets.right + insets.left, n2 += this.yGap * (this.rows - 1) + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }
}

