/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.TimerQueue;
import javax.swing.event.EventListenerList;

public class Timer
implements Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean notify = false;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    Runnable doPostEvent = null;
    private static boolean logTimers;
    long expirationTime;
    Timer nextTimer;
    boolean running;
    static Class class$java$awt$event$ActionListener;

    public int getDelay() {
        return this.delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    synchronized void cancelEvent() {
        this.notify = false;
    }

    synchronized void post() {
        if (!this.notify || !this.coalesce) {
            this.notify = true;
            SwingUtilities.invokeLater(this.doPostEvent);
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    static boolean access$000() {
        return logTimers;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void setDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid delay: " + n2);
        }
        this.delay = n2;
    }

    public void setInitialDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + n2);
        }
        this.initialDelay = n2;
    }

    public void setCoalesce(boolean bl2) {
        boolean bl3 = this.coalesce;
        this.coalesce = bl2;
        if (!bl3 && this.coalesce) {
            this.cancelEvent();
        }
    }

    public static void setLogTimers(boolean bl2) {
        logTimers = bl2;
    }

    public void setRepeats(boolean bl2) {
        this.repeats = bl2;
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ActionListener == null ? Timer.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)objectArray[n2 + 1]).actionPerformed(actionEvent);
            }
            n2 -= 2;
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public Timer(int n2, ActionListener actionListener) {
        this.delay = n2;
        this.initialDelay = n2;
        this.doPostEvent = new DoPostEvent(this);
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    static boolean access$100(Timer timer) {
        return timer.notify;
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    class DoPostEvent
    implements Runnable,
    Serializable {
        private final Timer this$0;

        public void run() {
            if (Timer.access$000()) {
                System.out.println("Timer ringing: " + this.this$0);
            }
            if (Timer.access$100(this.this$0)) {
                this.this$0.fireActionPerformed(new ActionEvent(this.this$0, 0, null, System.currentTimeMillis(), 0));
                if (this.this$0.coalesce) {
                    this.this$0.cancelEvent();
                }
            }
        }

        Timer getTimer() {
            return this.this$0;
        }

        DoPostEvent(Timer timer) {
            this.this$0 = timer;
        }
    }
}

