/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = new MenuSelectionManager();
    private Vector selection = new Vector();
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    static Class class$javax$swing$event$ChangeListener;

    public void clearSelectedPath() {
        this.setSelectedPath(null);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$ChangeListener == null ? MenuSelectionManager.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n2 + 1]).stateChanged(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        if (this.selection.size() > 0) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(0);
            return this.isComponentPartOfCurrentMenu(menuElement, component);
        }
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        Vector vector = (Vector)this.selection.clone();
        int n2 = vector.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n3);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n4 = 0;
            int n5 = menuElementArray.length;
            while (n4 < n5) {
                Component component;
                if (menuElementArray[n4] != null && (component = menuElementArray[n4].getComponent()).isShowing()) {
                    if (menuElementArray2 == null) {
                        menuElementArray2 = new MenuElement[n3 + 2];
                        int n6 = 0;
                        while (n6 <= n3) {
                            menuElementArray2[n6] = (MenuElement)vector.elementAt(n6);
                            ++n6;
                        }
                    }
                    menuElementArray2[n3 + 1] = menuElementArray[n4];
                    menuElementArray[n4].processKeyEvent(keyEvent, menuElementArray2, this);
                    if (keyEvent.isConsumed()) {
                        return;
                    }
                }
                ++n4;
            }
            --n3;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            return;
        }
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getModifiers();
        if ((n2 == 504 || n2 == 505) && (n3 & 0x1C) != 0) {
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        int n4 = point.x;
        int n5 = point.y;
        Vector vector = (Vector)this.selection.clone();
        int n6 = vector.size();
        boolean bl2 = false;
        int n7 = n6 - 1;
        while (n7 >= 0 && !bl2) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n7);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n8 = 0;
            int n9 = menuElementArray.length;
            while (n8 < n9 && !bl2) {
                Component component2;
                if (menuElementArray[n8] != null && (component2 = menuElementArray[n8].getComponent()).isShowing()) {
                    int n10;
                    int n11;
                    if (component2 instanceof JComponent) {
                        n11 = ((JComponent)component2).getWidth();
                        n10 = ((JComponent)component2).getHeight();
                    } else {
                        Rectangle rectangle = component2.getBounds();
                        n11 = rectangle.width;
                        n10 = rectangle.height;
                    }
                    point.x = n4;
                    point.y = n5;
                    SwingUtilities.convertPointFromScreen(point, component2);
                    if (point.x >= 0 && point.x < n11 && point.y >= 0 && point.y < n10) {
                        Serializable serializable;
                        if (menuElementArray2 == null) {
                            menuElementArray2 = new MenuElement[n7 + 2];
                            int n12 = 0;
                            while (n12 <= n7) {
                                menuElementArray2[n12] = (MenuElement)vector.elementAt(n12);
                                ++n12;
                            }
                        }
                        menuElementArray2[n7 + 1] = menuElementArray[n8];
                        MenuElement[] menuElementArray3 = this.getSelectedPath();
                        if (menuElementArray3[menuElementArray3.length - 1] != menuElementArray2[n7 + 1] && (menuElementArray3.length < 2 || menuElementArray3[menuElementArray3.length - 2] != menuElementArray2[n7 + 1])) {
                            serializable = menuElementArray3[menuElementArray3.length - 1].getComponent();
                            MouseEvent mouseEvent2 = new MouseEvent((Component)serializable, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            menuElementArray3[menuElementArray3.length - 1].processMouseEvent(mouseEvent2, menuElementArray2, this);
                            MouseEvent mouseEvent3 = new MouseEvent(component2, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            menuElementArray[n8].processMouseEvent(mouseEvent3, menuElementArray2, this);
                        }
                        serializable = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        menuElementArray[n8].processMouseEvent((MouseEvent)serializable, menuElementArray2, this);
                        bl2 = true;
                        mouseEvent.consume();
                    }
                }
                ++n8;
            }
            --n7;
        }
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selection.size()];
        int n2 = 0;
        int n3 = this.selection.size();
        while (n2 < n3) {
            menuElementArray[n2] = (MenuElement)this.selection.elementAt(n2);
            ++n2;
        }
        return menuElementArray;
    }

    private void printMenuElementArray(MenuElement[] menuElementArray) {
        this.printMenuElementArray(menuElementArray, false);
    }

    public void setSelectedPath(MenuElement[] menuElementArray) {
        int n2 = this.selection.size();
        int n3 = 0;
        if (menuElementArray == null) {
            menuElementArray = new MenuElement[]{};
        }
        int n4 = 0;
        int n5 = menuElementArray.length;
        while (n4 < n5) {
            if (n4 >= n2 || (MenuElement)this.selection.elementAt(n4) != menuElementArray[n4]) break;
            ++n3;
            ++n4;
        }
        n4 = n2 - 1;
        while (n4 >= n3) {
            ((MenuElement)this.selection.elementAt(n4)).menuSelectionChanged(false);
            this.selection.removeElementAt(n4);
            --n4;
        }
        n4 = n3;
        n5 = menuElementArray.length;
        while (n4 < n5) {
            if (menuElementArray[n4] != null) {
                menuElementArray[n4].menuSelectionChanged(true);
                this.selection.addElement(menuElementArray[n4]);
            }
            ++n4;
        }
        this.fireStateChanged();
    }

    private void printMenuElementArray(MenuElement[] menuElementArray, boolean bl2) {
        System.out.println("Path is(");
        int n2 = 0;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            int n4 = 0;
            while (n4 <= n2) {
                System.out.print("  ");
                ++n4;
            }
            MenuElement menuElement = menuElementArray[n2];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
            } else if (menuElement instanceof JMenuBar) {
                System.out.println("JMenuBar, ");
            } else if (menuElement instanceof JPopupMenu) {
                System.out.println("JPopupMenu, ");
            } else if (menuElement == null) {
                System.out.println("NULL , ");
            } else {
                System.out.println("" + menuElement + ", ");
            }
            ++n2;
        }
        System.out.println(")");
        if (bl2) {
            Thread.dumpStack();
        }
    }

    public static MenuSelectionManager defaultManager() {
        return instance;
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MenuSelectionManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MenuSelectionManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MenuSelectionManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement menuElement, Component component) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement.getComponent() == component) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n2 = 0;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            if (this.isComponentPartOfCurrentMenu(menuElementArray[n2], component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        int n2 = point2.x;
        int n3 = point2.y;
        Vector vector = (Vector)this.selection.clone();
        int n4 = vector.size();
        int n5 = n4 - 1;
        while (n5 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n5);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n6 = 0;
            int n7 = menuElementArray.length;
            while (n6 < n7) {
                Component component2;
                if (menuElementArray[n6] != null && (component2 = menuElementArray[n6].getComponent()).isShowing()) {
                    int n8;
                    int n9;
                    if (component2 instanceof JComponent) {
                        n9 = ((JComponent)component2).getWidth();
                        n8 = ((JComponent)component2).getHeight();
                    } else {
                        Rectangle rectangle = component2.getBounds();
                        n9 = rectangle.width;
                        n8 = rectangle.height;
                    }
                    point2.x = n2;
                    point2.y = n3;
                    SwingUtilities.convertPointFromScreen(point2, component2);
                    if (point2.x >= 0 && point2.x < n9 && point2.y >= 0 && point2.y < n8) {
                        return component2;
                    }
                }
                ++n6;
            }
            --n5;
        }
        return null;
    }
}

