/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "TreeUI";
    protected transient TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    protected boolean rootVisible;
    protected transient TreeCellRenderer cellRenderer;
    protected int rowHeight;
    private transient Hashtable expandedState;
    protected boolean showsRootHandles;
    protected transient TreeSelectionRedirector selectionRedirector;
    protected transient TreeCellEditor cellEditor;
    protected boolean editable;
    protected boolean largeModel;
    protected int visibleRowCount;
    protected boolean invokesStopCellEditing;
    protected boolean scrollsOnExpand;
    protected int toggleClickCount = 2;
    protected transient TreeModelListener treeModelListener;
    private transient Stack expandedStack = new Stack();
    private TreePath leadPath;
    private TreePath anchorPath;
    private boolean expandsSelectedPaths;
    private boolean settingUI;
    private boolean dragEnabled;
    private transient TreeExpansionListener uiTreeExpansionListener;
    private static int TEMP_STACK_SIZE = 11;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    public static final String TOGGLE_CLICK_COUNT_PROPERTY = "toggleClickCount";
    public static final String LEAD_SELECTION_PATH_PROPERTY = "leadSelectionPath";
    public static final String ANCHOR_SELECTION_PATH_PROPERTY = "anchorSelectionPath";
    public static final String EXPANDS_SELECTED_PATHS_PROPERTY = "expandsSelectedPaths";
    static Class class$javax$swing$event$TreeExpansionListener;
    static Class class$javax$swing$event$TreeWillExpandListener;
    static Class class$javax$swing$event$TreeSelectionListener;

    public int getLeadSelectionRow() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath != null) {
            return this.getRowForPath(treePath);
        }
        return -1;
    }

    public int getMaxSelectionRow() {
        return this.getSelectionModel().getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.getSelectionModel().getMinSelectionRow();
    }

    public int getRowCount() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowCount(this);
        }
        return 0;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public JTree() {
        this(JTree.getDefaultTreeModel());
    }

    public void cancelEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.cancelEditing(this);
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    protected void clearToggledPaths() {
        this.expandedState.clear();
    }

    private void expandRoot() {
        TreeModel treeModel = this.getModel();
        if (treeModel != null && treeModel.getRoot() != null) {
            this.expandPath(new TreePath(treeModel.getRoot()));
        }
    }

    public void treeDidChange() {
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
        this.invalidate();
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public boolean getExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isEditing(this);
        }
        return false;
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public boolean stopEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.stopEditing(this);
        }
        return false;
    }

    public int[] getSelectionRows() {
        return this.getSelectionModel().getSelectionRows();
    }

    public void addSelectionRow(int n2) {
        int[] nArray = new int[]{n2};
        this.addSelectionRows(nArray);
    }

    public void collapseRow(int n2) {
        this.collapsePath(this.getPathForRow(n2));
    }

    public void expandRow(int n2) {
        this.expandPath(this.getPathForRow(n2));
    }

    public void removeSelectionRow(int n2) {
        int[] nArray = new int[]{n2};
        this.removeSelectionRows(nArray);
    }

    public void scrollRowToVisible(int n2) {
        this.scrollPathToVisible(this.getPathForRow(n2));
    }

    public void setRowHeight(int n2) {
        int n3 = this.rowHeight;
        this.rowHeight = n2;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, n3, this.rowHeight);
        this.invalidate();
    }

    public void setSelectionRow(int n2) {
        int[] nArray = new int[]{n2};
        this.setSelectionRows(nArray);
    }

    public void setToggleClickCount(int n2) {
        int n3 = this.toggleClickCount;
        this.toggleClickCount = n2;
        this.firePropertyChange(TOGGLE_CLICK_COUNT_PROPERTY, n3, n2);
    }

    public void setVisibleRowCount(int n2) {
        int n3 = this.visibleRowCount;
        this.visibleRowCount = n2;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, n3, this.visibleRowCount);
        this.invalidate();
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public boolean isCollapsed(int n2) {
        return !this.isExpanded(n2);
    }

    public boolean isExpanded(int n2) {
        TreePath treePath;
        TreeUI treeUI = this.getUI();
        if (treeUI != null && (treePath = treeUI.getPathForRow(this, n2)) != null) {
            Boolean bl2 = (Boolean)this.expandedState.get(treePath);
            return bl2 != null && bl2 != false;
        }
        return false;
    }

    public boolean isRowSelected(int n2) {
        return this.getSelectionModel().isRowSelected(n2);
    }

    public int getClosestRowForLocation(int n2, int n3) {
        return this.getRowForPath(this.getClosestPathForLocation(n2, n3));
    }

    public int getRowForLocation(int n2, int n3) {
        return this.getRowForPath(this.getPathForLocation(n2, n3));
    }

    public void addSelectionInterval(int n2, int n3) {
        TreePath[] treePathArray = this.getPathBetweenRows(n2, n3);
        this.getSelectionModel().addSelectionPaths(treePathArray);
    }

    public void removeSelectionInterval(int n2, int n3) {
        TreePath[] treePathArray = this.getPathBetweenRows(n2, n3);
        this.getSelectionModel().removeSelectionPaths(treePathArray);
    }

    public void setSelectionInterval(int n2, int n3) {
        TreePath[] treePathArray = this.getPathBetweenRows(n2, n3);
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public void setEditable(boolean bl2) {
        boolean bl3 = this.editable;
        this.editable = bl2;
        this.firePropertyChange(EDITABLE_PROPERTY, bl3, bl2);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl3 ? AccessibleState.EDITABLE : null, bl2 ? AccessibleState.EDITABLE : null);
        }
    }

    public void setExpandsSelectedPaths(boolean bl2) {
        boolean bl3 = this.expandsSelectedPaths;
        this.expandsSelectedPaths = bl2;
        this.firePropertyChange(EXPANDS_SELECTED_PATHS_PROPERTY, bl3, bl2);
    }

    public void setInvokesStopCellEditing(boolean bl2) {
        boolean bl3 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl2;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl3, bl2);
    }

    public void setLargeModel(boolean bl2) {
        boolean bl3 = this.largeModel;
        this.largeModel = bl2;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, bl3, bl2);
    }

    public void setRootVisible(boolean bl2) {
        boolean bl3 = this.rootVisible;
        this.rootVisible = bl2;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, bl3, this.rootVisible);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public void setScrollsOnExpand(boolean bl2) {
        boolean bl3 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl2;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, bl3, bl2);
    }

    public void setShowsRootHandles(boolean bl2) {
        boolean bl3 = this.showsRootHandles;
        TreeModel treeModel = this.getModel();
        this.showsRootHandles = bl2;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, bl3, this.showsRootHandles);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
        this.invalidate();
    }

    public void addSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n2 = nArray.length;
            TreePath[] treePathArray = new TreePath[n2];
            int n3 = 0;
            while (n3 < n2) {
                treePathArray[n3] = treeUI.getPathForRow(this, nArray[n3]);
                ++n3;
            }
            this.addSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n2 = nArray.length;
            TreePath[] treePathArray = new TreePath[n2];
            int n3 = 0;
            while (n3 < n2) {
                treePathArray[n3] = treeUI.getPathForRow(this, nArray[n3]);
                ++n3;
            }
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void setSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n2 = nArray.length;
            TreePath[] treePathArray = new TreePath[n2];
            int n3 = 0;
            while (n3 < n2) {
                treePathArray[n3] = treeUI.getPathForRow(this, nArray[n3]);
                ++n3;
            }
            this.setSelectionPaths(treePathArray);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        int n2 = this.getPreferredSize().width;
        int n3 = this.getVisibleRowCount();
        int n4 = -1;
        if (this.isFixedRowHeight()) {
            n4 = n3 * this.getRowHeight();
        } else {
            TreeUI treeUI = this.getUI();
            if (treeUI != null && n3 > 0) {
                Rectangle rectangle;
                int n5 = treeUI.getRowCount(this);
                if (n5 >= n3) {
                    Rectangle rectangle2 = this.getRowBounds(n3 - 1);
                    if (rectangle2 != null) {
                        n4 = rectangle2.y + rectangle2.height;
                    }
                } else if (n5 > 0 && (rectangle = this.getRowBounds(0)) != null) {
                    n4 = rectangle.height * n3;
                }
            }
            if (n4 == -1) {
                n4 = 16 * n3;
            }
        }
        return new Dimension(n2, n4);
    }

    public Rectangle getRowBounds(int n2) {
        return this.getPathBounds(this.getPathForRow(n2));
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        return n2 == 1 ? rectangle.height : rectangle.width;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 1) {
            int n4 = this.getClosestRowForLocation(0, rectangle.y);
            if (n4 != -1) {
                Rectangle rectangle2 = this.getRowBounds(n4);
                if (rectangle2.y != rectangle.y) {
                    if (n3 < 0) {
                        return Math.max(0, rectangle.y - rectangle2.y);
                    }
                    return rectangle2.y + rectangle2.height - rectangle.y;
                }
                if (n3 < 0) {
                    if (n4 != 0) {
                        rectangle2 = this.getRowBounds(n4 - 1);
                        return rectangle2.height;
                    }
                } else {
                    return rectangle2.height;
                }
            }
            return 0;
        }
        return 4;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expandedState = new Hashtable();
        this.expandedStack = new Stack();
        Vector vector = (Vector)objectInputStream.readObject();
        int n2 = 0;
        int n3 = vector.size();
        if (n2 < n3 && vector.elementAt(n2).equals(CELL_RENDERER_PROPERTY)) {
            this.cellRenderer = (TreeCellRenderer)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(CELL_EDITOR_PROPERTY)) {
            this.cellEditor = (TreeCellEditor)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals("treeModel")) {
            this.treeModel = (TreeModel)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (TreeSelectionModel)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals("expandedState")) {
            this.unarchiveExpandedState(vector.elementAt(++n2));
            ++n2;
        }
        if (this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener) != 0) {
            this.selectionRedirector = new TreeSelectionRedirector(this);
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        if (this.treeModel != null) {
            this.treeModelListener = this.createTreeModelListener();
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.cellRenderer != null && this.cellRenderer instanceof Serializable) {
            vector.addElement(CELL_RENDERER_PROPERTY);
            vector.addElement(this.cellRenderer);
        }
        if (this.cellEditor != null && this.cellEditor instanceof Serializable) {
            vector.addElement(CELL_EDITOR_PROPERTY);
            vector.addElement(this.cellEditor);
        }
        if (this.treeModel != null && this.treeModel instanceof Serializable) {
            vector.addElement("treeModel");
            vector.addElement(this.treeModel);
        }
        if (this.selectionModel != null && this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        if ((object = this.getArchivableExpandedState()) != null) {
            vector.addElement("expandedState");
            vector.addElement(object);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private Object getArchivableExpandedState() {
        Enumeration enumeration;
        TreeModel treeModel = this.getModel();
        if (treeModel != null && (enumeration = this.expandedState.keys()) != null) {
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                int[] nArray;
                TreePath treePath = (TreePath)enumeration.nextElement();
                try {
                    nArray = this.getModelIndexsForPath(treePath);
                }
                catch (Error error) {
                    nArray = null;
                }
                if (nArray == null) continue;
                vector.addElement(nArray);
                vector.addElement(this.expandedState.get(treePath));
            }
            return vector;
        }
        return null;
    }

    public Object getLastSelectedPathComponent() {
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    private void unarchiveExpandedState(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                Boolean bl2 = (Boolean)vector.elementAt(n2--);
                try {
                    TreePath treePath = this.getPathForIndexs((int[])vector.elementAt(n2));
                    if (treePath != null) {
                        this.expandedState.put(treePath, bl2);
                    }
                }
                catch (Error error) {
                    // empty catch block
                }
                --n2;
            }
        }
    }

    public JTree(Object[] objectArray) {
        this(JTree.createTreeModel(objectArray));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.rootVisible ? "true" : "false";
        String string2 = this.showsRootHandles ? "true" : "false";
        String string3 = this.editable ? "true" : "false";
        String string4 = this.largeModel ? "true" : "false";
        String string5 = this.invokesStopCellEditing ? "true" : "false";
        String string6 = this.scrollsOnExpand ? "true" : "false";
        return super.paramString() + ",editable=" + string3 + ",invokesStopCellEditing=" + string5 + ",largeModel=" + string4 + ",rootVisible=" + string + ",rowHeight=" + this.rowHeight + ",scrollsOnExpand=" + string6 + ",showsRootHandles=" + string2 + ",toggleClickCount=" + this.toggleClickCount + ",visibleRowCount=" + this.visibleRowCount;
    }

    protected void removeDescendantToggledPaths(Enumeration enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2 = this.getDescendantToggledPaths((TreePath)enumeration.nextElement());
                if (enumeration2 == null) continue;
                while (enumeration2.hasMoreElements()) {
                    this.expandedState.remove(enumeration2.nextElement());
                }
            }
        }
    }

    public JTree(Hashtable hashtable) {
        this(JTree.createTreeModel(hashtable));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(Vector vector) {
        this(JTree.createTreeModel(vector));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTree(this);
        }
        return this.accessibleContext;
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.listenerList.getListeners(class$javax$swing$event$TreeExpansionListener == null ? (class$javax$swing$event$TreeExpansionListener = JTree.class$("javax.swing.event.TreeExpansionListener")) : class$javax$swing$event$TreeExpansionListener);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        if (this.settingUI) {
            this.uiTreeExpansionListener = treeExpansionListener;
        }
        this.listenerList.add(class$javax$swing$event$TreeExpansionListener == null ? (class$javax$swing$event$TreeExpansionListener = JTree.class$("javax.swing.event.TreeExpansionListener")) : class$javax$swing$event$TreeExpansionListener, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(class$javax$swing$event$TreeExpansionListener == null ? (class$javax$swing$event$TreeExpansionListener = JTree.class$("javax.swing.event.TreeExpansionListener")) : class$javax$swing$event$TreeExpansionListener, treeExpansionListener);
        if (this.uiTreeExpansionListener == treeExpansionListener) {
            this.uiTreeExpansionListener = null;
        }
    }

    void removeDescendantSelectedPaths(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        Object[] objectArray = treeModelEvent.getChildren();
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        if (treeSelectionModel != null && treePath != null && objectArray != null && objectArray.length > 0) {
            int n2 = objectArray.length - 1;
            while (n2 >= 0) {
                this.removeDescendantSelectedPaths(treePath.pathByAddingChild(objectArray[n2]), true);
                --n2;
            }
        }
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler(this);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeSelectionListener == null ? JTree.class$("javax.swing.event.TreeSelectionListener") : class$javax$swing$event$TreeSelectionListener)) {
                ((TreeSelectionListener)objectArray[n2 + 1]).valueChanged(treeSelectionEvent);
            }
            n2 -= 2;
        }
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener, treeSelectionListener);
        if (this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new TreeSelectionRedirector(this);
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener, treeSelectionListener);
        if (this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.listenerList.getListeners(class$javax$swing$event$TreeWillExpandListener == null ? (class$javax$swing$event$TreeWillExpandListener = JTree.class$("javax.swing.event.TreeWillExpandListener")) : class$javax$swing$event$TreeWillExpandListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(class$javax$swing$event$TreeWillExpandListener == null ? (class$javax$swing$event$TreeWillExpandListener = JTree.class$("javax.swing.event.TreeWillExpandListener")) : class$javax$swing$event$TreeWillExpandListener, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(class$javax$swing$event$TreeWillExpandListener == null ? (class$javax$swing$event$TreeWillExpandListener = JTree.class$("javax.swing.event.TreeWillExpandListener")) : class$javax$swing$event$TreeWillExpandListener, treeWillExpandListener);
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(TreeUI treeUI) {
        if ((TreeUI)this.ui != treeUI) {
            this.settingUI = true;
            this.uiTreeExpansionListener = null;
            try {
                super.setUI(treeUI);
                Object var3_2 = null;
                this.settingUI = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.settingUI = false;
                throw throwable;
            }
        }
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TreeCellEditor treeCellEditor) {
        TreeCellEditor treeCellEditor2 = this.cellEditor;
        this.cellEditor = treeCellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, treeCellEditor2, treeCellEditor);
        this.invalidate();
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        TreeCellRenderer treeCellRenderer2 = this.cellRenderer;
        this.cellRenderer = treeCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, treeCellRenderer2, this.cellRenderer);
        this.invalidate();
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public JTree(TreeModel treeModel) {
        this.expandedState = new Hashtable();
        this.setLayout(null);
        this.rowHeight = 16;
        this.visibleRowCount = 20;
        this.rootVisible = true;
        this.selectionModel = new DefaultTreeSelectionModel();
        this.cellRenderer = null;
        this.scrollsOnExpand = true;
        this.setOpaque(true);
        this.expandsSelectedPaths = true;
        this.updateUI();
        this.setModel(treeModel);
    }

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.accessibleContext != null) {
            if (this.treeModel != null) {
                this.treeModel.removeTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
            if (treeModel != null) {
                treeModel.addTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
        }
        this.treeModel = treeModel;
        this.clearToggledPaths();
        if (this.treeModel != null) {
            if (this.treeModelListener == null) {
                this.treeModelListener = this.createTreeModelListener();
            }
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
            if (this.treeModel.getRoot() != null && !this.treeModel.isLeaf(this.treeModel.getRoot())) {
                this.expandedState.put(new TreePath(this.treeModel.getRoot()), Boolean.TRUE);
            }
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, this.treeModel);
        this.invalidate();
        this.clearSelection();
    }

    public JTree(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JTree(TreeNode treeNode, boolean bl2) {
        this(new DefaultTreeModel(treeNode, bl2));
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorPath;
    }

    public TreePath getEditingPath() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getEditingPath(this);
        }
        return null;
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public TreePath getSelectionPath() {
        return this.getSelectionModel().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public TreePath getPathForRow(int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathForRow(this, n2);
        }
        return null;
    }

    public TreePath getClosestPathForLocation(int n2, int n3) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestPathForLocation(this, n2, n3);
        }
        return null;
    }

    public TreePath getPathForLocation(int n2, int n3) {
        Rectangle rectangle;
        TreePath treePath = this.getClosestPathForLocation(n2, n3);
        if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && n2 >= rectangle.x && n2 < rectangle.x + rectangle.width && n3 >= rectangle.y && n3 < rectangle.y + rectangle.height) {
            return treePath;
        }
        return null;
    }

    protected TreePath[] getPathBetweenRows(int n2, int n3) {
        TreeUI treeUI = this.getUI();
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (treeUI != null) {
            TreePath[] treePathArray = new TreePath[n5 - n4 + 1];
            int n6 = n4;
            while (n6 <= n5) {
                treePathArray[n6 - n4] = treeUI.getPathForRow(this, n6);
                ++n6;
            }
            return treePathArray;
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowForPath(this, treePath);
        }
        return -1;
    }

    public void addSelectionPath(TreePath treePath) {
        this.getSelectionModel().addSelectionPath(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.setExpandedState(treePath, false);
    }

    public void expandPath(TreePath treePath) {
        TreeModel treeModel = this.getModel();
        if (treePath != null && treeModel != null && !treeModel.isLeaf(treePath.getLastPathComponent())) {
            this.setExpandedState(treePath, true);
        }
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        if (this.uiTreeExpansionListener != null) {
            treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            this.uiTreeExpansionListener.treeCollapsed(treeExpansionEvent);
        }
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeExpansionListener == null ? JTree.class$("javax.swing.event.TreeExpansionListener") : class$javax$swing$event$TreeExpansionListener) && objectArray[n2 + 1] != this.uiTreeExpansionListener) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeExpansionListener)objectArray[n2 + 1]).treeCollapsed(treeExpansionEvent);
            }
            n2 -= 2;
        }
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        if (this.uiTreeExpansionListener != null) {
            treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            this.uiTreeExpansionListener.treeExpanded(treeExpansionEvent);
        }
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeExpansionListener == null ? JTree.class$("javax.swing.event.TreeExpansionListener") : class$javax$swing$event$TreeExpansionListener) && objectArray[n2 + 1] != this.uiTreeExpansionListener) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeExpansionListener)objectArray[n2 + 1]).treeExpanded(treeExpansionEvent);
            }
            n2 -= 2;
        }
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeWillExpandListener == null ? JTree.class$("javax.swing.event.TreeWillExpandListener") : class$javax$swing$event$TreeWillExpandListener)) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeWillExpandListener)objectArray[n2 + 1]).treeWillCollapse(treeExpansionEvent);
            }
            n2 -= 2;
        }
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeWillExpandListener == null ? JTree.class$("javax.swing.event.TreeWillExpandListener") : class$javax$swing$event$TreeWillExpandListener)) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeWillExpandListener)objectArray[n2 + 1]).treeWillExpand(treeExpansionEvent);
            }
            n2 -= 2;
        }
    }

    public void makeVisible(TreePath treePath) {
        TreePath treePath2;
        if (treePath != null && (treePath2 = treePath.getParentPath()) != null) {
            this.expandPath(treePath2);
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        this.getSelectionModel().removeSelectionPath(treePath);
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
                if (this.accessibleContext != null) {
                    ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        TreePath treePath2 = this.anchorPath;
        this.anchorPath = treePath;
        this.firePropertyChange(ANCHOR_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public void setLeadSelectionPath(TreePath treePath) {
        TreePath treePath2 = this.leadPath;
        this.leadPath = treePath;
        this.firePropertyChange(LEAD_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public void setSelectionPath(TreePath treePath) {
        this.getSelectionModel().setSelectionPath(treePath);
    }

    public void startEditingAtPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.startEditingAtPath(this, treePath);
        }
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedState.get(treePath) != null;
    }

    public boolean isCollapsed(TreePath treePath) {
        return !this.isExpanded(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = this.expandedState.get(treePath);
        if (object == null || !((Boolean)object).booleanValue()) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    public boolean isPathEditable(TreePath treePath) {
        return this.isEditable();
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.getSelectionModel().isPathSelected(treePath);
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null) {
                return this.isExpanded(treePath2);
            }
            return true;
        }
        return false;
    }

    private int[] getModelIndexsForPath(TreePath treePath) {
        if (treePath != null) {
            TreeModel treeModel = this.getModel();
            int n2 = treePath.getPathCount();
            int[] nArray = new int[n2 - 1];
            Object object = treeModel.getRoot();
            int n3 = 1;
            while (n3 < n2) {
                nArray[n3 - 1] = treeModel.getIndexOfChild(object, treePath.getPathComponent(n3));
                object = treePath.getPathComponent(n3);
                if (nArray[n3 - 1] < 0) {
                    return null;
                }
                ++n3;
            }
            return nArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void setExpandedState(TreePath var1_1, boolean var2_2) {
        if (var1_1 != null) {
            var4_3 = var1_1.getParentPath();
            var3_4 = this.expandedStack.size() == 0 ? new Stack() : (Stack)this.expandedStack.pop();
            try {
                while (var4_3 != null) {
                    if (this.isExpanded(var4_3)) {
                        var4_3 = null;
                        continue;
                    }
                    var3_4.push(var4_3);
                    var4_3 = var4_3.getParentPath();
                }
                var5_5 = var3_4.size() - 1;
                while (true) {
                    var4_3 = (TreePath)var3_4.pop();
                    if (!this.isExpanded(var4_3)) {
                        try {
                            this.fireTreeWillExpand(var4_3);
                        }
                        catch (ExpandVetoException var6_8) {
                            if (this.expandedStack.size() < JTree.TEMP_STACK_SIZE) {
                                var3_4.removeAllElements();
                                this.expandedStack.push(var3_4);
                            }
                            return;
                        }
                        this.expandedState.put(var4_3, Boolean.TRUE);
                        this.fireTreeExpanded(var4_3);
                        if (this.accessibleContext != null) {
                            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                        }
                    }
                    --var5_5;
                    break;
                }
            }
            finally {
                if (var5_5 >= 0) ** continue;
            }
            if (!var2_2) {
                var5_6 = this.expandedState.get(var1_1);
                if (var5_6 != null && ((Boolean)var5_6).booleanValue()) {
                    try {
                        this.fireTreeWillCollapse(var1_1);
                    }
                    catch (ExpandVetoException var6_9) {
                        return;
                    }
                    this.expandedState.put(var1_1, Boolean.FALSE);
                    this.fireTreeCollapsed(var1_1);
                    if (this.removeDescendantSelectedPaths(var1_1, false) && !this.isPathSelected(var1_1)) {
                        this.addSelectionPath(var1_1);
                    }
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            } else {
                var5_7 = this.expandedState.get(var1_1);
                if (var5_7 == null || !((Boolean)var5_7).booleanValue()) {
                    try {
                        this.fireTreeWillExpand(var1_1);
                    }
                    catch (ExpandVetoException var6_10) {
                        return;
                    }
                    this.expandedState.put(var1_1, Boolean.TRUE);
                    this.fireTreeExpanded(var1_1);
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            }
        }
    }

    protected boolean removeDescendantSelectedPaths(TreePath treePath, boolean bl2) {
        TreePath[] treePathArray = this.getDescendantSelectedPaths(treePath, bl2);
        if (treePathArray != null) {
            this.getSelectionModel().removeSelectionPaths(treePathArray);
            return true;
        }
        return false;
    }

    private TreePath getPathForIndexs(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        TreeModel treeModel = this.getModel();
        if (treeModel == null) {
            return null;
        }
        int n2 = nArray.length;
        Object object = treeModel.getRoot();
        TreePath treePath = new TreePath(object);
        int n3 = 0;
        while (n3 < n2) {
            if ((object = treeModel.getChild(object, nArray[n3])) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(object);
            ++n3;
        }
        return treePath;
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().addSelectionPaths(treePathArray);
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().removeSelectionPaths(treePathArray);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel == null) {
            treeSelectionModel = EmptySelectionModel.sharedInstance();
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
        }
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            treeSelectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = treeSelectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, this.selectionModel);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleSelection", false, true);
        }
    }

    public Rectangle getPathBounds(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathBounds(this, treePath);
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            TreePath treePath;
            Object object;
            Component component;
            Point point = mouseEvent.getPoint();
            int n2 = this.getRowForLocation(point.x, point.y);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (n2 != -1 && treeCellRenderer != null && (component = treeCellRenderer.getTreeCellRendererComponent(this, object = (treePath = this.getPathForRow(n2)).getLastPathComponent(), this.isRowSelected(n2), this.isExpanded(n2), this.getModel().isLeaf(object), n2, true)) instanceof JComponent) {
                Rectangle rectangle = this.getPathBounds(treePath);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        return null;
    }

    public String convertValueToText(Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected Enumeration getDescendantToggledPaths(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.expandedState.keys();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = (TreePath)enumeration.nextElement();
            if (!treePath.isDescendant(treePath2)) continue;
            vector.addElement(treePath2);
        }
        return vector.elements();
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return null;
        }
        Enumeration enumeration = this.expandedState.keys();
        Vector vector = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = (TreePath)enumeration.nextElement();
                Object object = this.expandedState.get(treePath2);
                if (treePath2 == treePath || object == null || !((Boolean)object).booleanValue() || !treePath.isDescendant(treePath2) || !this.isVisible(treePath2)) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(treePath2);
            }
        }
        if (vector == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return vector.elements();
    }

    static Hashtable access$000(JTree jTree) {
        return jTree.expandedState;
    }

    protected static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            defaultMutableTreeNode = new DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    private TreePath[] getDescendantSelectedPaths(TreePath treePath, boolean bl2) {
        TreePath[] treePathArray;
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        TreePath[] treePathArray2 = treePathArray = treeSelectionModel != null ? treeSelectionModel.getSelectionPaths() : null;
        if (treePathArray != null) {
            boolean bl3 = false;
            int n2 = treePathArray.length - 1;
            while (n2 >= 0) {
                if (treePathArray[n2] != null && treePath.isDescendant(treePathArray[n2]) && (!treePath.equals(treePathArray[n2]) || bl2)) {
                    bl3 = true;
                } else {
                    treePathArray[n2] = null;
                }
                --n2;
            }
            if (!bl3) {
                treePathArray = null;
            }
            return treePathArray;
        }
        return null;
    }

    public TreePath getNextMatch(String string, int n2, Position.Bias bias) {
        int n3 = this.getRowCount();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException();
        }
        string = string.toUpperCase();
        int n4 = bias == Position.Bias.Forward ? 1 : -1;
        int n5 = n2;
        do {
            TreePath treePath;
            String string2;
            if (!(string2 = this.convertValueToText((treePath = this.getPathForRow(n5)).getLastPathComponent(), this.isRowSelected(n5), this.isExpanded(n5), true, n5, false)).toUpperCase().startsWith(string)) continue;
            return treePath;
        } while ((n5 = (n5 + n4 + n3) % n3) != n2);
        return null;
    }

    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        TreePath leadSelectionPath;
        Accessible leadSelectionAccessible;
        private final JTree this$0;

        public int getAccessibleChildrenCount() {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null) {
                return 1;
            }
            return 0;
        }

        public int getAccessibleIndexInParent() {
            return super.getAccessibleIndexInParent();
        }

        public int getAccessibleSelectionCount() {
            Object[] objectArray = new Object[]{this.this$0.treeModel.getRoot()};
            TreePath treePath = new TreePath(objectArray);
            if (this.this$0.isPathSelected(treePath)) {
                return 1;
            }
            return 0;
        }

        public void clearAccessibleSelection() {
            int n2 = this.getAccessibleChildrenCount();
            int n3 = 0;
            while (n3 < n2) {
                this.removeAccessibleSelection(n3);
                ++n3;
            }
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        public void selectAllAccessibleSelection() {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                this.this$0.addSelectionPath(treePath);
            }
        }

        public void addAccessibleSelection(int n2) {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null && n2 == 0) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                this.this$0.addSelectionPath(treePath);
            }
        }

        public void removeAccessibleSelection(int n2) {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null && n2 == 0) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                this.this$0.removeSelectionPath(treePath);
            }
        }

        public boolean isAccessibleChildSelected(int n2) {
            if (n2 == 0) {
                Object[] objectArray = new Object[]{this.this$0.treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                return this.this$0.isPathSelected(treePath);
            }
            return false;
        }

        private Component getCurrentComponent() {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel == null) {
                return null;
            }
            TreePath treePath = new TreePath(treeModel.getRoot());
            if (this.this$0.isVisible(treePath)) {
                TreeCellRenderer treeCellRenderer = this.this$0.getCellRenderer();
                TreeUI treeUI = this.this$0.getUI();
                if (treeUI != null) {
                    int n2 = treeUI.getRowForPath(this.this$0, treePath);
                    int n3 = this.this$0.getLeadSelectionRow();
                    boolean bl2 = this.this$0.isFocusOwner() && n3 == n2;
                    boolean bl3 = this.this$0.isPathSelected(treePath);
                    boolean bl4 = this.this$0.isExpanded(treePath);
                    return treeCellRenderer.getTreeCellRendererComponent(this.this$0, treeModel.getRoot(), bl3, bl4, treeModel.isLeaf(treeModel.getRoot()), n2, bl2);
                }
            }
            return null;
        }

        public Accessible getAccessibleChild(int n2) {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null) {
                if (n2 != 0) {
                    return null;
                }
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                return new AccessibleJTreeNode(this, this.this$0, treePath, this.this$0);
            }
            return null;
        }

        public Accessible getAccessibleSelection(int n2) {
            if (n2 == 0) {
                Object[] objectArray = new Object[]{this.this$0.treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                if (this.this$0.isPathSelected(treePath)) {
                    return new AccessibleJTreeNode(this, this.this$0, treePath, this.this$0);
                }
            }
            return null;
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component instanceof Accessible) {
                return ((Accessible)((Object)component)).getAccessibleContext();
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleJTree(JTree jTree) {
            this.this$0 = jTree;
            super(jTree);
            TreeModel treeModel = jTree.getModel();
            if (treeModel != null) {
                treeModel.addTreeModelListener(this);
            }
            jTree.addTreeExpansionListener(this);
            jTree.addTreeSelectionListener(this);
            this.leadSelectionPath = jTree.getLeadSelectionPath();
            this.leadSelectionAccessible = this.leadSelectionPath != null ? new AccessibleJTreeNode(this, jTree, this.leadSelectionPath, jTree) : null;
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
            this.firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
            this.firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
            this.leadSelectionPath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath != this.leadSelectionPath) {
                Accessible accessible = this.leadSelectionAccessible;
                this.leadSelectionAccessible = this.leadSelectionPath != null ? new AccessibleJTreeNode(this, this.this$0, this.leadSelectionPath, this.this$0) : null;
                this.firePropertyChange("AccessibleActiveDescendant", accessible, this.leadSelectionAccessible);
            }
            this.firePropertyChange("AccessibleSelection", false, true);
        }

        public Accessible getAccessibleAt(Point point) {
            TreePath treePath = this.this$0.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                return new AccessibleJTreeNode(this, this.this$0, treePath, null);
            }
            return null;
        }

        static JTree access$100(AccessibleJTree accessibleJTree) {
            return accessibleJTree.this$0;
        }

        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree;
            private TreeModel treeModel;
            private Object obj;
            private TreePath path;
            private Accessible accessibleParent;
            private int index;
            private boolean isLeaf;
            private final AccessibleJTree this$1;

            public int getAccessibleActionCount() {
                AccessibleAction accessibleAction;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
                }
                return this.isLeaf ? 0 : 1;
            }

            public int getAccessibleChildrenCount() {
                return this.treeModel.getChildCount(this.obj);
            }

            public int getAccessibleIndexInParent() {
                Object[] objectArray;
                if (this.accessibleParent == null) {
                    this.getAccessibleParent();
                }
                if ((objectArray = this.path.getPath()).length > 1) {
                    Object object = objectArray[objectArray.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(object, this.obj);
                    }
                }
                return this.index;
            }

            public int getAccessibleSelectionCount() {
                int n2 = 0;
                int n3 = this.getAccessibleChildrenCount();
                int n4 = 0;
                while (n4 < n3) {
                    TreePath treePath = this.getChildTreePath(n4);
                    if (this.tree.isPathSelected(treePath)) {
                        ++n2;
                    }
                    ++n4;
                }
                return n2;
            }

            public void clearAccessibleSelection() {
                int n2 = this.getAccessibleChildrenCount();
                int n3 = 0;
                while (n3 < n2) {
                    this.removeAccessibleSelection(n3);
                    ++n3;
                }
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void selectAllAccessibleSelection() {
                TreeModel treeModel = AccessibleJTree.access$100(this.this$1).getModel();
                if (treeModel != null) {
                    int n2 = this.getAccessibleChildrenCount();
                    int n3 = 0;
                    while (n3 < n2) {
                        TreePath treePath = this.getChildTreePath(n3);
                        AccessibleJTree.access$100(this.this$1).addSelectionPath(treePath);
                        ++n3;
                    }
                }
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                return this.tree.isShowing() && this.isVisible();
            }

            public boolean isVisible() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Rectangle rectangle2 = this.tree.getVisibleRect();
                return rectangle != null && rectangle2 != null && rectangle2.intersects(rectangle);
            }

            public void addAccessibleSelection(int n2) {
                TreeModel treeModel = AccessibleJTree.access$100(this.this$1).getModel();
                if (treeModel != null && n2 >= 0 && n2 < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n2);
                    AccessibleJTree.access$100(this.this$1).addSelectionPath(treePath);
                }
            }

            public void removeAccessibleSelection(int n2) {
                TreeModel treeModel = AccessibleJTree.access$100(this.this$1).getModel();
                if (treeModel != null && n2 >= 0 && n2 < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n2);
                    AccessibleJTree.access$100(this.this$1).removeSelectionPath(treePath);
                }
            }

            public boolean doAccessibleAction(int n2) {
                AccessibleAction accessibleAction;
                if (n2 < 0 || n2 >= this.getAccessibleActionCount()) {
                    return false;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n2 == 0) {
                    if (AccessibleJTree.access$100(this.this$1).isExpanded(this.path)) {
                        AccessibleJTree.access$100(this.this$1).collapsePath(this.path);
                    } else {
                        AccessibleJTree.access$100(this.this$1).expandPath(this.path);
                    }
                    return true;
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.doAccessibleAction(n2 - 1);
                }
                return false;
            }

            public boolean isAccessibleChildSelected(int n2) {
                int n3 = this.getAccessibleChildrenCount();
                if (n2 < 0 || n2 >= n3) {
                    return false;
                }
                TreePath treePath = this.getChildTreePath(n2);
                return this.tree.isPathSelected(treePath);
            }

            public void setEnabled(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl2);
                    }
                }
            }

            public void setVisible(boolean bl2) {
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            private Component getCurrentComponent() {
                if (this.tree.isVisible(this.path)) {
                    TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                    if (treeCellRenderer == null) {
                        return null;
                    }
                    TreeUI treeUI = this.tree.getUI();
                    if (treeUI != null) {
                        int n2 = treeUI.getRowForPath(AccessibleJTree.access$100(this.this$1), this.path);
                        boolean bl2 = this.tree.isPathSelected(this.path);
                        boolean bl3 = this.tree.isExpanded(this.path);
                        boolean bl4 = false;
                        return treeCellRenderer.getTreeCellRendererComponent(this.tree, this.obj, bl2, bl3, this.isLeaf, n2, bl4);
                    }
                }
                return null;
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public Point getLocation() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            protected Point getLocationInJTree() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public Point getLocationOnScreen() {
                if (this.tree != null) {
                    Point point = this.tree.getLocationOnScreen();
                    Rectangle rectangle = this.tree.getPathBounds(this.path);
                    if (point != null && rectangle != null) {
                        Point point2 = new Point(rectangle.x, rectangle.y);
                        point2.translate(point.x, point.y);
                        return point2;
                    }
                    return null;
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Accessible accessible = this.getAccessibleParent();
                if (accessible != null && accessible instanceof AccessibleJTreeNode) {
                    Point point = ((AccessibleJTreeNode)accessible).getLocationInJTree();
                    if (point != null && rectangle != null) {
                        rectangle.translate(-point.x, -point.y);
                    } else {
                        return null;
                    }
                }
                return rectangle;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    String string = accessibleContext.getAccessibleName();
                    if (string != null && string != "") {
                        return accessibleContext.getAccessibleName();
                    }
                    return null;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public String getAccessibleActionDescription(int n2) {
                AccessibleAction accessibleAction;
                if (n2 < 0 || n2 >= this.getAccessibleActionCount()) {
                    return null;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n2 == 0) {
                    return "toggle expand";
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionDescription(n2 - 1);
                }
                return null;
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return this.tree.getLocale();
            }

            public Accessible getAccessibleParent() {
                if (this.accessibleParent == null) {
                    Object[] objectArray = this.path.getPath();
                    if (objectArray.length > 1) {
                        Object object = objectArray[objectArray.length - 2];
                        if (this.treeModel != null) {
                            this.index = this.treeModel.getIndexOfChild(object, this.obj);
                        }
                        Object[] objectArray2 = new Object[objectArray.length - 1];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
                        TreePath treePath = new TreePath(objectArray2);
                        this.accessibleParent = new AccessibleJTreeNode(this.this$1, this.tree, treePath, null);
                        this.setAccessibleParent(this.accessibleParent);
                    } else if (this.treeModel != null) {
                        this.accessibleParent = this.tree;
                        this.index = 0;
                        this.setAccessibleParent(this.accessibleParent);
                    }
                }
                return this.accessibleParent;
            }

            public Accessible getAccessibleChild(int n2) {
                if (n2 < 0 || n2 >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n2);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                TreePath treePath = new TreePath(objectArray2);
                return new AccessibleJTreeNode(this.this$1, AccessibleJTree.access$100(this.this$1), treePath, this);
            }

            public Accessible getAccessibleSelection(int n2) {
                int n3 = this.getAccessibleChildrenCount();
                if (n2 < 0 || n2 >= n3) {
                    return null;
                }
                int n4 = 0;
                int n5 = 0;
                while (n5 < n3 && n2 >= n4) {
                    TreePath treePath = this.getChildTreePath(n5);
                    if (this.tree.isPathSelected(treePath)) {
                        if (n4 == n2) {
                            return new AccessibleJTreeNode(this.this$1, this.tree, treePath, this);
                        }
                        ++n4;
                    }
                    ++n5;
                }
                return null;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getCurrentComponent();
                if (component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && this.isLeaf) {
                    return this.getCurrentAccessibleContext().getAccessibleSelection();
                }
                return this;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                int n2 = this.tree.getUI().getRowForPath(this.tree, this.path);
                int n3 = this.tree.getLeadSelectionRow();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                if (this.tree.isPathSelected(this.path)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (n3 == n2) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (!this.isLeaf) {
                    accessibleStateSet.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.path)) {
                    accessibleStateSet.add(AccessibleState.EXPANDED);
                } else {
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    accessibleStateSet.add(AccessibleState.EDITABLE);
                }
                return accessibleStateSet;
            }

            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleText();
                }
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleValue();
                }
                return null;
            }

            private TreePath getChildTreePath(int n2) {
                if (n2 < 0 || n2 >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n2);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                return new TreePath(objectArray2);
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public AccessibleJTreeNode(AccessibleJTree accessibleJTree, JTree jTree, TreePath treePath, Accessible accessible) {
                this.this$1 = accessibleJTree;
                this.tree = null;
                this.treeModel = null;
                this.obj = null;
                this.path = null;
                this.accessibleParent = null;
                this.index = 0;
                this.isLeaf = false;
                this.tree = jTree;
                this.path = treePath;
                this.accessibleParent = accessible;
                this.treeModel = jTree.getModel();
                this.obj = treePath.getLastPathComponent();
                if (this.treeModel != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }
        }
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasChildren;
        protected Object childValue;
        protected boolean loadedChildren = false;

        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicUtilTreeNode.createChildren(this, this.childValue);
        }

        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }

        public TreeNode getChildAt(int n2) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(n2);
        }

        public DynamicUtilTreeNode(Object object, Object object2) {
            super(object);
            this.childValue = object2;
            if (object2 != null) {
                if (object2 instanceof Vector) {
                    this.setAllowsChildren(true);
                } else if (object2 instanceof Hashtable) {
                    this.setAllowsChildren(true);
                } else if (object2 instanceof Object[]) {
                    this.setAllowsChildren(true);
                } else {
                    this.setAllowsChildren(false);
                }
            } else {
                this.setAllowsChildren(false);
            }
        }

        public static void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            block4: {
                block5: {
                    block3: {
                        if (!(object instanceof Vector)) break block3;
                        Vector vector = (Vector)object;
                        int n2 = 0;
                        int n3 = vector.size();
                        while (n2 < n3) {
                            defaultMutableTreeNode.add(new DynamicUtilTreeNode(vector.elementAt(n2), vector.elementAt(n2)));
                            ++n2;
                        }
                        break block4;
                    }
                    if (!(object instanceof Hashtable)) break block5;
                    Hashtable hashtable = (Hashtable)object;
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object object2 = enumeration.nextElement();
                        defaultMutableTreeNode.add(new DynamicUtilTreeNode(object2, hashtable.get(object2)));
                    }
                    break block4;
                }
                if (!(object instanceof Object[])) break block4;
                Object[] objectArray = (Object[])object;
                int n4 = 0;
                int n5 = objectArray.length;
                while (n4 < n5) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(objectArray[n4], objectArray[n4]));
                    ++n4;
                }
            }
        }
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        protected EmptySelectionModel() {
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }
    }

    protected class TreeModelHandler
    implements TreeModelListener {
        private final JTree this$0;

        protected TreeModelHandler(JTree jTree) {
            this.this$0 = jTree;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModel treeModel;
            if (treeModelEvent == null) {
                return;
            }
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray == null) {
                return;
            }
            Vector vector = new Vector(Math.max(1, objectArray.length));
            int n2 = objectArray.length - 1;
            while (n2 >= 0) {
                TreePath treePath2 = treePath.pathByAddingChild(objectArray[n2]);
                if (JTree.access$000(this.this$0).get(treePath2) != null) {
                    vector.addElement(treePath2);
                }
                --n2;
            }
            if (vector.size() > 0) {
                this.this$0.removeDescendantToggledPaths(vector.elements());
            }
            if ((treeModel = this.this$0.getModel()) == null || treeModel.isLeaf(treePath.getLastPathComponent())) {
                JTree.access$000(this.this$0).remove(treePath);
            }
            this.this$0.removeDescendantSelectedPaths(treeModelEvent);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent == null) {
                return;
            }
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath == null) {
                return;
            }
            if (treePath.getPathCount() == 1) {
                this.this$0.clearToggledPaths();
                if (this.this$0.treeModel.getRoot() != null && !this.this$0.treeModel.isLeaf(this.this$0.treeModel.getRoot())) {
                    JTree.access$000(this.this$0).put(treePath, Boolean.TRUE);
                }
            } else if (JTree.access$000(this.this$0).get(treePath) != null) {
                Vector vector = new Vector(1);
                boolean bl2 = this.this$0.isExpanded(treePath);
                vector.addElement(treePath);
                this.this$0.removeDescendantToggledPaths(vector.elements());
                if (bl2) {
                    TreeModel treeModel = this.this$0.getModel();
                    if (treeModel == null || treeModel.isLeaf(treePath.getLastPathComponent())) {
                        this.this$0.collapsePath(treePath);
                    } else {
                        JTree.access$000(this.this$0).put(treePath, Boolean.TRUE);
                    }
                }
            }
            this.this$0.removeDescendantSelectedPaths(treePath, false);
        }
    }

    protected class TreeSelectionRedirector
    implements Serializable,
    TreeSelectionListener {
        private final JTree this$0;

        protected TreeSelectionRedirector(JTree jTree) {
            this.this$0 = jTree;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(this.this$0);
            this.this$0.fireValueChanged(treeSelectionEvent2);
        }
    }
}

