/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final String uiClassID = "ScrollBarUI";
    private ChangeListener fwdAdjustmentEvents = new ModelListener(this, null);
    protected BoundedRangeModel model;
    protected int orientation;
    protected int unitIncrement;
    protected int blockIncrement;
    static Class class$java$awt$event$AdjustmentListener;

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public int getVisibleAmount() {
        return this.getModel().getExtent();
    }

    public JScrollBar() {
        this(1);
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public int getBlockIncrement(int n2) {
        return this.blockIncrement;
    }

    public int getUnitIncrement(int n2) {
        return this.unitIncrement;
    }

    public JScrollBar(int n2) {
        this(n2, 0, 10, 0, 100);
    }

    private void checkOrientation(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public void setBlockIncrement(int n2) {
        int n3 = this.blockIncrement;
        this.blockIncrement = n2;
        this.firePropertyChange("blockIncrement", n3, n2);
    }

    public void setMaximum(int n2) {
        this.getModel().setMaximum(n2);
    }

    public void setMinimum(int n2) {
        this.getModel().setMinimum(n2);
    }

    public void setOrientation(int n2) {
        this.checkOrientation(n2);
        int n3 = this.orientation;
        this.orientation = n2;
        this.firePropertyChange("orientation", n3, n2);
        if (n3 != n2 && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n3 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (n2 != n3) {
            this.revalidate();
        }
    }

    public void setUnitIncrement(int n2) {
        int n3 = this.unitIncrement;
        this.unitIncrement = n2;
        this.firePropertyChange("unitIncrement", n3, n2);
    }

    public void setValue(int n2) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n3 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n2);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n3), new Integer(boundedRangeModel.getValue()));
        }
    }

    public void setVisibleAmount(int n2) {
        this.getModel().setExtent(n2);
    }

    protected void fireAdjustmentValueChanged(int n2, int n3, int n4) {
        Object[] objectArray = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = null;
        int n5 = objectArray.length - 2;
        while (n5 >= 0) {
            if (objectArray[n5] == (class$java$awt$event$AdjustmentListener == null ? JScrollBar.class$("java.awt.event.AdjustmentListener") : class$java$awt$event$AdjustmentListener)) {
                if (adjustmentEvent == null) {
                    adjustmentEvent = new AdjustmentEvent(this, n2, n3, n4);
                }
                ((AdjustmentListener)objectArray[n5 + 1]).adjustmentValueChanged(adjustmentEvent);
            }
            n5 -= 2;
        }
    }

    public void setValues(int n2, int n3, int n4, int n5) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n6 = boundedRangeModel.getValue();
        boundedRangeModel.setRangeProperties(n2, n3, n4, n5, boundedRangeModel.getValueIsAdjusting());
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n6), new Integer(boundedRangeModel.getValue()));
        }
    }

    public JScrollBar(int n2, int n3, int n4, int n5, int n6) {
        this.checkOrientation(n2);
        this.unitIncrement = 1;
        this.blockIncrement = n4 == 0 ? 1 : n4;
        this.orientation = n2;
        this.model = new DefaultBoundedRangeModel(n3, n4, n5, n6);
        this.model.addChangeListener(this.fwdAdjustmentEvents);
        this.setRequestFocusEnabled(false);
        this.updateUI();
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            componentArray[n2].setEnabled(bl2);
            ++n2;
        }
    }

    public void setValueIsAdjusting(boolean bl2) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl3 = boundedRangeModel.getValueIsAdjusting();
        boundedRangeModel.setValueIsAdjusting(bl2);
        if (bl3 != bl2 && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl3 ? AccessibleState.BUSY : null, bl2 ? AccessibleState.BUSY : null);
        }
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.getOrientation() == 1) {
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.orientation == 1) {
            return new Dimension(dimension.width, 5);
        }
        return new Dimension(5, dimension.height);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.listenerList.getListeners(class$java$awt$event$AdjustmentListener == null ? (class$java$awt$event$AdjustmentListener = JScrollBar.class$("java.awt.event.AdjustmentListener")) : class$java$awt$event$AdjustmentListener);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.add(class$java$awt$event$AdjustmentListener == null ? (class$java$awt$event$AdjustmentListener = JScrollBar.class$("java.awt.event.AdjustmentListener")) : class$java$awt$event$AdjustmentListener, adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.remove(class$java$awt$event$AdjustmentListener == null ? (class$java$awt$event$AdjustmentListener = JScrollBar.class$("java.awt.event.AdjustmentListener")) : class$java$awt$event$AdjustmentListener, adjustmentListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",blockIncrement=" + this.blockIncrement + ",orientation=" + string + ",unitIncrement=" + this.unitIncrement;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar(this);
        }
        return this.accessibleContext;
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        Integer n2 = null;
        BoundedRangeModel boundedRangeModel2 = this.model;
        if (this.model != null) {
            this.model.removeChangeListener(this.fwdAdjustmentEvents);
            n2 = new Integer(this.model.getValue());
        }
        this.model = boundedRangeModel;
        if (this.model != null) {
            this.model.addChangeListener(this.fwdAdjustmentEvents);
        }
        this.firePropertyChange("model", boundedRangeModel2, this.model);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n2, new Integer(this.model.getValue()));
        }
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public void setUI(ScrollBarUI scrollBarUI) {
        super.setUI(scrollBarUI);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class 1 {
    }

    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private final JScrollBar this$0;

        public Number getCurrentAccessibleValue() {
            return new Integer(this.this$0.getValue());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(this.this$0.getMaximum());
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(this.this$0.getMinimum());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                this.this$0.setValue(number.intValue());
                return true;
            }
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (this.this$0.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        protected AccessibleJScrollBar(JScrollBar jScrollBar) {
            this.this$0 = jScrollBar;
            super(jScrollBar);
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private final JScrollBar this$0;

        private ModelListener(JScrollBar jScrollBar) {
            this.this$0 = jScrollBar;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2 = 601;
            int n3 = 5;
            this.this$0.fireAdjustmentValueChanged(n2, n3, this.this$0.getValue());
        }

        ModelListener(JScrollBar jScrollBar, 1 var2_2) {
            this(jScrollBar);
        }
    }
}

