/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class JFileChooser
extends JComponent
implements Accessible {
    private static final String uiClassID = "FileChooserUI";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY = "ApproveButtonMnemonicChangedProperty";
    public static final String CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY = "ControlButtonsAreShownChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    public static final String SELECTED_FILES_CHANGED_PROPERTY = "SelectedFilesChangedProperty";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "MultiSelectionEnabledChangedProperty";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY = "acceptAllFileFilterUsedChanged";
    public static final String DIALOG_TITLE_CHANGED_PROPERTY = "DialogTitleChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    private String dialogTitle = null;
    private String approveButtonText = null;
    private String approveButtonToolTipText = null;
    private int approveButtonMnemonic = 0;
    private ActionListener actionListener = null;
    private Vector filters = new Vector(5);
    private JDialog dialog = null;
    private int dialogType = 0;
    private int returnValue = -1;
    private JComponent accessory = null;
    private FileView fileView = null;
    private transient FileView uiFileView = null;
    private boolean controlsShown = true;
    private boolean useFileHiding = true;
    private int fileSelectionMode = 0;
    private boolean multiSelectionEnabled = false;
    private boolean useAcceptAllFileFilter = true;
    private boolean dragEnabled = false;
    private FileFilter fileFilter = null;
    private FileSystemView fileSystemView = null;
    private File currentDirectory = null;
    private File selectedFile = null;
    private File[] selectedFiles;
    protected AccessibleContext accessibleContext = null;
    static Class class$java$awt$Frame;
    static Class class$java$awt$event$ActionListener;

    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public JFileChooser() {
        this((File)null, (FileSystemView)null);
    }

    public void approveSelection() {
        this.returnValue = 0;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void changeToParentDirectory() {
        this.selectedFile = null;
        File file = this.getCurrentDirectory();
        this.setCurrentDirectory(this.getFileSystemView().getParentDirectory(file));
    }

    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory(this);
    }

    public void resetChoosableFileFilters() {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        this.setFileFilter(null);
        this.filters.removeAllElements();
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, this.getChoosableFileFilters());
    }

    public void updateUI() {
        if (this.isAcceptAllFileFilterUsed()) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        FileChooserUI fileChooserUI = (FileChooserUI)UIManager.getUI(this);
        if (this.fileSystemView == null) {
            this.setFileSystemView(FileSystemView.getFileSystemView());
        }
        this.setUI(fileChooserUI);
        this.uiFileView = this.getUI().getFileView(this);
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
    }

    public boolean getControlButtonsAreShown() {
        return this.controlsShown;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.useAcceptAllFileFilter;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    public boolean isFileHidingEnabled() {
        return this.useFileHiding;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setApproveButtonMnemonic(char n2) {
        int n3 = n2;
        if (n3 >= 97 && n3 <= 122) {
            n3 -= 32;
        }
        this.setApproveButtonMnemonic(n3);
    }

    public void setApproveButtonMnemonic(int n2) {
        if (this.approveButtonMnemonic == n2) {
            return;
        }
        int n3 = this.approveButtonMnemonic;
        this.approveButtonMnemonic = n2;
        this.firePropertyChange(APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY, n3, this.approveButtonMnemonic);
    }

    public void setDialogType(int n2) {
        if (this.dialogType == n2) {
            return;
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + n2);
        }
        int n3 = this.dialogType;
        this.dialogType = n2;
        if (n2 == 0 || n2 == 1) {
            this.setApproveButtonText(null);
        }
        this.firePropertyChange(DIALOG_TYPE_CHANGED_PROPERTY, n3, n2);
    }

    public void setFileSelectionMode(int n2) {
        if (this.fileSelectionMode == n2) {
            return;
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Incorrect Mode for Dialog: " + n2);
        }
        int n3 = this.fileSelectionMode;
        this.fileSelectionMode = n2;
        this.firePropertyChange(FILE_SELECTION_MODE_CHANGED_PROPERTY, n3, this.fileSelectionMode);
    }

    public void setAcceptAllFileFilterUsed(boolean bl2) {
        boolean bl3 = this.useAcceptAllFileFilter;
        this.useAcceptAllFileFilter = bl2;
        if (!bl2) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        } else {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange(ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY, bl3, this.useAcceptAllFileFilter);
    }

    public void setControlButtonsAreShown(boolean bl2) {
        if (this.controlsShown == bl2) {
            return;
        }
        boolean bl3 = this.controlsShown;
        this.controlsShown = bl2;
        this.firePropertyChange(CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY, bl3, this.controlsShown);
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public void setFileHidingEnabled(boolean bl2) {
        boolean bl3 = this.useFileHiding;
        this.useFileHiding = bl2;
        this.firePropertyChange(FILE_HIDING_CHANGED_PROPERTY, bl3, this.useFileHiding);
    }

    public void setMultiSelectionEnabled(boolean bl2) {
        if (this.multiSelectionEnabled == bl2) {
            return;
        }
        boolean bl3 = this.multiSelectionEnabled;
        this.multiSelectionEnabled = bl2;
        this.firePropertyChange(MULTI_SELECTION_ENABLED_CHANGED_PROPERTY, bl3, this.multiSelectionEnabled);
    }

    public int showOpenDialog(Component component) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(component, null);
    }

    public int showSaveDialog(Component component) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(component, null);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JFileChooser.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JFileChooser.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JFileChooser.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return new File[0];
        }
        return (File[])this.selectedFiles.clone();
    }

    public JFileChooser(File file) {
        this(file, (FileSystemView)null);
    }

    public void ensureFileIsVisible(File file) {
        this.getUI().ensureFileIsVisible(this, file);
    }

    public void setCurrentDirectory(File file) {
        File file2 = this.currentDirectory;
        if (file != null && !file.exists()) {
            file = this.currentDirectory;
        }
        if (file == null) {
            file = this.getFileSystemView().getDefaultDirectory();
        }
        if (this.currentDirectory != null && this.currentDirectory.equals(file)) {
            return;
        }
        File file3 = null;
        while (!this.isTraversable(file) && file3 != file) {
            file3 = file;
            file = this.getFileSystemView().getParentDirectory(file);
        }
        this.currentDirectory = file;
        this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, file2, this.currentDirectory);
    }

    public void setSelectedFile(File file) {
        File file2 = this.selectedFile;
        this.selectedFile = file;
        if (this.selectedFile != null) {
            if (file.isAbsolute() && !this.getFileSystemView().isParent(this.getCurrentDirectory(), this.selectedFile)) {
                this.setCurrentDirectory(this.selectedFile.getParentFile());
            }
            if (!this.isMultiSelectionEnabled() || this.selectedFiles == null || this.selectedFiles.length > 1) {
                this.ensureFileIsVisible(this.selectedFile);
            }
        }
        this.firePropertyChange(SELECTED_FILE_CHANGED_PROPERTY, file2, this.selectedFile);
    }

    public boolean accept(File file) {
        boolean bl2 = true;
        if (file != null && this.fileFilter != null) {
            bl2 = this.fileFilter.accept(file);
        }
        return bl2;
    }

    public boolean isTraversable(File file) {
        Boolean bl2 = null;
        if (file != null) {
            if (this.getFileView() != null) {
                bl2 = this.getFileView().isTraversable(file);
            }
            if (bl2 == null && this.uiFileView != null) {
                bl2 = this.uiFileView.isTraversable(file);
            }
            if (bl2 == null) {
                bl2 = this.getFileSystemView().isTraversable(file);
            }
        }
        return bl2 != null && bl2 != false;
    }

    public void setSelectedFiles(File[] fileArray) {
        File[] fileArray2 = this.selectedFiles;
        if (fileArray != null && fileArray.length == 0) {
            fileArray = null;
        }
        this.selectedFiles = fileArray;
        this.setSelectedFile(fileArray != null ? fileArray[0] : null);
        this.firePropertyChange(SELECTED_FILES_CHANGED_PROPERTY, fileArray2, this.selectedFiles);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        FileSystemView fileSystemView = null;
        if (this.isAcceptAllFileFilterUsed()) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        if (this.fileSystemView.equals(FileSystemView.getFileSystemView())) {
            fileSystemView = this.fileSystemView;
            this.fileSystemView = null;
        }
        objectOutputStream.defaultWriteObject();
        if (fileSystemView != null) {
            this.fileSystemView = fileSystemView;
        }
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string;
        String string2;
        String string3 = this.approveButtonText != null ? this.approveButtonText : "";
        String string4 = string2 = this.dialogTitle != null ? this.dialogTitle : "";
        String string5 = this.dialogType == 0 ? "OPEN_DIALOG" : (this.dialogType == 1 ? "SAVE_DIALOG" : (this.dialogType == 2 ? "CUSTOM_DIALOG" : ""));
        String string6 = this.returnValue == 1 ? "CANCEL_OPTION" : (this.returnValue == 0 ? "APPROVE_OPTION" : (this.returnValue == -1 ? "ERROR_OPTION" : ""));
        String string7 = string = this.useFileHiding ? "true" : "false";
        String string8 = this.fileSelectionMode == 0 ? "FILES_ONLY" : (this.fileSelectionMode == 1 ? "DIRECTORIES_ONLY" : (this.fileSelectionMode == 2 ? "FILES_AND_DIRECTORIES" : ""));
        String string9 = this.currentDirectory != null ? this.currentDirectory.toString() : "";
        String string10 = this.selectedFile != null ? this.selectedFile.toString() : "";
        return super.paramString() + ",approveButtonText=" + string3 + ",currentDirectory=" + string9 + ",dialogTitle=" + string2 + ",dialogType=" + string5 + ",fileSelectionMode=" + string8 + ",returnValue=" + string6 + ",selectedFile=" + string10 + ",useFileHiding=" + string;
    }

    public JFileChooser(String string) {
        this(string, (FileSystemView)null);
    }

    protected void fireActionPerformed(String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        long l2 = EventQueue.getMostRecentEventTime();
        int n2 = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n2 = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n2 = ((ActionEvent)aWTEvent).getModifiers();
        }
        ActionEvent actionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$java$awt$event$ActionListener == null ? JFileChooser.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, string, l2, n2);
                }
                ((ActionListener)objectArray[n3 + 1]).actionPerformed(actionEvent);
            }
            n3 -= 2;
        }
    }

    public void setApproveButtonText(String string) {
        if (this.approveButtonText == string) {
            return;
        }
        String string2 = this.approveButtonText;
        this.approveButtonText = string;
        this.firePropertyChange(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY, string2, string);
    }

    public void setApproveButtonToolTipText(String string) {
        if (this.approveButtonToolTipText == string) {
            return;
        }
        String string2 = this.approveButtonToolTipText;
        this.approveButtonToolTipText = string;
        this.firePropertyChange(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY, string2, this.approveButtonToolTipText);
    }

    public void setDialogTitle(String string) {
        String string2 = this.dialogTitle;
        this.dialogTitle = string;
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
        this.firePropertyChange(DIALOG_TITLE_CHANGED_PROPERTY, string2, string);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFileChooser(this);
        }
        return this.accessibleContext;
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent jComponent) {
        JComponent jComponent2 = this.accessory;
        this.accessory = jComponent;
        this.firePropertyChange(ACCESSORY_CHANGED_PROPERTY, jComponent2, this.accessory);
    }

    static int access$002(JFileChooser jFileChooser, int n2) {
        jFileChooser.returnValue = n2;
        return jFileChooser.returnValue;
    }

    public FileFilter getAcceptAllFileFilter() {
        FileFilter fileFilter = null;
        if (this.getUI() != null) {
            fileFilter = this.getUI().getAcceptAllFileFilter(this);
        }
        return fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public FileFilter[] getChoosableFileFilters() {
        Object[] objectArray = new FileFilter[this.filters.size()];
        this.filters.copyInto(objectArray);
        return objectArray;
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        if (fileFilter != null && !this.filters.contains(fileFilter)) {
            FileFilter[] fileFilterArray = this.getChoosableFileFilters();
            this.filters.addElement(fileFilter);
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, this.getChoosableFileFilters());
        }
        this.setFileFilter(fileFilter);
    }

    public void setFileFilter(FileFilter fileFilter) {
        FileFilter fileFilter2 = this.fileFilter;
        this.fileFilter = fileFilter;
        if (fileFilter != null) {
            if (this.isMultiSelectionEnabled() && this.selectedFiles != null && this.selectedFiles.length > 0) {
                Vector vector = new Vector();
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this.selectedFiles.length) {
                    if (fileFilter.accept(this.selectedFiles[n2])) {
                        vector.add(this.selectedFiles[n2]);
                    } else {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (bl2) {
                    this.setSelectedFiles(vector.size() == 0 ? null : (File[])vector.toArray(new File[vector.size()]));
                }
            } else if (this.selectedFile != null && !fileFilter.accept(this.selectedFile)) {
                this.setSelectedFile(null);
            }
        }
        this.firePropertyChange(FILE_FILTER_CHANGED_PROPERTY, fileFilter2, this.fileFilter);
    }

    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        if (this.filters.contains(fileFilter)) {
            if (this.getFileFilter() == fileFilter) {
                this.setFileFilter(null);
            }
            FileFilter[] fileFilterArray = this.getChoosableFileFilters();
            this.filters.removeElement(fileFilter);
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, this.getChoosableFileFilters());
            return true;
        }
        return false;
    }

    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public JFileChooser(FileSystemView fileSystemView) {
        this((File)null, fileSystemView);
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        FileSystemView fileSystemView2 = this.fileSystemView;
        this.fileSystemView = fileSystemView;
        this.firePropertyChange(FILE_SYSTEM_VIEW_CHANGED_PROPERTY, fileSystemView2, this.fileSystemView);
    }

    protected void setup(FileSystemView fileSystemView) {
        if (fileSystemView == null) {
            fileSystemView = FileSystemView.getFileSystemView();
        }
        this.setFileSystemView(fileSystemView);
        this.updateUI();
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
    }

    public FileView getFileView() {
        return this.fileView;
    }

    public void setFileView(FileView fileView) {
        FileView fileView2 = this.fileView;
        this.fileView = fileView;
        this.firePropertyChange(FILE_VIEW_CHANGED_PROPERTY, fileView2, fileView);
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.ui;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int showDialog(Component component, String string) throws HeadlessException {
        if (string != null) {
            this.setApproveButtonText(string);
            this.setDialogType(2);
        }
        this.dialog = this.createDialog(component);
        this.dialog.addWindowListener(new WindowAdapter(this){
            private final JFileChooser this$0;

            public void windowClosing(WindowEvent windowEvent) {
                JFileChooser.access$002(this.this$0, 1);
            }
            {
                this.this$0 = jFileChooser;
            }
        });
        this.returnValue = -1;
        this.rescanCurrentDirectory();
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    public String getDescription(File file) {
        String string = null;
        if (file != null) {
            if (this.getFileView() != null) {
                string = this.getFileView().getDescription(file);
            }
            if (string == null && this.uiFileView != null) {
                string = this.uiFileView.getDescription(file);
            }
        }
        return string;
    }

    public String getName(File file) {
        String string = null;
        if (file != null) {
            if (this.getFileView() != null) {
                string = this.getFileView().getName(file);
            }
            if (string == null && this.uiFileView != null) {
                string = this.uiFileView.getName(file);
            }
        }
        return string;
    }

    public String getTypeDescription(File file) {
        String string = null;
        if (file != null) {
            if (this.getFileView() != null) {
                string = this.getFileView().getTypeDescription(file);
            }
            if (string == null && this.uiFileView != null) {
                string = this.uiFileView.getTypeDescription(file);
            }
        }
        return string;
    }

    public Icon getIcon(File file) {
        Icon icon = null;
        if (file != null) {
            if (this.getFileView() != null) {
                icon = this.getFileView().getIcon(file);
            }
            if (icon == null && this.uiFileView != null) {
                icon = this.uiFileView.getIcon(file);
            }
        }
        return icon;
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        boolean bl2;
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JFileChooser.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        String string = this.getUI().getDialogTitle(this);
        JDialog jDialog = new JDialog(frame, string, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl2 = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            jDialog.getRootPane().setWindowDecorationStyle(6);
        }
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        return jDialog;
    }

    public JFileChooser(File file, FileSystemView fileSystemView) {
        this.setup(fileSystemView);
        this.setCurrentDirectory(file);
    }

    public JFileChooser(String string, FileSystemView fileSystemView) {
        this.setup(fileSystemView);
        if (string == null) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectory(this.fileSystemView.createFileObject(string));
        }
    }

    protected class AccessibleJFileChooser
    extends JComponent.AccessibleJComponent {
        private final JFileChooser this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILE_CHOOSER;
        }

        protected AccessibleJFileChooser(JFileChooser jFileChooser) {
            this.this$0 = jFileChooser;
            super(jFileChooser);
        }
    }
}

