/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.CompositeView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class JEditorPane
extends JTextComponent {
    PageStream loading;
    private EditorKit kit;
    private Hashtable pageProperties;
    private Hashtable typeHandlers;
    private static final Object kitRegistryKey = new StringBuffer("JEditorPane.kitRegistry");
    private static final Object kitTypeRegistryKey = new StringBuffer("JEditorPane.kitTypeRegistry");
    private static final Object kitLoaderRegistryKey = new StringBuffer("JEditorPane.kitLoaderRegistry");
    private static final String uiClassID = "EditorPaneUI";
    static Class class$javax$swing$event$HyperlinkListener;

    public JEditorPane() {
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(this){
            private final JEditorPane this$0;

            protected boolean accept(Component component) {
                return component != this.this$0 ? super.accept(component) : false;
            }
            {
                this.this$0 = jEditorPane;
            }

            public Component getDefaultComponent(Container container) {
                return container != this.this$0 || !this.this$0.isEditable() && this.this$0.getComponentCount() > 0 ? super.getDefaultComponent(container) : null;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (container != this.this$0 || !this.this$0.isEditable() && this.this$0.getComponentCount() > 0) {
                    return super.getComponentAfter(container, component);
                }
                Container container2 = this.this$0.getFocusCycleRootAncestor();
                return container2 != null ? container2.getFocusTraversalPolicy().getComponentAfter(container2, this.this$0) : null;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (container != this.this$0 || !this.this$0.isEditable() && this.this$0.getComponentCount() > 0) {
                    return super.getComponentBefore(container, component);
                }
                Container container2 = this.this$0.getFocusCycleRootAncestor();
                return container2 != null ? container2.getFocusTraversalPolicy().getComponentBefore(container2, this.this$0) : null;
            }
        });
        this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
        this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
    }

    private static void loadDefaultKitsIfNecessary() {
        if (SwingUtilities.appContextGet(kitTypeRegistryKey) == null) {
            Hashtable hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitTypeRegistryKey, hashtable);
            hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitLoaderRegistryKey, hashtable);
            JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
            JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
            JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
            JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n2 = jViewport.getHeight();
            Dimension dimension = textUI.getMinimumSize(this);
            if (n2 >= dimension.height) {
                Dimension dimension2 = textUI.getMaximumSize(this);
                if (n2 <= dimension2.height) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n2 = jViewport.getWidth();
            Dimension dimension = textUI.getMinimumSize(this);
            Dimension dimension2 = textUI.getMaximumSize(this);
            if (n2 >= dimension.width && n2 <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            Dimension dimension2;
            int n2;
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (!this.getScrollableTracksViewportWidth()) {
                n2 = jViewport.getWidth();
                dimension2 = textUI.getMinimumSize(this);
                if (n2 != 0 && n2 < dimension2.width) {
                    n3 = dimension2.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                n2 = jViewport.getHeight();
                dimension2 = textUI.getMinimumSize(this);
                if (n2 != 0 && n2 < dimension2.height) {
                    n4 = dimension2.height;
                }
            }
            if (n3 != dimension.width || n4 != dimension.height) {
                dimension = new Dimension(n3, n4);
            }
        }
        return dimension;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public final String getContentType() {
        return this.kit != null ? this.kit.getContentType() : null;
    }

    public String getText() {
        String string;
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.kit != null ? this.kit.toString() : "";
        String string2 = this.typeHandlers != null ? this.typeHandlers.toString() : "";
        return super.paramString() + ",kit=" + string + ",typeHandlers=" + string2;
    }

    public JEditorPane(String string) throws IOException {
        this();
        this.setPage(string);
    }

    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof StyledEditorKit) {
            try {
                Document document = this.getDocument();
                Caret caret = this.getCaret();
                int n2 = Math.min(caret.getDot(), caret.getMark());
                int n3 = Math.max(caret.getDot(), caret.getMark());
                if (n2 != n3) {
                    document.remove(n2, n3 - n2);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n2, string, ((StyledEditorKit)editorKit).getInputAttributes());
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        } else {
            super.replaceSelection(string);
        }
    }

    public void scrollToReference(String string) {
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            while (iterator.isValid()) {
                AttributeSet attributeSet = iterator.getAttributes();
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                if (string2 != null && string2.equals(string)) {
                    try {
                        Rectangle rectangle = this.modelToView(iterator.getStartOffset());
                        if (rectangle != null) {
                            Rectangle rectangle2 = this.getVisibleRect();
                            rectangle.height = rectangle2.height;
                            this.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        UIManager.getLookAndFeel().provideErrorFeedback(this);
                    }
                }
                iterator.next();
            }
        }
    }

    private void setCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            HeaderParser headerParser;
            int n2 = string.indexOf(59);
            if (n2 > -1 && n2 < string.length() - 1) {
                string = string.substring(n2 + 1);
            }
            if (string.length() > 0 && (string2 = (headerParser = new HeaderParser(string)).findValue("charset")) != null) {
                this.putClientProperty("charset", string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }

    public final void setContentType(String string) {
        Object object;
        int n2 = string.indexOf(";");
        if (n2 > -1) {
            object = string.substring(n2);
            if ((string = string.substring(0, n2).trim()).toLowerCase().startsWith("text/")) {
                this.setCharsetFromContentTypeParameters((String)object);
            }
        }
        if (!(this.kit != null && string.equals(this.kit.getContentType()) || (object = this.getEditorKitForContentType(string)) == null)) {
            this.setEditorKit((EditorKit)object);
        }
    }

    public void setPage(String string) throws IOException {
        if (string == null) {
            throw new IOException("invalid url");
        }
        URL uRL = new URL(string);
        this.setPage(uRL);
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            if (string == null || string.equals("")) {
                return;
            }
            StringReader stringReader = new StringReader(string);
            EditorKit editorKit = this.getEditorKit();
            editorKit.read(stringReader, document, 0);
        }
        catch (IOException iOException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    public URL getPage() {
        return (URL)this.getDocument().getProperty("stream");
    }

    public JEditorPane(URL uRL) throws IOException {
        this();
        this.setPage(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPage(URL uRL) throws IOException {
        Object object;
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        URL uRL2 = this.getPage();
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        boolean bl2 = false;
        if (uRL2 == null || !uRL2.sameFile(uRL)) {
            object = this.getStream(uRL);
            if (this.kit != null) {
                AbstractDocument abstractDocument;
                int n2;
                Object object2;
                Document document = this.kit.createDefaultDocument();
                if (this.pageProperties != null) {
                    object2 = this.pageProperties.keys();
                    while (object2.hasMoreElements()) {
                        Object object3 = object2.nextElement();
                        document.putProperty(object3, this.pageProperties.get(object3));
                    }
                    this.pageProperties.clear();
                }
                if (document.getProperty("stream") == null) {
                    document.putProperty("stream", uRL);
                }
                object2 = this;
                synchronized (object2) {
                    if (this.loading != null) {
                        this.loading.cancel();
                        this.loading = null;
                    }
                }
                if (document instanceof AbstractDocument && (n2 = (abstractDocument = (AbstractDocument)document).getAsynchronousLoadPriority()) >= 0) {
                    this.setDocument(document);
                    JEditorPane jEditorPane = this;
                    synchronized (jEditorPane) {
                        this.loading = new PageStream((InputStream)object);
                        PageLoader pageLoader = new PageLoader(this, document, this.loading, n2, uRL2, uRL);
                        pageLoader.start();
                    }
                    return;
                }
                this.read((InputStream)object, document);
                this.setDocument(document);
                bl2 = true;
            }
        }
        if ((object = uRL.getRef()) != null) {
            if (!bl2) {
                this.scrollToReference((String)object);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, (String)object){
                    private final String val$reference;
                    private final JEditorPane this$0;

                    public void run() {
                        this.this$0.scrollToReference(this.val$reference);
                    }
                    {
                        this.this$0 = jEditorPane;
                        this.val$reference = string;
                    }
                });
            }
        }
        this.firePropertyChange("page", uRL2, uRL);
    }

    private static Hashtable getKitLoaderRegistry() {
        JEditorPane.loadDefaultKitsIfNecessary();
        return (Hashtable)SwingUtilities.appContextGet(kitLoaderRegistryKey);
    }

    private static Hashtable getKitRegisty() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(kitRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable(3);
            SwingUtilities.appContextPut(kitRegistryKey, hashtable);
        }
        return hashtable;
    }

    private static Hashtable getKitTypeRegistry() {
        JEditorPane.loadDefaultKitsIfNecessary();
        return (Hashtable)SwingUtilities.appContextGet(kitTypeRegistryKey);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML(this) : new AccessibleJEditorPane(this);
        }
        return this.accessibleContext;
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$HyperlinkListener == null ? JEditorPane.class$("javax.swing.event.HyperlinkListener") : class$javax$swing$event$HyperlinkListener)) {
                ((HyperlinkListener)objectArray[n2 + 1]).hyperlinkUpdate(hyperlinkEvent);
            }
            n2 -= 2;
        }
    }

    public synchronized HyperlinkListener[] getHyperlinkListeners() {
        return (HyperlinkListener[])this.listenerList.getListeners(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener);
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = this.createDefaultEditorKit();
        }
        return this.kit;
    }

    public void setEditorKit(EditorKit editorKit) {
        EditorKit editorKit2 = this.kit;
        if (editorKit2 != null) {
            editorKit2.deinstall(this);
        }
        this.kit = editorKit;
        if (this.kit != null) {
            this.kit.install(this);
            this.setDocument(this.kit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
    }

    protected InputStream getStream(URL uRL) throws IOException {
        Object object;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            boolean bl2;
            object = (HttpURLConnection)uRLConnection;
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            int n2 = ((HttpURLConnection)object).getResponseCode();
            boolean bl3 = bl2 = n2 >= 300 && n2 <= 399;
            if (bl2) {
                String string = uRLConnection.getHeaderField("Location");
                uRL = string.startsWith("http", 0) ? new URL(string) : new URL(uRL, string);
                return this.getStream(uRL);
            }
        }
        if (this.pageProperties == null) {
            this.pageProperties = new Hashtable();
        }
        if ((object = uRLConnection.getContentType()) != null) {
            this.setContentType((String)object);
            this.pageProperties.put("content-type", object);
        }
        this.pageProperties.put("stream", uRL);
        String string = uRLConnection.getContentEncoding();
        if (string != null) {
            this.pageProperties.put("content-encoding", string);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        if (object instanceof HTMLDocument && this.kit instanceof HTMLEditorKit) {
            HTMLDocument hTMLDocument = (HTMLDocument)object;
            this.setDocument(hTMLDocument);
            this.read(inputStream, hTMLDocument);
        } else {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            super.read(inputStreamReader, object);
        }
    }

    public static String getEditorKitClassNameForContentType(String string) {
        return (String)JEditorPane.getKitTypeRegistry().get(string);
    }

    public JEditorPane(String string, String string2) {
        this();
        this.setContentType(string);
        this.setText(string2);
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        JEditorPane.registerEditorKitForContentType(string, string2, Thread.currentThread().getContextClassLoader());
    }

    void read(InputStream inputStream, Document document) throws IOException {
        try {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            this.kit.read(inputStreamReader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
        catch (ChangedCharSetException changedCharSetException) {
            String string = changedCharSetException.getCharSetSpec();
            if (changedCharSetException.keyEqualsCharSet()) {
                this.putClientProperty("charset", string);
            } else {
                this.setCharsetFromContentTypeParameters(string);
            }
            inputStream.close();
            URL uRL = (URL)document.getProperty("stream");
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            document.putProperty("IgnoreCharsetDirective", true);
            this.read(inputStream, document);
        }
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        Hashtable hashtable = JEditorPane.getKitRegisty();
        editorKit = (EditorKit)hashtable.get(string);
        if (editorKit == null) {
            String string2 = (String)JEditorPane.getKitTypeRegistry().get(string);
            ClassLoader classLoader = (ClassLoader)JEditorPane.getKitLoaderRegistry().get(string);
            try {
                Class clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                editorKit = (EditorKit)clazz.newInstance();
                hashtable.put(string, editorKit);
            }
            catch (Throwable throwable) {
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        return null;
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((editorKit = (EditorKit)this.typeHandlers.get(string)) == null && (editorKit = JEditorPane.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = this.createDefaultEditorKit();
        }
        return editorKit;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, editorKit);
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
        JEditorPane.getKitTypeRegistry().put(string, string2);
        JEditorPane.getKitLoaderRegistry().put(string, classLoader);
        JEditorPane.getKitRegisty().remove(string);
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        private final JEditorPane this$0;

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return this.this$0.getContentType();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }

        protected AccessibleJEditorPane(JEditorPane jEditorPane) {
            this.this$0 = jEditorPane;
            super(jEditorPane);
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        private AccessibleContext accessibleContext;
        private final JEditorPane this$0;

        public int getAccessibleChildrenCount() {
            if (this.accessibleContext != null) {
                return this.accessibleContext.getAccessibleChildrenCount();
            }
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            if (this.accessibleContext != null) {
                return this.accessibleContext.getAccessibleChild(n2);
            }
            return null;
        }

        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport(this.this$0);
        }

        protected AccessibleJEditorPaneHTML(JEditorPane jEditorPane) {
            this.this$0 = jEditorPane;
            super(jEditorPane);
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            this.accessibleContext = hTMLEditorKit.getAccessibleContext();
        }

        public Accessible getAccessibleAt(Point point) {
            if (this.accessibleContext != null && point != null) {
                try {
                    AccessibleComponent accessibleComponent = this.accessibleContext.getAccessibleComponent();
                    if (accessibleComponent != null) {
                        return accessibleComponent.getAccessibleAt(point);
                    }
                    return null;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    return null;
                }
            }
            return null;
        }
    }

    static class HeaderParser {
        String raw;
        String[][] tab;

        private void parse() {
            if (this.raw != null) {
                this.raw = this.raw.trim();
                char[] cArray = this.raw.toCharArray();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                boolean bl2 = true;
                boolean bl3 = false;
                int n5 = cArray.length;
                while (n3 < n5) {
                    char c2 = cArray[n3];
                    if (c2 == '=') {
                        this.tab[n4][0] = new String(cArray, n2, n3 - n2).toLowerCase();
                        bl2 = false;
                        n2 = ++n3;
                        continue;
                    }
                    if (c2 == '\"') {
                        if (bl3) {
                            this.tab[n4++][1] = new String(cArray, n2, n3 - n2);
                            bl3 = false;
                            while (++n3 < n5 && (cArray[n3] == ' ' || cArray[n3] == ',')) {
                            }
                            bl2 = true;
                            n2 = n3;
                            continue;
                        }
                        bl3 = true;
                        n2 = ++n3;
                        continue;
                    }
                    if (c2 == ' ' || c2 == ',') {
                        if (bl3) {
                            ++n3;
                            continue;
                        }
                        if (bl2) {
                            this.tab[n4++][0] = new String(cArray, n2, n3 - n2).toLowerCase();
                        } else {
                            this.tab[n4++][1] = new String(cArray, n2, n3 - n2);
                        }
                        while (n3 < n5 && (cArray[n3] == ' ' || cArray[n3] == ',')) {
                            ++n3;
                        }
                        bl2 = true;
                        n2 = n3;
                        continue;
                    }
                    ++n3;
                }
                if (--n3 > n2) {
                    if (!bl2) {
                        this.tab[n4++][1] = cArray[n3] == '\"' ? new String(cArray, n2, n3 - n2) : new String(cArray, n2, n3 - n2 + 1);
                    } else {
                        this.tab[n4][0] = new String(cArray, n2, n3 - n2 + 1).toLowerCase();
                    }
                } else if (n3 == n2) {
                    if (!bl2) {
                        this.tab[n4++][1] = cArray[n3] == '\"' ? String.valueOf(cArray[n3 - 1]) : String.valueOf(cArray[n3]);
                    } else {
                        this.tab[n4][0] = String.valueOf(cArray[n3]).toLowerCase();
                    }
                }
            }
        }

        public String findKey(int n2) {
            if (n2 < 0 || n2 > 10) {
                return null;
            }
            return this.tab[n2][0];
        }

        public String findValue(int n2) {
            if (n2 < 0 || n2 > 10) {
                return null;
            }
            return this.tab[n2][1];
        }

        public HeaderParser(String string) {
            this.raw = string;
            this.tab = new String[10][2];
            this.parse();
        }

        public int findInt(String string, int n2) {
            try {
                return Integer.parseInt(this.findValue(string, String.valueOf(n2)));
            }
            catch (Throwable throwable) {
                return n2;
            }
        }

        public String findValue(String string) {
            return this.findValue(string, null);
        }

        public String findValue(String string, String string2) {
            if (string == null) {
                return string2;
            }
            string.toLowerCase();
            int n2 = 0;
            while (n2 < 10) {
                if (this.tab[n2][0] == null) {
                    return string2;
                }
                if (string.equals(this.tab[n2][0])) {
                    return this.tab[n2][1];
                }
                ++n2;
            }
            return string2;
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        LinkVector hyperlinks;
        boolean linksValid;
        private final JEditorPane this$0;

        public int getLinkCount() {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            return this.hyperlinks.size();
        }

        private void buildLinkTable() {
            this.hyperlinks.removeAllElements();
            Document document = this.this$0.getDocument();
            if (document != null) {
                Element element;
                ElementIterator elementIterator = new ElementIterator(document);
                while ((element = elementIterator.next()) != null) {
                    String string;
                    if (!element.isLeaf()) continue;
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string == null) continue;
                    this.hyperlinks.addElement(new HTMLLink(this, element));
                }
            }
            this.linksValid = true;
        }

        public int getLinkIndex(int n2) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            Element element = null;
            Document document = this.this$0.getDocument();
            if (document != null) {
                element = document.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n3 = element.getElementIndex(n2);
                    element = element.getElement(n3);
                }
            }
            return this.hyperlinks.baseElementIndex(element);
        }

        public String getLinkText(int n2) {
            Document document;
            Element element;
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if ((element = (Element)this.hyperlinks.elementAt(n2)) != null && (document = this.this$0.getDocument()) != null) {
                try {
                    return document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        public AccessibleHyperlink getLink(int n2) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if (n2 >= 0 && n2 < this.hyperlinks.size()) {
                return (AccessibleHyperlink)this.hyperlinks.elementAt(n2);
            }
            return null;
        }

        public JEditorPaneAccessibleHypertextSupport(JEditorPane jEditorPane) {
            this.this$0 = jEditorPane;
            super(jEditorPane);
            this.linksValid = false;
            this.hyperlinks = new LinkVector(this, null);
            Document document = jEditorPane.getDocument();
            if (document != null) {
                document.addDocumentListener(new DocumentListener(this){
                    private final JEditorPaneAccessibleHypertextSupport this$1;
                    {
                        this.this$1 = jEditorPaneAccessibleHypertextSupport;
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }
                });
            }
        }

        static JEditorPane access$100(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport) {
            return jEditorPaneAccessibleHypertextSupport.this$0;
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;
            private final JEditorPaneAccessibleHypertextSupport this$1;

            public int getAccessibleActionCount() {
                return 1;
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public boolean isValid() {
                return this.this$1.linksValid;
            }

            public boolean doAccessibleAction(int n2) {
                URL uRL;
                if (n2 == 0 && this.isValid() && (uRL = (URL)this.getAccessibleActionObject(n2)) != null) {
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPaneAccessibleHypertextSupport.access$100(this.this$1), HyperlinkEvent.EventType.ACTIVATED, uRL);
                    JEditorPaneAccessibleHypertextSupport.access$100(this.this$1).fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                return false;
            }

            public Object getAccessibleActionAnchor(int n2) {
                return this.getAccessibleActionDescription(n2);
            }

            public Object getAccessibleActionObject(int n2) {
                if (n2 == 0 && this.isValid()) {
                    String string;
                    AttributeSet attributeSet = this.element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string != null) {
                        URL uRL;
                        try {
                            uRL = new URL(JEditorPaneAccessibleHypertextSupport.access$100(this.this$1).getPage(), string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                        return uRL;
                    }
                }
                return null;
            }

            public String getAccessibleActionDescription(int n2) {
                Document document;
                if (n2 == 0 && this.isValid() && (document = JEditorPaneAccessibleHypertextSupport.access$100(this.this$1).getDocument()) != null) {
                    try {
                        return document.getText(this.getStartIndex(), this.getEndIndex() - this.getStartIndex());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public HTMLLink(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport, Element element) {
                this.this$1 = jEditorPaneAccessibleHypertextSupport;
                this.element = element;
            }
        }

        private class LinkVector
        extends Vector {
            private final JEditorPaneAccessibleHypertextSupport this$1;

            private LinkVector(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport) {
                this.this$1 = jEditorPaneAccessibleHypertextSupport;
            }

            public int baseElementIndex(Element element) {
                int n2 = 0;
                while (n2 < this.elementCount) {
                    HTMLLink hTMLLink = (HTMLLink)this.elementAt(n2);
                    if (hTMLLink.element == element) {
                        return n2;
                    }
                    ++n2;
                }
                return -1;
            }

            LinkVector(JEditorPaneAccessibleHypertextSupport jEditorPaneAccessibleHypertextSupport, 1 var2_2) {
                this(jEditorPaneAccessibleHypertextSupport);
            }
        }
    }

    class PageLoader
    extends Thread {
        InputStream in;
        URL old;
        URL page;
        Document doc;
        private final JEditorPane this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block6: {
                    try {
                        this.this$0.read(this.in, this.doc);
                        JEditorPane jEditorPane = this.this$0;
                        synchronized (jEditorPane) {
                            this.this$0.loading = null;
                        }
                        URL uRL = (URL)this.doc.getProperty("stream");
                        String string = uRL.getRef();
                        if (string == null) break block6;
                        Runnable runnable = new Runnable(this){
                            private final PageLoader this$1;

                            public void run() {
                                URL uRL = (URL)PageLoader.access$000(this.this$1).getDocument().getProperty("stream");
                                String string = uRL.getRef();
                                PageLoader.access$000(this.this$1).scrollToReference(string);
                            }
                            {
                                this.this$1 = pageLoader;
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                    catch (IOException iOException) {
                        UIManager.getLookAndFeel().provideErrorFeedback(this.this$0);
                        Object var6_7 = null;
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final PageLoader this$1;

                            public void run() {
                                PageLoader.access$000(this.this$1).firePropertyChange("page", this.this$1.old, this.this$1.page);
                            }
                            {
                                this.this$1 = pageLoader;
                            }
                        });
                        return;
                    }
                }
                Object var6_6 = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        static JEditorPane access$000(PageLoader pageLoader) {
            return pageLoader.this$0;
        }

        PageLoader(JEditorPane jEditorPane, Document document, InputStream inputStream, int n2, URL uRL, URL uRL2) {
            this.this$0 = jEditorPane;
            this.setPriority(n2);
            this.in = inputStream;
            this.old = uRL;
            this.page = uRL2;
            this.doc = document;
        }
    }

    static class PageStream
    extends FilterInputStream {
        boolean canceled = false;

        public int available() throws IOException {
            this.checkCanceled();
            return super.available();
        }

        public int read() throws IOException {
            this.checkCanceled();
            return super.read();
        }

        public synchronized void cancel() {
            this.canceled = true;
        }

        protected synchronized void checkCanceled() throws IOException {
            if (this.canceled) {
                throw new IOException("page canceled");
            }
        }

        public void reset() throws IOException {
            this.checkCanceled();
            super.reset();
        }

        public long skip(long l2) throws IOException {
            this.checkCanceled();
            return super.skip(l2);
        }

        public PageStream(InputStream inputStream) {
            super(inputStream);
        }
    }

    static class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        PlainEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element element) {
            Document document = element.getDocument();
            Object object = document.getProperty("i18n");
            if (object != null && object.equals(Boolean.TRUE)) {
                return this.createI18N(element);
            }
            return new WrappedPlainView(element);
        }

        View createI18N(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new PlainParagraph(element);
                }
                if (string.equals("paragraph")) {
                    return new BoxView(element, 1);
                }
            }
            return null;
        }

        static class PlainParagraph
        extends ParagraphView {
            protected void setPropertiesFromAttributes() {
                Container container = this.getContainer();
                if (container != null && !container.getComponentOrientation().isLeftToRight()) {
                    this.setJustification(2);
                } else {
                    this.setJustification(0);
                }
            }

            public int getFlowSpan(int n2) {
                JTextArea jTextArea;
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    return Integer.MAX_VALUE;
                }
                return super.getFlowSpan(n2);
            }

            PlainParagraph(Element element) {
                super(element);
                this.layoutPool = new LogicalView(element);
                this.layoutPool.setParent(this);
            }

            protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
                JTextArea jTextArea;
                SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n2, sizeRequirements);
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    sizeRequirements2.minimum = sizeRequirements2.preferred;
                }
                return sizeRequirements2;
            }

            static class LogicalView
            extends CompositeView {
                public float getPreferredSpan(int n2) {
                    if (this.getViewCount() != 1) {
                        throw new Error("One child view is assumed.");
                    }
                    View view = this.getView(0);
                    return view.getPreferredSpan(n2);
                }

                protected int getViewIndexAtPosition(int n2) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        return element.getElementIndex(n2);
                    }
                    return 0;
                }

                protected boolean isAfter(int n2, int n3, Rectangle rectangle) {
                    return false;
                }

                protected boolean isBefore(int n2, int n3, Rectangle rectangle) {
                    return false;
                }

                protected void childAllocation(int n2, Rectangle rectangle) {
                }

                LogicalView(Element element) {
                    super(element);
                }

                protected void loadChildren(ViewFactory viewFactory) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        super.loadChildren(viewFactory);
                    } else {
                        GlyphView glyphView = new GlyphView(element);
                        this.append(glyphView);
                    }
                }

                public void paint(Graphics graphics, Shape shape) {
                }

                protected View getViewAtPoint(int n2, int n3, Rectangle rectangle) {
                    return null;
                }

                protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
                    return false;
                }

                protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
                    view.setParent(this);
                    super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
                }
            }
        }
    }
}

