/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultListSelectionModel
implements ListSelectionModel,
Cloneable,
Serializable {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int selectionMode = 2;
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = -1;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private int firstAdjustedIndex = Integer.MAX_VALUE;
    private int lastAdjustedIndex = -1;
    private boolean isAdjusting = false;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private BitSet value = new BitSet(32);
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean leadAnchorNotificationEnabled = true;
    static Class class$javax$swing$event$ListSelectionListener;

    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    public int getMinSelectionIndex() {
        return this.isSelectionEmpty() ? -1 : this.minIndex;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void clearSelection() {
        this.removeSelectionInterval(this.minIndex, this.maxIndex);
    }

    private void fireValueChanged() {
        if (this.lastAdjustedIndex == -1) {
            return;
        }
        if (this.getValueIsAdjusting()) {
            this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
            this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
        }
        int n2 = this.firstAdjustedIndex;
        int n3 = this.lastAdjustedIndex;
        this.firstAdjustedIndex = Integer.MAX_VALUE;
        this.lastAdjustedIndex = -1;
        this.fireValueChanged(n2, n3);
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public boolean isSelectionEmpty() {
        return this.minIndex > this.maxIndex;
    }

    private void clear(int n2) {
        if (!this.value.get(n2)) {
            return;
        }
        this.value.clear(n2);
        this.markAsDirty(n2);
        if (n2 == this.minIndex) {
            ++this.minIndex;
            while (this.minIndex <= this.maxIndex) {
                if (this.value.get(this.minIndex)) break;
                ++this.minIndex;
            }
        }
        if (n2 == this.maxIndex) {
            --this.maxIndex;
            while (this.minIndex <= this.maxIndex) {
                if (this.value.get(this.maxIndex)) break;
                --this.maxIndex;
            }
        }
        if (this.isSelectionEmpty()) {
            this.minIndex = Integer.MAX_VALUE;
            this.maxIndex = -1;
        }
    }

    private void markAsDirty(int n2) {
        this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, n2);
        this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, n2);
    }

    private void set(int n2) {
        if (this.value.get(n2)) {
            return;
        }
        this.value.set(n2);
        this.markAsDirty(n2);
        this.minIndex = Math.min(this.minIndex, n2);
        this.maxIndex = Math.max(this.maxIndex, n2);
    }

    public void setAnchorSelectionIndex(int n2) {
        this.updateLeadAnchorIndices(n2, this.leadIndex);
        this.anchorIndex = n2;
        this.fireValueChanged();
    }

    public void setLeadSelectionIndex(int n2) {
        int n3 = this.anchorIndex;
        if (n3 == -1 || n2 == -1) {
            return;
        }
        if (this.leadIndex == -1) {
            this.leadIndex = n2;
        }
        boolean bl2 = this.value.get(this.anchorIndex);
        if (this.getSelectionMode() == 0) {
            n3 = n2;
            bl2 = true;
        }
        int n4 = Math.min(this.anchorIndex, this.leadIndex);
        int n5 = Math.max(this.anchorIndex, this.leadIndex);
        int n6 = Math.min(n3, n2);
        int n7 = Math.max(n3, n2);
        this.updateLeadAnchorIndices(n3, n2);
        if (bl2) {
            this.changeSelection(n4, n5, n6, n7);
        } else {
            this.changeSelection(n6, n7, n4, n5, false);
        }
    }

    public void setSelectionMode(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    public boolean isSelectedIndex(int n2) {
        return n2 < this.minIndex || n2 > this.maxIndex ? false : this.value.get(n2);
    }

    public void addSelectionInterval(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            return;
        }
        if (this.getSelectionMode() != 2) {
            this.setSelectionInterval(n2, n3);
            return;
        }
        this.updateLeadAnchorIndices(n2, n3);
        int n4 = Integer.MAX_VALUE;
        int n5 = -1;
        int n6 = Math.min(n2, n3);
        int n7 = Math.max(n2, n3);
        this.changeSelection(n4, n5, n6, n7);
    }

    protected void fireValueChanged(int n2, int n3) {
        this.fireValueChanged(n2, n3, this.getValueIsAdjusting());
    }

    public void removeIndexInterval(int n2, int n3) {
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        int n6 = n5 - n4 + 1;
        int n7 = n4;
        while (n7 <= this.maxIndex) {
            this.setState(n7, this.value.get(n7 + n6));
            ++n7;
        }
        this.fireValueChanged();
    }

    public void removeSelectionInterval(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            return;
        }
        this.updateLeadAnchorIndices(n2, n3);
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        int n6 = Integer.MAX_VALUE;
        int n7 = -1;
        if (this.getSelectionMode() != 2 && n4 > this.minIndex && n5 < this.maxIndex) {
            n5 = this.maxIndex;
        }
        this.changeSelection(n4, n5, n6, n7);
    }

    public void setSelectionInterval(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            return;
        }
        if (this.getSelectionMode() == 0) {
            n2 = n3;
        }
        this.updateLeadAnchorIndices(n2, n3);
        int n4 = this.minIndex;
        int n5 = this.maxIndex;
        int n6 = Math.min(n2, n3);
        int n7 = Math.max(n2, n3);
        this.changeSelection(n4, n5, n6, n7);
    }

    private void updateLeadAnchorIndices(int n2, int n3) {
        if (this.leadAnchorNotificationEnabled) {
            if (this.anchorIndex != n2) {
                if (this.anchorIndex != -1) {
                    this.markAsDirty(this.anchorIndex);
                }
                this.markAsDirty(n2);
            }
            if (this.leadIndex != n3) {
                if (this.leadIndex != -1) {
                    this.markAsDirty(this.leadIndex);
                }
                this.markAsDirty(n3);
            }
        }
        this.anchorIndex = n2;
        this.leadIndex = n3;
    }

    private boolean contains(int n2, int n3, int n4) {
        return n4 >= n2 && n4 <= n3;
    }

    private void changeSelection(int n2, int n3, int n4, int n5) {
        this.changeSelection(n2, n3, n4, n5, true);
    }

    private void changeSelection(int n2, int n3, int n4, int n5, boolean bl2) {
        int n6 = Math.min(n4, n2);
        while (n6 <= Math.max(n5, n3)) {
            boolean bl3 = this.contains(n2, n3, n6);
            boolean bl4 = this.contains(n4, n5, n6);
            if (bl4 && bl3) {
                if (bl2) {
                    bl3 = false;
                } else {
                    bl4 = false;
                }
            }
            if (bl4) {
                this.set(n6);
            }
            if (bl3) {
                this.clear(n6);
            }
            ++n6;
        }
        this.fireValueChanged();
    }

    protected void fireValueChanged(int n2, int n3, boolean bl2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n4 = objectArray.length - 2;
        while (n4 >= 0) {
            if (objectArray[n4] == (class$javax$swing$event$ListSelectionListener == null ? DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n2, n3, bl2);
                }
                ((ListSelectionListener)objectArray[n4 + 1]).valueChanged(listSelectionEvent);
            }
            n4 -= 2;
        }
    }

    public void insertIndexInterval(int n2, int n3, boolean bl2) {
        int n4 = bl2 ? n2 : n2 + 1;
        int n5 = n4 + n3 - 1;
        int n6 = this.maxIndex;
        while (n6 >= n4) {
            this.setState(n6 + n3, this.value.get(n6));
            --n6;
        }
        boolean bl3 = this.getSelectionMode() == 0 ? false : this.value.get(n2);
        int n7 = n4;
        while (n7 <= n5) {
            this.setState(n7, bl3);
            ++n7;
        }
        this.fireValueChanged();
    }

    private void setState(int n2, boolean bl2) {
        if (bl2) {
            this.set(n2);
        } else {
            this.clear(n2);
        }
    }

    protected void fireValueChanged(boolean bl2) {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int n2 = this.firstChangedIndex;
        int n3 = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(n2, n3, bl2);
    }

    public void setLeadAnchorNotificationEnabled(boolean bl2) {
        this.leadAnchorNotificationEnabled = bl2;
    }

    public void setValueIsAdjusting(boolean bl2) {
        if (bl2 != this.isAdjusting) {
            this.isAdjusting = bl2;
            this.fireValueChanged(bl2);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)super.clone();
        defaultListSelectionModel.value = (BitSet)this.value.clone();
        defaultListSelectionModel.listenerList = new EventListenerList();
        return defaultListSelectionModel;
    }

    public String toString() {
        String string = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
        return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + string;
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

