/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    static final int DEFAULT_DRAG_MODE = 0;
    static final int OUTLINE_DRAG_MODE = 1;
    static final int FASTER_DRAG_MODE = 2;
    int dragMode = 0;
    private transient Rectangle currentBounds = null;
    private transient Graphics desktopGraphics = null;
    private transient Rectangle desktopBounds = null;
    private transient Rectangle[] floatingItems = new Rectangle[0];
    private transient Point currentLoc = null;

    void activateNextFrame(Container container) {
        JInternalFrame jInternalFrame = null;
        if (container == null) {
            return;
        }
        int n2 = 0;
        while (n2 < container.getComponentCount()) {
            if (container.getComponent(n2) instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container.getComponent(n2);
                break;
            }
            ++n2;
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            jInternalFrame.moveToFront();
        }
    }

    public void beginDraggingFrame(JComponent jComponent) {
        this.setupDragMode(jComponent);
        if (this.dragMode == 2) {
            this.floatingItems = this.findFloatingItems(jComponent);
            this.currentBounds = jComponent.getBounds();
            this.desktopBounds = jComponent.getParent().getBounds();
            this.desktopBounds.x = 0;
            this.desktopBounds.y = 0;
            this.desktopGraphics = jComponent.getParent().getGraphics();
            ((JInternalFrame)jComponent).isDragging = true;
        }
    }

    private void emergencyCleanup(JComponent jComponent) {
        if (((JInternalFrame)jComponent).danger) {
            SwingUtilities.invokeLater(new Runnable(this, jComponent){
                private final JComponent val$f;
                private final DefaultDesktopManager this$0;

                public void run() {
                    ((JInternalFrame)this.val$f).isDragging = false;
                    this.val$f.paintImmediately(0, 0, this.val$f.getWidth(), this.val$f.getHeight());
                    ((JInternalFrame)this.val$f).isDragging = true;
                }
                {
                    this.this$0 = defaultDesktopManager;
                    this.val$f = jComponent;
                }
            });
            ((JInternalFrame)jComponent).danger = false;
        }
    }

    public void endDraggingFrame(JComponent jComponent) {
        if (this.dragMode == 1 && this.currentLoc != null) {
            this.setBoundsForFrame(jComponent, this.currentLoc.x, this.currentLoc.y, jComponent.getWidth(), jComponent.getHeight());
            this.currentLoc = null;
        } else if (this.dragMode == 2) {
            this.currentBounds = null;
            if (this.desktopGraphics != null) {
                this.desktopGraphics.dispose();
                this.desktopGraphics = null;
            }
            this.desktopBounds = null;
            ((JInternalFrame)jComponent).isDragging = false;
        }
    }

    public void endResizingFrame(JComponent jComponent) {
        if (this.dragMode == 1 && this.currentBounds != null) {
            this.setBoundsForFrame(jComponent, this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
            this.currentBounds = null;
        }
    }

    private void setupDragMode(JComponent jComponent) {
        JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
        if (jDesktopPane != null) {
            String string = (String)jDesktopPane.getClientProperty("JDesktopPane.dragMode");
            this.dragMode = string != null && string.equals("outline") ? 1 : (string != null && string.equals("faster") && jComponent instanceof JInternalFrame ? 2 : (jDesktopPane.getDragMode() == JDesktopPane.OUTLINE_DRAG_MODE ? 1 : (jDesktopPane.getDragMode() == JDesktopPane.LIVE_DRAG_MODE && jComponent instanceof JInternalFrame ? 2 : 0)));
        }
    }

    public void beginResizingFrame(JComponent jComponent, int n2) {
        this.setupDragMode(jComponent);
    }

    public void dragFrame(JComponent jComponent, int n2, int n3) {
        if (this.dragMode == 1) {
            JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
            if (jDesktopPane != null) {
                Graphics graphics = jDesktopPane.getGraphics();
                graphics.setXORMode(Color.white);
                if (this.currentLoc != null) {
                    graphics.drawRect(this.currentLoc.x, this.currentLoc.y, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                }
                graphics.drawRect(n2, n3, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                this.currentLoc = new Point(n2, n3);
                graphics.dispose();
            }
        } else if (this.dragMode == 2) {
            this.dragFrameFaster(jComponent, n2, n3);
        } else {
            this.setBoundsForFrame(jComponent, n2, n3, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    private void dragFrameFaster(JComponent jComponent, int n2, int n3) {
        Rectangle rectangle = new Rectangle(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
        this.currentBounds.x = n2;
        this.currentBounds.y = n3;
        this.emergencyCleanup(jComponent);
        boolean bl2 = this.isFloaterCollision(rectangle, this.currentBounds);
        Rectangle rectangle2 = rectangle.intersection(this.desktopBounds);
        if (!bl2) {
            this.desktopGraphics.copyArea(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n2 - rectangle.x, n3 - rectangle.y);
        }
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        jComponent.setBounds(this.currentBounds);
        if (bl2) {
            ((JInternalFrame)jComponent).isDragging = false;
            jComponent2.paintImmediately(this.currentBounds);
            ((JInternalFrame)jComponent).isDragging = true;
        }
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        repaintManager.markCompletelyClean(jComponent2);
        repaintManager.markCompletelyClean(jComponent);
        Rectangle[] rectangleArray = null;
        rectangleArray = rectangle.intersects(this.currentBounds) ? SwingUtilities.computeDifference(rectangle, this.currentBounds) : new Rectangle[]{rectangle};
        int n4 = 0;
        while (n4 < rectangleArray.length) {
            jComponent2.paintImmediately(rectangleArray[n4]);
            ++n4;
        }
        if (!rectangle2.equals(rectangle)) {
            rectangleArray = SwingUtilities.computeDifference(rectangle, this.desktopBounds);
            int n5 = 0;
            while (n5 < rectangleArray.length) {
                rectangleArray[n5].x += n2 - rectangle.x;
                rectangleArray[n5].y += n3 - rectangle.y;
                ((JInternalFrame)jComponent).isDragging = false;
                jComponent2.paintImmediately(rectangleArray[n5]);
                ((JInternalFrame)jComponent).isDragging = true;
                ++n5;
            }
        }
    }

    public void resizeFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
        if (this.dragMode == 0 || this.dragMode == 2) {
            this.setBoundsForFrame(jComponent, n2, n3, n4, n5);
        } else {
            JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
            if (jDesktopPane != null) {
                Graphics graphics = jDesktopPane.getGraphics();
                graphics.setXORMode(Color.white);
                if (this.currentBounds != null) {
                    graphics.drawRect(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width - 1, this.currentBounds.height - 1);
                }
                graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
                this.currentBounds = new Rectangle(n2, n3, n4, n5);
                graphics.setPaintMode();
                graphics.dispose();
            }
        }
    }

    public void setBoundsForFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
        boolean bl2 = jComponent.getWidth() != n4 || jComponent.getHeight() != n5;
        jComponent.setBounds(n2, n3, n4, n5);
        if (bl2) {
            jComponent.validate();
        }
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        Container container = jInternalFrame.getParent();
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame jInternalFrame3 = jInternalFrame2 = jDesktopPane == null ? null : jDesktopPane.getSelectedFrame();
        if (container == null && (container = jInternalFrame.getDesktopIcon().getParent()) == null) {
            return;
        }
        if (jInternalFrame2 == null) {
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(jInternalFrame);
            }
        } else if (jInternalFrame2 != jInternalFrame) {
            if (jInternalFrame2.isSelected()) {
                try {
                    jInternalFrame2.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(jInternalFrame);
            }
        }
        jInternalFrame.moveToFront();
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        boolean bl2 = jInternalFrame.isSelected();
        Container container = jInternalFrame.getParent();
        if (bl2) {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (container != null) {
            container.remove(jInternalFrame);
            container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        }
        this.removeIconFor(jInternalFrame);
        if (jInternalFrame.getNormalBounds() != null) {
            jInternalFrame.setNormalBounds(null);
        }
        if (this.wasIcon(jInternalFrame)) {
            this.setWasIcon(jInternalFrame, null);
        }
        if (bl2) {
            this.activateNextFrame(container);
        }
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame jInternalFrame3 = jInternalFrame2 = jDesktopPane == null ? null : jDesktopPane.getSelectedFrame();
        if (jInternalFrame2 == jInternalFrame) {
            jDesktopPane.setSelectedFrame(null);
        }
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        block4: {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            if (jDesktopIcon.getParent() == null) break block4;
            jDesktopIcon.getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
            if (jInternalFrame.isSelected()) {
                jInternalFrame.moveToFront();
            } else {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        Container container;
        Serializable serializable;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        boolean bl2 = jInternalFrame.isSelected();
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (!this.wasIcon(jInternalFrame)) {
            serializable = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(serializable.x, serializable.y, serializable.width, serializable.height);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        if ((container = jInternalFrame.getParent()) == null) {
            return;
        }
        if (container instanceof JLayeredPane) {
            serializable = (JLayeredPane)container;
            int n2 = JLayeredPane.getLayer(jInternalFrame);
            JLayeredPane.putLayer(jDesktopIcon, n2);
        }
        if (jInternalFrame.isMaximum()) {
            try {
                jInternalFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        container.remove(jInternalFrame);
        container.add(jDesktopIcon);
        container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        try {
            jInternalFrame.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (bl2) {
            this.activateNextFrame(container);
        }
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle;
        if (!jInternalFrame.isIcon()) {
            rectangle = jInternalFrame.getParent().getBounds();
        } else {
            Container container = jInternalFrame.getDesktopIcon().getParent();
            if (container == null) {
                return;
            }
            rectangle = container.getBounds();
            try {
                jInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
        this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.removeIconFor(jInternalFrame);
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getNormalBounds() != null) {
            Rectangle rectangle = jInternalFrame.getNormalBounds();
            jInternalFrame.setNormalBounds(null);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.removeIconFor(jInternalFrame);
    }

    public void openFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getDesktopIcon().getParent() != null) {
            jInternalFrame.getDesktopIcon().getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
        }
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        if (container != null) {
            container.remove(jDesktopIcon);
            container.repaint(jDesktopIcon.getX(), jDesktopIcon.getY(), jDesktopIcon.getWidth(), jDesktopIcon.getHeight());
        }
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }

    private boolean isFloaterCollision(Rectangle rectangle, Rectangle rectangle2) {
        if (this.floatingItems.length == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.floatingItems.length) {
            boolean bl2 = rectangle.intersects(this.floatingItems[n2]);
            if (bl2) {
                return true;
            }
            boolean bl3 = rectangle2.intersects(this.floatingItems[n2]);
            if (bl3) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Rectangle[] findFloatingItems(JComponent jComponent) {
        Container container = jComponent.getParent();
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] == jComponent) break;
            ++n2;
        }
        Rectangle[] rectangleArray = new Rectangle[n2];
        n2 = 0;
        while (n2 < rectangleArray.length) {
            rectangleArray[n2] = componentArray[n2].getBounds();
            ++n2;
        }
        return rectangleArray;
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Dimension dimension = jDesktopIcon.getPreferredSize();
        Container container = jInternalFrame.getParent();
        if (container == null) {
            return new Rectangle(0, 0, dimension.width, dimension.height);
        }
        Rectangle rectangle = container.getBounds();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle2 = null;
        Component component = null;
        int n2 = 0;
        int n3 = rectangle.height - dimension.height;
        int n4 = dimension.width;
        int n5 = dimension.height;
        boolean bl2 = false;
        while (!bl2) {
            rectangle2 = new Rectangle(n2, n3, n4, n5);
            bl2 = true;
            int n6 = 0;
            while (n6 < componentArray.length) {
                block10: {
                    block9: {
                        block8: {
                            if (!(componentArray[n6] instanceof JInternalFrame)) break block8;
                            component = ((JInternalFrame)componentArray[n6]).getDesktopIcon();
                            break block9;
                        }
                        if (!(componentArray[n6] instanceof JInternalFrame.JDesktopIcon)) break block10;
                        component = (JInternalFrame.JDesktopIcon)componentArray[n6];
                    }
                    if (!component.equals(jDesktopIcon) && rectangle2.intersects(component.getBounds())) {
                        bl2 = false;
                        break;
                    }
                }
                ++n6;
            }
            if (component == null) {
                return rectangle2;
            }
            if ((n2 += component.getBounds().width) + n4 <= rectangle.width) continue;
            n2 = 0;
            n3 -= n5;
        }
        return rectangle2;
    }

    protected Rectangle getPreviousBounds(JInternalFrame jInternalFrame) {
        return jInternalFrame.getNormalBounds();
    }

    protected void setPreviousBounds(JInternalFrame jInternalFrame, Rectangle rectangle) {
        jInternalFrame.setNormalBounds(rectangle);
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl2) {
        if (bl2 != null) {
            jInternalFrame.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, bl2);
        }
    }

    JDesktopPane getDesktopPane(JComponent jComponent) {
        JDesktopPane jDesktopPane = null;
        Container container = jComponent.getParent();
        while (jDesktopPane == null) {
            if (container instanceof JDesktopPane) {
                jDesktopPane = (JDesktopPane)container;
                continue;
            }
            if (container == null) break;
            container = container.getParent();
        }
        return jDesktopPane;
    }
}

