/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class BoxLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private int axis;
    private Container target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private transient PrintStream dbg;

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n2 = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n2];
            this.yChildren = new SizeRequirements[n2];
            int n3 = 0;
            while (n3 < n2) {
                Component component = this.target.getComponent(n3);
                if (!component.isVisible()) {
                    this.xChildren[n3] = new SizeRequirements(0, 0, 0, component.getAlignmentX());
                    this.yChildren[n3] = new SizeRequirements(0, 0, 0, component.getAlignmentY());
                } else {
                    Dimension dimension = component.getMinimumSize();
                    Dimension dimension2 = component.getPreferredSize();
                    Dimension dimension3 = component.getMaximumSize();
                    this.xChildren[n3] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, component.getAlignmentX());
                    this.yChildren[n3] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, component.getAlignmentY());
                }
                ++n3;
            }
            int n4 = this.resolveAxis(this.axis, this.target.getComponentOrientation());
            if (n4 == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    private int resolveAxis(int n2, ComponentOrientation componentOrientation) {
        int n3 = n2 == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n2 == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n2);
        return n3;
    }

    public synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    void checkContainer(Container container) {
        if (this.target != container) {
            throw new AWTError("BoxLayout can't be shared");
        }
    }

    public synchronized void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        this.checkContainer(container);
        int n2 = container.getComponentCount();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        int n3 = this.resolveAxis(this.axis, componentOrientation);
        boolean bl2 = n3 != this.axis ? componentOrientation.isLeftToRight() : true;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            this.checkRequests();
            if (n3 == 0) {
                SizeRequirements.calculateTiledPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2, bl2);
                SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
            } else {
                SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2, bl2);
                SizeRequirements.calculateTiledPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
            }
        }
        int n4 = 0;
        while (n4 < n2) {
            Component component = container.getComponent(n4);
            component.setBounds((int)Math.min((long)insets.left + (long)nArray[n4], Integer.MAX_VALUE), (int)Math.min((long)insets.top + (long)nArray3[n4], Integer.MAX_VALUE), nArray2[n4], nArray4[n4]);
            ++n4;
        }
        if (this.dbg != null) {
            int n5 = 0;
            while (n5 < n2) {
                Component component = container.getComponent(n5);
                this.dbg.println(component.toString());
                this.dbg.println("X: " + this.xChildren[n5]);
                this.dbg.println("Y: " + this.yChildren[n5]);
                ++n5;
            }
        }
    }

    public BoxLayout(Container container, int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new AWTError("Invalid axis");
        }
        this.axis = n2;
        this.target = container;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        }
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        }
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    BoxLayout(Container container, int n2, PrintStream printStream) {
        this(container, n2);
        this.dbg = printStream;
    }

    public void addLayoutComponent(Component component, Object object) {
    }
}

