/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    protected Vector tracks = new Vector();

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondLength() {
        int n2;
        long l2 = this.getTickLength();
        if (this.divisionType != 0.0f) {
            double d2 = (double)this.getTickLength() / (double)(this.divisionType * (float)this.resolution);
            return (long)(1.0E9 * d2);
        }
        Track track = new Track();
        Track track2 = null;
        MidiEvent midiEvent = null;
        MidiMessage midiMessage = null;
        Object var9_7 = null;
        Vector vector = this.tracks;
        synchronized (vector) {
            n2 = 0;
            while (n2 < this.tracks.size()) {
                track2 = (Track)this.tracks.elementAt(n2);
                int n3 = 0;
                while (n3 < track2.size()) {
                    midiEvent = track2.get(n3);
                    midiMessage = midiEvent.getMessage();
                    if (midiMessage instanceof MetaMessage && ((MetaMessage)midiMessage).getType() == 81) {
                        track.add(midiEvent);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        n2 = 500000;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        int n4 = 0;
        while (n4 < track.size() - 1) {
            midiEvent = track.get(n4);
            l5 = midiEvent.getTick();
            if (l5 >= l4) {
                l3 += (l5 - l4) * (long)n2 / (long)this.resolution;
                l4 = l5;
                byte[] byArray = ((MetaMessage)midiEvent.getMessage()).getMessage();
                n2 = 0xFF & byArray[5];
                n2 |= (0xFF & byArray[4]) << 8;
                n2 |= (0xFF & byArray[3]) << 16;
            }
            ++n4;
        }
        l5 = this.getTickLength();
        if (l5 > l4) {
            l3 += (l5 - l4) * (long)n2 / (long)this.resolution;
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTickLength() {
        long l2 = 0L;
        Vector vector = this.tracks;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.tracks.size()) {
                long l3 = ((Track)this.tracks.elementAt(n2)).ticks();
                if (l3 > l2) {
                    l2 = l3;
                }
                ++n2;
            }
            return l2;
        }
    }

    public Sequence(float f2, int n2) throws InvalidMidiDataException {
        if (f2 == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f2 == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f2 == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f2 == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f2 == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f2);
        }
        this.resolution = n2;
    }

    public Sequence(float f2, int n2, int n3) throws InvalidMidiDataException {
        if (f2 == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f2 == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f2 == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f2 == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f2 == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f2);
        }
        this.resolution = n2;
        int n4 = 0;
        while (n4 < n3) {
            this.tracks.addElement(new Track());
            ++n4;
        }
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.addElement(track);
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Track[] getTracks() {
        Vector vector = this.tracks;
        synchronized (vector) {
            Track[] trackArray = new Track[this.tracks.size()];
            int n2 = 0;
            while (n2 < trackArray.length) {
                trackArray[n2] = (Track)this.tracks.elementAt(n2);
                ++n2;
            }
            return trackArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTrack(Track track) {
        Vector vector = this.tracks;
        synchronized (vector) {
            return this.tracks.removeElement(track);
        }
    }
}

