/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private byte[] buf = null;
    private static final long serialVersionUID = -3415254970957330361L;

    public int hashCode() {
        int n2 = this.addrType.hashCode();
        int n3 = 0;
        while (n3 < this.buf.length) {
            n2 += this.buf[n3];
            ++n3;
        }
        return n2;
    }

    public Object getContent() {
        return this.buf;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)object;
            if (this.addrType.compareTo(binaryRefAddr.addrType) == 0) {
                if (this.buf == null && binaryRefAddr.buf == null) {
                    return true;
                }
                if (this.buf == null || binaryRefAddr.buf == null || this.buf.length != binaryRefAddr.buf.length) {
                    return false;
                }
                int n2 = 0;
                while (n2 < this.buf.length) {
                    if (this.buf[n2] != binaryRefAddr.buf[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Address Type: " + this.addrType + "\n");
        stringBuffer.append("AddressContents: ");
        int n2 = 0;
        while (n2 < this.buf.length && n2 < 32) {
            stringBuffer.append(Integer.toHexString(this.buf[n2]) + " ");
            ++n2;
        }
        if (this.buf.length >= 32) {
            stringBuffer.append(" ...\n");
        }
        return stringBuffer.toString();
    }

    public BinaryRefAddr(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    public BinaryRefAddr(String string, byte[] byArray, int n2, int n3) {
        super(string);
        this.buf = new byte[n3];
        System.arraycopy(byArray, n2, this.buf, 0, n3);
    }
}

