/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.lang.reflect.Method;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataController;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public abstract class IIOMetadata {
    protected boolean standardFormatSupported;
    protected String nativeMetadataFormatName = null;
    protected String nativeMetadataFormatClassName = null;
    protected String[] extraMetadataFormatNames = null;
    protected String[] extraMetadataFormatClassNames = null;
    protected IIOMetadataController defaultController = null;
    protected IIOMetadataController controller = null;

    protected IIOMetadata() {
    }

    public abstract void reset();

    public boolean activateController() {
        if (!this.hasController()) {
            throw new IllegalStateException("hasController() == false!");
        }
        return this.getController().activate(this);
    }

    public boolean hasController() {
        return this.getController() != null;
    }

    public abstract boolean isReadOnly();

    public boolean isStandardMetadataFormatSupported() {
        return this.standardFormatSupported;
    }

    public String getNativeMetadataFormatName() {
        return this.nativeMetadataFormatName;
    }

    public String[] getExtraMetadataFormatNames() {
        if (this.extraMetadataFormatNames == null) {
            return null;
        }
        return (String[])this.extraMetadataFormatNames.clone();
    }

    public String[] getMetadataFormatNames() {
        String string = this.getNativeMetadataFormatName();
        String string2 = this.isStandardMetadataFormatSupported() ? "javax_imageio_1.0" : null;
        String[] stringArray = this.getExtraMetadataFormatNames();
        int n2 = 0;
        if (string != null) {
            ++n2;
        }
        if (string2 != null) {
            ++n2;
        }
        if (stringArray != null) {
            n2 += stringArray.length;
        }
        if (n2 == 0) {
            return null;
        }
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        if (string != null) {
            stringArray2[n3++] = string;
        }
        if (string2 != null) {
            stringArray2[n3++] = string2;
        }
        if (stringArray != null) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                stringArray2[n3++] = stringArray[n4];
                ++n4;
            }
        }
        return stringArray2;
    }

    public IIOMetadataController getController() {
        return this.controller;
    }

    public IIOMetadataController getDefaultController() {
        return this.defaultController;
    }

    public void setController(IIOMetadataController iIOMetadataController) {
        this.controller = iIOMetadataController;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTileNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    protected final IIOMetadataNode getStandardTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
        this.append(iIOMetadataNode, this.getStandardChromaNode());
        this.append(iIOMetadataNode, this.getStandardCompressionNode());
        this.append(iIOMetadataNode, this.getStandardDataNode());
        this.append(iIOMetadataNode, this.getStandardDimensionNode());
        this.append(iIOMetadataNode, this.getStandardDocumentNode());
        this.append(iIOMetadataNode, this.getStandardTextNode());
        this.append(iIOMetadataNode, this.getStandardTileNode());
        this.append(iIOMetadataNode, this.getStandardTransparencyNode());
        return iIOMetadataNode;
    }

    public IIOMetadataFormat getMetadataFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (this.standardFormatSupported && string.equals("javax_imageio_1.0")) {
            return IIOMetadataFormatImpl.getStandardFormatInstance();
        }
        String string2 = null;
        if (string.equals(this.nativeMetadataFormatName)) {
            string2 = this.nativeMetadataFormatClassName;
        } else if (this.extraMetadataFormatNames != null) {
            int n2 = 0;
            while (n2 < this.extraMetadataFormatNames.length) {
                if (string.equals(this.extraMetadataFormatNames[n2])) {
                    string2 = this.extraMetadataFormatClassNames[n2];
                    break;
                }
                ++n2;
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Unsupported format name");
        }
        try {
            Class clazz = Class.forName(string2, true, ClassLoader.getSystemClassLoader());
            Method method = clazz.getMethod("getInstance", null);
            return (IIOMetadataFormat)method.invoke(null, null);
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Can't obtain format");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    private void append(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2) {
        if (iIOMetadataNode2 != null) {
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    public abstract Node getAsTree(String var1);

    public abstract void mergeTree(String var1, Node var2) throws IIOInvalidTreeException;

    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(string, node);
    }

    protected IIOMetadata(boolean bl2, String string, String string2, String[] stringArray, String[] stringArray2) {
        this.standardFormatSupported = bl2;
        this.nativeMetadataFormatName = string;
        this.nativeMetadataFormatClassName = string2;
        if (stringArray != null) {
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("extraMetadataFormatNames.length == 0!");
            }
            if (stringArray2 == null) {
                throw new IllegalArgumentException("extraMetadataFormatNames != null && extraMetadataFormatClassNames == null!");
            }
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("extraMetadataFormatClassNames.length != extraMetadataFormatNames.length!");
            }
            this.extraMetadataFormatNames = (String[])stringArray.clone();
            this.extraMetadataFormatClassNames = (String[])stringArray2.clone();
        } else if (stringArray2 != null) {
            throw new IllegalArgumentException("extraMetadataFormatNames == null && extraMetadataFormatClassNames != null!");
        }
    }
}

