/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.Pattern;

public final class Matcher {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = -1;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;

    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    int getTextLength() {
        return this.text.length();
    }

    public int groupCount() {
        return this.parentPattern.groupCount - 1;
    }

    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    Matcher() {
    }

    public boolean find() {
        if (this.last == this.first) {
            ++this.last;
        }
        if (this.last > this.to) {
            int n2 = 0;
            while (n2 < this.groups.length) {
                this.groups[n2] = -1;
                ++n2;
            }
            return false;
        }
        return this.find(this.last, this.getTextLength());
    }

    public boolean lookingAt() {
        this.reset();
        return this.match(0, this.getTextLength(), 0);
    }

    public boolean matches() {
        this.reset();
        return this.match(0, this.getTextLength(), 1);
    }

    char charAt(int n2) {
        return this.text.charAt(n2);
    }

    public int end(int n2) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n2 > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n2);
        }
        return this.groups[n2 * 2 + 1];
    }

    public int start(int n2) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n2 > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n2);
        }
        return this.groups[n2 * 2];
    }

    public boolean find(int n2) {
        int n3 = this.getTextLength();
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.find(n2, n3);
    }

    private boolean find(int n2, int n3) {
        n2 = n2 < 0 ? 0 : n2;
        this.to = n3;
        this.first = n2;
        this.last = -1;
        this.oldLast = this.oldLast < 0 ? n2 : this.oldLast;
        int n4 = 0;
        while (n4 < this.groups.length) {
            this.groups[n4] = -1;
            ++n4;
        }
        this.acceptMode = 0;
        boolean bl2 = this.parentPattern.root.match(this, n2, this.text);
        if (!bl2) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl2;
    }

    private boolean match(int n2, int n3, int n4) {
        n2 = n2 < 0 ? 0 : n2;
        this.to = n3;
        this.first = n2;
        this.last = -1;
        this.oldLast = this.oldLast < 0 ? n2 : this.oldLast;
        int n5 = 0;
        while (n5 < this.groups.length) {
            this.groups[n5] = -1;
            ++n5;
        }
        this.acceptMode = n4;
        boolean bl2 = this.parentPattern.matchRoot.match(this, n2, this.text);
        if (!bl2) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl2;
    }

    CharSequence getSubSequence(int n2, int n3) {
        return this.text.subSequence(n2, n3);
    }

    public String group() {
        return this.group(0);
    }

    public String group(int n2) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (n2 < 0 || n2 > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n2);
        }
        if (this.groups[n2 * 2] == -1 || this.groups[n2 * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[n2 * 2], this.groups[n2 * 2 + 1]).toString();
    }

    public Matcher reset() {
        this.first = -1;
        this.last = -1;
        this.oldLast = -1;
        int n2 = 0;
        while (n2 < this.groups.length) {
            this.groups[n2] = -1;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.locals.length) {
            this.locals[n3] = -1;
            ++n3;
        }
        this.lastAppendPosition = 0;
        return this;
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.parentPattern = pattern;
        this.text = charSequence;
        int n2 = Math.max(pattern.groupCount, 10);
        this.groups = new int[n2 * 2];
        this.locals = new int[pattern.localCount];
        this.reset();
    }

    public String replaceAll(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.reset();
        boolean bl2 = this.find();
        while (bl2) {
            this.appendReplacement(stringBuffer, string);
            bl2 = this.find();
        }
        this.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public String replaceFirst(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.reset();
        if (this.find()) {
            this.appendReplacement(stringBuffer, string);
        }
        this.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.getSubSequence(this.lastAppendPosition, this.getTextLength()).toString());
        return stringBuffer;
    }

    public Matcher reset(CharSequence charSequence) {
        this.text = charSequence;
        return this.reset();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int n2 = 0;
        String string2 = string;
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '\\') {
                c2 = string.charAt(++n2);
                stringBuffer2.append(c2);
                ++n2;
                continue;
            }
            if (c2 == '$') {
                int n3;
                if ((n3 = string.charAt(++n2) - 48) < 0 || n3 > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++n2;
                boolean bl2 = false;
                while (!bl2) {
                    int n4;
                    if (n2 >= string.length() || (n4 = string.charAt(n2) - 48) < 0 || n4 > 9) break;
                    int n5 = n3 * 10 + n4;
                    if (this.groupCount() < n5) {
                        bl2 = true;
                        continue;
                    }
                    n3 = n5;
                    ++n2;
                }
                if (this.group(n3) == null) continue;
                stringBuffer2.append(this.group(n3));
                continue;
            }
            stringBuffer2.append(c2);
            ++n2;
        }
        stringBuffer.append(this.getSubSequence(this.lastAppendPosition, this.first));
        stringBuffer.append(stringBuffer2.toString());
        this.lastAppendPosition = this.last;
        return this;
    }
}

