/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;

public class Manifest
implements Cloneable {
    private Attributes attr = new Attributes();
    private Map entries = new HashMap();

    public int hashCode() {
        return this.attr.hashCode() + this.entries.hashCode();
    }

    public Manifest() {
    }

    public void clear() {
        this.attr.clear();
        this.entries.clear();
    }

    private int toLower(int n2) {
        return n2 >= 65 && n2 <= 90 ? 97 + (n2 - 65) : n2;
    }

    public Manifest(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public void read(InputStream inputStream) throws IOException {
        int n2;
        FastInputStream fastInputStream = new FastInputStream(inputStream);
        byte[] byArray = new byte[512];
        this.attr.read(fastInputStream, byArray);
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        String string = null;
        boolean bl2 = true;
        while ((n2 = fastInputStream.readLine(byArray)) != -1) {
            if (byArray[--n2] != 10) {
                throw new IOException("manifest line too long");
            }
            if (n2 > 0 && byArray[n2 - 1] == 13) {
                --n2;
            }
            if (n2 == 0 && bl2) continue;
            bl2 = false;
            if (string == null) {
                string = this.parseName(byArray, n2);
                if (string == null) {
                    throw new IOException("invalid manifest format");
                }
            } else {
                string = string + new String(byArray, 0, 1, n2 - 1);
            }
            if (fastInputStream.peek() == 32) continue;
            Attributes attributes = this.getAttributes(string);
            if (attributes == null) {
                attributes = new Attributes(n5);
                this.entries.put(string, attributes);
            }
            attributes.read(fastInputStream, byArray);
            n5 = Math.max(2, (n4 += attributes.size()) / ++n3);
            string = null;
            bl2 = true;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.attr.writeMain(dataOutputStream);
        Iterator iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            StringBuffer stringBuffer = new StringBuffer("Name: ");
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            ((Attributes)entry.getValue()).write(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    public Object clone() {
        return new Manifest(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Manifest) {
            Manifest manifest = (Manifest)object;
            return this.attr.equals(manifest.getMainAttributes()) && this.entries.equals(manifest.getEntries());
        }
        return false;
    }

    private String parseName(byte[] byArray, int n2) {
        if (this.toLower(byArray[0]) == 110 && this.toLower(byArray[1]) == 97 && this.toLower(byArray[2]) == 109 && this.toLower(byArray[3]) == 101 && byArray[4] == 58 && byArray[5] == 32) {
            return new String(byArray, 0, 6, n2 - 6);
        }
        return null;
    }

    static void make72Safe(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        if (n2 > 72) {
            int n3 = 70;
            while (n3 < n2 - 2) {
                stringBuffer.insert(n3, "\r\n ");
                n3 += 72;
                n2 += 3;
            }
        }
    }

    public Map getEntries() {
        return this.entries;
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public Manifest(Manifest manifest) {
        this.attr.putAll(manifest.getMainAttributes());
        this.entries.putAll(manifest.getEntries());
    }

    public Attributes getAttributes(String string) {
        return (Attributes)this.getEntries().get(string);
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count = 0;
        private int pos = 0;

        public byte peek() throws IOException {
            if (this.pos == this.count) {
                this.fill();
            }
            return this.buf[this.pos];
        }

        public int available() throws IOException {
            return this.count - this.pos + this.in.available();
        }

        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n2 = this.in.read(this.buf, 0, this.buf.length);
            if (n2 > 0) {
                this.count = n2;
            }
        }

        public long skip(long l2) throws IOException {
            if (l2 <= 0L) {
                return 0L;
            }
            long l3 = this.count - this.pos;
            if (l3 <= 0L) {
                return this.in.skip(l2);
            }
            if (l2 > l3) {
                l2 = l3;
            }
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }

        public int readLine(byte[] byArray) throws IOException {
            return this.readLine(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (n3 >= this.buf.length) {
                    return this.in.read(byArray, n2, n3);
                }
                this.fill();
                n4 = this.count - this.pos;
                if (n4 <= 0) {
                    return -1;
                }
            }
            if (n3 > n4) {
                n3 = n4;
            }
            System.arraycopy(this.buf, this.pos, byArray, n2, n3);
            this.pos += n3;
            return n3;
        }

        public int readLine(byte[] byArray, int n2, int n3) throws IOException {
            byte[] byArray2 = this.buf;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                int n6 = this.count - this.pos;
                if (n6 <= 0) {
                    this.fill();
                    n6 = this.count - this.pos;
                    if (n6 <= 0) {
                        return -1;
                    }
                }
                if ((n5 = n3 - n4) > n6) {
                    n5 = n6;
                }
                int n7 = this.pos;
                int n8 = n7 + n5;
                while (n7 < n8 && byArray2[n7++] != 10) {
                }
                n5 = n7 - this.pos;
                System.arraycopy(byArray2, this.pos, byArray, n2, n5);
                n2 += n5;
                n4 += n5;
                this.pos = n7;
                if (byArray2[n7 - 1] == 10) break;
            }
            return n4;
        }

        FastInputStream(InputStream inputStream) {
            this(inputStream, 8192);
        }

        FastInputStream(InputStream inputStream, int n2) {
            super(inputStream);
            this.buf = new byte[n2];
        }
    }
}

