/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public WeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry[] entryArray = this.table;
        int n2 = 0;
        while (n2 < entryArray.length) {
            entryArray[n2] = null;
            ++n2;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    private void expungeStaleEntries() {
        Reference reference;
        block0: while ((reference = this.queue.poll()) != null) {
            Entry entry;
            Entry entry2 = (Entry)reference;
            int n2 = Entry.access$000(entry2);
            int n3 = WeakHashMap.indexFor(n2, this.table.length);
            Entry entry3 = entry = this.table[n3];
            while (entry3 != null) {
                Entry entry4 = Entry.access$100(entry3);
                if (entry3 == entry2) {
                    if (entry == entry2) {
                        this.table[n3] = entry4;
                    } else {
                        Entry.access$102(entry, entry4);
                    }
                    Entry.access$102(entry2, null);
                    Entry.access$202(entry2, null);
                    --this.size;
                    continue block0;
                }
                entry = entry3;
                entry3 = entry4;
            }
        }
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (Entry.access$200(entry) == null) {
                    return true;
                }
                entry = Entry.access$100(entry);
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public WeakHashMap(int n2) {
        this(n2, 0.75f);
    }

    void resize(int n2) {
        Entry[] entryArray = this.getTable();
        int n3 = entryArray.length;
        if (this.size < this.threshold || n3 > n2) {
            return;
        }
        Entry[] entryArray2 = new Entry[n2];
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    public WeakHashMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        int n3 = 1;
        while (n3 < n2) {
            n3 <<= 1;
        }
        this.table = new Entry[n3];
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
    }

    static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (object.equals(Entry.access$200(entry))) {
                    return true;
                }
                entry = Entry.access$100(entry);
            }
        }
        return false;
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values(this, null));
    }

    public WeakHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    public void putAll(Map map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 >= this.threshold) {
            if ((n2 = (int)((float)n2 / this.loadFactor + 1.0f)) > 0x40000000) {
                n2 = 0x40000000;
            }
            int n3 = this.table.length;
            while (n3 < n2) {
                n3 <<= 1;
            }
            this.resize(n3);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet(this, null));
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet(this, null));
    }

    static int access$400(WeakHashMap weakHashMap) {
        return weakHashMap.modCount;
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    static Object access$300(Object object) {
        return WeakHashMap.unmaskNull(object);
    }

    public Object get(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (Entry.access$000(entry) == n2 && WeakHashMap.eq(object2, entry.get())) {
                return Entry.access$200(entry);
            }
            entry = Entry.access$100(entry);
        }
        return null;
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    public Object remove(Object object) {
        Entry entry;
        Object object2 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry2 = entry = entryArray[n3];
        while (entry2 != null) {
            Entry entry3 = Entry.access$100(entry2);
            if (n2 == Entry.access$000(entry2) && WeakHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n3] = entry3;
                } else {
                    Entry.access$102(entry, entry3);
                }
                return Entry.access$200(entry2);
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    Entry getEntry(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry = entryArray[n3];
        while (!(entry == null || Entry.access$000(entry) == n2 && WeakHashMap.eq(object2, entry.get()))) {
            entry = Entry.access$100(entry);
        }
        return entry;
    }

    Entry removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Entry[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n2 = HashMap.hash(object2);
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry3 = entry = entryArray[n3];
        while (entry3 != null) {
            Entry entry4 = Entry.access$100(entry3);
            if (n2 == Entry.access$000(entry3) && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n3] = entry4;
                } else {
                    Entry.access$102(entry, entry4);
                }
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return null;
    }

    static Entry[] access$500(WeakHashMap weakHashMap) {
        return weakHashMap.table;
    }

    private void transfer(Entry[] entryArray, Entry[] entryArray2) {
        int n2 = 0;
        while (n2 < entryArray.length) {
            Entry entry = entryArray[n2];
            entryArray[n2] = null;
            while (entry != null) {
                Entry entry2 = Entry.access$100(entry);
                Object object = entry.get();
                if (object == null) {
                    Entry.access$102(entry, null);
                    Entry.access$202(entry, null);
                    --this.size;
                } else {
                    int n3 = WeakHashMap.indexFor(Entry.access$000(entry), entryArray2.length);
                    Entry.access$102(entry, entryArray2[n3]);
                    entryArray2[n3] = entry;
                }
                entry = entry2;
            }
            ++n2;
        }
    }

    public Object put(Object object, Object object2) {
        Object object3 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object3);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (n2 == Entry.access$000(entry) && WeakHashMap.eq(object3, entry.get())) {
                Object object4 = Entry.access$200(entry);
                if (object2 != object4) {
                    Entry.access$202(entry, object2);
                }
                return object4;
            }
            entry = Entry.access$100(entry);
        }
        ++this.modCount;
        entryArray[n3] = new Entry(object3, object2, this.queue, n2, entryArray[n3]);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    class 1 {
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        private Object value;
        private final int hash;
        private Entry next;

        public int hashCode() {
            Object object = this.getKey();
            Object object2 = this.getValue();
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }

        public Object getKey() {
            return WeakHashMap.access$300(this.get());
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            Object object2;
            Object object3;
            Object object4;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object5 = this.getKey();
            return (object5 == (object4 = entry.getKey()) || object5 != null && object5.equals(object4)) && ((object3 = this.getValue()) == (object2 = entry.getValue()) || object3 != null && object3.equals(object2));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        static int access$000(Entry entry) {
            return entry.hash;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        static Object access$200(Entry entry) {
            return entry.value;
        }

        static Entry access$100(Entry entry) {
            return entry.next;
        }

        static Object access$202(Entry entry, Object object) {
            entry.value = object;
            return entry.value;
        }

        static Entry access$102(Entry entry, Entry entry2) {
            entry.next = entry2;
            return entry.next;
        }

        Entry(Object object, Object object2, ReferenceQueue referenceQueue, int n2, Entry entry) {
            super(object, referenceQueue);
            this.value = object2;
            this.hash = n2;
            this.next = entry;
        }
    }

    private class EntryIterator
    extends HashIterator {
        private final WeakHashMap this$0;

        public Object next() {
            return this.nextEntry();
        }

        private EntryIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            super(weakHashMap);
        }

        EntryIterator(WeakHashMap weakHashMap, 1 var2_2) {
            this(weakHashMap);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final WeakHashMap this$0;

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getKey();
            Entry entry2 = this.this$0.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return this.this$0.removeMapping(object) != null;
        }

        public Iterator iterator() {
            return new EntryIterator(this.this$0, null);
        }

        private EntrySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray(objectArray);
        }

        EntrySet(WeakHashMap weakHashMap, 1 var2_2) {
            this(weakHashMap);
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int index;
        Entry entry;
        Entry lastReturned;
        int expectedModCount;
        Object nextKey;
        Object currentKey;
        private final WeakHashMap this$0;

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.access$400(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.this$0.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.access$400(this.this$0);
            this.lastReturned = null;
            this.currentKey = null;
        }

        public boolean hasNext() {
            Entry[] entryArray = WeakHashMap.access$500(this.this$0);
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n2 = this.index;
                while (entry == null && n2 > 0) {
                    entry = entryArray[--n2];
                }
                this.entry = entry;
                this.index = n2;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = Entry.access$100(this.entry);
            }
            return true;
        }

        HashIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = WeakHashMap.access$400(this.this$0);
            this.nextKey = null;
            this.currentKey = null;
            this.index = weakHashMap.size() != 0 ? WeakHashMap.access$500(weakHashMap).length : 0;
        }

        protected Entry nextEntry() {
            if (WeakHashMap.access$400(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = Entry.access$100(this.entry);
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }
    }

    private class KeyIterator
    extends HashIterator {
        private final WeakHashMap this$0;

        public Object next() {
            return this.nextEntry().getKey();
        }

        private KeyIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            super(weakHashMap);
        }

        KeyIterator(WeakHashMap weakHashMap, 1 var2_2) {
            this(weakHashMap);
        }
    }

    private class KeySet
    extends AbstractSet {
        private final WeakHashMap this$0;

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public boolean contains(Object object) {
            return this.this$0.containsKey(object);
        }

        public boolean remove(Object object) {
            if (this.this$0.containsKey(object)) {
                this.this$0.remove(object);
                return true;
            }
            return false;
        }

        public Iterator iterator() {
            return new KeyIterator(this.this$0, null);
        }

        private KeySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }

        KeySet(WeakHashMap weakHashMap, 1 var2_2) {
            this(weakHashMap);
        }
    }

    private class ValueIterator
    extends HashIterator {
        private final WeakHashMap this$0;

        public Object next() {
            return Entry.access$200(this.nextEntry());
        }

        private ValueIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            super(weakHashMap);
        }

        ValueIterator(WeakHashMap weakHashMap, 1 var2_2) {
            this(weakHashMap);
        }
    }

    private class Values
    extends AbstractCollection {
        private final WeakHashMap this$0;

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public boolean contains(Object object) {
            return this.this$0.containsValue(object);
        }

        public Iterator iterator() {
            return new ValueIterator(this.this$0, null);
        }

        private Values(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }

        Values(WeakHashMap weakHashMap, 1 var2_2) {
            this(weakHashMap);
        }
    }
}

